
#ifndef OSAL_MINISPM_IF
#define OSAL_MINISPM_IF

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#if (OSAL_OS == OSAL_LINUX) || (OSAL_OS == OSAL_DARWIN)
   #define EXPORT __attribute__((visibility ("default")))
#else
   #define EXPORT
#endif


#ifdef __cplusplus
   extern "C" {
#endif

/**
 *  @param  const char *szApps  Komma-Separated String with Apps to start (at least),
 *                              for example "1024,1" would at least wait until apps 1024 and
 *                              1 have been registered (by start-request message)
 */
EXPORT void vStartCcaApplications(OSAL_tSemHandle hAllNormalEvent = OSAL_C_INVALID_HANDLE, const char *szApps = NULL);
EXPORT void vTerminateCcaApplications();

EXPORT void vPauseApplications(OSAL_tSemHandle hAllDoneEvent = OSAL_C_INVALID_HANDLE);
EXPORT void vNormalizeApplications(OSAL_tSemHandle hAllDoneEvent = OSAL_C_INVALID_HANDLE);


#ifdef __cplusplus
   }    // extern "C"
#endif


#endif   // OSAL_MINISPM_IF
