/* Generated by Together */

#ifndef APPMANAGER_H
#define APPMANAGER_H

#include <vector>
#include <string>



//#define REQUEST_PAUSE_STATE   0xF0
//#define REQUEST_NORMAL_STATE  0xF1
#define DO_STATE_REQUEST        0xF0

class MiniSpm;
class Application;
class CPowerMsg;
class tclSrvSupplier;
class tclAppInfoService;


class AppManager 
{
   private:
      typedef std::vector<Application *> tApplicationVector;

      tApplicationVector m_oApps;

      MiniSpm *m_poSpm;
      // Mode to control synch message or async message
      tBool m_bSynchMode;

   public:
      /**
       *  @param  tApplicationWaitList
       */
      AppManager(MiniSpm *poSpm);
      ~AppManager();
      void vStartApps(const char *szAppsToStart);
      void vEndApps();

      void vChangeStateTo(tU16 u16NewState);

   private:
       class tclHandle
       {
       public:
           tU32 m_u32TargetState;
           OSAL_tSemHandle m_hSem;
       };
      typedef std::vector<tU16> tApplicationWaitList;
      typedef std::vector<tclHandle*> tHandleVect;
      tHandleVect m_oHandleVect;
      static void vGetWaitList (const char *szApps, tApplicationWaitList &oEmptyList);

      void vProcessMessages(tU16 u16NewState);
      Application *poFindApp(tU16 u16AppId);
      void vInitApps(tApplicationWaitList &oWaitList);
      void vTerminateApps();
      tBool bCheckAppStates(tU16 u16AppState);

      void vTraceAppList(const char *szPrefix, const tApplicationWaitList &oWaitList);

     //For cca Ext
private:
      typedef std::vector<tclSrvSupplier *> tSrvSupplierVector;
      tSrvSupplierVector m_oSrvSuppAppsVector;
      
      typedef std::vector<tclAppInfoService*> tAppInfoVector;
      tAppInfoVector m_oAppInfoVector;
      tBool bCheckRegistryExits();
      void vFillDataFromReg(Application *poApp);
      // For SrvSupplier
      void vAddToSrvSuppListAndAck(tU16 u16ServiceId, tU16 u16ClientAppId);
      void vInformSrvSuppRegApps(Application *poApp);
      void vSrvSupplierUnreg(tU16 u16ServiceId,tU16 u16ClientAppId);
      void vRemoveFromSrvSupplierList(tU16 u16AppId);

      //For AppInfo Service
      void vAddToAppInfoListAndAck(tU16 u16ServerAppId, tU16 u16ClientAppId);
      void vInformAppInfoRegApps(Application *poApp);
      void vAppInfoUnReg(tU16 u16ServerAppId,tU16 u16ClientAppId);
      void vRemoveFromAppInfoList(tU16 u16AppId);
};

#endif //APPMANAGER_H
