// CCAMessages.h : interface of the CCA message classes
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(CCA_MESSAGE_HEADER)
#define CCA_MESSAGE_HEADER

#define  AMT_C_U16_APPID_INVALID                            0xFFFF
#define  AMT_C_U8_CCAMSGTYPE_POWER                       (tU8)0x40

#define  AMT_C_U16_PWR_APP_START_REQ                     (tU16)0x00
#define  AMT_C_U16_PWR_APP_INITIALIZED                   (tU16)0x01
#define  AMT_C_U16_PWR_APP_RESTART                       (tU16)0x02
#define  AMT_C_U16_PWR_PROXY_START_CONF                  (tU16)0x03
#define  AMT_C_U16_PWR_PROXY_START_REJ                   (tU16)0x04
#define  AMT_C_U16_PWR_PROXY_STATE_CHANGE_REQ            (tU16)0x10
#define  AMT_C_U16_PWR_APP_STATE_ACK                     (tU16)0x11
#define  AMT_C_U16_PWR_APP_STATE_REJ                     (tU16)0x12
#define  AMT_C_U16_PWR_PROXY_STATE_CHANGE_IMMEDIATELY    (tU16)0x13

#define  AMT_C_U16_PWR_PROXY_END_APP                     (tU16)0x20
#define  AMT_C_U16_PWR_APP_END_SUCCESSFUL                (tU16)0x21
#define  AMT_C_U16_PWR_APP_END_FAILURE                   (tU16)0x22

#define AMT_C_U32_STATE_INVALID                          (tU32)0x00
#define AMT_C_U32_STATE_UNINITALIZED                     (tU32)0x01
#define AMT_C_U32_STATE_INITIALIZED                      (tU32)0x02
#define AMT_C_U32_STATE_NORMAL                           (tU32)0x03
#define AMT_C_U32_STATE_DIAGNOSIS                        (tU32)0x04
#define AMT_C_U32_STATE_PAUSE                            (tU32)0x05
#define AMT_C_U32_STATE_PREPARE_DOWNLOAD                 (tU32)0x06
#define AMT_C_U32_STATE_RECEIVE_READY                    (tU32)0x07
#define AMT_C_U32_STATE_OFF                              (tU32)0x08


#define  AMT_C_U8_CCAMSGTYPE_SUPPLIER_STATE_REGISTER           (tU8)0x46
#define  AMT_C_U8_CCAMSGTYPE_SUPPLIER_STATE                    (tU8)0x47
#define  AMT_C_U8_CCAMSGTYPE_SUPPLIER_STATE_UNREGISTER         (tU8)0x48
#define  AMT_C_U8_CCAMSGTYPE_APPLICATION_INFO_REGISTER         (tU8)0x49
#define  AMT_C_U8_CCAMSGTYPE_APPLICATION_INFO                  (tU8)0x50
#define  AMT_C_U8_CCAMSGTYPE_APPLICATION_INFO_UNREGISTER       (tU8)0x51

 // Service supplier application is known but not started
 #define AMT_C_U8_CCAMSG_SUPPLIER_STATE_UNAVAILABLE   (tU8)0
 // Service supplier application is initialized
 #define AMT_C_U8_CCAMSG_SUPPLIER_STATE_AVAILABLE     (tU8)1
 // Service supplier there is no application which offers the service
 #define AMT_C_U8_CCAMSG_SUPPLIER_STATE_UNKNOWN       (tU8)2
 // Service supplier e.g. repeated registration for the same Service without prior de-registration
 #define AMT_C_U8_CCAMSG_SUPPLIER_STATE_ERROR         (tU8)3

 // Service supplier application is known but not started
 #define AMT_C_U8_CCAMSG_APPLICATION_INFO_UNAVAILABLE   (tU8)0
 // Service supplier application is initialized
 #define AMT_C_U8_CCAMSG_APPLICATION_INFO_AVAILABLE     (tU8)1
 // Service supplier there is no application which offers the service
 #define AMT_C_U8_CCAMSG_APPLICATION_INFO_UNKNOWN       (tU8)2
 // Service supplier e.g. repeated registration for the same Service without prior de-registration
 #define AMT_C_U8_CCAMSG_APPLICATION_INFO_ERROR         (tU8)3

class CCCABaseMsg
{
public:
   // StdCtor
   CCCABaseMsg():u16SourceAppId(0),u16DestAppId(0),u32Size(0),
      u16Version(0),u8Context(0),u8Type(0) {}
   CCCABaseMsg(tU16 _u16SrcAppId,tU16 _u16DstAppId,tU32 _u32Size,tU8 _u8Type)
      :u16SourceAppId(_u16SrcAppId),u16DestAppId(_u16DstAppId),u32Size(_u32Size),
      u16Version(2),u8Context(0),u8Type(_u8Type) {}
   tU16 u16SourceAppId;
   tU16 u16DestAppId;
   tU32 u32Size;
   tU16 u16Version;
   tU8  u8Context;
   tU8  u8Type;
};

class CServiceRegisterMsg : public CCCABaseMsg
{
public:
   CServiceRegisterMsg():CCCABaseMsg(0,0,26,0x41),u16SourceSubId(0),
      u16DestSubId(0),u32TimeStamp(0),u16ServiceId(0),u16MajorVersion(0),
      u16MinorVersion(0) {}
   CServiceRegisterMsg(tU16 u16SrvId, tU16 u16Major, tU16 u16Minor)
      :CCCABaseMsg(0,0,26,0x41),u16SourceSubId(0),u16DestSubId(0),
      u32TimeStamp(0),u16ServiceId(u16SrvId),u16MajorVersion(u16Major),
      u16MinorVersion(u16Minor) {}
   // datafields
   tU16 u16SourceSubId;
   tU16 u16DestSubId;
   tU32 u32TimeStamp;
   tU16 u16ServiceId;
   tU16 u16MajorVersion;
   tU16 u16MinorVersion;
};

class CServiceUnRegisterMsg : public CCCABaseMsg
{
public:
   CServiceUnRegisterMsg():CCCABaseMsg(0,0,24,0x42),u16SourceSubId(0),
      u16DestSubId(0),u32TimeStamp(0),u16ServiceId(0),u16RegisterId(0) {}
   CServiceUnRegisterMsg(tU16 u16SrvId, tU16 u16RegId)
      :CCCABaseMsg(0,0,24,0x42),u16SourceSubId(0),u16DestSubId(0),
      u32TimeStamp(0),u16ServiceId(u16SrvId),u16RegisterId(u16RegId) {}
   // datafields
   tU16 u16SourceSubId;
   tU16 u16DestSubId;
   tU32 u32TimeStamp;
   tU16 u16ServiceId;
   tU16 u16RegisterId;
};

class CServiceConfirmationMsg : public CCCABaseMsg
{
public:
   CServiceConfirmationMsg():CCCABaseMsg(0,0,32,0x43),u16SourceSubId(0),
      u16DestSubId(0),u32TimeStamp(0),u16ServiceId(0),u16RegisterId(0),
      u8State(0),u8Reserved(0),u16MajorVersion(0),u16MinorVersion(0),u16PatchVersion(0) {}
   CServiceConfirmationMsg(tU16 u16SrvId, tU16 u16RegId, tU8 u8State, tU16 u16Major, tU16 u16Minor, tU16 u16Patch)
      :CCCABaseMsg(0,0,32,0x43),u16SourceSubId(0),u16DestSubId(0),   //lint !e578
      u32TimeStamp(0),u16ServiceId(u16SrvId),u16RegisterId(u16RegId),
      u8State(u8State),u8Reserved(0),u16MajorVersion(u16Major),u16MinorVersion(u16Minor),u16PatchVersion(u16Patch) {}
   // datafields
   tU16 u16SourceSubId;
   tU16 u16DestSubId;
   tU32 u32TimeStamp;
   tU16 u16ServiceId;
   tU16 u16RegisterId;
   tU8  u8State;
   tU8  u8Reserved;
   tU16 u16MajorVersion;
   tU16 u16MinorVersion;
   tU16 u16PatchVersion;
};

class CServiceStatusMsg : public CCCABaseMsg
{
public:
   CServiceStatusMsg():CCCABaseMsg(0,0,26,0x44),u16SourceSubId(0),
      u16DestSubId(0),u32TimeStamp(0),u16ServiceId(0),u16RegisterId(0),
      u8State(0),u8Reserved(0) {}
   CServiceStatusMsg(tU16 u16SrvId, tU16 u16RegId, tU8 u8State)
      :CCCABaseMsg(0,0,26,0x44),u16SourceSubId(0),u16DestSubId(0),  //lint !e578
      u32TimeStamp(0),u16ServiceId(u16SrvId),u16RegisterId(u16RegId),
      u8State(u8State),u8Reserved(0) {}
   // datafields
   tU16 u16SourceSubId;
   tU16 u16DestSubId;
   tU32 u32TimeStamp;
   tU16 u16ServiceId;
   tU16 u16RegisterId;
   tU8  u8State;
   tU8  u8Reserved;
};

class CServiceDataMsg : public CCCABaseMsg
{
public:
   // StdCtor
   CServiceDataMsg():u16SourceSubId(0),u16DestSubId(0),
      u32TimeStamp(0),u16ServiceId(0),u16RegisterId(0),
      u16FunctionId(0),u8Opcode(0),u8ACT(0),u16CommandCntr(0),
      u8StreamType(0),u8StreamCntr(0) {}
   CServiceDataMsg(tU16 u16SrvId, tU16 u16RegId, tU16 u16FctId, tU8 u8Op)
      :CCCABaseMsg(0,0,32,0x45),u16SourceSubId(0),u16DestSubId(0),
      u16ServiceId(u16SrvId),u16RegisterId(u16RegId),u16FunctionId(u16FctId),
      u8Opcode(u8Op),u8ACT(0),u16CommandCntr(0),u8StreamType(0),u8StreamCntr(0),u32TimeStamp(0) {}
   // datafields
   tU16 u16SourceSubId;
   tU16 u16DestSubId;
   tU32 u32TimeStamp;
   tU16 u16ServiceId;
   tU16 u16RegisterId;
   tU16 u16FunctionId;
   tU8  u8Opcode;
   tU8  u8ACT;
   tU16 u16CommandCntr;
   tU8  u8StreamType;
   tU8  u8StreamCntr;
};

class CPowerMsg : public CCCABaseMsg
{
public:
   // StandardCtor
   CPowerMsg():CCCABaseMsg(0,0,32,0x40),u16SourceSubId(0),u16DestSubId(0),
      u32TimeStamp(0),u16PowerType(0),u16Dummy(),u32Data1(0),u32Data2(0) {}
   CPowerMsg(tU16 _u16PowerType, tU32 _u32Data1, tU32 _u32Data2)
      :CCCABaseMsg(0,0,32,0x40),u16SourceSubId(0),u16DestSubId(0),u32TimeStamp(0),
      u16PowerType(_u16PowerType),u16Dummy(0),u32Data1(_u32Data1),
      u32Data2(_u32Data2) {}
   tU16 u16SourceSubId;
   tU16 u16DestSubId;
   tU32 u32TimeStamp;
   tU16 u16PowerType;
   tU16 u16Dummy;
   tU32 u32Data1;
   tU32 u32Data2;
};


class CServiceSupplierRegister : public CCCABaseMsg
{

public:
    CServiceSupplierRegister (  tU16 nSource, 
                                tU16 nTarget, 
                                tU16 nServiceID, 
                                tU16 u16SourceSub = 0, 
                                tU16 u16TargetSub = 0, 
                                tU32 u32TimeStamp = 0): CCCABaseMsg(nSource,nTarget,22,0x46),
                                                                             m_u16SourceSub(u16SourceSub),
                                                                             m_u16TargetSub(u16TargetSub),
                                                                             m_u32TimeStamp(u32TimeStamp),
                                                                             m_nServiceID(nServiceID){}


    tU16 m_u16SourceSub;
    tU16 m_u16TargetSub;
    tU32 m_u32TimeStamp;
    tU16 m_nServiceID;
};

class CServiceSupplierStatus : public CCCABaseMsg 
{
public:
    CServiceSupplierStatus (     tU16 u16Source, 
                                 tU16 u16Target, 
                                 tU16 u16ServiceID, 
                                 tU16 u16AppID, 
                                 tU8  u8ServiceSupplierState, 
                                 tU16 u16SourceSub = 0, 
                                 tU16 u16TargetSub = 0, 
                                 tU32 u32TimeStamp = 0): CCCABaseMsg(u16Source,u16Target,25,0x47),
                                                                              m_u16SourceSub(u16SourceSub),
                                                                              m_u16TargetSub(u16TargetSub),
                                                                              m_u32TimeStamp(u32TimeStamp),
                                                                              m_u16ServiceID(u16ServiceID),
                                                                              m_u16AppID(u16AppID),
                                                                              m_u8ServiceSupplierState(u8ServiceSupplierState) {}

    tU16 m_u16SourceSub;
    tU16 m_u16TargetSub;
    tU32 m_u32TimeStamp;
    tU16 m_u16ServiceID;
    tU16 m_u16AppID;
    tU8  m_u8ServiceSupplierState;

};

class CServiceSupplierUnregister : public CCCABaseMsg
{
public:
    CServiceSupplierUnregister (  tU16 nSource, 
                                  tU16 nTarget, 
                                  tU16 nServiceID, 
                                  tU16 u16SourceSub = 0, 
                                  tU16 u16TargetSub = 0, 
                                  tU32 u32TimeStamp = 0): CCCABaseMsg(nSource,nTarget,22,0x48),
                                                                               m_u16SourceSub(u16SourceSub),
                                                                               m_u16TargetSub(u16TargetSub),
                                                                               m_u32TimeStamp(u32TimeStamp),
                                                                               m_nServiceID(nServiceID){}
    tU16 m_u16SourceSub;
    tU16 m_u16TargetSub;
    tU32 m_u32TimeStamp;
    tU16 m_nServiceID;
};

class CApplicationInfoRegister : public CCCABaseMsg
{
public:
    CApplicationInfoRegister (    tU16 nSource, 
                                  tU16 nTarget, 
                                  tU16 nAppID, 
                                  tU16 u16SourceSub = 0, 
                                  tU16 u16TargetSub = 0, 
                                  tU32 u32TimeStamp = 0): CCCABaseMsg(nSource,nTarget,22,0x49),
                                                                               m_u16SourceSub(u16SourceSub),
                                                                               m_u16TargetSub(u16TargetSub),
                                                                               m_u32TimeStamp(u32TimeStamp),
                                                                               m_nAppID(nAppID) {}

    tU16 m_u16SourceSub;
    tU16 m_u16TargetSub;
    tU32 m_u32TimeStamp;
    tU16 m_nAppID;
};

class CApplicationInfoStatus : public CCCABaseMsg
{
public:
    CApplicationInfoStatus (       tU16 u16Source, 
                                   tU16 u16Target, 
                                   tU16 u16AppID, 
                                   tU8  u8ApplicationInfoState, 
                                   tU16 u16SourceSub = 0, 
                                   tU16 u16TargetSub = 0, 
                                   tU32 u32Timestamp = 0): CCCABaseMsg(u16Source,u16Target,23,0x50),
                                                                               m_u16SourceSub(u16SourceSub),
                                                                               m_u16TargetSub(u16TargetSub),
                                                                               m_u32Timestamp(u32Timestamp),
                                                                               m_u16AppID(u16AppID),
                                                                               m_u8ApplicationInfoState(u8ApplicationInfoState){}
    tU16 m_u16SourceSub;
    tU16 m_u16TargetSub;
    tU32 m_u32Timestamp;
    tU16 m_u16AppID;
    tU8  m_u8ApplicationInfoState;
};

class CApplicationInfoUnregister : public CCCABaseMsg
{
public:
    CApplicationInfoUnregister (   tU16 nSource, 
                                   tU16 nTarget, 
                                   tU16 nAppID, 
                                   tU16 u16SourceSub = 0, 
                                   tU16 u16TargetSub = 0, 
                                   tU32 u32TimeStamp = 0): CCCABaseMsg(nSource,nTarget,22,0x51),
                                                                               m_u16SourceSub(u16SourceSub),
                                                                               m_u16TargetSub(u16TargetSub),
                                                                               m_u32TimeStamp(u32TimeStamp),
                                                                               m_nAppID(nAppID) {}
    tU16 m_u16SourceSub;
    tU16 m_u16TargetSub;
    tU32 m_u32TimeStamp;
    tU16 m_nAppID;
};


#endif
