

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "minispm.h"
#include "application.h"


Application::Application(tU16 u16AppId, OSAL_tMQueueHandle hMsgQueue, tU16 u16AppState)
: m_u16AppId (u16AppId)
, m_hMsgQueue (hMsgQueue)
, m_u16AppState (u16AppState)
{
    m_u16AppReqState = AMT_C_U32_STATE_INVALID;
    m_ServiceVector.clear();

}

tU16 Application::u16GetAppId()
{
    return m_u16AppId;
}

OSAL_tMQueueHandle Application::hGetMsgQueueHandle()
{
    return m_hMsgQueue;
}

void Application::vSetMsgQueueHandle(OSAL_tMQueueHandle hQueue)
{
    m_hMsgQueue = hQueue;
}


tU16 Application::u16GetAppState()
{
    return m_u16AppState;
}
tU16 Application::u16GetAppReqState()
{
    return m_u16AppReqState;
}

void Application::vSetAppState(tU16 u16AppState)
{
    m_u16AppState = u16AppState;
}

void Application::vSetAppReqState(tU16 u16AppReqState)
{
    m_u16AppReqState = u16AppReqState;
}

void Application::vAddServiceId(tU16 u16ServiceId)
{
    m_ServiceVector.push_back(u16ServiceId);
}

tBool Application::bCheckAppServiceProvider(tU16 u16ServiceId)
{
    for (unsigned int i = 0;i < m_ServiceVector.size(); i++ )
    {
        if ( m_ServiceVector[i] == u16ServiceId ) 
            return TRUE;
    }
    return FALSE;
}

tBool tclSrvSupplier::bSrvSuppRegister(tU16 u16ServiceId)
{
    tBool bReturn = FALSE;
    tclInterestedServiceInfo *poIntrSrvSuppInfo = poGetSrvSuppInfo(u16ServiceId);
    if ( poIntrSrvSuppInfo == NULL )
    {
        poIntrSrvSuppInfo = new tclInterestedServiceInfo();
        if ( poIntrSrvSuppInfo != NULL )
        {
            poIntrSrvSuppInfo->m_u16ServiceId = u16ServiceId;
            poIntrSrvSuppInfo->m_u8ServiceState = AMT_C_U8_CCAMSG_SUPPLIER_STATE_UNKNOWN;
            m_oIntrSrvSuppVector.push_back(poIntrSrvSuppInfo);
            bReturn = TRUE;
        }
    }
    return bReturn;
}

tBool tclSrvSupplier::bSrvSuppUnRegister(tU16 u16ServiceId)
{
    tBool bReturn = FALSE;
    tIntrSrvSuppVector::iterator it = m_oIntrSrvSuppVector.begin();
    while (it != m_oIntrSrvSuppVector.end())
    {
        if ( (*it)->m_u16ServiceId == u16ServiceId )
        {
            delete (*it);
            m_oIntrSrvSuppVector.erase(it);
            bReturn = TRUE;
            break;
        }
        ++it;
    }
    return bReturn;
}

tclSrvSupplier::~tclSrvSupplier()
{
    while (m_oIntrSrvSuppVector.size() != 0)
    {
        tIntrSrvSuppVector::iterator it = m_oIntrSrvSuppVector.begin();
        delete (*it);
        m_oIntrSrvSuppVector.erase(it);
    }
}

tclSrvSupplier::tclInterestedServiceInfo* tclSrvSupplier::poGetSrvSuppInfo(tU16 u16ServiceId)
{
    for (unsigned int i = 0;i < m_oIntrSrvSuppVector.size(); i++ )
    {
        if ( m_oIntrSrvSuppVector[i]->m_u16ServiceId== u16ServiceId ) 
            return m_oIntrSrvSuppVector[i];
    }
    return NULL;
}

tBool tclSrvSupplier::bSetServiceInfoState(tU16 u16ServiceId,tU8 u8ServiceState)
{
    tclInterestedServiceInfo *poIntrSrvSuppInfo = poGetSrvSuppInfo(u16ServiceId);
    if ( poIntrSrvSuppInfo != NULL )
    {
        poIntrSrvSuppInfo->m_u8ServiceState = u8ServiceState;
        return TRUE;
    }
    return FALSE;
}

tU8 tclSrvSupplier::u8GetServiceInfoState(tU16 u16ServiceId)
{
    tclInterestedServiceInfo *poIntrSrvSuppInfo = poGetSrvSuppInfo(u16ServiceId);
    if ( poIntrSrvSuppInfo != NULL )
    {
        return poIntrSrvSuppInfo->m_u8ServiceState;
    }
    return AMT_C_U8_CCAMSG_APPLICATION_INFO_ERROR;
}


tBool tclAppInfoService::bAppInfoRegister(tU16 u16AppId)
{
    tBool bReturn = FALSE;
    tclInterestedAppInfo *poIntrAppInfo = poGetIntrAppInfo(u16AppId);
    if ( poIntrAppInfo == NULL )
    {
        poIntrAppInfo = new tclInterestedAppInfo();
        if ( poIntrAppInfo != NULL )
        {
            poIntrAppInfo->m_u16AppId = u16AppId;
            poIntrAppInfo->m_u8AppInfoState = AMT_C_U8_CCAMSG_APPLICATION_INFO_UNKNOWN;
            m_oIntrAppInfoVector.push_back(poIntrAppInfo);
            bReturn = TRUE;
        }
    }
    return bReturn;
}

tBool tclAppInfoService::bAppInfoUnRegister(tU16 u16AppId)
{
    tBool bReturn = FALSE;
    tIntrAppInfoVector::iterator it = m_oIntrAppInfoVector.begin();
    while (it != m_oIntrAppInfoVector.end())
    {
        if ( (*it)->m_u16AppId == u16AppId )
        {
            delete (*it);
            m_oIntrAppInfoVector.erase(it);
            bReturn = TRUE;
            break;
        }
        ++it;
    }
    return bReturn;
}

tclAppInfoService::~tclAppInfoService()
{
    while (m_oIntrAppInfoVector.size() != 0)
    {
        tIntrAppInfoVector::iterator it = m_oIntrAppInfoVector.begin();
        delete (*it);
        m_oIntrAppInfoVector.erase(it);
    }
}

tclAppInfoService::tclInterestedAppInfo * tclAppInfoService::poGetIntrAppInfo(tU16 u16AppId)
{
    for (unsigned int i = 0;i < m_oIntrAppInfoVector.size(); i++ )
    {
        if ( m_oIntrAppInfoVector[i]->m_u16AppId == u16AppId ) 
            return m_oIntrAppInfoVector[i];
    }
    return NULL;
}

tBool tclAppInfoService::bSetAppInfoState(tU16 u16AppId,tU8 u8AppInfoState)
{
    tclInterestedAppInfo *poIntrAppInfo = poGetIntrAppInfo(u16AppId);
    if ( poIntrAppInfo != NULL )
    {
        poIntrAppInfo->m_u8AppInfoState = u8AppInfoState;
        return TRUE;
    }
    return FALSE;
}

tU8 tclAppInfoService::u8GetAppInfoState(tU16 u16AppId)
{
    tclInterestedAppInfo *poIntrAppInfo = poGetIntrAppInfo(u16AppId);
    if ( poIntrAppInfo != NULL )
    {
        return poIntrAppInfo->m_u8AppInfoState;
    }
    return AMT_C_U8_CCAMSG_APPLICATION_INFO_ERROR;
}
