/* Generated by Together */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "appmanager.h"
#include "minispm.h"

#include "application.h"

#include "CCAMessages.h"

#define MINIPROFILER_S_IMPORT_INTERFACE_ITRACE
#define ENABLE_INTERNAL_TRACE
#define ITRACE_TO_CONSOLE
#include "mini_profiler_if.h"


AppManager::AppManager(MiniSpm *poSpm)
: m_poSpm (poSpm),
  m_bSynchMode(TRUE)
{
}

AppManager::~AppManager()
{
    while (m_oSrvSuppAppsVector.size() != 0)
    {
        tSrvSupplierVector::iterator it = m_oSrvSuppAppsVector.begin();
        delete (*it);
        m_oSrvSuppAppsVector.erase(it);
    }
    while (m_oAppInfoVector.size() != 0)
    {
        tAppInfoVector::iterator it = m_oAppInfoVector.begin();
        delete (*it);
        m_oAppInfoVector.erase(it);
    }
    while (m_oHandleVect.size() != 0)
    {
        tHandleVect::iterator it = m_oHandleVect.begin();
        delete (*it);
        m_oHandleVect.erase(it);
    }
    while (m_oApps.size() != 0)
    {
        tApplicationVector::iterator it = m_oApps.begin();
        OSAL_s32MessageQueueClose ((*it)->hGetMsgQueueHandle());
        delete (*it);
        m_oApps.erase(it);
    }
}

void AppManager::vFillDataFromReg(Application *poApp)
{
    //ITRACE(("AppManager::vFillDataFromReg"));
    if ( poApp != NULL )
    {
        OSAL_tIODescriptor  s32fd_openkey;

        s32fd_openkey = OSAL_IOOpen( OSAL_C_STRING_DEVICE_REGISTRY"/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/PROCESS", OSAL_EN_READONLY);
        if ( OSAL_ERROR == s32fd_openkey )
        {
            ITRACE(("ERROR: Unable to open registry %s",OSAL_C_STRING_DEVICE_REGISTRY"/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/PROCESS"));
        }
        else
        {
            tChar  szProcName[100];
            unsigned long size = 100;
            tU32 i = 0;

            OSAL_trIOCtrlDir  arg ;
            arg.fd            = s32fd_openkey ;

            arg.s32Cookie     = 0 ; 

            while ( OSAL_ERROR != OSAL_s32IOControl( s32fd_openkey ,  OSAL_C_S32_IOCTRL_FIOREADDIR, (intptr_t)&arg) )
            {

                OSAL_szStringCopy( (tString)szProcName,(tCString)arg.dirent.s8Name );
                size = 100;         

                OSAL_tIODescriptor  s32fd_opensubkey ;

                tS8 as8Name[256] = OSAL_C_STRING_DEVICE_REGISTRY"/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/PROCESS";
                OSAL_szStringConcat((tString)as8Name, "/");
                OSAL_szStringConcat( (tString)as8Name, szProcName );

                s32fd_opensubkey =  OSAL_IOOpen( (tCString )as8Name , OSAL_EN_READONLY) ;
                if ( OSAL_ERROR == s32fd_opensubkey )
                {
                    ITRACE(("ERROR: Unable to open registry %s",as8Name));
                }
                else
                {
                    tU32 j = 0;
                    size = 100;
                    tChar szAppName[100];   

                    OSAL_trIOCtrlDir   arg ;
                    arg.fd             = s32fd_opensubkey ;
                    arg.s32Cookie      = 0 ;

                    while(OSAL_ERROR != OSAL_s32IOControl( s32fd_opensubkey ,  OSAL_C_S32_IOCTRL_FIOREADDIR , (intptr_t)&arg))
                    {
                        size = 100;
                        tS8 as8KeyName[256];
                        OSAL_szStringCopy((tString) szAppName, (tCString)arg.dirent.s8Name);
                        OSAL_szStringCopy((tString) as8KeyName, (tCString)as8Name);
                        OSAL_tIODescriptor  s32fd_open_subkeys;

                        OSAL_szStringConcat((tString)as8KeyName, "/");
                        OSAL_szStringConcat( (tString)as8KeyName, szAppName );

                        s32fd_open_subkeys = OSAL_IOOpen( (tCString)as8KeyName , OSAL_EN_READONLY);
                        if ( OSAL_ERROR == s32fd_open_subkeys )
                        {
                            ITRACE(("ERROR: Unable to open registry %s",as8KeyName));
                        }
                        else
                        {
                            OSAL_trIOCtrlRegistry  arg_appid;

                            tU32 dwAppID;
                            tChar szValueName_id[256]    = "APPID";

                            arg_appid.pcos8Name          = ( tPCS8 )szValueName_id ;
                            arg_appid.u32Size            = 4;
                            arg_appid.ps8Value           = (tPU8)&dwAppID;

                            tS32 s32RegAppOk  =OSAL_ERROR;
                            s32RegAppOk   = OSAL_s32IOControl( s32fd_open_subkeys , OSAL_C_S32_IOCTRL_REGQUERYVALUE  ,(intptr_t) &arg_appid);

                            if ( (OSAL_ERROR != s32RegAppOk) && (poApp->u16GetAppId() ==  dwAppID))
                            {
                                OSAL_tIODescriptor fd_open_SubSubKey;
                                tS8 as8SubKeyName[256];
                                OSAL_szStringCopy((tString) as8SubKeyName, (tCString)as8KeyName);
                                OSAL_szStringConcat((tString)as8SubKeyName, "/");
                                OSAL_szStringConcat( (tString)as8SubKeyName, "SERVICES" );

                                fd_open_SubSubKey = OSAL_IOOpen( (tCString)as8SubKeyName , OSAL_EN_READONLY);
                                if ( OSAL_ERROR == fd_open_SubSubKey )
                                {
                                    ITRACE(("ERROR: Unable to open registry %s",as8SubKeyName));
                                }
                                else
                                {
                                    OSAL_trIOCtrlDir   arg ;
                                    arg.fd             = fd_open_SubSubKey;
                                    arg.s32Cookie      = 0 ;
                                    while(OSAL_ERROR != OSAL_s32IOControl( fd_open_SubSubKey ,  OSAL_C_S32_IOCTRL_FIOREADDIR , (intptr_t)&arg))
                                    {
                                        tS8 as8LastSubKeyName[256];
                                        OSAL_szStringCopy((tString) as8LastSubKeyName, (tCString)as8SubKeyName);
                                        OSAL_tIODescriptor  s32fd_open_Lastsubkeys;

                                        OSAL_szStringConcat((tString)as8LastSubKeyName, "/");
                                        OSAL_szStringConcat( (tString)as8LastSubKeyName, (tCString)arg.dirent.s8Name );

                                        s32fd_open_Lastsubkeys = OSAL_IOOpen( (tCString)as8LastSubKeyName , OSAL_EN_READONLY);
                                        if ( OSAL_ERROR == s32fd_open_Lastsubkeys )
                                        {
                                            ITRACE(("ERROR: Unable to open registry %s",as8LastSubKeyName));
                                        }
                                        else
                                        {
                                            OSAL_trIOCtrlRegistry arg_service;
                                            tU32 u32ServiceId = 0;
                                            tChar szValueName_size[256]  = "SERVICEID";
                                            arg_service.pcos8Name           = ( tPCS8 )szValueName_size ;
                                            arg_service.u32Size             = sizeof(tU32);
                                            arg_service.ps8Value            = (tPU8)&u32ServiceId;
                                            tS32 s32RegServiceOk  = OSAL_ERROR;
                                            s32RegServiceOk   = OSAL_s32IOControl(  s32fd_open_Lastsubkeys , OSAL_C_S32_IOCTRL_REGQUERYVALUE  ,(intptr_t) &arg_service);
                                            if ( OSAL_ERROR != s32RegServiceOk)
                                                poApp->vAddServiceId(u32ServiceId);
                                            OSAL_s32IOClose(s32fd_open_Lastsubkeys);
                                        }

                                    }
                                    OSAL_s32IOClose(fd_open_SubSubKey);
                                }
                                // Got the expected application. So return
                                OSAL_s32IOClose(s32fd_open_subkeys);
                                OSAL_s32IOClose( s32fd_opensubkey );
                                OSAL_s32IOClose( s32fd_openkey );
                                return;
                            }
                            else
                            {
                                /*
                                *  Its not an application - ignore it!
                                */
                            }
                        }
                        OSAL_s32IOClose(s32fd_open_subkeys);
                    }
                }            
                OSAL_s32IOClose( s32fd_opensubkey );
            }
            OSAL_s32IOClose( s32fd_openkey );
        }
    }
}

tBool AppManager::bCheckRegistryExits()
{
    OSAL_tIODescriptor  s32fd;
    tBool bReturn = FALSE;
    s32fd = OSAL_IOOpen( OSAL_C_STRING_DEVICE_REGISTRY"/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/PROCESS", OSAL_EN_READONLY);
    if ( OSAL_ERROR == s32fd )
    {
        ITRACE(("ERROR: Unable to open registry %s",OSAL_C_STRING_DEVICE_REGISTRY"/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/PROCESS"));
    }
    else
    {
        OSAL_s32IOClose(s32fd);
        bReturn = TRUE;
    }
    return bReturn;
}

void AppManager::vStartApps(const char *szAppsToStart)
{
    /*
    *  alle Apps initialisieren
    */

    ITRACE(("AppManager::vStartApps"));
    if ( bCheckRegistryExits() )
    {
        tApplicationWaitList oWaitList;
        vGetWaitList(szAppsToStart, oWaitList);
        vInitApps(oWaitList);
    }
    else
    {
        ITRACE(("AppManager::vStartApps Error: Registry is not Valid or Not Existing"));
        OSAL_s32SemaphorePost(m_poSpm->m_phAllNormalEvent);
    }

}


void AppManager::vInitApps(tApplicationWaitList &oWaitList)
{
    OSAL_trMessage hMessage;
    tU32 u32Prior;

    tS32 s32MsgSize = 0;

    tU32 u32TimeOutValue = 3000;

    bool bAllAppsInit = (oWaitList.size() == 0) ? true : false;

    tApplicationWaitList::iterator it = oWaitList.begin();
    while (it != oWaitList.end())
    {
        Application *app = new Application (   (*it), OSAL_C_INVALID_HANDLE,  AMT_C_U32_STATE_INVALID   );
        vFillDataFromReg(app);
        m_oApps.push_back(app);
        ++it;
    }

    vTraceAppList("Force Wait for Applications", oWaitList);

    do
    {
        s32MsgSize = OSAL_s32MessageQueueWait(  m_poSpm->hGetSpmQueueHandle(),(tU8 *) &hMessage, sizeof(OSAL_trMessage), &u32Prior, u32TimeOutValue);
        if (s32MsgSize > 0)
        {
            u32TimeOutValue = OSAL_C_TIMEOUT_FOREVER;
            CCCABaseMsg *poBaseMsg = (CCCABaseMsg *) OSAL_pu8MessageContentGet(hMessage, OSAL_EN_READONLY); //lint !e826

            if (poBaseMsg != NULL)
            {
                switch( poBaseMsg->u8Type )
                {
                case AMT_C_U8_CCAMSGTYPE_POWER:
                    {
                        CPowerMsg *poPowerMsg = reinterpret_cast<CPowerMsg*>(poBaseMsg);
                        tBool bHandled = FALSE;
                        if (poPowerMsg->u16PowerType == AMT_C_U16_PWR_APP_START_REQ)
                        {
                            ITRACE(("Receive Startrequest from %d", poPowerMsg->u16SourceAppId));

                            bHandled = TRUE;

                            OSAL_tMQueueHandle hAppQueueHandle;
                            tChar ps8BoxName[256] = {0};
                            OSAL_s32PrintFormat(ps8BoxName,"mbx_%d",poPowerMsg->u16SourceAppId);

                            if (OSAL_s32MessageQueueOpen(ps8BoxName, OSAL_EN_WRITEONLY, &hAppQueueHandle) == OSAL_OK)
                            {
                                Application *app = poFindApp(poPowerMsg->u16SourceAppId);
                                if (app == NULL)
                                {
                                    app = new Application ( poPowerMsg->u16SourceAppId, 
                                        hAppQueueHandle, 
                                        AMT_C_U32_STATE_UNINITALIZED   );
                                    vFillDataFromReg(app);
                                    m_oApps.push_back(app);
                                }
                                else
                                {
                                    app->vSetMsgQueueHandle(hAppQueueHandle);
                                }

                                m_poSpm->s32CCASendPowerMsg (AMT_C_U16_PWR_PROXY_START_CONF, 0, 0, app);
                                app->vSetAppState(AMT_C_U32_STATE_UNINITALIZED);
                                ITRACE(("Send confirmation to %d", poPowerMsg->u16SourceAppId));
                            }
                        }

                        if (poPowerMsg->u16PowerType == AMT_C_U16_PWR_APP_INITIALIZED)
                        {
                            ITRACE(("Got INITIALIZED from %d", poPowerMsg->u16SourceAppId));
                            bHandled = TRUE;

                            Application *app = poFindApp(poPowerMsg->u16SourceAppId);
                            if (app != NULL)
                            {
                                app->vSetAppState(AMT_C_U32_STATE_INITIALIZED);
                                app->vSetAppReqState(AMT_C_U32_STATE_NORMAL);
                                if ( m_bSynchMode == TRUE )
                                {
                                     if (bCheckAppStates(AMT_C_U32_STATE_INITIALIZED) == TRUE)
                                     {
                                         vChangeStateTo(AMT_C_U32_STATE_NORMAL);
                                     }
                                }
                                else
                                {
                                    vInformSrvSuppRegApps(app);
                                    vInformAppInfoRegApps(app);
                                    m_poSpm->s32CCASendPowerMsg (AMT_C_U16_PWR_PROXY_STATE_CHANGE_REQ, AMT_C_U32_STATE_NORMAL, 0, app);
                                }
                            }
                        }

                        if (   poPowerMsg->u16PowerType == AMT_C_U16_PWR_APP_STATE_ACK  && poPowerMsg->u32Data2 == 0 )
                        {
                            ITRACE (("App %d replied statechange with %u %u", poPowerMsg->u16SourceAppId, poPowerMsg->u32Data1, poPowerMsg->u32Data2));
                            bHandled = TRUE;

                            Application *app = poFindApp(poPowerMsg->u16SourceAppId);
                            if (app != NULL)
                            {
                                if ( app->u16GetAppReqState() == AMT_C_U32_STATE_NORMAL )
                                {
                                    app->vSetAppState (AMT_C_U32_STATE_NORMAL);
                                    if ( bCheckAppStates(AMT_C_U32_STATE_NORMAL) == TRUE )
                                    {
                                        if (m_poSpm->m_phAllNormalEvent != OSAL_C_INVALID_HANDLE)
                                        {
                                            OSAL_s32SemaphorePost(m_poSpm->m_phAllNormalEvent);
                                            m_poSpm->m_phAllNormalEvent = OSAL_C_INVALID_HANDLE;
                                        }
                                        tHandleVect::iterator it = m_oHandleVect.begin();
                                        while (it != m_oHandleVect.end())
                                        {
                                            if ( ((*it)->m_u32TargetState == AMT_C_U32_STATE_NORMAL) && ((*it)->m_hSem != OSAL_C_INVALID_HANDLE))
                                            {
                                                OSAL_s32SemaphorePost((*it)->m_hSem);
                                                delete (*it);
                                                it = m_oHandleVect.erase(it);
                                            }
                                            else
                                            {
                                                ++it;
                                            }
                                        }
                                        OSAL_s32SemaphorePost(m_poSpm->hGetProtectionHandle());
                                    }
                                }
                                if ( app->u16GetAppReqState() == AMT_C_U32_STATE_PAUSE )
                                {
                                    app->vSetAppState (AMT_C_U32_STATE_PAUSE);
                                    if ( bCheckAppStates(AMT_C_U32_STATE_PAUSE) == TRUE )
                                    {
                                        tHandleVect::iterator it = m_oHandleVect.begin();
                                        while (it != m_oHandleVect.end())
                                        {
                                            if ( ((*it)->m_u32TargetState == AMT_C_U32_STATE_PAUSE) && ((*it)->m_hSem != OSAL_C_INVALID_HANDLE))
                                            {
                                                OSAL_s32SemaphorePost((*it)->m_hSem);
                                                delete (*it);
                                                it = m_oHandleVect.erase(it);
                                            }
                                            else
                                            {
                                                ++it;
                                            }
                                        }
                                        OSAL_s32SemaphorePost(m_poSpm->hGetProtectionHandle());
                                    }
                                }
                                if ( app->u16GetAppReqState() == AMT_C_U32_STATE_OFF )
                                {
                                    app->vSetAppState (AMT_C_U32_STATE_OFF);
                                    app->vSetAppReqState(AMT_C_U32_STATE_INVALID);
                                    m_bSynchMode = TRUE; //wait for all in OFF, then TERMINATED
                                    if ( m_bSynchMode == TRUE )
                                    {
                                        if (bCheckAppStates(AMT_C_U32_STATE_OFF) == TRUE)
                                        {
                                            ITRACE (("AppManager: all apps in OFF, now send to TERMINATED"));
                                            if (m_oApps.size() > 0)
                                            {
                                                for (unsigned int i=0; i<m_oApps.size(); ++i)
                                                {
                                                    Application *app = m_oApps[i];
                                                    ITRACE (("Request statechange to %d from App %d", AMT_C_U16_PWR_PROXY_END_APP, app->u16GetAppId()));
                                                    m_poSpm->s32CCASendPowerMsg (AMT_C_U16_PWR_PROXY_END_APP, 0, 0, app);
                                                }
                                            }
                                        }
                                    }
                                    else
                                    {
                                        m_poSpm->s32CCASendPowerMsg (AMT_C_U16_PWR_PROXY_END_APP, 0, 0, app);
                                    }
                                }
                            }
                        }
                        if (poPowerMsg->u16PowerType == AMT_C_U16_PWR_APP_END_FAILURE)
                        {
                            ITRACE(( "Got AMT_C_U16_PWR_APP_END_FAILURE message from App %u (u16PowerType %u, u32Data1 %u, u32Data2 %u)", 
                                poPowerMsg->u16SourceAppId, 
                                poPowerMsg->u16PowerType, 
                                poPowerMsg->u32Data1, 
                                poPowerMsg->u32Data2  ));
                            bHandled = TRUE;
                            OSAL_vAssert(0);
                        }
                        if ( poPowerMsg->u16PowerType == AMT_C_U16_PWR_APP_END_SUCCESSFUL )
                        {
                            bHandled = TRUE;
                            Application *app = poFindApp(poPowerMsg->u16SourceAppId);
                            if (app != NULL)
                            {
                                app->vSetAppState(AMT_C_U32_STATE_INVALID);
                                ITRACE(("Got TERMINATED from %d", poPowerMsg->u16SourceAppId));
                                if ( bCheckAppStates(AMT_C_U32_STATE_INVALID) )
                                {
                                    s32MsgSize = 0;
                                    break;
                                }
                            }
                        }
                        if ( (poPowerMsg->u16PowerType  == AMT_C_U16_PWR_APP_END_SUCCESSFUL ) || (poPowerMsg->u16PowerType  == AMT_C_U16_PWR_APP_END_FAILURE) )
                        {
                            bHandled = TRUE;
                            Application *app = poFindApp(poPowerMsg->u16SourceAppId);
                            if ( (app != NULL) && (app->u16GetAppState() == AMT_C_U32_STATE_INVALID ) )
                            {
                                vInformSrvSuppRegApps(app);
                                vInformAppInfoRegApps(app);
                                vRemoveFromAppInfoList(app->u16GetAppId());
                                vRemoveFromSrvSupplierList(app->u16GetAppId());
                            }
                        }
                        if ( bHandled == FALSE )
                        {
                            ITRACE(("POWER MESSAGE NOT HANDLED FROM APP %u (u16PowerType %u, u32Data1 %u, u32Data2 %u)", 
                                poPowerMsg->u16SourceAppId, 
                                poPowerMsg->u16PowerType, 
                                poPowerMsg->u32Data1, 
                                poPowerMsg->u32Data2  ));
                        }
                    }
                    break;
                case DO_STATE_REQUEST:
                    {
                        OSAL_tSemHandle hDoneEvent = poBaseMsg->u32Size;

                        tU32 u32TargetState = AMT_C_U32_STATE_INVALID;
                        m_poSpm->m_oStateListLock.vLock();
                        if (m_poSpm->m_oStateList.size() > 1)
                        {
                            u32TargetState = m_poSpm->m_oStateList[1];
                            m_poSpm->m_oStateList.erase(m_poSpm->m_oStateList.begin());
                        }
                        m_poSpm->m_oStateListLock.vUnlock();

                        if (u32TargetState != AMT_C_U32_STATE_INVALID)
                            vChangeStateTo((tU16) u32TargetState);
                        tclHandle *pHandle = new tclHandle();
                        pHandle->m_hSem =hDoneEvent;
                        pHandle->m_u32TargetState = u32TargetState;
                        m_oHandleVect.push_back(pHandle);
                    }
                    break;
                case AMT_C_U8_CCAMSGTYPE_SUPPLIER_STATE_REGISTER:
                    {
                        CServiceSupplierRegister *poSrvSuppierReg = reinterpret_cast<CServiceSupplierRegister*>(poBaseMsg);
                        if (poSrvSuppierReg != NULL )
                        {
                            ITRACE(("Got SUPPLIER_STATE_REGISTER from %d for service id %d", poSrvSuppierReg->u16SourceAppId,poSrvSuppierReg->m_nServiceID));
                            vAddToSrvSuppListAndAck(poSrvSuppierReg->m_nServiceID,poSrvSuppierReg->u16SourceAppId);
                        }
                        else
                            OSAL_vAssert(0);
                        m_bSynchMode = false;
                    }
                    break;
                case AMT_C_U8_CCAMSGTYPE_SUPPLIER_STATE_UNREGISTER:
                    {
                        CServiceSupplierUnregister *poSrvSuppierUnreg = reinterpret_cast<CServiceSupplierUnregister*>(poBaseMsg);
                        if (poSrvSuppierUnreg != NULL )
                        {
                            ITRACE(("Got SUPPLIER_STATE_UNREGISTER from %d for service id %d", poSrvSuppierUnreg->u16SourceAppId,poSrvSuppierUnreg->m_nServiceID));
                            vSrvSupplierUnreg(poSrvSuppierUnreg->m_nServiceID,poSrvSuppierUnreg->u16SourceAppId);
                        }
                        else
                            OSAL_vAssert(0);
                        m_bSynchMode = false;
                    }
                    break;

                case AMT_C_U8_CCAMSGTYPE_APPLICATION_INFO_REGISTER:
                    {
                        CApplicationInfoRegister *poAppInfoReg = reinterpret_cast<CApplicationInfoRegister*>(poBaseMsg);
                        if (poAppInfoReg != NULL )
                        {
                            // Client with u16SourceAppId is interested in server with app id m_nAppID
                            // if the server with appid m_nAppID is already up then inform the client by sending a AppInfoStatus
                            ITRACE(("Got APPLICATION_INFO_REGISTER from %d for App id %d", poAppInfoReg->u16SourceAppId,poAppInfoReg->m_nAppID));
                            vAddToAppInfoListAndAck(poAppInfoReg->m_nAppID,poAppInfoReg->u16SourceAppId);
                        }
                        else
                            OSAL_vAssert(0);
                        m_bSynchMode = false;
                    }
                    break;
                case AMT_C_U8_CCAMSGTYPE_APPLICATION_INFO_UNREGISTER:
                    {
                        CApplicationInfoUnregister *poAppInfoUnReg = reinterpret_cast<CApplicationInfoUnregister*>(poBaseMsg);
                        if (poAppInfoUnReg != NULL )
                        {
                            // Remove the client from notification table
                            ITRACE(("Got APPLICATION_INFO_UNREGISTER from %d for App id %d", poAppInfoUnReg->u16SourceAppId,poAppInfoUnReg->m_nAppID));
                            vAppInfoUnReg(poAppInfoUnReg->m_nAppID,poAppInfoUnReg->u16SourceAppId);
                        }
                        else
                            OSAL_vAssert(0);
                        m_bSynchMode = false;
                    }
                    break;

                default:
                    ITRACE(("\n Wrong Message Type %d",poBaseMsg->u8Type));

                }
            }

            OSAL_s32MessageDelete(hMessage);
        }
        else
        {
            if ( OSAL_u32ErrorCode() == OSAL_E_TIMEOUT )
            {
                if (m_poSpm->m_phAllNormalEvent != OSAL_C_INVALID_HANDLE)
                {
                    OSAL_s32SemaphorePost(m_poSpm->m_phAllNormalEvent);
                    m_poSpm->m_phAllNormalEvent = OSAL_C_INVALID_HANDLE;
                }
                OSAL_s32SemaphorePost(m_poSpm->hGetProtectionHandle());
                break;
            }
        }
    } while (s32MsgSize != 0);
}



void AppManager::vEndApps()
{
    ITRACE(("AppManager::vEndApps"));

    vChangeStateTo(AMT_C_U32_STATE_OFF);

}

void AppManager::vChangeStateTo(tU16 u16NewState)
{
    if (m_oApps.size() > 0)
    {
        for (unsigned int i=0; i<m_oApps.size(); ++i)
        {
            Application *app = m_oApps[i];
            ITRACE (("Request statechange to %d from App %d", u16NewState, app->u16GetAppId()));
            app->vSetAppReqState(u16NewState);
            m_poSpm->s32CCASendPowerMsg (AMT_C_U16_PWR_PROXY_STATE_CHANGE_REQ, u16NewState, 0, app);
        }
    }
}

void AppManager::vTraceAppList(const char *szPrefix, const tApplicationWaitList &oWaitList)
{
    std::string oTmp;
    for (unsigned int i=0; i<oWaitList.size(); ++i)
    {
#define BUF 64
        char szTmp[BUF] = {'\0'};
        OSALUTIL_s32SaveNPrintFormat(szTmp, BUF, "%u", oWaitList[i]);
        if (oTmp.size() > 0)
            oTmp += ", ";
        oTmp += szTmp;
    }
    ITRACE(("%s %s", szPrefix, oTmp.c_str() ));
}



tBool AppManager::bCheckAppStates(tU16 u16AppState)
{
    tApplicationWaitList oWaitList;

    for ( unsigned int i=0; i<m_oApps.size(); ++i)
    {
        Application *app = m_oApps[i];
        if (app->u16GetAppState() != u16AppState)
        {
            oWaitList.push_back(app->u16GetAppId());
        }
    }

    if (oWaitList.size() > 0)
    {
        // Noch nicht alle apps im angeforderten Zustand...
        vTraceAppList("Wait for Applications", oWaitList);
    }
    else
    {
        // alle apps fertig!
        char tmp[1024];
        char tmp1[1024];
        OSALUTIL_s32NPrintFormat((tS8*)tmp, 1024, "All Apps in state %d: ", u16AppState);

        for ( unsigned int j=0; j<m_oApps.size(); ++j)
        {
            strncpy (tmp1, tmp, 1024);
            Application *app = m_oApps[j];
            OSALUTIL_s32NPrintFormat((tS8*)tmp, 1024, "%s %d", tmp1, app->u16GetAppId());
        }
        tmp[1023] = '\0';
        tmp[1022] = '\n';
        ITRACE((tmp));
    }

    return (oWaitList.size() == 0) ? TRUE : FALSE;
}

Application *AppManager::poFindApp(tU16 u16AppId)
{
    Application *app = NULL;

    for (unsigned int i=0; i<m_oApps.size(); ++i)
    {
        if (m_oApps[i]->u16GetAppId() == u16AppId)
        {
            app = m_oApps[i];
            break;
        }
    }

    return app;
}


void AppManager::vGetWaitList (const char *szApps, tApplicationWaitList &oEmptyList)
{
    if (szApps != NULL)
    {
        unsigned int u32Len = strlen (szApps);
        if (u32Len > 0)
        {
            char *szString = new char[u32Len+1];
            if (szString != NULL)
            {
                strcpy (szString, szApps);
                szString[u32Len] = '\0';

                char *szTok = strtok(szString, ",");
                while (szTok != NULL)
                {
                    oEmptyList.push_back(atoi(szTok));
                    szTok = strtok(NULL, ",");
                };

                delete[] szString;
            }
        }
    }
}

void AppManager::vAddToSrvSuppListAndAck(tU16 u16ServiceId, tU16 u16ClientAppId)
{
    tclSrvSupplier* poSrvSuppInfo = NULL;

    for (unsigned int i = 0; i < m_oSrvSuppAppsVector.size(); ++i)
    {
        if ( m_oSrvSuppAppsVector[i]->u16GetAppId() == u16ClientAppId )
        {
            m_oSrvSuppAppsVector[i]->bSrvSuppRegister(u16ServiceId);
            poSrvSuppInfo = m_oSrvSuppAppsVector[i];
            break;
        }
    }
    if ( poSrvSuppInfo == NULL)
    {
        poSrvSuppInfo = new tclSrvSupplier(u16ClientAppId);
        if ( poSrvSuppInfo != NULL )
        {
            poSrvSuppInfo->bSrvSuppRegister(u16ServiceId);
            m_oSrvSuppAppsVector.push_back(poSrvSuppInfo);
        }
    }
    Application * App = poFindApp(u16ClientAppId);
    if ( App != NULL )
    {
        tBool bChkOneSrvProviderExists = FALSE;
        for (unsigned int i=0; i < m_oApps.size(); ++i)
        {
            if ( m_oApps[i]->bCheckAppServiceProvider( u16ServiceId ) == TRUE )
            {
                if ( (m_oApps[i]->u16GetAppState() == AMT_C_U32_STATE_INITIALIZED) || (m_oApps[i]->u16GetAppState() == AMT_C_U32_STATE_NORMAL))
                {
                    poSrvSuppInfo->bSetServiceInfoState(u16ServiceId,AMT_C_U8_CCAMSG_SUPPLIER_STATE_AVAILABLE);
                    m_poSpm->s32CCASendSrvStatus(u16ServiceId,m_oApps[i]->u16GetAppId(),AMT_C_U8_CCAMSG_SUPPLIER_STATE_AVAILABLE,App->u16GetAppId(),App->hGetMsgQueueHandle());
                    ITRACE(("Sending SrvSuppStatus ( DestAppId,ServiceId,AppId,state ) -> (%d,%d,%d,SUPPLIER_STATE_AVAILABLE) ",u16ClientAppId,u16ServiceId,m_oApps[i]->u16GetAppId()));
                }
                else
                {
                    poSrvSuppInfo->bSetServiceInfoState(u16ServiceId,AMT_C_U8_CCAMSG_SUPPLIER_STATE_UNAVAILABLE);
                    m_poSpm->s32CCASendSrvStatus(u16ServiceId,m_oApps[i]->u16GetAppId(),AMT_C_U8_CCAMSG_SUPPLIER_STATE_UNAVAILABLE,App->u16GetAppId(),App->hGetMsgQueueHandle());
                    ITRACE(("Sending SrvSuppStatus ( DestAppId,ServiceId,AppId,state ) -> (%d,%d,%d,SUPPLIER_STATE_UNAVAILABLE) ",u16ClientAppId,u16ServiceId,m_oApps[i]->u16GetAppId()));
                }
                bChkOneSrvProviderExists = TRUE;
            }
        }
        if ( bChkOneSrvProviderExists == FALSE )
        {
            poSrvSuppInfo->bSetServiceInfoState(u16ServiceId,AMT_C_U8_CCAMSG_SUPPLIER_STATE_UNKNOWN);
            m_poSpm->s32CCASendSrvStatus(u16ServiceId,AMT_C_U16_APPID_INVALID,AMT_C_U8_CCAMSG_SUPPLIER_STATE_UNKNOWN,App->u16GetAppId(),App->hGetMsgQueueHandle());
            ITRACE(("Sending SrvSuppStatus ( DestAppId,ServiceId,AppId,state ) -> (%d,%d,APPID_INVALID,SUPPLIER_STATE_UNKNOWN) ",u16ClientAppId,u16ServiceId));
        }
    }
    else
        OSAL_vAssert(0);
}

void AppManager::vInformSrvSuppRegApps(Application *poApp)
{
    for (unsigned int i=0; i< m_oSrvSuppAppsVector.size(); ++i)
    {
        Application *ClientApp = poFindApp(m_oSrvSuppAppsVector[i]->u16GetAppId());
        for (unsigned int j=0; j< m_oSrvSuppAppsVector[i]->m_oIntrSrvSuppVector.size(); ++j)
        {
            if ( poApp->bCheckAppServiceProvider(m_oSrvSuppAppsVector[i]->m_oIntrSrvSuppVector[j]->m_u16ServiceId) == TRUE )
            {
                if ( (poApp->u16GetAppState() == AMT_C_U32_STATE_INITIALIZED) || (poApp->u16GetAppState() == AMT_C_U32_STATE_NORMAL))
                {
                    m_oSrvSuppAppsVector[i]->m_oIntrSrvSuppVector[j]->m_u8ServiceState = AMT_C_U8_CCAMSG_SUPPLIER_STATE_AVAILABLE;
                    ITRACE(("Sending SrvSuppStatus ( DestAppId,ServiceId,AppId,state ) -> (%d,%d,%d,SUPPLIER_STATE_AVAILABLE) ",m_oSrvSuppAppsVector[i]->u16GetAppId(),m_oSrvSuppAppsVector[i]->m_oIntrSrvSuppVector[j]->m_u16ServiceId,poApp->u16GetAppId()));
                }
                else
                {
                    m_oSrvSuppAppsVector[i]->m_oIntrSrvSuppVector[j]->m_u8ServiceState = AMT_C_U8_CCAMSG_SUPPLIER_STATE_UNAVAILABLE;
                    ITRACE(("Sending SrvSuppStatus ( DestAppId,ServiceId,AppId,state ) -> (%d,%d,%d,SUPPLIER_STATE_UNAVAILABLE) ",m_oSrvSuppAppsVector[i]->u16GetAppId(),m_oSrvSuppAppsVector[i]->m_oIntrSrvSuppVector[j]->m_u16ServiceId,poApp->u16GetAppId()));
                }
                m_poSpm->s32CCASendSrvStatus(
                    m_oSrvSuppAppsVector[i]->m_oIntrSrvSuppVector[j]->m_u16ServiceId,
                    poApp->u16GetAppId(),
                    m_oSrvSuppAppsVector[i]->m_oIntrSrvSuppVector[j]->m_u8ServiceState,
                    ClientApp->u16GetAppId(),
                    ClientApp->hGetMsgQueueHandle());
            }
        }
    }
}

void AppManager::vSrvSupplierUnreg(tU16 u16ServiceId,tU16 u16ClientAppId)
{
    tSrvSupplierVector::iterator it = m_oSrvSuppAppsVector.begin();
    while (it != m_oSrvSuppAppsVector.end())
    {
        if ( (*it)->u16GetAppId() == u16ClientAppId )
        {
            if ( (*it)->bSrvSuppUnRegister(u16ServiceId))
                ITRACE(("ServiceId %d is removed from SrvSupplier List ",u16ServiceId));
            if ( (*it)->m_oIntrSrvSuppVector.size() == 0 )
            {
                ITRACE(("AppId %d is removed from SrvSupplier List ",(*it)->u16GetAppId()));
                delete (*it);
                m_oSrvSuppAppsVector.erase(it);
            }
            break;
        }
        ++it;
    }
}

void AppManager::vAddToAppInfoListAndAck(tU16 u16ServerAppId, tU16 u16ClientAppId)
{
    tclAppInfoService* poAppInfoSrv = NULL;

    for (unsigned int i = 0; i < m_oAppInfoVector.size(); ++i)
    {
        if ( m_oAppInfoVector[i]->u16GetAppId() == u16ClientAppId )
        {
            m_oAppInfoVector[i]->bAppInfoRegister(u16ServerAppId);
            poAppInfoSrv = m_oAppInfoVector[i];
            break;
        }
    }
    if ( poAppInfoSrv == NULL)
    {
        poAppInfoSrv = new tclAppInfoService(u16ClientAppId);
        if ( poAppInfoSrv != NULL )
        {
            poAppInfoSrv->bAppInfoRegister(u16ServerAppId);
            m_oAppInfoVector.push_back(poAppInfoSrv);
        }
    }

    //Send the status immidiately
    Application *poClientApp = poFindApp(u16ClientAppId);
    Application *poSrvApp = poFindApp(u16ServerAppId);
    if ( poClientApp != NULL )
    {
        if(poSrvApp != NULL )
        {
            if ( (poSrvApp->u16GetAppState() == AMT_C_U32_STATE_INITIALIZED) || (poSrvApp->u16GetAppState() == AMT_C_U32_STATE_NORMAL))
            {
                poAppInfoSrv->bSetAppInfoState(u16ServerAppId,AMT_C_U8_CCAMSG_APPLICATION_INFO_AVAILABLE);
                m_poSpm->s32CCASendAppInfoStatus( u16ServerAppId, AMT_C_U8_CCAMSG_APPLICATION_INFO_AVAILABLE, poClientApp->u16GetAppId(),poClientApp->hGetMsgQueueHandle());
                ITRACE(("Sending AppInfoStatus ( DestAppId,AppID,State )-> (%d,%d,APPLICATION_INFO_AVAILABLE) ",poClientApp->u16GetAppId(),u16ServerAppId));
            }
            else
            {
                poAppInfoSrv->bSetAppInfoState(u16ServerAppId,AMT_C_U8_CCAMSG_APPLICATION_INFO_UNAVAILABLE);
                m_poSpm->s32CCASendAppInfoStatus( u16ServerAppId, AMT_C_U8_CCAMSG_APPLICATION_INFO_UNAVAILABLE, poClientApp->u16GetAppId(),poClientApp->hGetMsgQueueHandle());
                ITRACE(("Sending AppInfoStatus ( DestAppId,AppID,State )-> (%d,%d,APPLICATION_INFO_UNAVAILABLE) ",poClientApp->u16GetAppId(),u16ServerAppId));
            }
        }
        else
        {
            poAppInfoSrv->bSetAppInfoState(u16ServerAppId,AMT_C_U8_CCAMSG_APPLICATION_INFO_UNKNOWN);
            m_poSpm->s32CCASendAppInfoStatus(  AMT_C_U16_APPID_INVALID, AMT_C_U8_CCAMSG_APPLICATION_INFO_UNKNOWN, poClientApp->u16GetAppId(),poClientApp->hGetMsgQueueHandle());
            ITRACE(("Sending AppInfoStatus ( DestAppId,AppID,State )-> (%d,APPID_INVALID,APPLICATION_INFO_UNAVAILABLE) ",poClientApp->u16GetAppId()));
        }
    }
    else
        OSAL_vAssert(0);
}

void AppManager::vInformAppInfoRegApps(Application *poApp)
{
    if ( poApp != NULL )
    {
        for (unsigned int i = 0; i < m_oAppInfoVector.size(); ++i)
        {
            Application *poClientApp = poFindApp(m_oAppInfoVector[i]->u16GetAppId());
            if ( poClientApp != NULL )
            {
                for (unsigned int j = 0; j< m_oAppInfoVector[i]->m_oIntrAppInfoVector.size(); j++ )
                {
                    if ( m_oAppInfoVector[i]->m_oIntrAppInfoVector[j]->m_u16AppId == poApp->u16GetAppId() )
                    {
                        if ( (poApp->u16GetAppState() == AMT_C_U32_STATE_INITIALIZED) || (poApp->u16GetAppState() == AMT_C_U32_STATE_NORMAL))
                        {
                            m_oAppInfoVector[i]->m_oIntrAppInfoVector[j]->m_u8AppInfoState = AMT_C_U8_CCAMSG_APPLICATION_INFO_AVAILABLE;
                            ITRACE(("Sending AppInfoStatus ( DestAppId,AppID,State )-> (%d,%d,APPLICATION_INFO_AVAILABLE) ",poClientApp->u16GetAppId(),m_oAppInfoVector[i]->m_oIntrAppInfoVector[j]->m_u16AppId));
                        }
                        else
                        {
                            m_oAppInfoVector[i]->m_oIntrAppInfoVector[j]->m_u8AppInfoState = AMT_C_U8_CCAMSG_APPLICATION_INFO_UNAVAILABLE;
                            ITRACE(("Sending AppInfoStatus ( DestAppId,AppID,State )-> (%d,%d,APPLICATION_INFO_UNAVAILABLE) ",poClientApp->u16GetAppId(),m_oAppInfoVector[i]->m_oIntrAppInfoVector[j]->m_u16AppId));
                        }
                        m_poSpm->s32CCASendAppInfoStatus(   
                            m_oAppInfoVector[i]->m_oIntrAppInfoVector[j]->m_u16AppId,
                            m_oAppInfoVector[i]->m_oIntrAppInfoVector[j]->m_u8AppInfoState,
                            poClientApp->u16GetAppId(),
                            poClientApp->hGetMsgQueueHandle());
                    }
                }
            }
        }
    }
}

void AppManager::vAppInfoUnReg(tU16 u16ServerAppId,tU16 u16ClientAppId)
{
    tAppInfoVector::iterator it = m_oAppInfoVector.begin();
    while (it != m_oAppInfoVector.end())
    {
        if ( (*it)->u16GetAppId() == u16ClientAppId )
        {
            if ( (*it)->bAppInfoUnRegister(u16ServerAppId))
                ITRACE(("Removing AppId %d from AppInfoList ",u16ServerAppId));
            if ((*it)->m_oIntrAppInfoVector.size() == 0)
            {
                ITRACE(("Removing AppId %d from AppInfoList ",(*it)->u16GetAppId()));
                delete (*it);
                m_oAppInfoVector.erase(it);
            }
            break;
        }
        ++it;
    }
}

void AppManager::vRemoveFromSrvSupplierList(tU16 u16AppId)
{
    tSrvSupplierVector::iterator it = m_oSrvSuppAppsVector.begin();
    while (it != m_oSrvSuppAppsVector.end())
    {
        if ( (*it)->u16GetAppId() == u16AppId )
        {
            delete (*it);
            m_oSrvSuppAppsVector.erase(it);
            ITRACE(("AppId %d is removed from SrvSupplier List ",u16AppId));
            break;
        }
        ++it;
    }
}

void AppManager::vRemoveFromAppInfoList(tU16 u16AppId)
{
    tAppInfoVector::iterator it = m_oAppInfoVector.begin();
    while (it != m_oAppInfoVector.end())
    {
        if ( (*it)->u16GetAppId() == u16AppId )
        {
            delete (*it);
            m_oAppInfoVector.erase(it);
            ITRACE(("Removing AppId %d from AppInfoList ",u16AppId));
            break;
        }
        ++it;
    }
}
