
#ifndef CLIENT_SOCKET_H
#define CLIENT_SOCKET_H

#ifdef VASCO_OS_LINUX
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <netdb.h>

#define SOCKET int
#define INVALID_SOCKET -1
#define SOCKADDR_IN struct sockaddr_in
#define SOCKADDR struct sockaddr
#define PSOCKADDR  (struct sockaddr*)
#define SOCKET_ERROR -1
#define closesocket(x) close(x)
//#define __packed             __attribute__ ((packed))
#define INVALID_HANDLE_VALUE -1
#define Sleep usleep;
#else
#include "winsock2.h"
#endif

class ClientSocket
{
   private:
      SOCKET m_oClientSocket;
      bool m_bSynchronize;

   public:
      ClientSocket(bool bSynchronize = true);
      ~ClientSocket();

      bool bInit(int port, const char *szHostName = NULL);
      void vClose();

      int s32Send (const char *buf, int len, int flags);
};

#endif    // CLIENT_SOCKET_H
