/******************************************************************************\
 *
 * FILE:         system_ipc.h
 *
 *
 * DESCRIPTION:  This module is the interface header for IPCA
 *               
 *
 * AUTHOR:       CM/DI ESI 1 - Dirk Tiemann
 *
 * COPYRIGHT:    (c) 2002 Blaupunktwerke GmbH, Hildesheim
 *
\******************************************************************************/

/* PVCS Change Description */
/*
  $Log:   //hi230124/projects/Vasco/swnavi/archives/products/system/system_ipc.h-arc  $
 * 
 *    Rev 1.0   Feb 14 2003 13:37:00   TND2HI
 * Initial revision.
*/

/******************************************************************************/
#ifndef SYSTEM_IPC_HEADER
#define SYSTEM_IPC_HEADER

/* ************************************************************************** */
/* INCLUDES */
/* ************************************************************************** */

#ifdef __cplusplus
extern "C" {
#endif

/* ************************************************************************** */
/* DEFINES */
/* ************************************************************************** */
/* Context Bytes Definition Table (CBDT, version 0.91) */

#define IPC_MSG_HEADER_LENGTH   15
  
/* -------------------------------------------------------------------------- */
/* @def IPC_CONTEXT_TYPE_... | 0xXX | posible context types */
#define IPC_CONTEXT_TYPE_LOCAL_CCA              0x00
#define IPC_CONTEXT_TYPE_IPNET_SSI              0x40
//#define IPC_CONTEXT_TYPE_IPNET_SSS              0x40
#define IPC_CONTEXT_TYPE_MCNET                  0x80
#define IPC_CONTEXT_TYPE_ISO_TP                 0x81
#define IPC_CONTEXT_TYPE_NET_VAG_CAN            0x84
#define IPC_CONTEXT_TYPE_NET_DC_CAN             0x88
#define IPC_CONTEXT_TYPE_NET_MOST               0xA0
#define IPC_CONTEXT_TYPE_NET_MOST2              0xA1

/* -------------------------------------------------------------------------- */
/* @def IPC_CONTEXT_SUB_TYPE_... | 0xXX | posible context sub types */
/* LOCAL_CCA */
#define IPC_CONTEXT_SUBTYPE_POWER_MESSAGE                   0x40
#define IPC_CONTEXT_SUBTYPE_SERVICE_REGISTER                0x41
#define IPC_CONTEXT_SUBTYPE_SERVICE_UNREGISTER              0x42
#define IPC_CONTEXT_SUBTYPE_SERVICE_REGISTER_CONFIRMATION   0x43
#define IPC_CONTEXT_SUBTYPE_UNKNOWN_REGISTER_ID             0x04
#define IPC_CONTEXT_SUBTYPE_SERVICE_STATUS                  0x44
#define IPC_CONTEXT_SUBTYPE_SERVICE_DATA                    0x45
#define IPC_CONTEXT_SUBTYPE_SUPPLIER_STATE_REGISTER         0x46
#define IPC_CONTEXT_SUBTYPE_SUPPLIER_STATE                  0x47
#define IPC_CONTEXT_SUBTYPE_SUPPLIER_STATE_UNREGISTER       0x48
#define IPC_CONTEXT_SUBTYPE_APPLICATION_INFO_REGISTER       0x49
#define IPC_CONTEXT_SUBTYPE_APPLICATION_INFO                0x50
#define IPC_CONTEXT_SUBTYPE_APPLICATION_INFO_UNREGISTER     0x51

/* IPNet_SSI */
#define IPC_CONTEXT_SUBTYPE_LOCAL_NET_CTRL     0x01
#define IPC_CONTEXT_SUBTYPE_RUI_DATA_TRANSFER  0x10
#define IPC_CONTEXT_SUBTYPE_DUI_DATA_TRANSFER  0x20
#define IPC_CONTEXT_SUBTYPE_UIP_DATA_TRANSFER  0x30
/* Net_MCNet */
#define IPC_CONTEXT_SUBTYPE_LOCAL_NET_CTRL     0x01
#define IPC_CONTEXT_SUBTYPE_REMOTE_NET_CTRL    0x02 
#define IPC_CONTEXT_SUBTYPE_ASDT_STD           0x10
#define IPC_CONTEXT_SUBTYPE_ASDT_EXP           0x12
#define IPC_CONTEXT_SUBTYPE_UUDT               0x40
#define IPC_CONTEXT_SUBTYPE_USDT               0x42
/* Net_VAG_CAN */
#define IPC_CONTEXT_SUBTYPE_LOCAL_NET_CTRL     0x01
#define IPC_CONTEXT_SUBTYPE_REMOTE_NET_CTRL    0x02
#define IPC_CONTEXT_SUBTYPE_OSEK_NWM           0x03
#define IPC_CONTEXT_SUBTYPE_ASDT_OSEK1         0x20
#define IPC_CONTEXT_SUBTYPE_ASDT_VW_TP16       0x22
#define IPC_CONTEXT_SUBTYPE_ASDT_VW_TP20       0x24
#define IPC_CONTEXT_SUBTYPE_VAG_BR_SIGNAL      0x40
#define IPC_CONTEXT_SUBTYPE_USDT_ISO           0x50
/* Net_DC_CAN */
#define IPC_CONTEXT_SUBTYPE_LOCAL_NET_CTRL     0x01
#define IPC_CONTEXT_SUBTYPE_REMOTE_NET_CTRL    0x02
#define IPC_CONTEXT_SUBTYPE_OSEK_NWM           0x03
#define IPC_CONTEXT_SUBTYPE_ASDT_OSEK1         0x20
#define IPC_CONTEXT_SUBTYPE_UUDT_OSEK1         0x40
#define IPC_CONTEXT_SUBTYPE_ICAN_BR_SIGNAL     0x42
#define IPC_CONTEXT_SUBTYPE_USDT_ISO           0x50
/* Net_MOST */
/* Net_MOST2 */
#define IPC_CONTEXT_SUBTYPE_LOCAL_NET_CTRL     0x01
#define IPC_CONTEXT_SUBTYPE_REMOTE_NET_CTRL    0x02
#define IPC_CONTEXT_SUBTYPE_USDT_MOST          0x50
#define IPC_CONTEXT_SUBTYPE_USDT_MOSH          0x52
#define IPC_CONTEXT_SUBTYPE_USDT_SIGNAL        0x12


/* -------------------------------------------------------------------------- */
/* Net Service */
/* @def IPC_SRVC_CODE_... | 0xXX | posible service codes */

/* MCNet */
#define IPC_SRVC_CODE_MCN_CONNECT_REQ          0x20
#define IPC_SRVC_CODE_MCN_CONNECT_CON          0x21
#define IPC_SRVC_CODE_MCN_CONNECT_IND          0x23

#define IPC_SRVC_CODE_MCN_CONNECT_TEST_REQ     0x24
#define IPC_SRVC_CODE_MCN_CONNECT_TEST_CON     0x25
#define IPC_SRVC_CODE_MCN_CONNECT_TEST_IND     0x27

#define IPC_SRVC_CODE_MCN_DATA_REQ             0x40
#define IPC_SRVC_CODE_MCN_DATA_CON             0x41
#define IPC_SRVC_CODE_MCN_DATA_IND             0x45

/* VAG CAN */

#define IPC_SRVC_CODE_VAG_REJECT	            0x1B
#define IPC_SRVC_CODE_VAG_C_COMPONENT_STATUS	0x00
#define IPC_SRVC_CODE_VAG_R_COMPONENT_STATUS	0x01
#define IPC_SRVC_CODE_VAG_C_STATUS_CAN	      0x20
#define IPC_SRVC_CODE_VAG_R_STATUS_CAN	      0x21
#define IPC_SRVC_CODE_VAG_C_STATUS_CHANNEL	  0x20
#define IPC_SRVC_CODE_VAG_R_STATUS_CHANNEL	  0x21

#define IPC_SRVC_CODE_VAG_DATA_REQ_TP         0x40
#define IPC_SRVC_CODE_VAG_DATA_CONF_TP        0x41
#define IPC_SRVC_CODE_VAG_DATA_IND_TP         0x45

#define IPC_SRVC_CODE_VAG_DATA_REQ_BC_SIGNAL  0x40
#define IPC_SRVC_CODE_VAG_DATA_CONF_BC_SIGNAL 0x41
#define IPC_SRVC_CODE_VAG_DATA_IND_BC_SIGNAL  0x45

/* IPNet_SSI */
#define IPC_SRVC_CODE_SSI_DATA_REQ             0x40
#define IPC_SRVC_CODE_SSI_DATA_CON             0x41
#define IPC_SRVC_CODE_SSI_DATA_IND             0x45


#ifdef __cplusplus
}
#endif

#endif /* SYSTEM_IPC_HEADER */
