/***************************************************************************
 * .EXPORT_ME
 * FILE:         ostypes.h
 * PROJECT:      VASCO
 * SW-COMPONENT: OSAL
 *--------------------------------------------------------------------------
 * DESCRIPTION:  This file contains the various typedefs for the
 *               different OSAL platforms. This should be conform 
 *               with the "Entwicklungsleitlinien (ELL)".
 *--------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      | Modification                        | Author
 * 03.04.00  | Initial revision                    | Uelschen,EFT42
 * 04.04.00  | tS64 in vxWorks is long long        | de Vries,EFT22
 *           | and tDouble;tPDouble added          |
 * 04.04.00  | L***X added                         | Uelschen,EFT42
 * 23.05.00  | 64 bit types removed                | Tiemann,EFT42
 * 30.05.00  | Bugfix: pointer to constant         | Uelschen,EFT42 
 * 11.08.00  | tS32 --> signed long for Linux      | Wunderlich, EFT32
 * 14.08.00  | `VASCO_PC_TYPES_HEADER' added       | Wunderlich, EFT32
 * 08.09.00  | `signed' removed for Linux          | Wunderlich, EFT32
 * 22.11.00  | conform to pc_types.h                  | Uelschen, EFT42
 *
 **************************************************************************/


#ifndef OSAL_OSTYPES_HEADER
#define OSAL_OSTYPES_HEADER


#ifdef __cplusplus
extern "C" {
#endif

/**************************************************************************/
/* Typedefs                                                               */
/**************************************************************************/

typedef tChar                    tUTF8;

/* --Pointer and constant types: */

typedef tVoid*                   tPVoid;
                                 
typedef tChar*                   tPChar;
typedef tUChar*                  tPUChar;
                                 
typedef tShort*                  tPShort;
typedef tUShort*                 tPUShort;
                                 
typedef tInt*                    tPInt;
typedef tUInt*                   tPUInt;
                                 
typedef tLong*                   tPLong;
typedef tULong*                  tPULong;
                                 
typedef tFloat*                  tPFloat;
typedef tDouble*                 tPDouble;
typedef tLDouble*                tPLDouble;
                                 
typedef tBool*                   tPBool;
                                 
typedef tBitfield*               tPBitField;    
typedef tUBitfield*              tPUBitfield;

typedef tC8*                     tPC8;
typedef tC16*                    tPC16;

typedef tS8*                     tPS8;
typedef tS16*                    tPS16;
typedef tS32*                    tPS32;

typedef tU8*                     tPU8;
typedef tU16*                    tPU16;
typedef tU32*                    tPU32;

typedef tF32*                    tPF32;
typedef tF64*                    tPF64;

typedef const tC8                tCC8;
typedef const tC16               tCC16;

typedef const tS8                tCS8;
typedef const tS16               tCS16;
typedef const tS32               tCS32;

typedef const tU8                tCU8;
typedef const tU16               tCU16;
typedef const tU32               tCU32;

typedef const tF32               tCF32;
typedef const tF64               tCF64;

typedef const tC8*               tPCC8;
typedef const tC16*              tPCC16;

typedef const tS8*               tPCS8;
typedef const tS16*              tPCS16;
typedef const tS32*              tPCS32;

typedef const tU8*               tPCU8;
typedef const tU16*              tPCU16;
typedef const tU32*              tPCU32;

typedef const tF32*              tPCF32;
typedef const tF64*              tPCF64;

typedef const tVoid*             tPCVoid;        
typedef const tChar*             tPCChar;
typedef const tUChar*            tPCUChar;

typedef const tShort*            tPCShort;
typedef const tUShort*           tPCUShort;

typedef const tInt*              tPCInt;
typedef const tUInt*             tPCUInt;

typedef const tLong*             tPCLong;
typedef const tULong*            tPCULong;

typedef const tFloat*            tPCFloat;
typedef const tDouble*           tPCDouble;
typedef const tLDouble*          tPCLDouble;

typedef const tBool*             tPCBool;

typedef const tBitfield*         tPCBitField;    
typedef const tUBitfield*        tPCUBitfield;

/* --Reference Types for C++ */

#ifdef __cplusplus

typedef tChar&                   tRChar;
typedef tUChar&                  tRUChar;
                                 
typedef tShort&                  tRShort;
typedef tUShort&                 tRUShort;
                                 
typedef tInt&                    tRInt;
typedef tUInt&                   tRUInt;
                                 
typedef tLong&                   tRLong;
typedef tULong&                  tRULong;
                                 
typedef tFloat&                  tRFloat;
typedef tDouble&                 tRDouble;
typedef tLDouble&                tRLDouble;

typedef tBool&                   tRBool;

typedef tBitfield&               tRBitField;    
typedef tUBitfield&              tRUBitfield;

typedef tC8&                     tRC8;
typedef tC16&                    tRC16;

typedef tS8&                     tRS8;
typedef tS16&                    tRS16;
typedef tS32&                    tRS32;
                                 
typedef tU8&                     tRU8;
typedef tU16&                    tRU16;
typedef tU32&                    tRU32;
                                 
typedef tF32&                    tRF32;
typedef tF64&                    tRF64;
                                 
typedef const tC8&               tRCC8;
typedef const tC16&              tRCC16;
                                 
typedef const tS8&               tRCS8;
typedef const tS16&              tRCS16;
typedef const tS32&              tRCS32;
                                 
typedef const tU8&               tRCU8;
typedef const tU16&              tRCU16;
typedef const tU32&              tRCU32;
                                 
typedef const tF32&              tRCF32;
typedef const tF64&              tRCF64;

typedef const tChar&             tRCChar;
typedef const tUChar&            tRCUChar;

typedef const tShort&            tRCShort;
typedef const tUShort&           tRCUShort;

typedef const tInt&              tRCInt;
typedef const tUInt&             tRCUInt;

typedef const tLong&             tRCLong;
typedef const tULong&            tRCULong;

typedef const tFloat&            tRCFloat;
typedef const tDouble&           tRCDouble;
typedef const tLDouble&          tRCLDouble;

typedef const tBool&             tRCBool;

typedef const tBitfield&         tRCBitField;    
typedef const tUBitfield&        tRCUBitfield;

#endif /* --C++ */

typedef void (*OSAL_tpfCallback) ( tPVoid );

typedef enum {
         OSAL_EN_READONLY        =0x0001,
         OSAL_EN_WRITEONLY       =0x0002,
         OSAL_EN_READWRITE       =0x0004,
         OSAL_EN_APPEND          =0x0008,
         OSAL_EN_TEXT            =0x0010,
         OSAL_EN_BINARY          =0x0020,
         OSAL_EN_READSTREAM      =0x0040,
         OSAL_EN_ACCESS_DEVICE   =0x0080,
         OSAL_EN_ACCESS_DIR      =0x0100
} OSAL_tenAccess;

#ifdef __cplusplus
}
#endif

#endif 


/* EOF */

