/***************************************************************************
 * .EXPORT_ME
 * FILE:         ossmphr.h
 * PROJECT:      VASCO
 * SW-COMPONENT: OSAL
 *--------------------------------------------------------------------------
 * DESCRIPTION:  This is the headerfile for the OS - Abstraction Layer for 
 *               Semaphore-Functions. This Header has to be included to use
 *               functions for Semaphores
 *--------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      |   Modification                         | Author
 * 16.03.00  |   Initial revision                     | de Vries,EFT22
 * 10.04.00  |   Restructuring                        | Uelschen, EFT42
 * 17.05.00  |   semaphores now with name             | de Vries, EFT22
 * 05.06.00  |   OSAL_Sem..Timeout removed            | de Vries, EFT22
 * 19.07.00  |   typedef U32 OSAL_tSemHandle for RX732| Tiemann, EFT42
 * 04.08.00  |   Linux defines added                  | Wunderlich, EFT32
 * 11.08.00  |   Linux uses OSAL_DECL now             | Wunderlich, EFT32
 * 07.02.02  |   class OSAL_tclSemaphore added        | Walkling, EST
 * 18.02.02  |   Nucleus defines added                | Uelschen, ESN2
 * 13.06.02  |   add dynamic-download extension       | Perick, CM-CR/EES4
 *
 **************************************************************************/

#if !defined (OSAL_SEM_HEADER)
   #define OSAL_SEM_HEADER


#if OSAL_OS==OSAL_VXWORKS
typedef sem_t* OSAL_tSemHandle;
#elif OSAL_OS==OSAL_WINNT || OSAL_OS==OSAL_RX732 || OSAL_OS==OSAL_WINCE \
   || OSAL_OS==OSAL_NUCLEUS || OSAL_OS==OSAL_TENGINE || OSAL_OS==OSAL_LINUX \
   || (OSAL_OS==OSAL_DARWIN)
#ifdef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT
typedef uintptr_t OSAL_tSemHandle; 
#else
typedef tU32 OSAL_tSemHandle;
#endif 
#endif

#ifdef __cplusplus
extern "C"
{
   #endif

#ifndef OSAL_DYNAMIC_DOWNLOAD
   
   #if OSAL_OS==OSAL_WINNT  || OSAL_OS==OSAL_RX732 || OSAL_OS==OSAL_WINCE \
	|| OSAL_OS==OSAL_VXWORKS || OSAL_OS==OSAL_LINUX || (OSAL_OS==OSAL_DARWIN) \
   || OSAL_OS==OSAL_NUCLEUS || OSAL_OS==OSAL_TENGINE
   
   /* --10.2.1 Create a new Semaphore */
   OSAL_DECL tS32 OSAL_s32SemaphoreCreate(tCString szName,OSAL_tSemHandle* phSid, tU32 value);
   
   /* --10.2.2 Open a Semaphore */
   OSAL_DECL tS32 OSAL_s32SemaphoreOpen(tCString coszName, OSAL_tSemHandle* phSid);
   
   /* --10.2.3 Close a Semaphore */
   OSAL_DECL tS32 OSAL_s32SemaphoreClose(OSAL_tSemHandle hSid);
   
   /* --10.2.4 Remove a Semaphore from System */
   OSAL_DECL tS32 OSAL_s32SemaphoreDelete(tCString coszName);
   
   /* --10.2.5 Read the Value of a Semaphore */
   OSAL_DECL tS32 OSAL_s32SemaphoreGetValue(OSAL_tSemHandle hSid, tPS32 ps32Value);
   
   /* --10.2.6 Post (Increment) a Semaphore */
   OSAL_DECL tS32 OSAL_s32SemaphorePost(OSAL_tSemHandle hSid);
   
   /* --10.2.7 Wait (Decrement) for a Semaphore */
   OSAL_DECL tS32 OSAL_s32SemaphoreWait(OSAL_tSemHandle hSid,OSAL_tMSecond msec);
   
   #endif /* OSAL_OS */

#endif // OSAL_DYNAMIC_DOWNLOAD


/**************************************************************************/
/* dynamic-download                                                       */
/**************************************************************************/
#if( defined OSAL_DYNAMIC_DOWNLOAD || defined OSAL_DYNAMIC_BASE)
typedef tS32 (*tOSAL_s32SemaphoreCreate)(tCString szName,OSAL_tSemHandle* phSid, tU32 value);
typedef tS32 (*tOSAL_s32SemaphoreOpen)(tCString coszName, OSAL_tSemHandle* phSid);
typedef tS32 (*tOSAL_s32SemaphoreClose)(OSAL_tSemHandle hSid);
typedef tS32 (*tOSAL_s32SemaphoreDelete)(tCString coszName);
typedef tS32 (*tOSAL_s32SemaphoreGetValue)(OSAL_tSemHandle hSid, tPS32 ps32Value);
typedef tS32 (*tOSAL_s32SemaphorePost)(OSAL_tSemHandle hSid);
typedef tS32 (*tOSAL_s32SemaphoreWait)(OSAL_tSemHandle hSid,OSAL_tMSecond msec);
#endif

#ifdef OSAL_DYNAMIC_DOWNLOAD
extern tOSAL_s32SemaphoreCreate   OSAL_s32SemaphoreCreate;
extern tOSAL_s32SemaphoreOpen     OSAL_s32SemaphoreOpen;
extern tOSAL_s32SemaphoreClose    OSAL_s32SemaphoreClose;
extern tOSAL_s32SemaphoreDelete   OSAL_s32SemaphoreDelete;
extern tOSAL_s32SemaphoreGetValue OSAL_s32SemaphoreGetValue;
extern tOSAL_s32SemaphorePost     OSAL_s32SemaphorePost;
extern tOSAL_s32SemaphoreWait     OSAL_s32SemaphoreWait;
#endif // OSAL_DYNAMIC_DOWNLOAD
      
   #ifdef __cplusplus
}
#endif

#ifdef __cplusplus
class OSAL_DECL OSAL_tclSemaphore : public OSAL_tclBase
{
   public:
      /* The following methods are according to the OSAL specification. */
      /* Constructor of this class. */
      OSAL_tclSemaphore();
      /* Destructor of this class. */
      virtual ~OSAL_tclSemaphore();
      /*
         This methode creates the semaphore. 
         If the creation of the semaphore has finished without
         an error the s32Open methode is called afterwards.
         (For more detail see OSAL Refernzhandbuch Kapitel Semaphore.)
      
         Additional Errors or meaning:
         OSAL_E_UNKNOWN: A handle already stored in this object.
         OSAL_E_NOSPACE: There is no space to save the name.
      */
      tS32 s32Create( tCString coszName,   /* (I) */
                      tU32 u32InitialValue /* (I) */ );
      /*
         This methode opens a semaphore.
         (For more detail see OSAL Refernzhandbuch Kapitel Semaphore.)
      
         Additional Errors or meaning:
         OSAL_E_ALREADYEXISTS: There exists already an opened semaphore.
         OSAL_E_NOSPACE: There is no space to save the name.
      */
      tS32 s32Open( tCString coszName /* (I) */ );
      /*
         This methode opens a semaphore with the name stored
         in this object.
         (This is an additional method!)
      
         Additional Errors or meaning:
         OSAL_E_ALREADYEXISTS: There exists already an opened semaphore.
         OSAL_E_UNKNOWN: There is no name saved in the object. 
                         (Use s32Open( tCString coszName ) )
      */
      tS32 s32Open();
      /*
         This methode closes a semaphore.
         (For more detail see OSAL Refernzhandbuch Kapitel Semaphore.)
      */
      tS32 s32Close( );
      /*
         This methode deletes the semaphore. 
         Before deleting the semaphore the methode s32Close will be
         performed to close the semaphore. After performing this 
         methode this semaphore object provides no semaphore 
         functionality but it is possible to create a new semaphore 
         in the same object.
         (For more detail see OSAL Refernzhandbuch Kapitel Semaphore.)
      */
      tS32 s32Delete( );
      /*
         This methode is to obtain the value of the semaphore.
         (For more detail see OSAL Refernzhandbuch Kapitel Semaphore.)
      */
      tS32 s32GetValue( tPS32 ps32Value /* (->O) */ );
      /*
         This methode increments the value of the semaphore.
         (For more detail see OSAL Refernzhandbuch Kapitel Semaphore.)
      */
      tS32 s32Post();
      /*
         This methode decrements the value of the semaphore and the thread
         will be blocked in case of a semaphore value 0.
         (For more detail see OSAL Refernzhandbuch Kapitel Semaphore.)
      */
      tS32 s32Wait( OSAL_tMSecond msec /* (I) */ );
      /* 
         The following methods are new and/or with modification to the
         OSAL specification. 
      */
      /*
         To get the name of the created semaphore this methode can be used.
         After deletion the semaphore there is no name available furthermore.
      */
      tCString pszGetName();
   private:
      //
      /*
         This member stores the name of the semaphore.
      */
      tString szName;
      /*
         This member stores the handle of the semaphore.
      */
      OSAL_tSemHandle hSemaphoreHandle;
};
#endif

#endif 


/* EOF */
