/***************************************************************************
 * .EXPORT_ME
 * FILE:         osshmem.h
 * PROJECT:      VASCO
 * SW-COMPONENT: OSAL
 *--------------------------------------------------------------------------
 * DESCRIPTION:  This is the headerfile for the OS - Abstraction Layer for
 *               SharedMemory-Functions. This Header has to be included to
 *               use the functions for shared memory handling
 *--------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      |   Modification                      | Author
 *           |                                     |
 * 17.05.00  |   Initial revision                  | de Vries,EFT22
 *           |                                     |
 * 08.08.00  |   Linux defines added;              | Wunderlich, EFT32
 *           |   `OSAL_tShMemHandle' changed       |
 *           |   from `tU32' to `tS32;             |
 *           |   parameter `u32Size' added in      |
 *           |  `OSAL_s32SharedMemoryUnmap'        |
 *           |                                     |
 * 11.08.00  |  Linux uses OSAL_DECL now           | Wunderlich, EFT32
 *           |                                     |
 * 12.09.00  |  `OSAL_s32SharedMemoryDelete' added | Wunderlich, EFT32
 * 17.01.01  |  Define for WINCE added             | de Vries, EFG32
 * 07.02.02  |   class OSAL_tclSharedMemory added  | Walkling, EST
 * 18.02.02  |   Nucleus defines added             | Uelschen, ESN2
 * 13.06.02  |  add dynamic-download extension     | Perick, CM-CR/EES4
 *           |                                     |
 *
 **************************************************************************/

#if !defined (OSAL_SHAREDMEM_HEADER)
#define OSAL_SHAREDMEM_HEADER

#ifdef __cplusplus
extern "C"
{
   #endif
   
   /**************************************************************************/
   /* typedefs                                                               */
   /**************************************************************************/
   
   /* EFT32-Wu: This typedef was `tU32', formerly. But since
     `OSAL_SharedMemoryCreate' returns OSAL_ERROR in case of errors (which is
     -1), it has to be `signed'. */
   
   #ifdef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT
   typedef intptr_t OSAL_tShMemHandle;
   #else
   typedef tS32 OSAL_tShMemHandle;
   #endif

   #ifndef OSAL_DYNAMIC_DOWNLOAD
   
   #if OSAL_OS==OSAL_VXWORKS || OSAL_OS==OSAL_WINNT || OSAL_OS==OSAL_LINUX || (OSAL_OS==OSAL_DARWIN) \
		|| OSAL_OS==OSAL_WINCE || OSAL_OS==OSAL_NUCLEUS || OSAL_OS==OSAL_TENGINE
   



   #if OSAL_OS==OSAL_WINNT 
   #if TSIM_OSAL
   OSAL_DECL OSAL_tShMemHandle OSAL_SharedMemoryCreate(tCString coszName, OSAL_tenAccess enAccess, tU32 u32Size);
   #else
   OSAL_DECL OSAL_tShMemHandle OSAL_SharedMemoryCreateDebug(tCString coszName,  OSAL_tenAccess enAccess, tU32 u32Size, char* lpszFileName, int nLine);   
   OSAL_DECL OSAL_tShMemHandle OSAL_SharedMemoryCreateOrg(tCString coszName, OSAL_tenAccess enAccess, tU32 u32Size);

   #if !defined OSAL_DYNAMIC_DOWNLOAD && !defined OSAL_DYNAMIC_BASE
   #define OSAL_SharedMemoryCreate(coszName,enAccess,u32Size) OSAL_SharedMemoryCreateDebug(coszName,enAccess,u32Size,__FILE__,__LINE__)
   #else
   #define OSAL_SharedMemoryCreate(coszName,enAccess,u32Size) OSAL_SharedMemoryCreateOrg(coszName,enAccess,u32Size)   
   #endif
   #endif
   #else
   
   OSAL_DECL OSAL_tShMemHandle OSAL_SharedMemoryCreate(tCString coszName, OSAL_tenAccess enAccess, tU32 u32Size);
   
   #endif

   #if OSAL_OS==OSAL_WINNT 
   #if TSIM_OSAL
   OSAL_DECL tS32 OSAL_SharedMemoryOpen(tCString coszName,OSAL_tenAccess enAccess);
   OSAL_DECL tS32 OSAL_s32SharedMemoryClose(OSAL_tShMemHandle hShared);
   OSAL_DECL tS32 OSAL_s32SharedMemoryDelete(tCString coszName);  
   OSAL_DECL tPVoid OSAL_pvSharedMemoryMap(OSAL_tShMemHandle hShared,
   OSAL_tenAccess enAccess, tU32 u32Size, tU32 u32Offset);
   OSAL_DECL tS32 OSAL_s32SharedMemoryUnmap(tPVoid pvSharedMemory, tU32 u32Size);
   #else

   OSAL_DECL OSAL_tShMemHandle OSAL_SharedMemoryOpenDebug(tCString coszName, OSAL_tenAccess enAccess,char* lpszFileName, int nLine);
   OSAL_DECL OSAL_tShMemHandle OSAL_SharedMemoryOpenOrg(tCString coszName, OSAL_tenAccess enAccess);

   #if !defined OSAL_DYNAMIC_DOWNLOAD && !defined OSAL_DYNAMIC_BASE
   #define OSAL_SharedMemoryOpen(coszName,enAccess) OSAL_SharedMemoryOpenDebug(coszName,enAccess,__FILE__,__LINE__)
   #else
   #define OSAL_SharedMemoryOpen(coszName,enAccess) OSAL_SharedMemoryOpenOrg(coszName,enAccess)
   #endif
   #endif
   
   #else

   OSAL_DECL OSAL_tShMemHandle OSAL_SharedMemoryOpen(tCString coszName, OSAL_tenAccess enAccess);

   #endif

   /* --13.2.3 Close a Shared Memory Block */
   OSAL_DECL tS32 OSAL_s32SharedMemoryClose(OSAL_tShMemHandle hShared);
   
   /* --13.2.X Delete a Shared Memory Block */
   OSAL_DECL tS32 OSAL_s32SharedMemoryDelete(tCString coszName);
   
   /* --13.2.4 Get a Pointer to the Begin of a Shared Memory Block */
   OSAL_DECL tPVoid OSAL_pvSharedMemoryMap(OSAL_tShMemHandle hShared,
    OSAL_tenAccess enAccess, tU32 u32Size, tU32 u32Offset);
   
   /* --13.2.5 Give a Pointer back to the System */
   /* EFT32-Wu: `OSAL_s32SharedMemoryUnmap' corresponds to POSIX `munmap'. This
      POSIX function needs the size, too. So, `u32Size' has been added: */
   OSAL_DECL tS32 OSAL_s32SharedMemoryUnmap(tPVoid pvSharedMemory, tU32 u32Size);
   
   #endif

#endif // OSAL_DYNAMIC_DOWNLOAD

/**************************************************************************/
/* dynamic-download                                                       */
/**************************************************************************/
#if ( defined OSAL_DYNAMIC_DOWNLOAD || defined OSAL_DYNAMIC_BASE)
typedef OSAL_tShMemHandle (*tOSAL_SharedMemoryCreate)(tCString coszName,
                                                      OSAL_tenAccess enAccess, 
                                                      tU32 u32Size);
typedef OSAL_tShMemHandle (*tOSAL_SharedMemoryOpen)(tCString coszName,
                                                    OSAL_tenAccess enAccess);
typedef tS32 (*tOSAL_s32SharedMemoryClose)(OSAL_tShMemHandle hShared);
typedef tS32 (*tOSAL_s32SharedMemoryDelete)(tCString coszName);
typedef tPVoid (*tOSAL_pvSharedMemoryMap)(OSAL_tShMemHandle hShared,
                                          OSAL_tenAccess enAccess, 
                                          tU32 u32Size, tU32 u32Offset);
typedef tS32 (*tOSAL_s32SharedMemoryUnmap)(tPVoid pvSharedMemory, tU32 u32Size);
#endif

#ifdef OSAL_DYNAMIC_DOWNLOAD
extern tOSAL_SharedMemoryCreate    OSAL_SharedMemoryCreate;
extern tOSAL_SharedMemoryOpen      OSAL_SharedMemoryOpen;
extern tOSAL_s32SharedMemoryClose  OSAL_s32SharedMemoryClose;
extern tOSAL_s32SharedMemoryDelete OSAL_s32SharedMemoryDelete;
extern tOSAL_pvSharedMemoryMap     OSAL_pvSharedMemoryMap;
extern tOSAL_s32SharedMemoryUnmap  OSAL_s32SharedMemoryUnmap;
#endif // OSAL_DYNAMIC_DOWNLOAD

   
   
   #ifdef __cplusplus
}
#endif

#ifdef __cplusplus
class OSAL_DECL OSAL_tclSharedMemory : public OSAL_tclBase
{
   public:
      /* The following methods are according to the OSAL specification. */
      /* Constructor of this class. */
      OSAL_tclSharedMemory();
      /* Destructor of this class. */
      virtual ~OSAL_tclSharedMemory();
      /*
         This methode creates a shared memory area. 
         If the creation of the shared memory area has finished without
         an error the s32Open methode is called afterwards.
         (For more detail see OSAL Refernzhandbuch Kapitel Shared Memory.)
      
         Additional Errors or meaning:
         OSAL_E_UNKNOWN: A handle already stored in this object.
         OSAL_E_NOSPACE: There is no space to save the name.
      */
      tS32 s32Create( tCString coszName,       /* (I) */
                      OSAL_tenAccess enAccess, /* (I) */
                      tU32 u32Size             /* (I) */);
      /*
         This methode opens a shared memory area.
         (For more detail see OSAL Refernzhandbuch Kapitel Shared Memory.)
      
         Additional Errors or meaning:
         OSAL_E_ALREADYEXISTS: There exists already an opened shared memory area.
         OSAL_E_NOSPACE: There is no space to save the name.
      */
      tS32 s32Open( tCString coszName,      /* (I) */
                    OSAL_tenAccess enAccess /* (I) */ );
      /*
         This methode opens a shared memory area with the name stored
         in this object.
         (This is an additional method!)
      
         Additional Errors or meaning:
         OSAL_E_ALREADYEXISTS: There exists already an opened shared memory area.
         OSAL_E_UNKNOWN: There is no name saved in the object. 
                         (Use s32Open( tCString coszName ) )
      */
      tS32 s32Open( OSAL_tenAccess enAccess ) /* (I) */;
      /*
         This methode closes a shared memory area.
         (For more detail see OSAL Refernzhandbuch Kapitel Shared Memory.)
      */
      tS32 s32Close( );
      /*
         This methode deletes the shared memory area. 
         Before deleting the shared memory area the methode s32Close will be
         performed to close the shared memory area. After performing this 
         methode this shared memory area object provides no shared memory 
         functionality but it is possible to create a new shared memory area 
         in the same object.
         (For more detail see OSAL Refernzhandbuch Kapitel Shared Memory.)
      */
      tS32 s32Delete( );
      /*
         This methode returns a pointer to the requested memory or OSAL_NULL.
         In case of OSAL_NULL there is also set an errorcode.
         (For more detail see OSAL Refernzhandbuch Kapitel Shared Memory.)
      */
      tPVoid pvMap( OSAL_tenAccess enAccess,    /* (I) */
                    tU32           u32Length,   /* (I) */
                    tU32           u32Offset ); /* (I) */
      /*
         This methode releases the pointer to the shared memory.
         (For more detail see OSAL Refernzhandbuch Kapitel Shared Memory.)
      */
      tS32 s32Unmap( tPVoid pvSharedMemory, /* (I) */
                     tU32   u32Size );      /* (I) */
      /* 
         The following methods are new and/or with modification to the
         OSAL specification. 
      */
      /*
         To get the name of the created shared memory area this methode can be used.
         After deletion the shared memory area there is no name available furthermore.
      */
      tCString pszGetName();
   private:
      //
      /*
         This member stores the name of the shared memory area.
      */
      tString szName;
      /*
         This member stores the handle of the shared memory area.
      */
      OSAL_tShMemHandle hSharedMemoryHandle;
};
#endif

#endif 


/* EOF */
