/******************************************************************************
 * .EXPORT_ME
 * FILE:         osproc.h
 * PROJECT:      VASCO
 * SW-COMPONENT: OSAL
 *-----------------------------------------------------------------------------
 * DESCRIPTION:  This is the headerfile for the OS - Abstraction Layer for 
 *               Process and Thread-Functions. This Header has to be 
 *               included to use the functions for Thread control
 *-----------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      |   Modification                              | Author
 * 17.05.00  |   Initial revision                          | de Vries,EFT22
 *           |                                             |
 * 23.05.00  |   Thread prototypes for RX732               | Tiemann, EFT42
 *           |   #include "os_process.h" moved             |
 *           |                                             |
 * 25.05.00  |   parameter in ..PROC..ControlBlock changed | de Vries, EFT22
 * 31.05.00  |   vxWorks: osTaksDelete statt taskDelete    | de Vries, EFT22
 * 24.07.00  |   vxWorks: INLINE function for vxWorks      | de Vries, EFT22
 * 03.08.00  |   Linux defines added                       | Wunderlich, EFT32
 *           |                                             |
 * 11.08.00  |   Linux uses OSAL_DECL now;                 | Wunderlich, EFT32
 *           |   `()' replaced by `( tVoid )'              |
 * 31.01.01  |   WinCE: OSAL_EN_THREAD_PENDED_DELAYED      | deVries, EFG32
 *           |   OSAL_EN_THREAD_INVALID_STATUS new         |  
 * 01.02.01  |   OSAL_C_xxxxx_ID_SELF new defined for CE   | de Vries, EFG32
 * 07.02.02  |   OSAL_DECL added in class definitions      | Walkling, EST
 * 18.02.02  |   Nucleus defines added                     | Uelschen, ESN2
 * 19.03.02  |   OSAL_tclThread: added stacksize: create   | Walkling, EST
 *           |   and spawn                                 |
 * 13.06.02  |   add dynamic-download extension            | Perick,CM-CR/EES4
 *           |                                             |
 * 21.09.10  |   add OSAL interfaces for Floating Point
                 exception                                 | Ravindran P (RBEI/ECF1)
 *****************************************************************************/

#if !defined (OSAL_PROC_HEADER)
  #define OSAL_PROC_HEADER


#ifdef __cplusplus
extern "C"
{
      #endif
   
           /* --Use old OSAL for WinCE. DELETE THIS IN THE NEAR FUTURE (UELSCHEN). */
   #if OSAL_OS==OSAL_WINCE || OSAL_OS==OSAL_NUCLEUS || OSAL_OS==OSAL_TENGINE
   
   /* -- Die moeglichen Zustaende eines Threads: */
   typedef enum {
       OSAL_EN_THREAD_INITIALIZED,         /* initialized */
       OSAL_EN_THREAD_RUNNING,             /* running */
       OSAL_EN_THREAD_READY,               /* ready */
       OSAL_EN_THREAD_PENDED,              /* pended */
       OSAL_EN_THREAD_DELAYED,             /* delayed */
       OSAL_EN_THREAD_SUSPENDED,           /* suspended */
       OSAL_EN_THREAD_SUSPENDED_PENDED,    /* suspended+pended */
       OSAL_EN_THREAD_SUSPENDED_DELAYED,   /* suspended+delayed */
       OSAL_EN_THREAD_PENDED_DELAYED,      /* CE: Sl/Blk */
           OSAL_EN_THREAD_INVALIDSTATUS        /* added for WinCE */ 
   } OSAL_tenThreadState;
   #endif
   
      /*****************************************************************************/
      /* typedefs                                                                  */
      /*****************************************************************************/
      
      /* -- Prototyp fuer Einstiegsfunktion eines Threads: */
      typedef tVoid (*OSAL_tpfThreadEntry) ( tPVoid );
      
      /* >>> Here, `OSAL_tpfThreadEntry' is `pointer to void-function'.
             According to POSIX, it should be `pointer to function that
             returns a void-pointer. To be fixed some time to
             `typedef tPVoid (*OSAL_tpfThreadEntry) ( tPVoid );'
                      ^^^^^^                                     */
      
      /* -- Kennung fuer einen Prozess. */
      typedef intptr_t OSAL_tProcessID;

      /* -- Kennung fuer eine Thread. */
      typedef intptr_t OSAL_tThreadID;
      /*FPE mode */
	  typedef enum
      {
          OSAL_EN_U8_FPE_MODE_FPE_ABORT = 0, /*Abort the thread when a FPE occurs*/
          OSAL_EN_U8_FPE_MODE_FPE_FLAG       /*Continue execution when a FPE occurs */
      }OSAL_tenFPEMode;

   /* -- Attribute beim Erzeugen eines Prozesses */
   typedef struct
   {
        tString szName;                   /* Name des Prozesses */
        tU32 u32Priority;                 /* Prioritaet */
        tString szAppName;                /* zu startende Applikation */
        tString szCommandLine;            /* Kommandozeilenparameter */
#if (OSAL_OS==OSAL_LINUX) || (OSAL_OS==OSAL_DARWIN)
        tString szCGroup_path;            /* Path for CGroup to spawn */
#endif
   } OSAL_trProcessAttribute;
   /* -- Attribute beim Erzeugen eines Threads: */
   typedef struct
   {
      tCString szName;                  /* Name */
      tU32 u32Priority;                 /* Prioritaet */
      tS32 s32StackSize;                /* Groesse des Stacks */
      OSAL_tpfThreadEntry pfEntry;      /* Startroutine */
      tPVoid pvArg;                     /* Argument der Startroutine */
      #if (OSAL_OS==OSAL_VXWORKS)
      OSAL_tProcessID procId;           /* processId from thread */
      #endif
   } OSAL_trThreadAttribute;
   /* -- Kontrollblock eines Processes */
   typedef struct
   {
        OSAL_tProcessID id;                 /* ID */
        tString szName;                     /* Name des Prozesses*/
      #if OSAL_OS==OSAL_WINCE || OSAL_OS==OSAL_NUCLEUS || OSAL_OS==OSAL_TENGINE
      tU32 u32Priority;                   /* Prioritaet */        
      #endif
        OSAL_tMSecond startTime;            /* Startzeitpunkt des Prozesses */
        OSAL_tMSecond runningTime;          /* Benutzte Gesamtrechenzeit */
      #if OSAL_OS==OSAL_WINCE || OSAL_OS==OSAL_NUCLEUS || OSAL_OS==OSAL_TENGINE
           tPVoid pvControlArea;  
      #endif
   } OSAL_trProcessControlBlock;
   /* -- Kontrollblock einer Thread */
   typedef struct
   {
      OSAL_tThreadID id;                  /* ID */
      tString szName;                     /* Name */
      tU32 u32Priority;                   /* Prioritaet */
      tU32 u32CurrentPriority;            /* Aktuelle Prioritaet */
      tS32 s32StackSize;                  /* Groesse des Stacks in Bytes */
      tS32 s32UsedStack;                  /* Benutzter Stack in Bytes */
      OSAL_tMSecond startTime;            /* Startzeitpunkt der thread */
      OSAL_tMSecond runningTime;          /* Benutzte Gesamtrechenzeit */
      OSAL_tMSecond sliceTime;            /* Benutzte Rechenzeit in der aktuellen Zeitscheibe */
      #if OSAL_OS==OSAL_WINCE || OSAL_OS==OSAL_NUCLEUS || OSAL_OS==OSAL_TENGINE
        OSAL_tenThreadState enStatus;       /* Status */
      #endif
      tU32 u32ErrorCode;                  /* Letzter Fehlercode */
   } OSAL_trThreadControlBlock;
     
   /*Floating point exceptions*/
    #define OSAL_C_U8_FPE_INEXACT                     ((tU8) 0x01) /*Inexact Exception*/
    #define OSAL_C_U8_FPE_UNDERFLOW                   ((tU8) 0x02) /*Underflow Exception*/
    #define OSAL_C_U8_FPE_OVERFLOW                    ((tU8) 0x04) /*Overflow Exception*/
    #define OSAL_C_U8_FPE_DIVZERO                     ((tU8) 0x08) /*Divide by Zero Exception*/
    #define OSAL_C_U8_FPE_INVALID                     ((tU8) 0x10) /*Invalid Exception*/


#ifndef OSAL_DYNAMIC_DOWNLOAD

   #if OSAL_OS==OSAL_RX732 || OSAL_OS==OSAL_WINNT || OSAL_OS==OSAL_LINUX || (OSAL_OS==OSAL_DARWIN) || OSAL_OS==OSAL_VXWORKS || OSAL_OS==OSAL_WINCE || OSAL_OS==OSAL_NUCLEUS || OSAL_OS==OSAL_TENGINE
   
   /* --9.2.1 Create and Activate a new Process */
   OSAL_DECL OSAL_tProcessID OSAL_ProcessSpawn(const OSAL_trProcessAttribute* pcorAttr);
   
   /* --9.2.2 Delete a Process */
   OSAL_DECL tS32 OSAL_s32ProcessDelete(OSAL_tProcessID pid);
   
   /* --9.2.3 Get the ID of Actual Process */
   OSAL_DECL OSAL_tProcessID OSAL_ProcessWhoAmI( tVoid );
   
   /* --9.2.5 Get the Process List */
   OSAL_DECL tS32 OSAL_s32ProcessList(OSAL_tProcessID pas32List[], tS32 s32Length);
      
   /* --9.2.7 Get the Process Control Block */
   OSAL_DECL tS32 OSAL_s32ProcessControlBlock(OSAL_tProcessID pid,
    OSAL_trProcessControlBlock* prPcb);
   
   /* --9.2.10 Create a new Thread */
   OSAL_DECL OSAL_tThreadID OSAL_ThreadCreate(const OSAL_trThreadAttribute* pcorAttr);
   
   /* --9.2.11 Activate a Thread */
   OSAL_DECL tS32 OSAL_s32ThreadActivate(OSAL_tThreadID tid);
   
   /* --9.2.12 Create and Activate a Thread */
   OSAL_DECL OSAL_tThreadID OSAL_ThreadSpawn(const OSAL_trThreadAttribute* pcorAttr);
   
   /* --9.2.13 Delete a Thread */
   OSAL_DECL tS32 OSAL_s32ThreadDelete(OSAL_tThreadID tid);
   
   /* --9.2.14 Suspend the Actual Thread for a Time Span */
   OSAL_DECL tS32 OSAL_s32ThreadWait(OSAL_tMSecond msec);
   
   /* --9.2.15 Suspend a Thread */
   OSAL_DECL tS32 OSAL_s32ThreadSuspend(OSAL_tThreadID tid);
   
   /* --9.2.16 Resume a Thread */
   OSAL_DECL tS32 OSAL_s32ThreadResume(OSAL_tThreadID tid);
   
   /* --9.2.17 Change the Thread Priority */
   OSAL_DECL tS32 OSAL_s32ThreadPriority(OSAL_tThreadID tid, tU32 nprio);
    /*Floating point exception related functions*/

    /*Reset the FPE for the current thread*/
    OSAL_DECL tVoid OSAL_vFPEReset(tVoid);
   /*Get the FPE for the current thread */
    OSAL_DECL tU8 OSAL_u8GetFPE(tVoid);
   /*Set the FPE mode for the current thread */
    OSAL_DECL tS32 OSAL_s32SetFPEMode(OSAL_tenFPEMode enMode);


   
   #if OSAL_OS==OSAL_WINCE
        /* --9.2.18 Get the Thread Status */
        OSAL_DECL tS32 OSAL_s32ThreadStatus(OSAL_tThreadID tid,
                OSAL_tenThreadState* pState);
   #endif
   
   /* --9.2.20 Get the Thread Control Block */
   OSAL_DECL tS32 OSAL_s32ThreadControlBlock(OSAL_tThreadID tid,
    OSAL_trThreadControlBlock* prTcb);
   
   /* --9.2.21 Get the Thread List */
   OSAL_DECL tS32 OSAL_s32ThreadList(OSAL_tThreadID pList[], tS32 s32Length);
   
   #if OSAL_OS==OSAL_WINCE || OSAL_OS==OSAL_NUCLEUS || OSAL_OS==OSAL_TENGINE || OSAL_OS==OSAL_LINUX || (OSAL_OS==OSAL_DARWIN)
   
   #undef OSAL_C_PROCESS_ID_SELF 
   #undef OSAL_C_THREAD_ID_SELF 
   #define OSAL_C_PROCESS_ID_SELF OSAL_ProcessWhoAmI()
   #define OSAL_C_THREAD_ID_SELF  OSAL_ThreadWhoAmI()
   
   #endif 
   
#if OSAL_OS==OSAL_WINNT 
#ifdef TSIM_OSAL
		#undef OSAL_C_PROCESS_ID_SELF 
		#undef OSAL_C_THREAD_ID_SELF 
		#define OSAL_C_PROCESS_ID_SELF OSAL_ProcessWhoAmI()
		#define OSAL_C_THREAD_ID_SELF  OSAL_ThreadWhoAmI()
#endif  /*#ifdef TSIM_OSAL*/
#endif 
   
   /* --9.2.19 Get the ID of the Actual Thread */
   OSAL_DECL OSAL_tThreadID OSAL_ThreadWhoAmI( tVoid );
   /* --9.2.22 Terminate the Actual Thread */
   OSAL_DECL tVoid OSAL_vThreadExit( tVoid );
   /* Set process specific exit code */
   OSAL_DECL tVoid OSAL_vSetProcessExitCode( tU32 );
   /* --9.2.4 Terminate the Actual Process */
   OSAL_DECL tVoid OSAL_vProcessExit( tVoid );
   
   #if OSAL_OS==OSAL_NUCLEUS || OSAL_OS==OSAL_TENGINE
    OSAL_DECL tS32 OSALAPI_s32ThreadConnect(tVoid);
    OSAL_DECL tS32 OSALAPI_s32ThreadDisconnect(tVoid);
   #endif // OSAL_OS==OSAL_NUCLEUS
   
   #endif 
   
   
   /* --VXWORKS OSAL_INLINE */
   #if OSAL_OS==OSAL_VXWORKS
   typedef struct
   {
      tString applicationName;
      OSAL_tpfThreadEntry applicationFunc;
   } vxWorks2OSAL_tProcessNameConverter;
   #include "os_process.h"
   
   /* special functions and VxWorks-Functions are defined via INLINE */
   
   #define OSAL_ThreadCreate(pcorAttr) \
        osThreadInit(pcorAttr,0)
   
   
   #define OSAL_ThreadSpawn(pcorAttr) \
        osThreadSpawn(pcorAttr,0)
    
   
   #define OSAL_s32ThreadActivate(tid) \
        taskActivate(tid)
   
   
   #define OSAL_s32ThreadWait(msec) \
        taskDelay(((msec*sysClkRateGet())/1000))
   
   
   #define OSAL_s32ThreadSuspend(tid) \
        taskSuspend(tid)
   
   
   #define OSAL_s32ThreadResume(tid) \
        taskResume(tid)
   
   
   #define OSAL_ThreadWhoAmI() \
            taskIdSelf()
   
   
   #define OSAL_s32ThreadLock() \
        taskLock()
   
   #define OSAL_s32ThreadUnlock() \
        taskUnlock()
   
   
   #endif

#endif // OSAL_DYNAMIC_DOWNLOAD

/**************************************************************************/
/* dynamic-download                                                       */
/**************************************************************************/
#if ( defined OSAL_DYNAMIC_DOWNLOAD || defined OSAL_DYNAMIC_BASE)
typedef OSAL_tProcessID (*tOSAL_ProcessSpawn)(const OSAL_trProcessAttribute* pcorAttr);
typedef tS32 (*tOSAL_s32ProcessDelete)(OSAL_tProcessID pid);
typedef OSAL_tProcessID (*tOSAL_ProcessWhoAmI)( tVoid );
typedef tVoid (*tOSAL_vProcessExit)( tVoid );
typedef tS32 (*tOSAL_s32ProcessList)(tS32 pas32List[], tS32 s32Length);
typedef tS32 (*tOSAL_s32ProcessControlBlock)(OSAL_tProcessID pid, OSAL_trProcessControlBlock* prPcb);
typedef OSAL_tThreadID (*tOSAL_ThreadCreate)(const OSAL_trThreadAttribute* pcorAttr);
typedef tS32 (*tOSAL_s32ThreadActivate)(OSAL_tThreadID tid);
typedef OSAL_tThreadID (*tOSAL_ThreadSpawn)(const OSAL_trThreadAttribute* pcorAttr);
typedef tS32 (*tOSAL_s32ThreadDelete)(OSAL_tThreadID tid);
typedef tS32 (*tOSAL_s32ThreadWait)(OSAL_tMSecond msec);
typedef tS32 (*tOSAL_s32ThreadSuspend)(OSAL_tThreadID tid);
typedef tS32 (*tOSAL_s32ThreadResume)(OSAL_tThreadID tid);
typedef tS32 (*tOSAL_s32ThreadPriority)(OSAL_tThreadID tid, tU32 nprio);
typedef OSAL_tThreadID (*tOSAL_ThreadWhoAmI)( tVoid );
typedef tS32 (*tOSAL_s32ThreadControlBlock)(OSAL_tThreadID tid, OSAL_trThreadControlBlock* prTcb);
typedef tS32 (*tOSAL_s32ThreadList)(tS32 pas32List[], tS32 s32Length);
typedef tVoid (*tOSAL_vThreadExit)( tVoid );
#endif


#if (OSAL_OS != OSAL_TENGINE) 
#ifdef OSAL_DYNAMIC_DOWNLOAD
extern tOSAL_ProcessSpawn            OSAL_ProcessSpawn;
extern tOSAL_s32ProcessDelete        OSAL_s32ProcessDelete;
extern tOSAL_ProcessWhoAmI           OSAL_ProcessWhoAmI;
extern tOSAL_vProcessExit            OSAL_vProcessExit;
extern tOSAL_s32ProcessList          OSAL_s32ProcessList;
extern tOSAL_s32ProcessControlBlock  OSAL_s32ProcessControlBlock;
extern tOSAL_ThreadCreate            OSAL_ThreadCreate;
extern tOSAL_s32ThreadActivate       OSAL_s32ThreadActivate;
extern tOSAL_ThreadSpawn             OSAL_ThreadSpawn;
extern tOSAL_s32ThreadDelete         OSAL_s32ThreadDelete;
extern tOSAL_s32ThreadWait           OSAL_s32ThreadWait;
extern tOSAL_s32ThreadSuspend        OSAL_s32ThreadSuspend;
extern tOSAL_s32ThreadResume         OSAL_s32ThreadResume;
extern tOSAL_s32ThreadPriority       OSAL_s32ThreadPriority;
extern tOSAL_ThreadWhoAmI            OSAL_ThreadWhoAmI;
extern tOSAL_s32ThreadControlBlock   OSAL_s32ThreadControlBlock;
extern tOSAL_s32ThreadList           OSAL_s32ThreadList;
extern tOSAL_vThreadExit             OSAL_vThreadExit;
#endif // OSAL_DYNAMIC_DOWNLOAD
#endif
      
   #ifdef __cplusplus
}
#endif

/* --OSAL object oriented C++-Interface. */
#ifdef __cplusplus
typedef enum {
   OSAL_EN_CREATE,
   OSAL_EN_SPAWN
} OSAL_tenCreationType;
class OSAL_DECL OSAL_tclThread : public OSAL_tclBase
{
   public:
      //--constructor
      OSAL_tclThread();
      
      //--destructor
      virtual ~OSAL_tclThread();
      
      //--Creates a new thread, thread is not active
      virtual OSAL_tIODescriptor s32Create( tCString coszName, 
                              tU32 u32Priority = OSAL_C_U32_THREAD_PRIORITY_NORMAL,
                              tS32 s32Stacksize = 0);
      
      //--Creates a new thread, thread is active
      virtual OSAL_tThreadID s32Spawn( tCString coszName, 
                             tU32 u32Priority = OSAL_C_U32_THREAD_PRIORITY_NORMAL,
                             tS32 s32Stacksize = 0);
      
      //--Activates a created thread
      virtual tS32 s32Activate();     
      
      //--Deletes a thread
      virtual tS32 s32Delete();
      
      //--Suspends a thread
      virtual tS32 s32Suspend();
      
      //--Resumes a suspended thread
      virtual tS32 s32Resume();               
      
      //--Set thread priority
      virtual tS32 s32SetPriority(tU32 u32Priority);
      
      //--Get the thread control block
      tS32 s32GetThreadControlBlock(OSAL_trThreadControlBlock* prThreadControlBlock);
      
      //--Suspends the current thread for a period
      virtual tS32 s32Wait(OSAL_tMSecond msec);
      //--Get the name of the thread
      tCString coszGetName() const
      {
         return rThreadAttribute.szName;
      }
      //--Get the id of the thread
          OSAL_tThreadID GetID() const
      {
         return hThreadId;
      }
      // --
      const OSAL_trThreadAttribute& rGetThreadAttribute() const
      {
         return rThreadAttribute;
      }
   private:
      /*
         This methode is used by the create and spawn methodes.
      */
      OSAL_tThreadID s32Build( OSAL_tenCreationType enCreationType, 
                     tCString& coszrfName, 
                     tU32 u32Priority,
                     tS32 s32Stacksize );
      
      // --Entry function of the thread
      virtual tVoid vEntry() =0;
      
      static tVoid vEntryHelper(tPVoid pvArg);
      
      // --Thread ID
      OSAL_tThreadID  hThreadId;
      
      // --Startinformations
      OSAL_trThreadAttribute rThreadAttribute;
};
class OSAL_DECL OSAL_tclProcess : public OSAL_tclBase
{
   public:
      //--constructor
      OSAL_tclProcess();
      
      //--destructor
      virtual ~OSAL_tclProcess();
      
      //--Creates and activates a new process
      virtual OSAL_tThreadID s32Spawn(tCString szName, tCString szAppName, tCString szCommandLine);
      
      //--Deletes a process
      virtual tS32 s32Delete();
      
      //--Get the process control block
      virtual tS32  s32GetProcessControlBlock(OSAL_trProcessControlBlock* prProcessControlBlock);
      //--Get the id of the process
      OSAL_tProcessID GetID() const
      {
         return hProcessId;
      }
      //--Get the name of the process
      tCString coszGetName() const
      {
         return rProcessAttribute.szName;
      }
      // --Get the start information of the process
      const OSAL_trProcessAttribute& rGetProcessAttribute() const
      {
         return rProcessAttribute;
      }
   private:
      /*
         This methode resets the member variable rProcessAttribute.
      */
      tVoid vResetAttributes();
      
      // --Process ID
      OSAL_tProcessID hProcessId;
      
      //--Startinformations
      OSAL_trProcessAttribute rProcessAttribute;
};
#endif

#endif 


/* EOF */
