/***************************************************************************
 * .EXPORT_ME
 * FILE:         ossmphr.h
 * PROJECT:      GMGE
 * SW-COMPONENT: OSAL
 *--------------------------------------------------------------------------
 * DESCRIPTION:  This is the headerfile for the OS - Abstraction Layer for 
 *               Mutex-Functions. This Header has to be included to use
 *               functions for Mutexes
 *--------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2009 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      |   Modification                         | Author
 * 16.03.00  |   Initial revision                     | Meyer,CF31
 * 23.11.17  |   Enable Mutex mocks                   | Deepak Kumar(RBEI/ECF1)
 **************************************************************************/

#if !defined (OSAL_MTX_HEADER)
   #define OSAL_MTX_HEADER

#define OSAL_MTX_INHERIT    0
#define OSAL_MTX_CEIL       1
#define OSAL_MTX_FIFO       2
#define OSAL_MTX_PRIO       3
#define OSAL_MTX_DEFAULT    OSAL_MTX_INHERIT


typedef uintptr_t OSAL_tMtxHandle;


#ifdef __cplusplus
extern "C"
{
#endif

  /* Create new Mutex */
  OSAL_DECL tS32 OSAL_s32MutexCreate(tCString coszName,OSAL_tMtxHandle * phMutex, tU32 u32Opt);
  
  /* Delete existing Mutex */
  OSAL_DECL tS32 OSAL_s32MutexDelete (tCString coszName);
  
  /* Get a handle of an existing mutex */
  OSAL_DECL tS32 OSAL_s32MutexOpen (tCString coszName, OSAL_tMtxHandle * phMutex);
  
  /* close open handle of a mutex */
  OSAL_DECL tS32 OSAL_s32MutexClose (OSAL_tMtxHandle hMutex);
  
  /* Unlock a Mutex */
  OSAL_DECL tS32 OSAL_s32MutexUnLock (OSAL_tMtxHandle hMutex);
  
  /* Lock a Mutex*/
  OSAL_DECL tS32 OSAL_s32MutexLock (OSAL_tMtxHandle hMutex, OSAL_tMSecond msec);
 
 

/**************************************************************************/
/* dynamic-download                                                       */
/**************************************************************************/
#if( defined OSAL_DYNAMIC_DOWNLOAD || defined OSAL_DYNAMIC_BASE)
typedef tS32 (*tOSAL_s32MutexCreate)(tCString coszName,OSAL_tMtxHandle * phMutex,tU32 u32Opt);
typedef tS32 (*tOSAL_s32MutexOpen)(tCString coszName, OSAL_tMtxHandle* phMid);
typedef tS32 (*tOSAL_s32MutexClose)(OSAL_tMtxHandle hMid);
typedef tS32 (*tOSAL_s32MutexDelete)(tCString coszName);
typedef tS32 (*tOSAL_s32MutexUnLock)(OSAL_tMtxHandle hMid);
typedef tS32 (*tOSAL_s32MutexLock)(OSAL_tMtxHandle hMid,OSAL_tMSecond msec);
#endif

#ifdef OSAL_DYNAMIC_DOWNLOAD
extern tOSAL_s32MutexCreate       OSAL_s32MutexCreate;
extern tOSAL_s32MutexOpen         OSAL_s32MutexOpen;
extern tOSAL_s32MutexClose        OSAL_s32MutexClose;
extern tOSAL_s32MutexDelete       OSAL_s32MutexDelete;
extern tOSAL_s32MutexUnLock       OSAL_s32MutexUnLock;
extern tOSAL_s32MutexLock         OSAL_s32MutexLock;
#endif // OSAL_DYNAMIC_DOWNLOAD
      
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
class OSAL_DECL OSAL_tclMutex : public OSAL_tclBase
{
   public:
      /* The following methods are according to the OSAL specification. */
      /* Constructor of this class. */
      OSAL_tclMutex();
      /* Destructor of this class. */
      virtual ~OSAL_tclMutex();
      /*
         This methode creates the semaphore. 
         If the creation of the semaphore has finished without
         an error the s32Open methode is called afterwards.
         (For more detail see OSAL Refernzhandbuch Kapitel Semaphore.)
      
         Additional Errors or meaning:
         OSAL_E_UNKNOWN: A handle already stored in this object.
         OSAL_E_NOSPACE: There is no space to save the name.
      */
      tS32 s32Create( tCString coszName,   /* (I) */
                      tU32 u32InitialValue /* (I) */ );
      /*
         This methode opens a semaphore.
         (For more detail see OSAL Refernzhandbuch Kapitel Semaphore.)
      
         Additional Errors or meaning:
         OSAL_E_ALREADYEXISTS: There exists already an opened semaphore.
         OSAL_E_NOSPACE: There is no space to save the name.
      */
      tS32 s32Open( tCString coszName /* (I) */ );
      /*
         This methode opens a semaphore with the name stored
         in this object.
         (This is an additional method!)
      
         Additional Errors or meaning:
         OSAL_E_ALREADYEXISTS: There exists already an opened semaphore.
         OSAL_E_UNKNOWN: There is no name saved in the object. 
                         (Use s32Open( tCString coszName ) )
      */
      tS32 s32Open();
      /*
         This methode closes a semaphore.
         (For more detail see OSAL Refernzhandbuch Kapitel Semaphore.)
      */
      tS32 s32Close( );
      /*
         This methode deletes the semaphore. 
         Before deleting the semaphore the methode s32Close will be
         performed to close the semaphore. After performing this 
         methode this semaphore object provides no semaphore 
         functionality but it is possible to create a new semaphore 
         in the same object.
         (For more detail see OSAL Refernzhandbuch Kapitel Semaphore.)
      */
      tS32 s32Delete( );
  
	  
	  /*
         This methode increments the value of the semaphore.
         (For more detail see OSAL Refernzhandbuch Kapitel Semaphore.)
      */
      tS32 s32Unlock();
      /*
         This methode decrements the value of the semaphore and the thread
         will be blocked in case of a semaphore value 0.
         (For more detail see OSAL Refernzhandbuch Kapitel Semaphore.)
      */
      tS32 s32Lock( OSAL_tMSecond msec /* (I) */ );
      /* 
         The following methods are new and/or with modification to the
         OSAL specification. 
      */
      /*
         To get the name of the created semaphore this methode can be used.
         After deletion the semaphore there is no name available furthermore.
      */
      tCString pszGetName();
   private:
      //
      /*
         This member stores the name of the semaphore.
      */
      tCString szName;
      /*
         This member stores the handle of the semaphore.
      */
      OSAL_tMtxHandle hMutexHandle;
};
#endif

#endif 


/* EOF */
