/*********************************************************************************************************************
* FILE        : osioctrl_gnss.h
*
* DESCRIPTION : This has implements all the interfaces for applications to used dev_gnss driver.
*---------------------------------------------------------------------------------------------------------------------
* AUTHOR(s)   : Ramachandra Madhu Kiran (CM-AI/PJ-CF35)
*
* HISTORY     :
*------------------------------------------------------------------------------------------------
* Date        |       Version          | Author & comments
*-------------|------------------------|---------------------------------------------------------
* 28.SEP.2013 | Initial version: 1.0   | Ramachandra Madhu Kiran (CM-AI/PJ-CF35)
* -----------------------------------------------------------------------------------------------
*********************************************************************************************************************/
#ifndef __OSAL_GNSS_H__
#define __OSAL_GNSS_H__

#define OSAL_C_U8_GNSS_NO_CHANNELS           ((tU8)48)
#define OSAL_C_GNSSFW_MAX_MSG_LENGTH         ((tU16)128)

/* Channel status */
#define OSAL_C_U16_GNSS_SAT_HEALTHY               ((tU16)0x0001)
#define OSAL_C_U16_GNSS_SAT_ALMANAC_AVAILABLE     ((tU16)0x0002)
#define OSAL_C_U16_GNSS_SAT_EPHEMERIS_AVAILABLE   ((tU16)0x0004)
#define OSAL_C_U16_GNSS_SAT_DGPS_AVAILABLE        ((tU16)0x0008)
#define OSAL_C_U16_GNSS_SAT_TRACKED               ((tU16)0x0010)
#define OSAL_C_U16_GNSS_SAT_USED_FOR_POSCALC      ((tU16)0x0020)

/* Satellite system used for position calculation */
#define OSAL_C_U8_GNSS_SATSYS_UNKNOWN     ((tU8)0x0)
#define OSAL_C_U8_GNSS_SATSYS_GPS         ((tU8)0x01)  
#define OSAL_C_U8_GNSS_SATSYS_GLONASS     ((tU8)0x02)
#define OSAL_C_U8_GNSS_SATSYS_GALILEO     ((tU8)0x04)
#define OSAL_C_U8_GNSS_SATSYS_COMPASS     ((tU8)0x08)
#define OSAL_C_U8_GNSS_SATSYS_SBAS        ((tU8)0x10)
#define OSAL_C_U8_GNSS_SATSYS_QZSS        ((tU8)0x20)
#define OSAL_C_U8_GNSS_SATSYS_ALL     ((tU8)( OSAL_C_U8_GNSS_SATSYS_GPS      | \
                                              OSAL_C_U8_GNSS_SATSYS_GLONASS  | \
                                              OSAL_C_U8_GNSS_SATSYS_GALILEO  | \
                                              OSAL_C_U8_GNSS_SATSYS_COMPASS  | \
                                              OSAL_C_U8_GNSS_SATSYS_SBAS     | \
                                              OSAL_C_U8_GNSS_SATSYS_QZSS) )

typedef enum
{
   GNSS_HW_UNKNOWN = 0,
   GNSS_HW_STA8088 = 1,   // teseo2
   GNSS_HW_STA8089 = 2    // teseo3

}tEnGnssHwType;

/* GNSS Fix modes */
typedef enum
{
   GNSS_FIX_TYPE_NOFIX   = 1,
   GNSS_FIX_TYPE_2D      = 2,
   GNSS_FIX_TYPE_3D      = 3,
   GNSS_FIX_TYPE_UNKNOWN = 255

 }OSAL_tenGnssMode;

/* GNSS quality */
typedef enum
{
	GNSSQUALITY_NOFIX        = 0,
	GNSSQUALITY_AUTONOMOUS   = 1,
	GNSSQUALITY_DIFFERENTIAL = 2,
	GNSSQUALITY_UNKNOWN      = 255
	
}OSAL_tenGnssQuality;


/* Antenna state */
typedef enum
{
   GNSS_ANTENNA_NORMAL        = 0,
   GNSS_ANTENNA_OPEN          = 1,
   GNSS_ANTENNA_SHORT         = 2,
   GNSS_ANTENNA_BURNING       = 3,
   GNSS_ANTENNA_BATTERY_SHORT = 4,
   GNSS_ANTENNA_UNKNOWN       = 5

} OSAL_tenGnssAntStatus;

/* This holds all antenna related information. */
typedef struct
{
   OSAL_tenGnssAntStatus enGnssAntStatus;
   tF32 f32AntCurrent;

}OSAL_trGnssAntennaInfo;


/* UTC time obtained from GNSS receiver */
typedef struct
{
   tU16 u16Year;
   tU8 u8Month;
   tU8 u8Day;
   tU8 u8Hour;
   tU8 u8Minute;
   tU8 u8Second;
   tU16 u16Millisecond;

}OSAL_trGnssTimeUTC;

/* This holds the status of each of the channels used to track satellites */
typedef struct
{
   tU16 u16SvID;
   tU16 u16SatStatus;
   tF32 f32Azimuthal;
   tF32 f32Elevation;
   tU8 u8CarrierToNoiseRatio;

}OSAL_trGnssChannelStatus;

/* information about the GNSS solution mode and quality */
typedef struct
{
   OSAL_tenGnssQuality enQuality;
   OSAL_tenGnssMode enMode;

} OSAL_trGnssFixStatus;

/* complete GNSS Position Time and Velocity Information */
typedef struct
{
   /* UTC time */
	OSAL_trGnssTimeUTC rTimeUTC;
   /* Position information */
	tF64 f64Latitude;
	tF64 f64Longitude;
	tF32 f32AltitudeWGS84;
	tF32 f32GeoidalSeparation;
   /* Velocity information */
	tF32 f32VelocityEast;
	tF32 f32VelocityNorth;
	tF32 f32VelocityUp;
   /* Covariance and noise matrices information */
	OSAL_trCovarianceMatrix rPositionCovarianceMatrix;
	OSAL_trCovarianceMatrix rPositionNoiseMatrix;
	OSAL_trCovarianceMatrix rVelocityCovarianceMatrix;
	OSAL_trCovarianceMatrix rVelocityNoiseMatrix;
   /* Type and quality of fix */
	OSAL_trGnssFixStatus rFixStatus;
   /* Dilution of position */
	tF32 f32GDOP;
	tF32 f32HDOP;
	tF32 f32PDOP;
	tF32 f32TDOP;
	tF32 f32VDOP;
   /* Satellite system used */
	tU8 u8SatSysUsed;
   /* Number of satellites visible*/
	tU16 u16SatsVisible;
   /* Number of Satellites for which ephermeris and almanac is received */
	tU16 u16Received;
   /* number of satellites used to calculate the fix information */
	tU16 u16SatsUsed;
   /* Kalman, Stop detection, Walking mode, FDE filter information */
	tU16 u16FilterData;

}OSAL_trGnssPVTData;

/* The complete GNSS structure. This is the exchange format between 
   GNSS proxy Driver and VD-Sensor. This is designed for new FI 
   document version 5.0 */
typedef struct
{
   tU32 u32TimeStamp;
   OSAL_trGnssPVTData rPVTData;
   OSAL_trGnssChannelStatus rChannelStatus[OSAL_C_U8_GNSS_NO_CHANNELS];

}OSAL_trGnssFullRecord;

/* GNSS configuration message */
typedef struct 
{
   // GNSS receiver H/W Type
   tEnGnssHwType enGnssHwType;
   // Firmware version of the GNSS receiver
   tU32 u32GnssRecvBinVer;
   // Maximum number of channels tracked by GNSS receiver
   tU16 u16NumOfChannels;
   // Status supported for individual channels
   tU16 u16GnssSatStatusSupported;
   // Frequency at which GNSS information will be transmitted
   tU8 u8UpdateFrequency;
   // 32 Bit CRC of the Firmware in GNSS receiver
   tU32 u32GnssRecvFwCrc;
   // Bosch Specific Firwmware Version
   tU8 u8GnssFwVersion[OSAL_C_GNSSFW_MAX_MSG_LENGTH];
}OSAL_trGnssConfigData;


/* Binary type to be flashed. */
typedef enum
{
   IMAGE_INVALID = 0,
   IMAGE_TESEO_FLASHER_BIN = 1,
   IMAGE_TESEO_FIRMWARE = 2,
   IMAGE_UNKONWN = 255
} tEnImageType;

/* Structure to configure Teseo firmware update */
typedef struct
{
   tEnImageType enType; /* Type of the image to be flashed */
   tU32 u32Size;        /* size of the binary image to be flashed. */
   tU32 u32ChkSum;      /* Checksum of binary Image. Depends on the image
                        if and what algorithm used */
} trImageOptions;

/* GNSS Chip type mounted on the board */
typedef enum
{
   GNSS_CHIP_TYPE_INVALID = 0,
   GNSS_CHIP_TYPE_TESEO_2 = 1,   /* For Teseo-2 flashing */
   GNSS_CHIP_TYPE_TESEO_3 = 2,   /* For Teseo-3 flashing */
   GNSS_CHIP_TYPE_UNKNOWN = 255

} tEnGnssChipType;


/* IO_CTRL's interfaces exported from Gnss proxy */

/* Get GNSS Config data */
#define OSAL_C_S32_IOCTRL_GNSS_GET_CONFIG_DATA          (1)
/* Set satellite system to be used for position calculation */
#define OSAL_C_S32_IOCTRL_GNSS_SET_SAT_SYS              (2)
/* Get satellite system to be used for position calculation */
#define OSAL_C_S32_IOCTRL_GNSS_GET_SAT_SYS              (3)
/*Get GNSS antenna Status - Not supported currently */
#define OSAL_C_S32_IOCTL_GNSS_GET_ANTENNA_STATUS        (4)
/* This is a trigger to flash binary image to GNSS chip */
#define OSAL_C_S32_IOCTL_GNSS_FLASH_IMAGE               (5)
/* This gives the list of NMEA messages received per fix.
   This is only for testing purpose. */
#define OSAL_C_S32_IOCTL_GNSS_GET_NMEA_RECVD_LIST       (6)
/* Infoms the GNSS driver about critical voltage state */
#define OSAL_C_S32_IOCTL_GNSS_SET_CVM_STATE             (7)
/* Sets GNSS epoch */
#define OSAL_C_S32_IOCTL_GNSS_SET_EPOCH                 (8)
/* Flush GNSS buffer on SCC */
#define OSAL_C_S32_IOCTL_GNSS_FLUSH_SENSOR_DATA         (9)
/*  To get the crc of GNSS chip firmware */
#define OSAL_C_S32_IOCTL_GNSS_GET_GNSS_CHIP_CRC         (10)
/* This is similar to "OSAL_C_S32_IOCTRL_GNSS_SET_SAT_SYS".
   Only difference is, the satellite system set will 
   be NON_Persistent.This is supposed to be 
   used only for Diagnosis*/
#define OSAL_C_S32_IOCTRL_GNSS_DIAG_SET_SAT_SYS         (11)
/* To get the currently stored epoch values */
#define OSAL_C_S32_IOCTL_GNSS_GET_EPOCH                 (12)
/* To select the GNSS chip type mounted on the board for 
firmware update. This works only if /dev/gnss is opened 
in OSAL_EN_WRITEONLY mode*/
#define OSAL_C_S32_IOCTL_GNSS_SET_CHIP_TYPE             (13)

/*--------------END OF FILE---------------*/
#endif