/***************************************************************************
 * .EXPORT_ME
 * FILE:         osioctrl.h
 * PROJECT:      VASCO
 * SW-COMPONENT: OSAL
 *--------------------------------------------------------------------------
 * DESCRIPTION:  Defines for
 *--------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2001 Robert Bosch GmbH, Hildesheim
 *  $Revision: 1.9 $
 *      $Date: 2008/04/15 09:59:55CEST $
 * HISTORY:
 * Date      |   Modification                      | Author
 *           |                                     |
 * ??.??.??  |   Initial revision                  | ??
 *           |                                     |
 * 22.10.01  |   Ringbuffer for Gyro and Odom      | Garrelts, ENS1
 *           |   resized to 512 entrys             |
 * 07.03.02  |   Nucleus defines added             | Tiemann, ESI1
 * 26.04.02  |   AUXCLOCK Control added            | Garrelts
 * 29.04.02  |   Trace device added                | Schubert
 * 29.04.02  |   PRM/PRC/CDCTRL added              | Mathews, Garrelts
 * 08.05.02  |   PRM - Preport Memory added        | Mathews
 * 17.05.02  |   PRM/PRC additional Defines        | Garrelts
 * 21.02.02  |   implementation of ovc driver      | Mamone, EHS1
 *           |   (changes marked with ident #Ma)   |
 * 29.04.02  |   new IO Control added              | Mamone, EHS1
 * 24.05.02  |   new speech structures             | Garrelts, CM
 * 16.09.02  |   add SPI structures                | Krappweis, 3SOFT
 *           |   changed OSAL_trGetErrorBuffer     | Krappweis, 3SOFT
 * 04.02.03  |   new IO Controls for /dev/card     | Fabig, 3Soft
 * 11.02.03  |   PRM/PRC Ressourcennamen geändert  | Garrelts
 * 19.03.03  |   new labels for ovc driver         | Mamone, ESU2 (#MaF70.001)
 * 01.04.03  |   KDS device added                  | Kania, EES4
 * 10.07.03  |   new IO COntrol for /dev/registry  | Scherber, ESA2
 * 11.07.03  |   new IO Control for /dev/ramdisk   | Kropp, EES4
 * 12.07.03  |   new IO Control for /dev_mp3       | Meyer, ESU1
 * 16.07.03  |   new IO Control for /dev/ffs       | Kropp, EES4
 * 06.04.04  |   add IO Control to start/stop gyro | Bode, EES4
 * 08.06.05  |   new IO Control to dev/adc		   | CM-DI/EDI2-hka2kor	
 * 07.10.05  |   new IO Control for /dev/dspexch   | Vinod, RBIN/EDI4
 * 11.10.05  |   rem defines for /dev/rpm (WinCE)  | Soj, RBIN
 * 25.01.06  |   IO Control for acoustic devices   | Vinod, RBIN/EDI4
 *			 |   (dev/acousticin & dev/acousticout)|
 * 26.02.07  |   @brief Acousticout events         | Hennings, CF14 
 * 22.01.07  |   Added new IO Controls for 		   | Kanishka, RBIN/ECM1
 *           |   /dev/card                         |
 * 31.01.07  |   Added new typedefs & defines for  | Kanishka, RBIN/ECM1
 *           |   /dev/card   
 * 22.03.07  |   Added new typedefs & defines for  | Vamsi Krishna, RBIN/ECM1
 *           |   /dev/TDA7564 (I2C)                         |
 * 21.05.07  |   Added definitions for dev_map,    | S.Kropp, CM-AM/ENG-DI
 *           |   dev_sysctrl and dev_tmc           |
 * 04.06.07  |   Added new enum for /dev/adc       | hka2kor, RBIN/ECM1
 * 05.07.07  |   addes define and stucts for       |
 *           |   /dev/steering & /dev/abs          | fsj2hi, CM-DI/PJ14
 * 19.10.07  |   Linux defines added               | Soj, RBIN/ECM1
 *           |                                     |
 * 30.10.07  |  Changed the data type of 		   |
             |   registerForNotify in structure    |  rav8kor,RBIN/EDI3
             |   OSAL_tenRtcTimeUpdToNotify        |
 * 21.01.08  |  added /dev/touchscreen             | fsj2hi, CM-DI/PJ-CF31
 * 14.02.08  |  Added new IO control and error 	   | vij7kor, RBIN/ECM1
 *           |  defines for /dev/card              |
 * 20.02.08  |  Added System State for             | rar6kor, RBIN/ECM3
 *           |  Osalbench(OSAL_WINNT builds only)  |
 * 21.02.08  |   added #define 		           |
 *           |   OSAL_C_S32_IOCTRL_FIOATTRIBGET    |
 *           |   and structure for get/set         |hka2kor, RBIN/ECM1
 *           |   attributes of file/directory      |
 *           |   from the SD card.	           |
 * 28.02.08  | Added new defines for dev_sysctrl.  | kos2hi, CM-AM\ENG-DI
 * 06.05.08  | New IOControls and a new data       | ggs2hi, CM-AM/ENG-DI2
 *           | structure for dev_sysctrl.          |
 * 15.05.08| extended AcousticOut for Loan Buffer in AcousticOut | wk83hi,
 * 21.05.08	 | GPIO defines for OSAL to DTT abstraction | Shilpa Bhat RBEI/ECM1
 * 05.06.08  | added defines for dev_sysctrl       | kos2hi, CM-AM/ENG-DI1
 * 25.06.2008 | added defines for dev/ipod         | wk83hi
 * 27.06.08  | Updated GPIO defines for OSAL to    |
 *           | DTT abstraction                     | Shilpa Bhat RBEI/ECM1
 * 19.08.08  | Add OSAL_C_32_IOCTRL_GPIO_SET_TRIGGER  | Köchling
 * 01.09.08  | Added new IOCTRL's for GPIO         | Shilpa Bhat RBEI/ECM1
 *           | Active/Inactive functionality 	   |
 * 15.09.08  | New IO Control
             | OSAL_C_S32_IOCTRL_SWC_GET_DEVICE_STATE |
             | has been added and existing 2 IO control |
             | names have been modified            | Sainath Kalpuri RBEI/ECM1 
 * 13.10.08  | OSAL_C_U8_SWC_SHORT_CIRCUIT state has | Sainath Kalpuri RBEI/ECM1
             | been included
*  29.10.08  | Added error values for dev-ipod <-> fc_ipod | Klaus Wacker CF31 
 *  3.13.08  | added ioctl to /dev/touchscreen     | fsj2hi, CM-DI/PJ-CF31
 *  3.13.08  | extended gpios                      | koe2hi, CM-DI/PJ-CF31
*  05.11.08  | Values of SWC status information related
               macros have been modified                | Sainath Kalpuri RBEI/ECM1
*  14.11.08  | Modify/add ioctl values for iPod,   | Martin Mueller PJ-CF31
               change usb device info length      
* 26.12.08   | Added OSAL_C_U8_SWC_INVALID_LEVEL   | Hemantha Kumar A (RBEI/ECM1)
*            | state is added                      |
* 03.04.09   | New IOControl is added to check the
               validity of read sample             | Sainath Kalpuri (RBEI/ECF1)
* 24.08.10   | Gyro 3D related modifications have  | Sainath Kalpuri (RBEI/ECF1)
             | been done
* 23.09.10   | 3 new entries related to Antenna    | Sainath Kalpuri (RBEI/ECF1)
             | open, short and shdn have been added|
             | in OSAL_enGpioPins entry.
* 14.02.11   | New IOCtrol for FAT Format          | Anoop Chandran (RBEI/ECF1)
* 05.04.11   | Added Signature verify argument     | Anooj Gopi (RBEI/ECF1)
             | structres                           | 
* 23.05.12   |New IO Control                       |
			 |OSAL_C_S32_IOCTRL_GYRO_GET_TEMP      |Sanjay Gurugubelli(RBEI/ECF5)
			 |has been added for dev_gyro          |
* 11.10.12	| Added new defines for /dev/acoustic/SRC   | Niyatha S Rao, ECF5, RBEI
* 12.10.12   |New IO Control & structure for same added |Gopinathan Subu(RBEI/ECF5)
             |OSAL_C_S32_IOCTL_TOUCHSCREEN_SETRESPONSE_TIME
             |OSAL_C_S32_IOCTL_TOUCHSCREEN_SETDISPLAYSIZE
* 3.12.12    |SWC callback argument type change    |Gopinathan Subu(RBEI/ECF5)
             |to maintain the new OSAL standard    |  
* 13.08.13   |Added IOctrls for device ADR3CTRL    |SJA3KOR(RBEI/ECF5)			 
* 07.05.14   | Added GPIO PINs for GNSS ANT        |Nikhil Ravindran (RBEI/ECF5)		 
* 20.05.14   |Added a member szDevicName in the structure   |
*            |OSAL_trIOCtrlCardState                        |PMH5KOR(RBEI/ECF5)
* 22.07.14   |Added GPIO For GMMY16                |Nikhil Ravindran (RBEI/ECF5)	
* 23.09.12   |add structs for gyro/acc HW info     |Joachim Friess (CM-DI/ECO1)
* 03.03.15   |added new enum for odometer status   |Srinivas Prakash Anvekar (RBEI/ECF5)
*             and structure containing this odometer       |
*             status have been updated to its new datatype |
* 29.02.16   |Added GPIO For CAF                 |Nikhil Ravindran (RBEI/ECF5)
* 15.06.2016 |Added GPIO PIN for A-IVI           |Ajay Vishwanath Bande (RBEI/ECF5)
* 04.08.16   |Added GPIO For A-IVI                 |Nikhil Ravindran (RBEI/ECF5)
* 12.09.2016 - Added GPIO PIN for A-IVI - Nikhil Ravindran (RBEI/ECF5)
* 08.12.2016 - New IOControl added - OSAL_C_S32_IOCTRL_PRM_PARTITION_INFO - AHM5KOR
* 13.11.2017 - Added GPIO PIN for A-IVI - Nikhil Ravindran (RBEI/ECF5)
* 28.02.2018 - Added GPIO PIN for A-IVI/A-IVI2 - Nikhil Ravindran (RBEI/ECF1)
* 21.08.2018 - Added GPIO PIN  - Nikhil Ravindran (RBEI/ECF1)
* 27.11.2018 - Added GPIO PIN  - Akshay Kundgol (RBEI/ECF1)
* 27.02.2018 - Added GPIO PIN  - Amit Bhardwaj (RBEI/ECF1)
* 17.04.2019 - Added GPIO PIN  - Akshay Kundgol (RBEI/ECF1)
* 17.05.2019   |New IO Control                                    |
               |OSAL_C_S32_IOCTRL_PRM_FORMAT_DEVICE               |Akshay Kundgol (RBEI/ECF1)
               |has been added for formatting USB to FAT32        |
* 12.06.2019 - Added GPIO PIN  - Akshay Kundgol (RBEI/ECF1)
* 10.06.2019   |New IO Control                                    |
               |OSAL_C_S32_IOCTRL_PRM_UNMOUNT_DEVICE              |Akshay Kundgol (RBEI/ECF1)
               |has been added for unmounting the partition       |
* 29.07.2019 - Added GPIO PIN  - Akshay Kundgol (RBEI/ECF1)
* 25.09.2019 - Added GPIO PIN  - Deepak Kumar   (RBEI/ECF1)			   
 **************************************************************************/
#ifndef OSIOCTRL_HEADER
#define OSIOCTRL_HEADER

/* --In this file the typical IOCTRLs are declared. */

/**************************************************************************/
/* defines                                                               */
/**************************************************************************/

/*************************************************************************/
/* Important note on IOCTRL values                                       */
/*************************************************************************/
/* IOCTRLs usually are processed in the IOCTRL function of a device.
 * So the same values are used with different meanings in diffent devices.
 *
 * Some values are reserved because they are processed in the OSAL dispatcher itself.
 *
 * !!! Please keep these values exclusive and define them as (OSAL_C_S32_MAX-Offset)
 *     to make them easy to find. !!!
 *
 * Currently exclusive values exist for 
 *
 * a) PRM, e.g. OSAL_C_S32_IOCTRL_GET_EXCLUSIVE_ACCESS
 * b) Trace, only for OSAL_C_S32_IOCTRL_ISACTIVE
 *
 *************************************************************************/   



#define OSAL_C_S32_IOCTRL_VERSION               OSAL_C_S32_MAX
#define OSAL_C_S32_IOCTRL_CALLBACK_REG          ((tS32)1)
#define OSAL_C_S32_IOCTRL_CALLBACK_UNREG        ((tS32)2)

#if (OSAL_OS==OSAL_NUCLEUS)
#define OSAL_C_S32_IOCTRL_ISACTIVE_VIA_DEV      ((tS32)3)
#define OSAL_C_S32_IOCTRL_ISACTIVE              ((tS32)OSAL_C_S32_MAX - 100)
#else
#define OSAL_C_S32_IOCTRL_ISACTIVE              ((tS32)3)
#endif

#define OSAL_C_S32_IOCTRL_SEND_BINARY_DATA      ((tS32)4)
#define OSAL_C_S32_IOCTRL_INIT_TRIP_DATA_REC    ((tS32)5)
#define OSAL_C_S32_IOCTRL_INIT_TRIP_DATA_REPLAY ((tS32)6)
#define OSAL_C_S32_IOCTRL_STOP_TRIP_DATA_REPLAY ((tS32)7)
#define OSAL_C_S32_IOCTRL_GET_NEXT_TRIP_DATA    ((tS32)8)
#define OSAL_C_S32_IOCTRL_GET_OUTPUTCHANNEL     ((tS32)9)
#define OSAL_C_S32_IOCTRL_SET_OUTPUTCHANNEL     ((tS32)10)
#define OSAL_C_S32_IOCTRL_SET_DSP_INST_NAME     ((tS32)11)
#define OSAL_C_S32_IOCTRL_RESET_DSP_INST_NAME   ((tS32)12)
#define OSAL_C_S32_IOCTRL_CREATE_TTFIS_PROXY    ((tS32)13)
#define OSAL_C_S32_IOCTRL_SET_TTFIS_SINK        ((tS32)14)
#define OSAL_C_S32_IOCTRL_GET_TTFIS_SINK        ((tS32)15)
#define OSAL_C_S32_IOCTRL_ENABLE_TTFIS_SINK     ((tS32)16)
#define OSAL_C_S32_IOCTRL_SET_LOCK_STATUS       ((tS32)17)

// Comp_comm identifier, for a new Comp_comm add identifier
// to enum
#ifndef VASCO_OS_TENGINE
#ifndef TSIM_OSAL
typedef enum
{
  OUTPUT_DEFAULT,
  OUTPUT_VIA_SOCKET,
  OUTPUT_VIA_SIO,
  OUTPUT_IN_FILE,
  OUTPUT_VIA_IPC,
  OUTPUT_VIA_PROXY,
  OUTPUT_VIA_ELSIO,
  OUTPUT_VIA_USBIO,
  OUTPUT_VIA_NULLDEVICE
}TR_tenOutputChan;
#endif
#endif


/* --VXWORKS INLINE */
#if OSAL_OS==OSAL_VXWORKS

#include "iolib.h"

#define OSAL_C_S32_IOCTRL_FIOWHERE              ((tS32)FIOWHERE)
#define OSAL_C_S32_IOCTRL_FIOSEEK               ((tS32)FIOSEEK)
#define OSAL_C_S32_IOCTRL_FIOREADDIR            ((tS32)FIOREADDIR)
#define OSAL_C_S32_IOCTRL_FIONREAD              ((tS32)FIONREAD)
#define OSAL_C_S32_IOCTRL_FIOMKDIR              ((tS32)FIOMKDIR)
#define OSAL_C_S32_IOCTRL_FIORMDIR              ((tS32)FIORMDIR)
#define OSAL_C_S32_IOCTRL_FIOGETNAME            ((tS32)FIOGETNAME)
#define OSAL_C_S32_IOCTRL_FIOLABELGET           ((tS32)FIOLABELGET)
#define OSAL_C_S32_IOCTRL_FIODISKCHANGE         ((tS32)FIODISKCHANGE)
#define OSAL_C_S32_IOCTRL_FIOUNMOUNT            ((tS32)FIOUNMOUNT)
#define OSAL_C_S32_IOCTRL_FIOFSTATGET           ((tS32)FIOFSTATGET)
#define OSAL_C_S32_IOCTRL_FIODISKFORMAT         ((tS32)FIODISKFORMAT)
#define OSAL_C_S32_IOCTRL_FIODISKINIT           ((tS32)FIODISKINIT)
#define OSAL_C_S32_IOCTRL_FIORENAME             ((tS32)FIORENAME)
#define OSAL_C_S32_IOCTRL_FIOSYNC               ((tS32)FIOSYNC)
#define OSAL_C_S32_IOCTRL_FIOFLUSH              ((tS32)FIOFLUSH)
#define OSAL_C_S32_IOCTRL_FIOTRUNC              ((tS32)FIOTRUNC)
#define OSAL_C_S32_IOCTRL_FIONFREE              ((tS32)FIONFREE)
#define OSAL_C_S32_IOCTRL_FIOLABELSET           ((tS32)FIOLABELSET)
#define OSAL_C_S32_IOCTRL_FIOATTRIBSET          ((tS32)FIOATTRIBSET)
#define OSAL_C_S32_IOCTRL_FIOCONTIG             ((tS32)FIOCONTIG)
#define OSAL_C_S32_IOCTRL_FIONCONTIG            ((tS32)FIONCONTIG)

#elif OSAL_OS==OSAL_RX732 || OSAL_OS==OSAL_WINNT || OSAL_OS==OSAL_WINCE \
        || OSAL_OS==OSAL_NUCLEUS || OSAL_OS==OSAL_TENGINE \
        || OSAL_OS==OSAL_LINUX || OSAL_OS==OSAL_DARWIN

#define OSAL_C_S32_IOCTRL_FIOWHERE              ((tS32)1001)
#define OSAL_C_S32_IOCTRL_FIOSEEK               ((tS32)1002)
#define OSAL_C_S32_IOCTRL_FIOREADDIR            ((tS32)1003)
#define OSAL_C_S32_IOCTRL_FIONREAD              ((tS32)1004)
#define OSAL_C_S32_IOCTRL_FIOMKDIR              ((tS32)1005)
#define OSAL_C_S32_IOCTRL_FIORMDIR              ((tS32)1006)
#define OSAL_C_S32_IOCTRL_FIOGETNAME            ((tS32)1007)
#define OSAL_C_S32_IOCTRL_FIOLABELGET           ((tS32)1008)
#define OSAL_C_S32_IOCTRL_FIODISKCHANGE         ((tS32)1009)
#define OSAL_C_S32_IOCTRL_FIOUNMOUNT            ((tS32)1010)
#define OSAL_C_S32_IOCTRL_FIOFSTATGET           ((tS32)1011)
#define OSAL_C_S32_IOCTRL_FIODISKFORMAT         ((tS32)1012)
#define OSAL_C_S32_IOCTRL_FIODISKINIT           ((tS32)1013)
#define OSAL_C_S32_IOCTRL_FIORENAME             ((tS32)1014)
#define OSAL_C_S32_IOCTRL_FIOSYNC               ((tS32)1015)
#define OSAL_C_S32_IOCTRL_FIOFLUSH              ((tS32)1016)
#define OSAL_C_S32_IOCTRL_FIOTRUNC              ((tS32)1017)
#define OSAL_C_S32_IOCTRL_FIONFREE              ((tS32)1018)
#define OSAL_C_S32_IOCTRL_FIOLABELSET           ((tS32)1019)
#define OSAL_C_S32_IOCTRL_FIOATTRIBSET          ((tS32)1020)
#define OSAL_C_S32_IOCTRL_FIOCONTIG             ((tS32)1021)
#define OSAL_C_S32_IOCTRL_FIONCONTIG            ((tS32)1022)
#define OSAL_C_S32_IOCTRL_FIOFREESIZE           ((tS32)1023)
#define OSAL_C_S32_IOCTRL_FIOTOTALSIZE          ((tS32)1024)
#define OSAL_C_S32_IOCTRL_FIOOPENDIR            ((tS32)1025)
#define OSAL_C_S32_IOCTRL_FIOSETSTREAMMODE      ((tS32)1026)
#define OSAL_C_S32_IOCTRL_FIOREADDIREXT         ((tS32)1027)
#define OSAL_C_S32_IOCTRL_FIORMRECURSIVE        ((tS32)1028)
#define OSAL_C_S32_IOCTRL_FIOATTRIBGET          ((tS32)1029)
#define OSAL_C_S32_IOCTRL_FIOCOPYDIR            ((tS32)1030)
#define OSAL_C_S32_IOCTRL_FIORMRECURSIVE_CANCEL ((tS32)1031)
#define OSAL_C_S32_IOCTRL_FIOREADDIREXT2        ((tS32)1032)
#define OSAL_C_S32_IOCTRL_FIOPREPAREEJECT       ((tS32)1033)
#define OSAL_C_S32_IOCTRL_FIOGETMOUNTPOINTINFO  ((tS32)1034)  
#define OSAL_C_S32_IOCTRL_FIOSETMOUNTPOINTACCESS ((tS32)1035)  
#define OSAL_C_S32_IOCTRL_FIOGETMOUNTPOINTACCESS ((tS32)1036)
#define OSAL_C_S32_IOCTRL_FIOTRIGGER_SIGN_VERIFY ((tS32)1037) /* Triggers Signature verification operation */
#define OSAL_C_S32_IOCTRL_FIOCRYPT_VERIFY_STATUS ((tS32)1038) /* Returns the status of the signature verification operation - 3 options */
#define OSAL_C_S32_IOCTRL_FIOGET_SIGNATURE_TYPE  ((tS32)1039) /* Returns the type of signature used in verification - 3 options */
#define OSAL_C_S32_IOCTRL_FIOGET_CID             ((tS32)1040) /* Read the CID */
#define OSAL_C_S32_IOCTRL_FIOGET_REAL_PATH       ((tS32)1041) /* returns the native os path of the osal device */
#define OSAL_C_S32_IOCTRL_eMMC_REFRESH_START	 ((tS32)1042)  /* Additional IO Controls for Refresh of eMMC: IOCTL for starting refresh */
#define OSAL_C_S32_IOCTRL_eMMC_REFRESH_STOP 	 ((tS32)1043)  /* IOCTL for eMMC refresh stop*/
#define OSAL_C_S32_IOCTRL_eMMC_GET_REFRESH_STATE ((tS32)1044) /* IOCTL for getting eMMC refresh state*/
#define OSAL_C_S32_IOCTRL_FIO_CHMOD              ((tS32)1045)
#define OSAL_C_S32_IOCTRL_FIO_CHOWN              ((tS32)1046)
#endif

typedef struct
{
	tBool RefreshComplete; /* Refresh Status*/
	tU32 LastRefreshedBlock; /* Last Block number that was refreshed*/
	tU32 CompleteRefreshCount; /* Total number of times eMMC is refreshed in its Life time */
	OSAL_trTimeDate    rEntryTime; /* Last time when refresh activity was succesful*/
}RefreshCfg;

enum {
   eMMC_REFRESH_NORMAL, 
   eMMC_REFRESH_STOP_NORMAL,	    /* pass this as argument in normal stop sequence*/
   eMMC_REFRESH_STOP_LOW_VOLTAGE 	/* pass this argument, incase of system low voltage*/
};
// OSAL_C_S32_IOCTRL_eMMC_GET_REFRESH_STATE update arguments with any one of the following enum value
typedef enum {
   eMMC_REFRESH_NOTSTARTED,
   eMMC_REFRESH_STARTED,
   eMMC_REFRESH_FINISHED,
   eMMC_REFRESH_STOPPED_NORMAL,
   eMMC_REFRESH_STOPPED_ON_LOW_VOLTAGE 
}tenRefreshState;
/* default timeout parameter for OSAL_C_S32_IOCTRL_FIOSETSTREAMMODE */
#define OSAL_C_S32_FIOSTREAMMODETIMEDEFAULT     ((tS32)-1)


#define OSAL_C_S32_IOCTRL_SIO_BAUD_SET          ((tS32)1)
#define OSAL_C_S32_IOCTRL_SIO_DATABITS_SET      ((tS32)2)
#define OSAL_C_S32_IOCTRL_SIO_PARITY_SET        ((tS32)3)
#define OSAL_C_S32_IOCTRL_SIO_STOPBITS_SET      ((tS32)4)
#define OSAL_C_S32_IOCTRL_SIO_REMOTEFLOW_SET    ((tS32)5)
#define OSAL_C_S32_IOCTRL_SIO_LOCALFLOW_SET     ((tS32)6)
#define OSAL_C_S32_IOCTRL_SIO_CTSOPTION_SET     ((tS32)7)
#define OSAL_C_S32_IOCTRL_SIO_BIT7LOW_SET       ((tS32)8)
#define OSAL_C_S32_IOCTRL_SIO_BIT7HIGH_SET      ((tS32)9)
#define OSAL_C_S32_IOCTRL_SIO_BREAKTIME_SET     ((tS32)10)
#define OSAL_C_S32_IOCTRL_SIO_INTV_SET          ((tS32)11)
#define OSAL_C_S32_IOCTRL_SIO_FLUSH             ((tS32)12)
#define OSAL_C_S32_IOCTRL_SIO_READEVENT_SET     ((tS32)13)

#define OSAL_C_S32_IOCTRL_SIO_SET_RSMODE		((tS32)14)
#define OSAL_C_S32_IOCTRL_SIO_GET_RSMODE		((tS32)15)
#define OSAL_C_S32_IOCTRL_SIO_SET_RSFLOW		((tS32)16)
#define OSAL_C_S32_IOCTRL_SIO_GET_RSFLOW		((tS32)17)
#define OSAL_C_S32_IOCTRL_SIO_SET_RSBREAK		((tS32)18)
#define OSAL_C_S32_IOCTRL_SIO_SET_RSSNDTMO		((tS32)19)
#define OSAL_C_S32_IOCTRL_SIO_SET_RSRCVTMO		((tS32)20)
/* */
typedef struct
{		      /*lint -e{46} */
tU32    u32parity:2;  /*lint -e{46} *//* 0: none, 1: odd, 2: even, 3: -- */
tU32    u32datalen:2; /*lint -e{46} *//* 0: 5 bits, 1: 6 bits, 2: 7 bits, 3: 8 bits */
tU32    u32stopbits:2;/*lint -e{46} *//* 0: 1 bit, 1: 1.5 bits, 2: 2 bits, 3: -- */
tU32    u32baud:24;   /*lint -e{46} *//* baud rate */

}OSAL_trRsMode;

typedef struct
{		      /*lint -e{46} */
tU32   u32rcvxoff:1;  /*lint -e{46} *//* forced XOFF state change */
tU32   u32csflow:1;   /*lint -e{46} *//* CTS control */
tU32   u32rsflow:1;   /*lint -e{46} *//* RTS control */
tU32   u32xonany:1;   /*lint -e{46} *//* XON for any character */
tU32   u32sxflow:1;   /*lint -e{46} *//* send XON/XOFF control */
tU32   u32rxflow:1;   /*lint -e{46} *//* receive XON/XOFF control */

}OSAL_trRsFlow;




/* DEV Remote shell /dev/rfs */
#define OSAL_C_S32_IOCTRL_RSH_READ_STD_ERR              ((tS32)1)

/* param for OSAL_C_S32_IOCTRL_RSH_READ_STD_ERR
   this ioctl expands to a standard read request */
typedef struct
{
    tPS8 pBuffer;       /* pointer to buffer */
    tU32 u32Size;       /* size of buffer */
    tU32 *ret_size;     /* return: read bytes */
} OSAL_trReadStderr;
 



/*DEV BT IOCTRLS*/
#define OSAL_C_S32_IOCTRL_BT_SET_RSBREAK                ((tS32)21)
#define OSAL_C_S32_IOCTRL_BT_SET_RSSNDTMO               ((tS32)22)
#define OSAL_C_S32_IOCTRL_BT_SET_RSRCVTMO               ((tS32)23)
#define OSAL_C_S32_IOCTRL_BT_CPU_RESET_BT               ((tS32)24)

#define OSAL_C_S32_IOCTRL_GYRO_RESET                    ((tS32)1)
#define OSAL_C_S32_IOCTRL_GYRO_INIT                     ((tS32)2)
#define OSAL_C_S32_IOCTRL_GYRO_FLUSH                    ((tS32)3)
#define OSAL_C_S32_IOCTRL_GYRO_GETCNT                   ((tS32)4)
#define OSAL_C_S32_IOCTRL_GYRO_SET_TIMEOUT_VALUE        ((tS32)5)
#define OSAL_C_S32_IOCTRL_GYRO_GET_TIMEOUT_VALUE        ((tS32)6)
#define OSAL_C_S32_IOCTRL_GYRO_GETDIAGMODE              ((tS32)7)
#define OSAL_C_S32_IOCTRL_GYRO_SETDIAGMODE              ((tS32)8)
#define OSAL_C_S32_IOCTRL_GYRO_START                    ((tS32)9)
#define OSAL_C_S32_IOCTRL_GYRO_STOP                     ((tS32)10)
#define OSAL_C_S32_IOCTRL_GYRO_GET_TYPE                 ((tS32)11)
#define OSAL_C_S32_IOCTRL_GYRO_GETRESOLUTION            ((tS32)12)
#define OSAL_C_S32_IOCTRL_GYRO_GETCYCLETIME             ((tS32)13)
#define OSAL_C_S32_IOCTRL_GYRO_GET_DIAG_RAW_DATA        ((tS32)14)
#define OSAL_C_S32_IOCTRL_GYRO_GET_3D_DIAG_RAW_DATA     ((tS32)15)
#define OSAL_C_S32_IOCTRL_GYRO_GET_TEMP                 ((tS32)16)
#define OSAL_C_S32_IOCTRL_GYRO_GET_HW_INFO              ((tS32)17)
#define OSAL_C_S32_IOCTRL_GYRO_SELF_TEST                ((tS32)18)



#define OSAL_C_S32_IOCTRL_ODOMETER_RESET                ((tS32)1)
#define OSAL_C_S32_IOCTRL_ODOMETER_INIT                 ((tS32)2)
#define OSAL_C_S32_IOCTRL_ODOMETER_FLUSH                ((tS32)3)
#define OSAL_C_S32_IOCTRL_ODOMETER_GETCNT               ((tS32)4)
#define OSAL_C_S32_IOCTRL_ODOMETER_GETDIRECTION         ((tS32)5)
#define OSAL_C_S32_IOCTRL_ODOMETER_SETDIRECTION         ((tS32)6)
//#MaF70.001.sn Ford
#define OSAL_C_S32_IOCTRL_ODOMETER_GET_WHEELCOUNTER     ((tS32)7)
//#MaF70.001.en
//#MaF76.sn
#define OSAL_C_S32_IOCTRL_ODOMETER_SET_TIMEOUT_VALUE    ((tS32)8)
#define OSAL_C_S32_IOCTRL_ODOMETER_GET_TIMEOUT_VALUE    ((tS32)9)
#define OSAL_C_S32_IOCTRL_ODOMETER_INIT_OVC             ((tS32)10)
//#MaF76.en
//#MaF82.sn
#define  OSAL_C_S32_IOCTRL_ODOMETER_INACTIVATE_OIC      ((tS32)11) 
#define  OSAL_C_S32_IOCTRL_ODOMETER_ACTIVATE_OIC        ((tS32)12) 
//#MaF82.en
#define OSAL_C_S32_IOCTRL_ODOMETER_GETRESOLUTION         ((tS32)13)
#define OSAL_C_S32_IOCTRL_ODOMETER_GETCYCLETIME          ((tS32)14)

#define OSAL_C_S32_IOCTRL_ODOMETER_PULSES_PER_REVOLUTION ((tS32)15)
#define OSAL_C_S32_IOCTRL_ODOMETER_WHEEL_CIRCUMFERENCE   ((tS32)16)

#define OSAL_C_S32_IOCTRL_ODOMETER_SET_K_VALUE           ((tS32)17)
#define OSAL_C_S32_IOCTRL_ODOMETER_REREAD_KDS_PPR        ((tS32)18)

//#MaV01A.sn
// time from first movement/change of odometer-counter, see trOvcInitValue.u8DrivingTime
#define OVC_C_ODOMINIT_STATUS_NOMOVEMENT                 (0x00)
#define OVC_C_ODOMINIT_STATUS_DRTIME_GREATERTHAN249      (0xFA)
#define OVC_C_ODOMINIT_STATUS_MOVEMENTFROMSTARTUP        (0xFB)
#define OVC_C_ODOMINIT_RESERVED                          (0xFC)
#define OVC_C_ODOMINIT_STATUS_DISCONNECTED_NOIGNITION    (0xFD)
#define OVC_C_ODOMINIT_STATUS_DISCONNECTED_IGNITION      (0xFE)
#define OVC_C_ODOMINIT_STATUS_DISCONNECTED_UNKNOWN       (0xFF)

#define OVC_C_ODOMUPDATE_STATUS_CONNECTED                (0x00)
#define OVC_C_ODOMUPDATE_STATUS_UNSTEADY                 (0x80)
#define OVC_C_ODOMUPDATE_STATUS_DISCONNECTED_NOIGNITION  (0xFD)
#define OVC_C_ODOMUPDATE_STATUS_DISCONNECTED_IGNITION    (0xFE)
#define OVC_C_ODOMUPDATE_STATUS_DISCONNECTED_UNKNOWN     (0xFF)

//defines for mapping of MCM odometer status
#define OVC_ODOMSTATE_CONNECTED                          (0x00)   //->possible in incoming update msg
#define OVC_ODOMSTATE_UNSTEADY                           (0x01)   //->possible in incoming update msg
#define OVC_ODOMSTATE_INIT_NOMOVEMENT                    (0x02)   //->possible in incoming init msg
#define OVC_ODOMSTATE_INIT_MOVEMENT_FROM_STARTUP         (0x03)   //->possible in incoming init msg
#define OVC_ODOMSTATE_DISCONNECTED_NOIGNITION            (0x06)   //->possible in incoming init msg
#define OVC_ODOMSTATE_DISCONNECTED_IGNITION              (0x07)   //->possible in incoming init and update msg
#define OVC_ODOMSTATE_DISCONNECTED_UNKNOWN               (0x08)   //->possible in incoming init and update msg
#define OVC_ODOMSTATE_UNKNOWN                            (0x0F)

#define OVC_ODOMSTATE_STATUS_MASK                        (0x0F)
#define OVC_ODOMSTATE_RESET_BIT_MASK                     (0x10)
#define OVC_ODOMSTATE_VIRTUAL_DATA_BIT_MASK              (0x20)

#define OVC_DRIVING_TIME_UNIT                            (50)  //in ms
#define OVC_SENDPERIOD_TIME_UNIT                         (5)  //means 5ms
//#MaV01A.en

/* Dev ACC IO Controls */
#define OSAL_C_S32_IOCTRL_ACC_FLUSH                    ((tS32)1)
#define OSAL_C_S32_IOCTRL_ACC_GETCNT                   ((tS32)2)
#define OSAL_C_S32_IOCTRL_ACC_SET_TIMEOUT_VALUE        ((tS32)3)
#define OSAL_C_S32_IOCTRL_ACC_GET_TIMEOUT_VALUE        ((tS32)4)
#define OSAL_C_S32_IOCTRL_ACC_START                    ((tS32)5)
#define OSAL_C_S32_IOCTRL_ACC_STOP                     ((tS32)6)
#define OSAL_C_S32_IOCTRL_ACC_GET_DIAG_RAW_DATA        ((tS32)7)
#define OSAL_C_S32_IOCTRL_ACC_GET_TEMP				    ((tS32)8)
#define OSAL_C_S32_IOCTRL_ACC_GET_HW_INFO                        ((tS32)9)
#define OSAL_C_S32_IOCTRL_ACC_SELF_TEST                ((tS32)10)
#define OSAL_C_S32_IOCTRL_ACC_GETCYCLETIME                ((tS32)11)

/* Dev ADR3CTRL IO Controls */
#define OSAL_C_S32_IOCTRL_ADR3CTRL_REGISTER_RESET_CALLBACK      ((tS32)1)
#define OSAL_C_S32_IOCTRL_ADR3CTRL_RESET_ADR3                   ((tS32)2)
#define OSAL_C_S32_IOCTRL_ADR3CTRL_SET_BOOTMODE_SPI             ((tS32)3)
#define OSAL_C_S32_IOCTRL_ADR3CTRL_WRITE_DOWNLOAD_DATA           ((tS32)4)
#define OSAL_C_S32_IOCTRL_ADR3CTRL_READ_DOWNLOAD_STATUS          ((tS32)5)
#define OSAL_C_S32_IOCTRL_ADR3CTRL_SET_BLOCKINGMODE_READ_TIMEOUT ((tS32)6)
#define OSAL_C_S32_IOCTRL_ADR3CTRL_READ_CLEAR_RESET_COUNT        ((tS32)7)
#define OSAL_C_S32_IOCTRL_ADR3CTRL_SET_BOOTMODE_NORMAL           ((tS32)8)
#define OSAL_C_S32_IOCTRL_ADR3CTRL_INC_ADR3_DOWN                 ((tS32)9)

#define OSAL_C_S32_IOCTRL_SPEECH_STOP                   ((tS32)1)
#define OSAL_C_S32_IOCTRL_SPEECH_STATUS                 ((tS32)2)
#define OSAL_C_S32_IOCTRL_SPEECH_SET_MEMORY_START       ((tS32)3)
#define OSAL_C_S32_IOCTRL_SPEECH_GET_MEMORY_CONFIG      ((tS32)4)

#define OSAL_C_S32_IOCTRL_DVDCTRL_CLOSE                 ((tS32)1)
#define OSAL_C_S32_IOCTRL_DVDCTRL_OPEN                  ((tS32)2)

#define OSAL_C_S32_IOCTRL_AUXILIARY_CLOCK_GETRESOLUTION ((tS32)1)
#define OSAL_C_S32_IOCTRL_AUXILIARY_CLOCK_GETCYCLETIME  ((tS32)2)
#define OSAL_C_S32_IOCTRL_AUXILIARY_CLOCK_CONVERTTICKSTOPOSIX  ((tS32)3)

#define OSAL_C_S32_IOCTRL_REGQUERYVALUE                 ((tS32)1)
#define OSAL_C_S32_IOCTRL_REGENUMVALUE                  ((tS32)2)
#define OSAL_C_S32_IOCTRL_REGSETVALUE                   ((tS32)3)
/* @@@@ 26.08.2002 Ka: Added for Nucleus OSAL IO */
#define OSAL_C_S32_IOCTRL_REGGETVALUE                   ((tS32)4)
#define OSAL_C_S32_IOCTRL_REGREADDIR                    ((tS32)5)
#define OSAL_C_S32_IOCTRL_REGREMOVEVALUE                ((tS32)6)

#define OSAL_C_S32_IOCTRL_REGREADVALUE                  ((tS32)7)
#define OSAL_C_S32_IOCTRL_REGWRITEVALUE                 ((tS32)8)
#define OSAL_C_S32_IOCTRL_REGDELETEVALUE                 ((tS32)9)
#define OSAL_C_S32_IOCTRL_REGLOOKUPAPPPATH              ((tS32)10)
#define OSAL_C_S32_IOCTRL_REGLOOKUPSRVPATH              ((tS32)11)
#define OSAL_C_S32_IOCTRL_BUILD_REG                     ((tS32)12)
#define OSAL_C_S32_IOCTRL_BUILD_ERG                     ((tS32)13)
#define OSAL_C_S32_IOCTRL_REGISTRYLOCK                  ((tS32)14)
#define OSAL_C_S32_IOCTRL_REGISTRYUNLOCK                ((tS32)15)
#define OSAL_C_S32_IOCTRL_GET_ERGVAL                    ((tS32)16)

/* IO control for all file system devices */
#define OSAL_C_S32_IOCTRL_DISK_ABORT     ((tS32)-1)
#define OSAL_C_S32_IOCTRL_FIOCHKDSK      ((tS32)-2)

/* IO control specific RAMDISK */
#define OSAL_C_S32_IOCTRL_RAMDISK_CREATE ((tS32)1)
#define OSAL_C_S32_IOCTRL_RAMDISK_DELETE ((tS32)2)
#define OSAL_C_S32_IOCTRL_RAMDISK_RELOAD ((tS32)3)
#define OSAL_C_S32_IOCTRL_FFS_SAVENOW    ((tS32)4)
#define OSAL_C_S32_IOCTRL_FFS_RELOAD     ((tS32)5)
#define OSAL_C_S32_IOCTRL_FFS_BACKUP     ((tS32)6)

/* IO control specific MMC Card */
#define OSAL_C_S32_IOCTRL_CARD_CREATE                ((tS32)7)	  /* Formats the card */
#define OSAL_C_S32_IOCTRL_CARD_DELETE                ((tS32)8)	  /* kbj1kor - This is not supported */
#define OSAL_C_S32_IOCTRL_CARD_STATE                 ((tS32)10)   /* Returns the actual state of card */
#define OSAL_C_S32_IOCTRL_CARD_CHKDSK_NOTIFY         ((tS32)11)   /* Indicates the progress of check disk */
#define OSAL_C_S32_IOCTRL_CARD_CHKDSK_UNREG          ((tS32)12)   /* Un-registers the CHKDSK callback */
#define OSAL_C_S32_IOCTRL_CARD_MOUNT                 ((tS32)13)	  /* Mounts/Unmounts the card */
#define OSAL_C_S32_IOCTRL_CARD_GETMEDIAINFO          ((tS32)14)	  /* Reads information about the inserted card */
#define OSAL_C_S32_IOCTRL_CARD_ABORT_CHKDISK         ((tS32)15)	  /* Aborts an ongoing checkdisk */
#define OSAL_C_S32_IOCTRL_CARD_FORMAT_NOTIFY         ((tS32)16)	  /*Registers the callback function for format*/
#define OSAL_C_S32_IOCTRL_CARD_FORMAT_UNREG          ((tS32)17)	  /*Unregisters the callback function for format*/
#define OSAL_C_S32_IOCTRL_CARD_GET_MOUNT_ERROR       ((tS32)18)	  /*to get error that occured during mount*/
#define OSAL_C_S32_IOCTRL_CARD_GET_DIR_PATH          ((tS32)19)	  /*to get dir path */
#define OSAL_C_S32_IOCTRL_TRIGGER_SIGN_VERIFY        ((tS32)20)	  /* Triggers Signature verification operation */
#define OSAL_C_S32_IOCTRL_CRYPT_VERIFY_STATUS        ((tS32)21)	  /* Returns the status of the signature verification operation - 3 options */
#define OSAL_C_S32_IOCTRL_GET_SIGNATURE_TYPE         ((tS32)22)	  /* Returns the type of signature used in verification - 3 options */
#define OSAL_C_S32_IOCTRL_FAT_FORMAT                 ((tS32)79)	  /*to get dir path */
#define OSAL_C_S32_VALUE_STRING                         ((tS32)0)
#define OSAL_C_S32_VALUE_S32                            ((tS32)1)

/* IO control for SD card refresh */
#define OSAL_C_S32_IOCTRL_SDCARD_REFRESH_STATUS         ((tS32)600)	  /* indicates if SD card refresh is needed -3 options */
#define OSAL_C_S32_IOCTRL_SDCARD_START_REFRESH          ((tS32)601)	  /* starts the SD card refresh process */
#define OSAL_C_S32_IOCTRL_SDCARD_STOP_REFRESH           ((tS32)602)	  /* stops the SD card refresh process */
#define OSAL_C_S32_IOCTRL_SDCARD_ABORT_REFRESH          ((tS32)603)	  /* aborts the SD card refresh process */
#define OSAL_C_S32_IOCTRL_SDCARD_FORCED_REFRESH         ((tS32)604)	  /* starts the SD card refresh process with increased block access and blocking*/
#define OSAL_C_S32_IOCTRL_SDCARD_REGISTER_CALLBACK      ((tS32)605)   /* registers the callback function on SD Card refresh complete */

/*   Added the following Commands for CDCTRL and PRM*/
/* NOTE: make sure to set min value correct if a new entry is added */
#define OSAL_C_S32_IOCTRL_GET_EXCLUSIVE_ACCESS          (OSAL_C_S32_MAX-1)
#define OSAL_C_S32_IOCTRL_PRM_MAX_VALUE                  OSAL_C_S32_IOCTRL_GET_EXCLUSIVE_ACCESS
#define OSAL_C_S32_IOCTRL_REL_EXCLUSIVE_ACCESS          (OSAL_C_S32_MAX-2)
#define OSAL_C_S32_IOCTRL_REG_NOTIFICATION              (OSAL_C_S32_MAX-3)
#define OSAL_C_S32_IOCTRL_UNREG_NOTIFICATION            (OSAL_C_S32_MAX-4)
#define OSAL_C_S32_IOCTRL_EX_OPEN_FILE                  (OSAL_C_S32_MAX-5)
#define OSAL_C_S32_IOCTRL_PRM_GETMEDIAINFO              (OSAL_C_S32_MAX-6)
#define OSAL_C_S32_IOCTRL_PRM_GETDEVICEINFO             (OSAL_C_S32_MAX-7)
#define OSAL_C_S32_IOCTRL_PRM_GETDISKTYPE               (OSAL_C_S32_MAX-8)
#define OSAL_C_S32_IOCTRL_PRM_EJECTLOCK                 (OSAL_C_S32_MAX-9)
#define OSAL_C_S32_IOCTRL_PRM_GET_NAVIROOT              (OSAL_C_S32_MAX-10)
#define OSAL_C_S32_IOCTRL_PRM_SET_NAVIROOT              (OSAL_C_S32_MAX-11)
#define OSAL_C_S32_IOCTRL_PRM_REG_NOTIFICATION_EXT2     (OSAL_C_S32_MAX-12)
#define OSAL_C_S32_IOCTRL_PRM_UNREG_NOTIFICATION_EXT2   (OSAL_C_S32_MAX-13)
#define OSAL_C_S32_IOCTRL_PRM_REG_SYSTEM_INFO           (OSAL_C_S32_MAX-14)
#define OSAL_C_S32_IOCTRL_PRM_UNREG_SYSTEM_INFO         (OSAL_C_S32_MAX-15)
#define OSAL_C_S32_IOCTRL_PRM_REG_SYSTEM_STAT_INFO      (OSAL_C_S32_MAX-16)
#define OSAL_C_S32_IOCTRL_PRM_UNREG_SYSTEM_STAT_INFO    (OSAL_C_S32_MAX-17)
#define OSAL_C_S32_IOCTRL_PRM_ACTIVATE_SIGNAL           (OSAL_C_S32_MAX-18)
#define OSAL_C_S32_IOCTRL_PRM_USBPOWER_GET_PORTCOUNT    (OSAL_C_S32_MAX-19)
#define OSAL_C_S32_IOCTRL_PRM_USBPOWER_GET_PORTSTATE    (OSAL_C_S32_MAX-20)
#define OSAL_C_S32_IOCTRL_PRM_USBPOWER_SET_PORTPOWER    (OSAL_C_S32_MAX-21)
#define OSAL_C_S32_IOCTRL_PRM_REMOUNT                   (OSAL_C_S32_MAX-22)
#define OSAL_C_S32_IOCTRL_PRM_TRIGGER_ERRMEM_TTFIS      (OSAL_C_S32_MAX-23)
#define OSAL_C_S32_IOCTRL_PRM_TRIGGER_DEL_ERRMEM        (OSAL_C_S32_MAX-24)
#define OSAL_C_S32_IOCTRL_PRM_PARTITION_INFO            (OSAL_C_S32_MAX-25)
#define OSAL_C_S32_IOCTRL_PRM_SYSTEM_CALL               (OSAL_C_S32_MAX-26)
#define OSAL_C_S32_IOCTRL_PRM_RESET_ADR3                (OSAL_C_S32_MAX-27)
#define OSAL_C_S32_IOCTRL_PRM_MOUNT_ISO_IMAGE           (OSAL_C_S32_MAX-28)
#define OSAL_C_S32_IOCTRL_PRM_FORMAT_DEVICE             (OSAL_C_S32_MAX-29)
#define OSAL_C_S32_IOCTRL_PRM_UNMOUNT_DEVICE            (OSAL_C_S32_MAX-30)
#define OSAL_C_S32_IOCTRL_PRM_MIN_VALUE                 OSAL_C_S32_IOCTRL_PRM_UNMOUNT_DEVICE


enum {
   WRITE_ERRMEM_START,
   WRITE_ERRMEM_SUCCESS,
   ERASE_ERRMEM_START,
   WRITE_ERRMEM_FAILED,
   ERROR_MOUNT_FAILED
};


#define OSAL_C_S32_IOCTRL_CDCTRL_CLOSEDOOR             ((tS32)1)
#define OSAL_C_S32_IOCTRL_CDCTRL_EJECTMEDIA            ((tS32)2)
#define OSAL_C_S32_IOCTRL_CDCTRL_GETTEMP               ((tS32)3)
#define OSAL_C_S32_IOCTRL_CDCTRL_GETLOADERINFO         ((tS32)4)
#define OSAL_C_S32_IOCTRL_CDCTRL_GETTRACKINFO          ((tS32)5)
#define OSAL_C_S32_IOCTRL_CDCTRL_SETMOTORON            ((tS32)6)
#define OSAL_C_S32_IOCTRL_CDCTRL_SETMOTOROFF           ((tS32)7)
#define OSAL_C_S32_IOCTRL_CDCTRL_READRAWDATA           ((tS32)8)
#define OSAL_C_S32_IOCTRL_CDCTRL_READERRORBUFFER       ((tS32)9)
#define OSAL_C_S32_IOCTRL_CDCTRL_GETCDINFO             ((tS32)10)
#define OSAL_C_S32_IOCTRL_CDCTRL_READRAWDATA_MSF       ((tS32)11)
#define OSAL_C_S32_IOCTRL_CDCTRL_GET_DRIVE_VERSION     ((tS32)12)
#define OSAL_C_S32_IOCTRL_CDCTRL_SETPOWEROFF           ((tS32)13)
#define OSAL_C_S32_IOCTRL_CDCTRL_GETDVDINFO            ((tS32)14)
#define OSAL_C_S32_IOCTRL_CDCTRL_READRAWDATAUNCACHED   ((tS32)15)
#define OSAL_C_S32_IOCTRL_CDCTRL_GETMEDIAINFO          ((tS32)OSAL_C_S32_IOCTRL_PRM_GETMEDIAINFO)
#define OSAL_C_S32_IOCTRL_CDCTRL_GETDEVICEINFO         ((tS32)OSAL_C_S32_IOCTRL_PRM_GETDEVICEINFO)
#define OSAL_C_S32_IOCTRL_CDCTRL_GETDISKTYPE           ((tS32)OSAL_C_S32_IOCTRL_PRM_GETDISKTYPE)
#define OSAL_C_S32_IOCTRL_CDCTRL_EJECTLOCK             ((tS32)OSAL_C_S32_IOCTRL_PRM_EJECTLOCK)
#define OSAL_C_S32_IOCTRL_CDCTRL_GETDRIVEVERSION       ((tS32)16)
#define OSAL_C_S32_IOCTRL_CDCTRL_SETSTREAMMODE         ((tS32)17)
#define OSAL_C_S32_IOCTRL_CDCTRL_SETDRIVESPEED         ((tS32)18)
#define OSAL_C_S32_IOCTRL_CDCTRL_GET_DEVICE_VERSION    ((tS32)19) // OSAL_C_S32_IOCTRL_CDCTRL_GET_DRIVE_VERSION for struct OSAL_trCdDeviceVersion


/* parameter for OSAL_C_S32_IOCTRL_CDCTRL_SETDRIVESPEED */
#define OSAL_C_S32_IOCTRL_SETNORMALSPEED               ((tS32)0)
#define OSAL_C_S32_IOCTRL_SETHIGHSPEED                 ((tS32)1)
#define OSAL_C_S32_IOCTRL_SETLOWNOISESPEED             ((tS32)2)

/* parameter for ? */
#define OSAL_C_S16_CDCTRL_ERRORBUFFERSIZE              ((tS16)15)

#define OSAL_C_S32_IOCTRL_CDAUDIO_PLAY             ((tS32)0)
#define OSAL_C_S32_IOCTRL_CDAUDIO_STOP             ((tS32)1)
#define OSAL_C_S32_IOCTRL_CDAUDIO_PAUSE            ((tS32)2)
#define OSAL_C_S32_IOCTRL_CDAUDIO_SETMFS           ((tS32)3)
/* SETMSF is the correctly spelled version of SETMFS... */
#define OSAL_C_S32_IOCTRL_CDAUDIO_SETMSF              (OSAL_C_S32_IOCTRL_CDAUDIO_SETMFS)
#define OSAL_C_S32_IOCTRL_CDAUDIO_GETCDINFO           ((tS32)4)
#define OSAL_C_S32_IOCTRL_CDAUDIO_FASTFORWARD         ((tS32)5)
#define OSAL_C_S32_IOCTRL_CDAUDIO_FASTBACKWARD        ((tS32)6)
#define OSAL_C_S32_IOCTRL_CDAUDIO_GETPLAYINFO         ((tS32)7)
#define OSAL_C_S32_IOCTRL_CDAUDIO_GETTRACKINFO        ((tS32)8)
#define OSAL_C_S32_IOCTRL_CDAUDIO_GETALBUMNAME        ((tS32)9)
#define OSAL_C_S32_IOCTRL_CDAUDIO_GETTRACKCDINFO      ((tS32)10)
#define OSAL_C_S32_IOCTRL_CDAUDIO_RESUME              ((tS32)11)
#define OSAL_C_S32_IOCTRL_CDAUDIO_REGPLAYNOTIFY       ((tS32)12)
#define OSAL_C_S32_IOCTRL_CDAUDIO_UNREGPLAYNOTIFY     ((tS32)13)
#define OSAL_C_S32_IOCTRL_CDAUDIO_SETPLAYRANGE        ((tS32)14)
#define OSAL_C_S32_IOCTRL_CDAUDIO_GETADDITIONALCDINFO ((tS32)15)  /*parameter: OSAL_trAdditionalCDInfo*/

#define OSAL_C_S32_IOCTRL_AUDIOIN_GET_SAMPLERATE	((tS32)1)
#define OSAL_C_S32_IOCTRL_AUDIOIN_SET_SAMPLERATE	((tS32)2)
#define OSAL_C_S32_IOCTRL_AUDIOIN_GET_NUM_CHANNELS	((tS32)3)
#define OSAL_C_S32_IOCTRL_AUDIOIN_SET_NUM_CHANNELS	((tS32)4)
#define OSAL_C_S32_IOCTRL_AUDIOIN_GET_MODE			((tS32)5)
#define OSAL_C_S32_IOCTRL_AUDIOIN_SET_MODE			((tS32)6)
#define OSAL_C_S32_IOCTRL_AUDIOIN_SET_NOTIFY		((tS32)7)
#define OSAL_C_S32_IOCTRL_AUDIOIN_GET_SOURCE		((tS32)8)
#define OSAL_C_S32_IOCTRL_AUDIOIN_SET_SOURCE		((tS32)9)
#define OSAL_C_S32_IOCTRL_AUDIOIN_GET_POSITION     ((tS32)10)

#define OSAL_C_S32_IOCTRL_AUDIOOUT_SETSAMPLERATE    ((tS32)1)
#define OSAL_C_S32_IOCTRL_AUDIOOUT_FLUSH            ((tS32)2)
#define OSAL_C_S32_IOCTRL_AUDIOOUT_SETVOLUME        ((tS32)3)
#define OSAL_C_S32_IOCTRL_AUDIOOUT_STEREO_MODE      ((tS32)4)
#define OSAL_C_S32_IOCTRL_AUDIOOUT_LAST_DATA        ((tS32)5)
#define OSAL_C_S32_IOCTRL_AUDIOOUT_GET_POSITION     ((tS32)6)
#define OSAL_C_S32_IOCTRL_AUDIOOUT_GET_BUFFER_INFO  ((tS32)7)
#define OSAL_C_S32_IOCTRL_AUDIOOUT_SETVOLUME_STEREO ((tS32)8)

#define OSAL_C_S32_IOCTRL_SPEECH_STOP              ((tS32)1)
#define OSAL_C_S32_IOCTRL_SPEECH_STATUS            ((tS32)2)
#define OSAL_C_S32_IOCTRL_SPEECH_SET_MEMORY_START  ((tS32)3)
#define OSAL_C_S32_IOCTRL_SPEECH_SET_MEMORY_CONFIG ((tS32)4)

/* Speechdata */
#define OSAL_C_S32_IOCTRL_SPEECHDATA_STORAGE_INFO        ((tS32)1)
#define OSAL_C_S32_IOCTRL_SPEECHDATA_SET_STORED_PACKAGES ((tS32)2)
#define OSAL_C_S32_IOCTRL_SPEECHDATA_GET_DATA_POINTER    ((tS32)3)

/* dev_sysctrl */
#define OSAL_C_S32_IOCTRL_SYSCTRL_VERSION                 ((tS32) 1)
#define OSAL_C_S32_IOCTRL_SYSCTRL_REG_NOTIFICATION        ((tS32) 2)
#define OSAL_C_S32_IOCTRL_SYSCTRL_SET_BRIGHTNESS          ((tS32) 3)
#define OSAL_C_S32_IOCTRL_SYSCTRL_GET_BRIGHTNESS          ((tS32) 4)
#define OSAL_C_S32_IOCTRL_SYSCTRL_SET_BACKLIGHT           ((tS32) 5)
#define OSAL_C_S32_IOCTRL_SYSCTRL_SET_VOLUME              ((tS32) 6)
#define OSAL_C_S32_IOCTRL_SYSCTRL_GET_VOLUME              ((tS32) 7)
#define OSAL_C_S32_IOCTRL_SYSCTRL_SET_AUDIOMUTE           ((tS32) 8)
#define OSAL_C_S32_IOCTRL_SYSCTRL_GET_BATTERY_LEVEL       ((tS32) 9)
#define OSAL_C_S32_IOCTRL_SYSCTRL_SET_VOICEGUIDANCE_START ((tS32)10)
#define OSAL_C_S32_IOCTRL_SYSCTRL_SET_VOICEGUIDANCE_STOP  ((tS32)11)
#define OSAL_C_S32_IOCTRL_SYSCTRL_SET_NAVIROOT            ((tS32)12)
#define OSAL_C_S32_IOCTRL_SYSCTRL_GET_NAVIROOT            ((tS32)13)
#define OSAL_C_S32_IOCTRL_SYSCTRL_GET_LANGUAGE            ((tS32)14)
#define OSAL_C_S32_IOCTRL_SYSCTRL_GET_CLOCKINFORMATION    ((tS32)15)
#define OSAL_C_S32_IOCTRL_SYSCTRL_GET_DEVICENAME          ((tS32)16)
#define OSAL_C_S32_IOCTRL_SYSCTRL_SET_DEVICENAME          ((tS32)17)
#define OSAL_C_S32_IOCTRL_SYSCTRL_IS_DAYMODE              ((tS32)18)
#define OSAL_C_S32_IOCTRL_SYSCTRL_GET_SDCARD_ID           ((tS32)19)
#define OSAL_C_S32_IOCTRL_SYSCTRL_GET_NAND_ID             ((tS32)20)

#define OSAL_C_S32_IOCTRL_SYSCTRL_AUDIO_REQUEST_CHANNEL     ((tS32)21)
#define OSAL_C_S32_IOCTRL_SYSCTRL_AUDIO_QUIT_CHANNEL        ((tS32)22)
#define OSAL_C_S32_IOCTRL_SYSCTRL_AUDIO_STREAMING_BEGIN     ((tS32)23)
#define OSAL_C_S32_IOCTRL_SYSCTRL_AUDIO_STREAMING_END       ((tS32)24)
#define OSAL_C_S32_IOCTRL_SYSCTRL_AUDIO_SET_ACK             ((tS32)25)

#define OSAL_C_S32_IOCTRL_SYSCTRL_ACQUIRE_MICROPHONE      ((tS32)26)
#define OSAL_C_S32_IOCTRL_SYSCTRL_DYNLIB_LOAD             ((tS32)27)
#define OSAL_C_S32_IOCTRL_SYSCTRL_DYNLIB_UNLOAD           ((tS32)28)
#define OSAL_C_S32_IOCTRL_SYSCTRL_DYNLIB_RESOLVE_SYMBOL   ((tS32)29)

#define OSAL_C_S32_IOCTRL_SYSCTRL_PULSE_INIT                ((tS32)30)
#define OSAL_C_S32_IOCTRL_SYSCTRL_PULSE_DEINIT              ((tS32)31)
#define OSAL_C_S32_IOCTRL_SYSCTRL_PULSE_GETFREQUENCY        ((tS32)32)

#define OSAL_C_S32_IOCTRL_SYSCTRL_BTHF_DIAL              ((tS32)33)
#define OSAL_C_S32_IOCTRL_SYSCTRL_BTHF_DIALPAD           ((tS32)34)
#define OSAL_C_S32_IOCTRL_SYSCTRL_BTHF_IS_CONNECTED      ((tS32)35)

/* dev_tmc */
#define OSAL_C_S32_IOCTRL_TMC_VERSION                 ((tS32) 1)
#define OSAL_C_S32_IOCTRL_TMC_REG_NOTIFICATION        ((tS32) 2)
#define OSAL_C_S32_IOCTRL_TMC_SET_FREQUENCY           ((tS32) 3)
#define OSAL_C_S32_IOCTRL_TMC_GET_FREQUENCY           ((tS32) 4)
#define OSAL_C_S32_IOCTRL_TMC_SET_PI                  ((tS32) 5)
#define OSAL_C_S32_IOCTRL_TMC_GET_PI                  ((tS32) 6)
#define OSAL_C_S32_IOCTRL_TMC_SEARCH                  ((tS32) 7)
#define OSAL_C_S32_IOCTRL_TMC_GET_MAXBUFFERSIZE       ((tS32) 8)
#define OSAL_C_S32_IOCTRL_TMC_SET_READTIMEOUT         ((tS32) 9)
#define OSAL_C_S32_IOCTRL_TMC_GET_STATE               ((tS32)10)
#define OSAL_C_S32_IOCTRL_TMC_SEARCH_PILIST           ((tS32)11)

/* dev_tsd */
#define OSAL_C_S32_IOCTRL_TSD_VERSION                 ((tS32) 1)
#define OSAL_C_S32_IOCTRL_TSD_REG_NOTIFICATION        ((tS32) 2)
#define OSAL_C_S32_IOCTRL_TSD_SET_COUNTRYCODE         ((tS32) 3)
#define OSAL_C_S32_IOCTRL_TSD_SET_HORIZONROW          ((tS32) 4)
#define OSAL_C_S32_IOCTRL_TSD_PAUSE                   ((tS32) 5)
#define OSAL_C_S32_IOCTRL_TSD_RESUME                  ((tS32) 6)
#define OSAL_C_S32_IOCTRL_TSD_DUMP_IMAGE              ((tS32) 7)

/* dev_vnv */
#define OSAL_C_S32_IOCTRL_VNV_VERSION                 ((tS32) 1)
#define OSAL_C_S32_IOCTRL_VNV_REG_NOTIFICATION        ((tS32) 2)

/* dev_map (/dev/map_high, /dev/map_carsor) */
#define OSAL_C_S32_IOCTRL_MAP_GETRXTIMEOUT            ((tS32) 1)
#define OSAL_C_S32_IOCTRL_MAP_GETTXTIMEOUT            ((tS32) 2)
#define OSAL_C_S32_IOCTRL_MAP_SETRXTIMEOUT            ((tS32) 3)
#define OSAL_C_S32_IOCTRL_MAP_SETTXTIMEOUT            ((tS32) 4)
#define OSAL_C_S32_IOCTRL_MAP_SETBLOCKINGSTATE        ((tS32) 5)
#define OSAL_C_S32_IOCTRL_MAP_GETBLOCKINGSTATE        ((tS32) 6)



//BEGIN------------OSAL-device DRV_IPN--------------------------------
/*dev_rp_if - radio processor interface plus FGS-access */
/*c.k. 21.01.05 see:
   \\HI230124\projects\Paramount\90.Dokumentation\0400.Software\ARM\OSAL-Driver\dev_rp_if
 */ //tbd.c.k. : cleanup during maintainance!
#if 0 
#define OSAL_C_S32_IOCTRL_RP_IF_IPN_CHANNELREQUEST ((tS32)1)
#define OSAL_C_S32_IOCTRL_RP_IF_IPN_CHANNELCLOSE ((tS32)2)
#define OSAL_C_S32_IOCTRL_RP_IF_IPN_INIT ((tS32)3)
#define OSAL_C_S32_IOCTRL_RP_IF_IPN_MONIINIT ((tS32)4)
//to ease programming it's also possible to use the following flags to use
//these like also defined OSAL_IORead and OSAL_IOWrite	
#define OSAL_C_S32_IOCTRL_RP_IF_IPN_WRITEDATA  ((tS32)5) //for ipn_iDataSend or ipn_fInsertRxMessageFromMonitor:
#define OSAL_C_S32_IOCTRL_RP_IF_IPN_READDATA   ((tS32)6) //for ipn_iDataGet(…) or ipn_iMoniDataGet(…):

#define OSAL_C_S32_IOCTRL_FGS_TEST_CONNECTION_ALIVE ((tS32)7)
#endif
//tbd.: check if this could be just added to drv_ipn.h

//---FGS----
#define OSAL_C_S32_IOCTRL_DRVIPN_FGS_TEST_CONNECTION_ALIVE ((tS32)2)  /*Note: No1 is used to use register of callback*/
#define OSAL_C_S32_IOCTRL_FGS_TEST_CONNECTION_ALIVE OSAL_C_S32_IOCTRL_DRVIPN_FGS_TEST_CONNECTION_ALIVE

//---General---
//Note:  Other supported modes are: Callback Function and Blocking Mode
#define OSAL_C_S32_IOCTRL_DRVIPN_MODE_CALLBACKEVENT_GET_EVENTMASKANDHANDLE ((tS32)3)
#define OSAL_C_S32_IOCTRL_DRVIPN_MODE_CALLBACKMODE_CALLBACK_REG            OSAL_C_S32_IOCTRL_CALLBACK_REG   //is ((tS32)1) see above
#define OSAL_C_S32_IOCTRL_DRVIPN_MODE_BLOCKING                             ((tS32)4)
#define OSAL_C_S32_IOCTRL_DRVIPN_GET_PAYLOADWRITEBUFFER                    ((tS32)5)
#define OSAL_C_S32_IOCTRL_DRVIPN_GET_PAYLOADWRITEBUFFER_MAXSIZE            ((tS32)6)
#define OSAL_C_S32_IOCTRL_DRVIPN_GET_PAYLOADREADBUFFER_MAXSIZE             ((tS32)7)
#define OSAL_C_S32_IOCTRL_DRVIPN_GET_PAYLOADWRITEBUFFER_INDEX              ((tS32)8)
#define OSAL_C_S32_IOCTRL_DRVIPN_GET_READBUFFER_HEADERSIZE                 ((tS32)9)
#define OSAL_C_S32_IOCTRL_DRVIPN_GET_WRITEBUFFER_HEADERSIZE                ((tS32)10)
#define OSAL_C_S32_IOCTRL_DRVIPN_SET_BLOCKINGMODE_WRITE_TIMEOUT            ((tS32)11)
#define OSAL_C_S32_IOCTRL_DRVIPN_SET_BLOCKINGMODE_READ_TIMEOUT             ((tS32)12)
#define OSAL_C_S32_IOCTRL_DRVIPN_SET_IOCONTROL_TEST_CONNECTION_ALIVE_TIMOUT ((tS32)13)
#define OSAL_C_S32_IOCTRL_RU_COM_START_AMFM_AUD_LIB                         ((tS32)14) //start embedded radiosoftware 
#define OSAL_C_S32_IOCTRL_DRVIPN_ADR3_RESET                                ((tS32)15)



//used for OSAL_C_S32_IOCTRL_DRVIPN_MODE_CALLBACKEVENT
typedef struct _OSAL_trDRVIPN_EventMode_EventHandleMask //c.k. 190905
{
  OSAL_tEventHandle handleEvent;
  OSAL_tEventMask   maskEvent;
} OSAL_trDRVIPN_EventMode_EventHandleMask;

//End--------------------------------------------------------------------

//BEGIN---------------OSAL-device DRV_CSM--------------------------------
#if (OSAL_OS==OSAL_NUCLEUS) || (OSAL_OS==OSAL_WINNT) || (OSAL_OS==OSAL_WINCE) || (OSAL_OS==OSAL_LINUX) || (OSAL_OS==OSAL_DARWIN)

typedef enum /*_OSAL_tenIOCtrlOSAL_NotifyMethod*/ // this enum is new part of OSAL (not fixed), here for reference 
{
   eOSAL_Notify_NoNotification,
   eOSAL_Notify_AbortWait, 
   eOSAL_Notify_ReturnOnEvent, 
   eOSAL_Notify_LocalCallback, 
   eOSAL_Notify_OSAL_MessageQueue, 
   eOSAL_Notify_OSAL_Event 
} OSAL_tenDRVCSM_NotifyMethod;

typedef enum  // this enum is new part of OSAL (not fixed), here for reference 
{   
   eOSAL_Notify_AbortOnEmptyQueue,
   eOSAL_Notify_AbortImmediately,
   eOSAL_Notify_AbortClearQueue
} OSAL_tenDRVCSM_RetrieveAbort;


//Note: c.k. adjusted after taking from spec
typedef enum /*_OSAL_tenIOCtrlCSM_NotifyError*/ // this enum is new part of OSAL (not fixed), here for reference 
{
   eNotify_DeviceClosed, 
   eNotify_TaskAborted, 
   eNotify_TaskRunning, 
   eNotify_MethodNotAvailable, 
   eNotify_TaskError
} OSAL_tenDRVCSM_NotifyError;


//Note: c.k. adjusted after taking from spec
typedef enum /*_OSAL_tenIOCtrlCSM_NotifyEvent */
{
   eCSM_NoEvent, 
   eCSM_Aborted,
   eCSM_Timeout,
   eCSM_ApplicationGeneralBus, // for initialisation of CSM_lApplCallbackInit( bBus 
   eCSM_ApplicationGeneral, // for initialisation of CSM_lApplCallbackInit 
   eCSM_ConnectState, 
   eCSM_CommunicationCon, 
   eCSM_CommunicationInd, 
   eCSM_DataCon, 
   eCSM_DataInd, 
   eCSM_SignalInd, 
   eCSM_BusErrorInd,
   eCSM_DataIndFF, 
   eCSM_DataErrorInd, 

   eCSM_MAX_COUNT
   // may be extended for additional events 88
} OSAL_tenDRVCSM_NotifyEvent;

typedef struct // this struct is new part of OSAL (not fixed), here for reference 
{ 
   OSAL_tenDRVCSM_NotifyMethod eNotifyMethod; // [Return, Message, Call, . . .] 
   tU32 u32_OSAL_NotificationHandle; // Handle for Event or MessageQueue 
   tU32 u32_OSAL_NotificationID; // EventBit or Data for MessageQueue 
} OSAL_trDRVCSM_NotificationTask;


typedef struct // this struct is new part of OSAL (not fixed), here for reference 
{ 
   OSAL_tenDRVCSM_NotifyEvent eNotifyEvent; 
   void* pv_OSAL_RegistrationParameter; // Application specific data 
} OSAL_trDRVCSM_RegisterNotification;


typedef void (*OSAL_tpvFnDRVCSM_BUS_ERROR_IND) ( void *, tU8, tU16);
typedef void (*OSAL_tpvFnDRVCSM_BUS_STATE_IND) ( tU8, tU8);     /* only internal CB function! */

typedef void (*OSAL_tpvFnDRVCSM_ErrorInd)( void *, tU32 Bus, tU32 Error); 

typedef struct //_OSAL_trIOCtrlCSM_ErrorNotifyInit// see CSM_lBusErrorIndCallback Init 
{ 
   tS32 s32CSM_Return; 
   /*vCSMErrorInd fErrorCallBack; // only valid for Method Call */
   OSAL_tpvFnDRVCSM_ErrorInd fErrorCallBack;
} OSAL_trDRVCSM_ErrorNotifyInit; // (to be clarify)



typedef struct //_OSAL_trIOCtrlCSM_CommunicationReq// see CSM_lCommunicationReq 93
{ 
   tS32 s32CSM_Return; 
   tU32 u32Action; 
   tU32 u32AppId; 
   tU32 u32Bus; 
   tU32 u32ProtocolType; 
   tU32 u32AddressField; 
} OSAL_trDRVCSM_CommunicationReq;

typedef struct //_OSAL_trIOCtrlCSM_GetCommunicationState// see CSM_lGetCommunicationState 103
{ 
   tS32 s32CSM_Return; 
   tU32 u32ConnectState; 
   tU32 u32AppId; 
   tU32 u32Bus; 
   tU32 u32ProtocolType; 
   tU32 u32AddressField; 
} OSAL_trDRVCSM_GetCommunicationState;


typedef struct //_OSAL_trIOCtrlCSM_DataReq// see CSM_lDataReq 113
{ 
   tS32 s32CSM_Return; 
   const tU8* pu8Data; 
   tU32 u32Length; 
   tU32 tU32CSM_Error; 
   tU32 u32ProtocolType; 
   tU32 u32AddressField; 
} OSAL_trDRVCSM_DataReq;

typedef struct //_OSAL_trIOCtrlCSM_DataRead// see CSM_lDataRead
{ 
   tS32 s32CSM_Return; 
   tU8* pu8Data; 
   tU32 u32Length; 
   tU32 tU32CSM_Error; 
   tU32 u32ProtocolType; 
   tU32 u32AddressField; 
} OSAL_trDRVCSM_DataRead;

typedef struct //_OSAL_trIOCtrlCSM_SignalWrite// see CSM_lSignalWrite
{ 
   tS32 s32CSM_Return; 
   const tU8* pvNewSignalData; 
   tU32 u32DataBufferLength; 
   tU32 u32TxType; 
   tU32 u32SignalID; 
} OSAL_trDRVCSM_SignalWrite; 

typedef struct //_OSAL_trIOCtrlCSM_SignalRead// see CSM_lSignalRead 
{ 
   tS32 s32CSM_Return; 
   tU8* pvActSignalData; 
   tU32 u32DataBufferLength; 
   tU32 u32SignalStatus; 
   tU32 u32SignalID; 
} OSAL_trDRVCSM_SignalRead;

// structs for data in notifications: 
typedef struct // this struct is new part of OSAL (not fixed), here for reference 
{ 
   tU32 u32DataBufferLength; 
   tU8* pvNotifyData; // points to application specific data 145
   tU32 u32Timeout;
} OSAL_trDRVCSM_RetrieveEvents; 

// pvNotifyData points for CSM to: 
typedef struct // “Variant” style 
{ 
   tU32 u32DataLength; 
   OSAL_tenDRVCSM_NotifyEvent eNotifyEvent;
   /*tU8 CSM_NotifyData[0]; // variable length */
   tU8 CSM_NotifyData[1];  //Note: Hi Georg - It does not eat the [0]
} OSAL_trDRVCSM_NotificationData;

typedef struct // see yyy_vCSMDataCon 
{ 
   tU32 u32TransferResult; 
   tU32 u32ProtocolType; 
   tU32 u32AddressField; 
} OSAL_trDRVCSM_DataCon; 

typedef struct // see yyy_vCSMDataInd 

{ 
   tU32 u32ProtocolType; 
   tU32 u32AddressField; 
   tU32 u32DataLength; 
   /*tU32 u32Data[0]; // variable length */
   tU32 CSM_NotifyData[1]; //Note: c.k. it did not eat [0]
} OSAL_trDRVCSM_DataInd; 

typedef struct // see ??? 181
{ 
   tU32 u32Bus; // originally BYTE
   tU32 u32ErrorType; // originally WORD 
} OSAL_trDRVCSM_ErrorNotify;

typedef struct // see yyy_vGetCommunicationCon 
{ // and yyy_vGetCommunicationInd 
   tU32 u32ConnectState; 
   tU32 u32AppId; 
   tU32 u32Bus; 
   tU32 u32ProtocolType; 
   tU32 u32AddressField; 
} OSAL_trDRVCSM_CommunicationConInd;



/**** typedefs for a application callback function pointer */
typedef void (*OSAL_tpvFnDRVCSM_TP_COMMUNICATION_CON) ( void *, tU8, tU32 , const void *, tU8 , tU16);
typedef void (*OSAL_tpvFnDRVCSM_TP_COMMUNICATION_IND) ( void *, tU8, tU32 , const void *, tU8 , tU16 );

/*** for network protocolls  */
typedef void (*OSAL_tpvFnDRVCSM_TP_DATA_CON) ( void *, tU32 , const void *, tU8 );
typedef void (*OSAL_tpvFnDRVCSM_TP_DATA_IND) ( void *, tU32 , const void *, tU8* , tU16 );

/*** for broadcast server */
typedef void (*OSAL_tpvFnDRVCSM_CBR_SIGNAL_IND)( void *, tU32 SignalId, tU32 SignalStatus); 

typedef struct
{
   OSAL_tpvFnDRVCSM_TP_COMMUNICATION_CON vPFNTpCommunicationCon;
   OSAL_tpvFnDRVCSM_TP_COMMUNICATION_IND vPFNTpCommunicationInd;
   OSAL_tpvFnDRVCSM_TP_DATA_CON vPFNTpDataCon;
   OSAL_tpvFnDRVCSM_TP_DATA_IND vPFNTpDataInd;
} OSAL_trDRVCSM_APPL_CALLBACK;

typedef struct
{
   tU16 u16ApplID;
   OSAL_tpvFnDRVCSM_TP_COMMUNICATION_IND vPFNTpCommunicationCon;
   OSAL_tpvFnDRVCSM_TP_COMMUNICATION_IND vPFNTpCommunicationInd;
} OSAL_trDRVCSM_BR_SIGNAL_APPL_CALLBACK;

typedef struct // see CSM_lApplCallbackInit 
{ 
   tS32 s32CSM_Return; 
   tU32 u32ProtocolType; 
   tU32 u32AddressField; 
   OSAL_trDRVCSM_APPL_CALLBACK *pvCallBackFcts;
} OSAL_trDRVCSM_ApplNotifyInit;

typedef struct // see CSM_lApplCallbackInit( bBus
{ 
   tS32 s32CSM_Return; 
   tU32 u32Bus; 
   tU32 u32ProtocolType; 
   tU32 u32AddressField; 
   OSAL_trDRVCSM_APPL_CALLBACK *pvCallBackFcts;
} OSAL_trDRVCSM_ApplNotifyInitBus;


typedef struct //_OSAL_trIOCtrlCSM_SignalNotifyInit// see CSM_lSignalCallbackInit 62
{ 
   tS32 s32CSM_Return; 
   tU32 u32SignalID; 
   //vCSMSignalInd fSignalCallBack; // only valid for Method Call 66 //tbd.: Georg please solve thi
   OSAL_tpvFnDRVCSM_CBR_SIGNAL_IND fSignalCallBack;
} OSAL_trDRVCSM_SignalNotifyInit;

typedef struct //_OSAL_trIOCtrlCSM_SignalNotifyInit// see CSM_lSignalCallbackInit 62
{ 
   tS32 s32CSM_Return; 
   OSAL_tpvFnDRVCSM_BUS_ERROR_IND fBusErrorCallBack;
} OSAL_trDRVCSM_BusErrorNotifyInit;


//OSAL_C_S32_IOCTRL_VERSION //see above
#define OSAL_C_S32_IOCTRL_CSM_COMMUNICATION_REQ          ((tS32) 1)
#define OSAL_C_S32_IOCTRL_CSM_GET_COMMUNICATION_STATE    ((tS32) 2)
#define OSAL_C_S32_IOCTRL_CSM_DATA_REQ                   ((tS32) 3)
#define OSAL_C_S32_IOCTRL_CSM_SIGNAL_WRITE               ((tS32) 4)
#define OSAL_C_S32_IOCTRL_CSM_SIGNAL_READ                ((tS32) 5)
#define OSAL_C_S32_IOCTRL_REGISTER_NOTIFICATION          ((tS32) 6)
#define OSAL_C_S32_IOCTRL_RETRIEVE_EVENTS                ((tS32) 7)
#define OSAL_C_S32_IOCTRL_NOTIFICATION_TASK              ((tS32) 8)
#define OSAL_C_S32_IOCTRL_ABORT_RETRIEVE                 ((tS32) 9)
#define OSAL_C_S32_IOCTRL_CSM_DATA_READ                  ((tS32)10)

#endif /* (OSAL_OS==OSAL_NUCLEUS) */
//END--------------------------------------------------------------------


//BEGIN---------------OSAL-device DRV_SPI--------------------------------

/* SPI IOCTRL Codes */
#define OSAL_C_S32_IOCTRL_SPI_LOCK                          ((tS32) 1)
#define OSAL_C_S32_IOCTRL_SPI_UNLOCK                        ((tS32) 2)
#define OSAL_C_S32_IOCTRL_SPI_SETUP                         ((tS32) 3)
#define OSAL_C_S32_IOCTRL_SPI_TRANSCEIVE                    ((tS32) 4)
#define OSAL_C_S32_IOCTRL_SPI_TRANSCEIVE_TUNERIC            ((tS32) 5) //c.k. 180505
#define OSAL_C_S32_IOCTRL_SPI_LOCK_FOR_TUNERICS             ((tS32) 6) //c.k. 160605
#define OSAL_C_S32_IOCTRL_SPI_UNLOCK_FOR_TUNERICS           ((tS32) 7) //c.k. 160605
#define OSAL_C_S32_IOCTRL_SPI_INITIALISE_LOCK_FOR_TUNERICS  ((tS32) 8) //c.k. 230605
#define OSAL_C_S32_IOCTRL_SPI_DELETE_LOCK_FOR_TUNERICS      ((tS32) 9) //c.k. 230605

#define OSAL_C_S32_IOCTRL_SPI_SETBAUD           ((tS32) 10)
#define OSAL_C_S32_IOCTRL_SPI_SPI_SYNC_ABORT    ((tS32) 11) //TODO implement
#define OSAL_C_S32_IOCTRL_SPI_SPI_SYNC_START    ((tS32) 12) //TODO implement
#define OSAL_C_S32_IOCTRL_SPI_SPI_SYNC_FLUSH    ((tS32) 13) //TODO implement
#define OSAL_C_S32_IOCTRL_SPI_SPI_SYNC_SETMODE  ((tS32) 14) //TODO implement

#define OSAL_C_S32_IOCTRL_SPI_RX_FLUSH          ((tS32) 15)
#define OSAL_C_S32_IOCTRL_SPI_TX_FLUSH          ((tS32) 16)

#define OSAL_C_S32_IOCTRL_SPI_READ_ERRORBUFFER  ((tS32) 17) //TODO implement
#define OSAL_C_S32_IOCTRL_SPI_FLUSH_ERROR       ((tS32) 18) //TODO implement

#define OSAL_C_S32_IOCTRL_SPI_NOTIFY            ((tS32) 19)
#define OSAL_C_S32_IOCTRL_SPI_GET_PANEL_STATE   ((tS32) 20)

#define OSAL_C_S32_IOCTRL_SPI_STANDBY           ((tS32) 21)
#define OSAL_C_S32_IOCTRL_SPI_SET_ADVANCED_MODE ((tS32) 22) //switch SPI between advanced and non advanced mode

#define OSAL_C_S32_IOCTRL_SPI_INSTALL_REQCALLBACK ((tS32) 23) 
#define OSAL_C_S32_IOCTRL_SPI_ENABLE_REQCALLBACK  ((tS32) 24)
#define OSAL_C_S32_IOCTRL_SPI_DISABLE_REQCALLBACK ((tS32) 25)


//END--------------------------------------------------------------------

//BEGIN---------------OSAL-device DRV_SPM--------------------------------
//OSAL_C_S32_IOCTRL_VERSION //see above
#define OSAL_C_S32_IOCTRL_SPM_RESET_COPRO           ((tS32) 16)
#define OSAL_C_S32_IOCTRL_SPM_RESTART_COPRO         ((tS32) 17)
#define OSAL_C_S32_IOCTRL_SPM_STARTUP_INVESTIGATION ((tS32) 18)
#define OSAL_C_S32_IOCTRL_SPM_GET_WAKEUP_REASON     ((tS32) 20)
#define OSAL_C_S32_IOCTRL_SPM_GET_STARTMODE         ((tS32) 21)
#define OSAL_C_S32_IOCTRL_SPM_SET_SUSPEND_TIME      ((tS32) 22)
#define OSAL_C_S32_IOCTRL_SPM_GET_SUSPEND_TIME      ((tS32) 23)
#define OSAL_C_S32_IOCTRL_SPM_GET_ON_REASONS        ((tS32) 24)
#define OSAL_C_S32_IOCTRL_SPM_GET_RESET_REASON      ((tS32) 25)
#define OSAL_C_S32_IOCTRL_SPM_STOP_COMMUNICATION    ((tS32) 26)
#define OSAL_C_S32_IOCTRL_SPM_PROTECT_MEM_SECTION   ((tS32) 27)
#define OSAL_C_S32_IOCTRL_SPM_FREE_MEM_SECTION      ((tS32) 28)
#define OSAL_C_S32_IOCTRL_SPM_RESET_FGS             ((tS32) 29)
#define OSAL_C_S32_IOCTRL_SPM_DEV_ACK_CALLBACK_REG  ((tS32) 30)
#define OSAL_C_S32_IOCTRL_SPM_SET_DEVICE_STATE      ((tS32) 31)
#define OSAL_C_S32_IOCTRL_SPM_GET_CSM_SIGNAL        ((tS32) 35)        
#define OSAL_C_S32_IOCTRL_SPM_START_SUSPEND_MODE    ((tS32) 36)
#define OSAL_C_S32_IOCTRL_SPM_RESTART_SUSPEND_MODE  ((tS32) 37)
#define OSAL_C_S32_IOCTRL_SPM_START_WDT             ((tS32) 38)
#define OSAL_C_S32_IOCTRL_SPM_STOP_WDT              ((tS32) 39)
#define OSAL_C_S32_IOCTRL_SPM_TRIGGER_WDT           ((tS32) 40)
#define OSAL_C_S32_IOCTRL_SPM_REGISTER_CVM_CALLBACK ((tS32) 41)
#define OSAL_C_S32_IOCTRL_SPM_STOP_COPRO            ((tS32) 42)
#define OSAL_C_S32_IOCTRL_SPM_SEND_CSM_SIGNAL       ((tS32) 43)
#define OSAL_C_S32_IOCTRL_SPM_GET_RESET_INFORMATION ((tS32) 44)
#define OSAL_C_S32_IOCTRL_SPM_PREPARE_SHUTDOWN      ((tS32) 45)
#define OSAL_C_S32_IOCTRL_SPM_STARTUP_PROCESSED         ((tS32) 46)
#define OSAL_C_S32_IOCTRL_SPM_GET_ORIGINAL_RESET_REASON ((tS32) 47)
#define OSAL_C_S32_IOCTRL_SPM_SET_RMT_ENABLE        ((tS32) 48)
#define OSAL_C_S32_IOCTRL_SPM_GET_UBAT_SENSE        ((tS32) 49)
#define OSAL_C_S32_IOCTRL_SPM_SET_HW_MUTE           ((tS32) 50)
#define OSAL_C_S32_IOCTRL_SPM_SET_CSM_NETWORK       ((tS32) 51)
#define OSAL_C_S32_IOCTRL_SPM_SHUTDOWN              ((tS32) 52)
#define OSAL_C_S32_IOCTRL_SPM_SHUTDOWN_SYSTEM       ((tS32) 52) //same value as OSAL_C_S32_IOCTRL_SPM_SHUTDOWN
#define OSAL_C_S32_IOCTRL_SPM_SET_SRAM_PARAM        ((tS32) 53)
#define OSAL_C_S32_IOCTRL_SPM_GET_SRAM_PARAM        ((tS32) 54)
#define OSAL_C_S32_IOCTRL_SPM_SET_WAKEUP_CONFIG     ((tS32) 55)
#define OSAL_C_S32_IOCTRL_SPM_WDT_TIMEOUT_WARNING   ((tS32) 56)
#define OSAL_C_S32_IOCTRL_SPM_GET_RMT_ENABLE        ((tS32) 57)
#define OSAL_C_S32_IOCTRL_SPM_REGISTER_DRV_CVM      ((tS32) 58)
#define OSAL_C_S32_IOCTRL_SPM_UNREGISTER_DRV_CVM    ((tS32) 59)
#define OSAL_C_S32_IOCTRL_SPM_SEND_ENV_STATUS       ((tS32) 60)
#define OSAL_C_S32_IOCTRL_SPM_RESET_RESET_REASON    ((tS32) 61)
#define OSAL_C_S32_IOCTRL_SPM_GET_ORIGINAL_WAKEUP_REASON ((tS32) 62)
#define OSAL_C_S32_IOCTRL_SPM_SW_WDT_WARNING        ((tS32) 63)
#define OSAL_C_S32_IOCTRL_SPM_STOP_CSM    	        ((tS32) 64)
#define OSAL_C_S32_IOCTRL_SPM_MEM_READ    	        ((tS32) 65)
#define OSAL_C_S32_IOCTRL_SPM_MEM_WRITE     	    ((tS32) 66)
#define OSAL_C_S32_IOCTRL_SPM_SET_CONFIG    	    ((tS32) 67)
#define OSAL_C_S32_IOCTRL_SPM_GET_CURRENT           ((tS32) 68)
#define OSAL_C_S32_IOCTRL_SPM_RESET_STARTUP_COUNTER ((tS32) 69)
 

typedef enum 
{ 
   /* Insert here all drivers who needs cvm signals,
      an don´t forget to add also the handling for every
      new driver in dev_spm/dev_spm_voltage_supervision.
   */
   OSAL_EN_CVM_DRV_ATA = 0x0           /* Media Drive (e.g. CD, DVD) via ATA-Driver  */ 
} OSAL_tenCvmDrvId; 

//END--------------------------------------------------------------------

//BEGIN--------------- OSAL-device DRV_WUP (for Gen2)--------------------
#define OSAL_C_S32_IOCTRL_WUP_WAKEUP                ((tS32)1)
#define OSAL_C_S32_IOCTRL_WUP_ORIG_WAKEUP           ((tS32)2)
#define OSAL_C_S32_IOCTRL_WUP_LINE_STATUS           ((tS32)3)
#define OSAL_C_S32_IOCTRL_WUP_READ_COUNTER          ((tS32)4)
#define OSAL_C_S32_IOCTRL_WUP_RESET_COUNTER         ((tS32)5)
#define OSAL_C_S32_IOCTRL_WUP_SYSTEM_STATUS         ((tS32)6)
#define OSAL_C_S32_IOCTRL_WUP_NOTIFY                ((tS32)7)
#define OSAL_C_S32_IOCTRL_WUP_PROCESSED             ((tS32)8)
#define OSAL_C_S32_IOCTRL_WUP_SET_WAKEUP_CONFIG     ((tS32)9)
#define OSAL_C_S32_IOCTRL_WUP_GET_RESET_TYPE        ((tS32)10)
#define OSAL_C_S32_IOCTRL_WUP_GET_ORIG_RESET_TYPE   ((tS32)11)
#define OSAL_C_S32_IOCTRL_WUP_READ_HISTORY          ((tS32)12)
#define OSAL_C_S32_IOCTRL_WUP_CLEAR_HISTORY         ((tS32)13)
#define OSAL_C_S32_IOCTRL_WUP_SET_SHUTDOWN_ABORT    ((tS32)14)
#define OSAL_C_S32_IOCTRL_WUP_PREPARE_FOR_SHUTDOWN  ((tS32)15)
#define OSAL_C_S32_IOCTRL_WUP_DRV_TMR_DIFFERENCE    ((tS32)16)
#define OSAL_C_S32_IOCTRL_WUP_ECL_EVENTS            ((tS32)17)
#define OSAL_C_S32_IOCTRL_WUP_SHUTDOWN              ((tS32)18)
#define OSAL_C_S32_IOCTRL_WUP_SET_EMERGENCY_CONFIG  ((tS32)19)
#define OSAL_C_S32_IOCTRL_WUP_SET_RESET_COUNTER     ((tS32)20)
#define OSAL_C_S32_IOCTRL_WUP_EXT_WAKEUP            ((tS32)21)
#define OSAL_C_S32_IOCTRL_WUP_SET_EXT_WAKEUP_CONFIG ((tS32)22)
#define OSAL_C_S32_IOCTRL_WUP_SET_EXT_EMY_OFF_CTR   ((tS32)23)
#define OSAL_C_S32_IOCTRL_WUP_GET_EXT_EMY_OFF_CTR   ((tS32)24)
#define OSAL_C_S32_IOCTRL_WUP_EXT_LATCH_ON_OFF      ((tS32)25)


/* different wakeup configurations */
#define DEV_WUP_WAKEUP_CONFIG_DEFAULT				0
#define DEV_WUP_WAKEUP_CONFIG_WITHOUT_MOST 			1
#define DEV_WUP_WAKEUP_CONFIG_WITHOUT_CAN			2
#define DEV_WUP_WAKEUP_CONFIG_EMERGENCY_OFF			3
#define DEV_WUP_WAKEUP_CONFIG_WITHOUT_PHONE			4
#define DEV_WUP_WAKEUP_CONFIG_TRANSPORT                         5

/* WakeUp reasons to set via OSAL_C_S32_IOCTRL_WUP_SET_SHUTDOWN_ABORT */
#define DEV_WUP_SHUTDOWN_ABORT_UNDEF 0
#define DEV_WUP_SHUTDOWN_ABORT_MOST 1
#define DEV_WUP_SHUTDOWN_ABORT_CAN 2
#define DEV_WUP_SHUTDOWN_ABORT_RBD 3	/* RBD via deticated GPIO*/

/* Used for OSAL_C_S32_IOCTRL_WUP_EXT_LATCH_ON_OFF: */
#define DEV_WUP_EXT_LATCH_OFF         0
#define DEV_WUP_EXT_LATCH_ON          1

/* Used for OSAL_C_S32_IOCTRL_WUP_SHUTDOWN: */
#define DEV_WUP_SHUTDOWN_RESET        0
#define DEV_WUP_SHUTDOWN_NORMAL       1
#define DEV_WUP_SHUTDOWN_IMMEDIATE    2
#define DEV_WUP_SHUTDOWN_DOWNLOAD     3

/* Used for OSAL_C_S32_IOCTRL_WUP_PREPARE_FOR_SHUTDOWN: */
#define DEV_WUP_OSAL_AOSM_RESET_INACTIVE                 0	// do nothing
#define DEV_WUP_OSAL_AOSM_RESET_IMMEDIATELY              1	// perform directly a abort-of-shutdown reset
#define DEV_WUP_OSAL_AOSM_RESET_AFTER_SHUTDOWN           2	// wait for shutdown call (switch-power-supply-off) and
#define DEV_WUP_OSAL_EXTERNAL_WAKEUP_LATCH_ON            3  // activate the external wakeup latch functionality
#define DEV_WUP_OSAL_EXTERNAL_WAKEUP_LATCH_OFF           4  // deactivate the external wakeup latch functionality

/* Used for OSAL_C_S32_IOCTRL_WUP_SET_EMERGENCY_CONFIG: */
#define DEV_WUP_OSAL_EMERGENCY_CONFIG_LOW_POWER         1	// Switch off power-supply for some hw-devices

/* structure for read data */
typedef struct
{
  tU32  eject     : 1;	   // OnTipper 
  tU32  ignition  : 1;	   // CD or DVD 
  tU32  insert    : 1;	   // Debug switch, aka. External reset
  tU32  rtc       : 1;	   // Phonemute pin
  tU32  tipper    : 1;	   // SBX connected to USP WakeUp
  tU32  dooropen  : 1;	   // vehicle info door open (early signal)
  tU32  phonemute : 1;	   // vehicle info phonemute (early signal)
  tU32  can       : 1;	   // can wakeup
  tU32  debug     : 1;	   // debug switch
  tU32  most      : 1;	   // wakeup via most wakeup (ecl) line
  tU32  rbd       : 1;       // wakeup via rbd gpio pin
  tU32  lin       : 1;	   // lin or tlin
  tU32  external  : 1;	   // coldstart or external
  tU32  coldstart : 1; 
  tU32  abortOfShutdown : 1; /* Current (re)start caused by incoming wakeup-reason during platform shutdown */
  tU32  most_wakeup : 1;               /* ECL-Pulse NORMAL_WAKEUP detected*/
  tU32  most_rbd    : 1;               /* ECL-Pulse RING-BREAK-DIAGNOSIS detected*/
  tU32  most_stg    : 1;               /* ECL-Pulse short-to-ground detected*/// 
} OSAL_tWupWakeUpReasons;

/* structure to determine line status */
typedef struct
{
  tU8 most;     // NORMAL_STARTUP, RINGBREAK_DIAGNOSTICS,
                          // SHORT_TO_GROUND
  tU8 can;      // ACTIVE, INACTIVE
  tU8 mostgpio; /* gpio states of most and can lines  */
  tU8 cangpio;  /* 0 = low level, 1 = high level      */
} OSAL_tWupLineStatus;

/* structure to set the notifications a registered client module needs */
typedef struct 
{
  tS32 handle;                  // event handle
  tU32 mask;           // mask to set the corresponding event
  tU32 notification;   // notification to set or unset
  tChar removeNotification;     // 0: set , 1: remove
} OSAL_tWupNotification;

typedef struct 
{
  tU32 WakeUp;
  tU32 Stg;
  tU32 Rbd;
} OSAL_tWupEclEvents;

//END--------------------------------------------------------------------

//BEGIN--------------- OSAL-device DEV_WUP (for Gen3)--------------------

#define DEV_WUP_CONF_C_U8_MAX_NUM_OF_BUFFERED_ONOFF_EVENTS             ((tU8)10)

//#define OSAL_C_S32_IOCTRL_WUP_SHUTDOWN                                            ((tS32)18)  // IO-control already defined by Gen2 defines
#define OSAL_C_S32_IOCTRL_WUP_GET_STARTTYPE                                         ((tS32)50)
#define OSAL_C_S32_IOCTRL_WUP_GET_WAKEUP_REASON                                     ((tS32)51)
#define OSAL_C_S32_IOCTRL_WUP_REGISTER_CLIENT                                       ((tS32)52)
#define OSAL_C_S32_IOCTRL_WUP_UNREGISTER_CLIENT                                     ((tS32)53)
#define OSAL_C_S32_IOCTRL_WUP_REGISTER_ONOFF_REASON_CHANGED_NOTIFICATION            ((tS32)54)
#define OSAL_C_S32_IOCTRL_WUP_UNREGISTER_ONOFF_REASON_CHANGED_NOTIFICATION          ((tS32)55)
#define OSAL_C_S32_IOCTRL_WUP_GET_ONOFF_EVENTS                                      ((tS32)56)
#define OSAL_C_S32_IOCTRL_WUP_ACKNOWLEDGE_ONOFF_EVENT                               ((tS32)57)
#define OSAL_C_S32_IOCTRL_WUP_GET_ONOFF_STATES                                      ((tS32)58)
#define OSAL_C_S32_IOCTRL_WUP_RESET_PROCESSOR                                       ((tS32)59)
#define OSAL_C_S32_IOCTRL_WUP_CONFIGURE_WAKEUP_REASONS                              ((tS32)60)
#define OSAL_C_S32_IOCTRL_WUP_GET_LATEST_RESET_REASON                               ((tS32)61)
#define OSAL_C_S32_IOCTRL_WUP_INDICATE_STARTUP_FINISHED                             ((tS32)62)
#define OSAL_C_S32_IOCTRL_WUP_EXTEND_POWER_OFF_TIMEOUT                              ((tS32)63)
#define OSAL_C_S32_IOCTRL_WUP_CONTROL_RESET_MASTER_SUPERVISION                      ((tS32)64)
#define OSAL_C_S32_IOCTRL_WUP_ACKNOWLEDGE_ONOFF_STATE                               ((tS32)65)
#define OSAL_C_S32_IOCTRL_WUP_GET_APPLICATION_MODE                                  ((tS32)66)
#define OSAL_C_S32_IOCTRL_WUP_GET_CPU_SUPERVISION_ERROR_WARNING                              ((tS32)67)
#define OSAL_C_S32_IOCTRL_WUP_REGISTER_CPU_SUPERVISION_ERROR_WARNING_CHANGED_NOTIFICATION    ((tS32)68)
#define OSAL_C_S32_IOCTRL_WUP_UNREGISTER_CPU_SUPERVISION_ERROR_WARNING_CHANGED_NOTIFICATION  ((tS32)69)
#define OSAL_C_S32_IOCTRL_WUP_GET_OPERATIONAL_STATE                                          ((tS32)70)
#define OSAL_C_S32_IOCTRL_WUP_GET_DM_VERITY_STATE                                            ((tS32)71)
#define OSAL_C_S32_IOCTRL_WUP_SET_DM_VERITY_CHECK_RESULT                                     ((tS32)72)
#define OSAL_C_S32_IOCTRL_WUP_SET_FAST_SHUTDOWN                                              ((tS32)73)
#define OSAL_C_S32_IOCTRL_WUP_CONFIGURE_WAKEUP_REASONS_NEW                                   ((tS32)74)

#define DEV_WUP_C_U8_STARTTYPE_COLDSTART                             ((tU8)0x00)
#define DEV_WUP_C_U8_STARTTYPE_RESTART_VCC                           ((tU8)0x01)
#define DEV_WUP_C_U8_STARTTYPE_WARMSTART                             ((tU8)0x02)
#define DEV_WUP_C_U8_STARTTYPE_RESTART_CPU                           ((tU8)0x03)
#define DEV_WUP_C_U8_STARTTYPE_UNKNOWN                               ((tU8)0xFF) // Temporary to be downward compatible to previous interface

#define DEV_WUP_C_U8_WAKEUP_REASON_UNKNOWN                           ((tU8)0x00)
#define DEV_WUP_C_U8_WAKEUP_REASON_POWER_ON_RESET                    ((tU8)0x01)
#define DEV_WUP_C_U8_WAKEUP_REASON_ON_TIPPER                         ((tU8)0x02)
#define DEV_WUP_C_U8_WAKEUP_REASON_CAN                               ((tU8)0x03)
#define DEV_WUP_C_U8_WAKEUP_REASON_MOST                              ((tU8)0x04)
#define DEV_WUP_C_U8_WAKEUP_REASON_IGN_PIN                           ((tU8)0x05)
#define DEV_WUP_C_U8_WAKEUP_REASON_TEL_MUTE                          ((tU8)0x06)
#define DEV_WUP_C_U8_WAKEUP_REASON_DEBUG_WAKEUP                      ((tU8)0x07)
#define DEV_WUP_C_U8_WAKEUP_REASON_RTC_WAKEUP                        ((tU8)0x08)
#define DEV_WUP_C_U8_WAKEUP_REASON_CD_INSERT_DETECTED                ((tU8)0x09)
#define DEV_WUP_C_U8_WAKEUP_REASON_CD_EJECT_DETECTED                 ((tU8)0x0A)
#define DEV_WUP_C_U8_WAKEUP_REASON_S_CONTACT_WAKEUP                  ((tU8)0x0B)
#define DEV_WUP_C_U8_WAKEUP_REASON_CELLNETWORK_WAKEUP                ((tU8)0x0C)
#define DEV_WUP_C_U8_WAKEUP_REASON_CAN2_WAKEUP                       ((tU8)0x0D)
#define DEV_WUP_C_U8_WAKEUP_REASON_CAN3_WAKEUP                       ((tU8)0x0E)
#define DEV_WUP_C_U8_WAKEUP_REASON_CAN4_WAKEUP                       ((tU8)0x0F)
#define DEV_WUP_C_U8_WAKEUP_REASON_ODOMETER_WAKEUP                   ((tU8)0x10)
#define DEV_WUP_C_U8_WAKEUP_REASON_LIN_WAKEUP                        ((tU8)0x11)
#define DEV_WUP_C_U8_WAKEUP_REASON_EXTERNAL_PIN_WAKEUP               ((tU8)0x12)
#define DEV_WUP_C_U8_WAKEUP_REASON_UART                              ((tU8)0x13)
#define DEV_WUP_C_U8_WAKEUP_REASON_UART2                             ((tU8)0x14)
#define DEV_WUP_C_U8_WAKEUP_REASON_USB                               ((tU8)0x15)
#define DEV_WUP_C_U8_WAKEUP_REASON_BLUETOOTH                         ((tU8)0x16)
#define DEV_WUP_C_U8_WAKEUP_REASON_ACCELERATOR_SENSOR                ((tU8)0x17)
#define DEV_WUP_C_U8_WAKEUP_REASON_EXTERNAL_GPIO2                    ((tU8)0x18)
#define DEV_WUP_C_U8_WAKEUP_REASON_EXTERNAL_GPIO3                    ((tU8)0x19)
#define DEV_WUP_C_U8_WAKEUP_REASON_EXTERNAL_GPIO4                    ((tU8)0x1A)
#define DEV_WUP_C_U8_WAKEUP_REASON_EXTERNAL_GPIO5                    ((tU8)0x1B)
#define DEV_WUP_C_U8_WAKEUP_REASON_ILLUMINATION                      ((tU8)0x1C)

#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_ON_TIPPER            ((tU32)0x00000001)
#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_CAN                  ((tU32)0x00000002)
#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_MOST                 ((tU32)0x00000004)
#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_IGN_PIN              ((tU32)0x00000008)
#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_TEL_MUTE             ((tU32)0x00000010)
#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_DEBUG_WAKEUP         ((tU32)0x00000020)
#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_RTC_WAKEUP           ((tU32)0x00000040)
#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_CD_INSERT_DETECTED   ((tU32)0x00000080)
#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_CD_EJECT_DETECTED    ((tU32)0x00000100)
#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_S_CONTACT_WAKEUP     ((tU32)0x00000200)
#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_CELLNETWORK_WAKEUP   ((tU32)0x00000400)
#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_CAN2_WAKEUP          ((tU32)0x00000800)
#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_CAN3_WAKEUP          ((tU32)0x00001000)
#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_CAN4_WAKEUP          ((tU32)0x00002000)
#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_ODOMETER_WAKEUP      ((tU32)0x00004000)
#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_LIN_WAKEUP           ((tU32)0x00008000)
#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_EXTERNAL_PIN_WAKEUP  ((tU32)0x00010000)
#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_UART                 ((tU32)0x00020000)
#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_UART2                ((tU32)0x00040000)
#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_USB                  ((tU32)0x00080000)
#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_BLUETOOTH            ((tU32)0x00100000)
#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_ACCELERATOR_SENSOR   ((tU32)0x00200000)
#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_EXTERNAL_GPIO2       ((tU32)0x00400000)
#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_EXTERNAL_GPIO3       ((tU32)0x00800000)
#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_EXTERNAL_GPIO4       ((tU32)0x01000000)
#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_EXTERNAL_GPIO5       ((tU32)0x02000000)
#define DEV_WUP_C_U32_WAKEUP_REASONS_MASK_ILLUMINATION         ((tU32)0x04000000)

#define DEV_WUP_C_U8_ONOFF_EVENT_POWER_ON_RESET                      ((tU8)0x00)
#define DEV_WUP_C_U8_ONOFF_EVENT_CSD_HOME_PRESSED                    ((tU8)0x01)
#define DEV_WUP_C_U8_ONOFF_EVENT_DRIVERS_DOOR_OPENED                 ((tU8)0x02)
#define DEV_WUP_C_U8_ONOFF_EVENT_DEBUG_WAKEUP                        ((tU8)0x03)
#define DEV_WUP_C_U8_ONOFF_EVENT_RTC_WAKEUP                          ((tU8)0x04)
#define DEV_WUP_C_U8_ONOFF_EVENT_ON_TIPPER_PRESS                     ((tU8)0x05)
#define DEV_WUP_C_U8_ONOFF_EVENT_IGNITION_PIN                        ((tU8)0x06)
#define DEV_WUP_C_U8_ONOFF_EVENT_CD_INSERT_DETECTED                  ((tU8)0x07)
#define DEV_WUP_C_U8_ONOFF_EVENT_CD_EJECT_DETECTED                   ((tU8)0x08)
#define DEV_WUP_C_U8_ONOFF_EVENT_MOST_ACTIVE_DETECTED                ((tU8)0x09)
#define DEV_WUP_C_U8_ONOFF_EVENT_MOST_RBD_DETECTED                   ((tU8)0x0A)
#define DEV_WUP_C_U8_ONOFF_EVENT_MOST_ECL_STG_DETECTED               ((tU8)0x0B)
#define DEV_WUP_C_U8_ONOFF_EVENT_MOST_UNDEF_DETECTED                 ((tU8)0x0C)
#define DEV_WUP_C_U8_ONOFF_EVENT_UART                                ((tU8)0x0D)
#define DEV_WUP_C_U8_ONOFF_EVENT_BLUETOOTH                           ((tU8)0x0E)
#define DEV_WUP_C_U8_ONOFF_EVENT_NO_WAKEUP_EVENT                     ((tU8)0xFF)

#define DEV_WUP_C_U8_ONOFF_STATE_CAN                                 ((tU8)0x00)
#define DEV_WUP_C_U8_ONOFF_STATE_FLEXRAY                             ((tU8)0x01)
#define DEV_WUP_C_U8_ONOFF_STATE_MOST                                ((tU8)0x02)
#define DEV_WUP_C_U8_ONOFF_STATE_LIN                                 ((tU8)0x03)
#define DEV_WUP_C_U8_ONOFF_STATE_IGN_PIN                             ((tU8)0x04)
#define DEV_WUP_C_U8_ONOFF_STATE_TELEPHONE_MUTE                      ((tU8)0x05)
#define DEV_WUP_C_U8_ONOFF_STATE_MOST_RBD                            ((tU8)0x06)
#define DEV_WUP_C_U8_ONOFF_STATE_MOST_ECL                            ((tU8)0x07)
#define DEV_WUP_C_U8_ONOFF_STATE_MOST_UNDEF                          ((tU8)0x08)
#define DEV_WUP_C_U8_ONOFF_STATE_S_CONTACT                           ((tU8)0x09)
#define DEV_WUP_C_U8_ONOFF_STATE_CAN2                                ((tU8)0x0A)
#define DEV_WUP_C_U8_ONOFF_STATE_CAN3                                ((tU8)0x0B)
#define DEV_WUP_C_U8_ONOFF_STATE_CAN4                                ((tU8)0x0C)
#define DEV_WUP_C_U8_ONOFF_STATE_ODOMETER                            ((tU8)0x0D)
#define DEV_WUP_C_U8_ONOFF_STATE_CELLNETWORK                         ((tU8)0x0E)
#define DEV_WUP_C_U8_ONOFF_STATE_EXTERNAL_PIN                        ((tU8)0x0F)
#define DEV_WUP_C_U8_ONOFF_STATE_USB                                 ((tU8)0x10)
#define DEV_WUP_C_U8_ONOFF_STATE_CD_CLAMP                            ((tU8)0x11)
#define DEV_WUP_C_U8_ONOFF_STATE_ILLUMINATION                        ((tU8)0x12)
#define DEV_WUP_C_U8_ONOFF_STATE_MAX_VALUE_PLUS_ONE                  ((tU8)0x13)

#define DEV_WUP_C_STRING_NOTIFICATION_EVENT_PREFIX               "DevWupNotify"
#define DEV_WUP_C_STRING_NOTIFICATION_EVENT_POSTFIX_FORMAT       "%s%02u"
#define DEV_WUP_C_U8_NOTIFICATION_EVENT_NAME_LENGTH              ((tU8)(sizeof(DEV_WUP_C_STRING_NOTIFICATION_EVENT_PREFIX)+2))

#define DEV_WUP_C_U32_CLIENT_ID_INVALID                        ((tU32)0xFFFFFFFF)

#define DEV_WUP_C_U32_EVENT_MASK_ONOFF_EVENT_CHANGED_NOTIFY          ((tU32)0x00000001)
#define DEV_WUP_C_U32_EVENT_MASK_ONOFF_STATE_CHANGED_NOTIFY          ((tU32)0x00000002)
#define DEV_WUP_C_U32_EVENT_MASK_CPU_SUPERVISION_ERROR_WARNING_CHANGED_NOTIFY ((tU32)0x00000004)
#define DEV_WUP_C_U32_EVENT_MASK_RESERVED_FOR_SERVER_4               ((tU32)0x00000008)
#define DEV_WUP_C_U32_EVENT_MASK_RESERVED_FOR_SERVER_5               ((tU32)0x00000010)
#define DEV_WUP_C_U32_EVENT_MASK_RESERVED_FOR_SERVER_6               ((tU32)0x00000020)
#define DEV_WUP_C_U32_EVENT_MASK_RESERVED_FOR_SERVER_7               ((tU32)0x00000040)
#define DEV_WUP_C_U32_EVENT_MASK_RESERVED_FOR_SERVER_8               ((tU32)0x00000080)
#define DEV_WUP_C_U32_EVENT_MASK_RESERVED_FOR_SERVER_9               ((tU32)0x00000100)
#define DEV_WUP_C_U32_EVENT_MASK_RESERVED_FOR_SERVER_10              ((tU32)0x00000200)
#define DEV_WUP_C_U32_EVENT_MASK_RESERVED_FOR_SERVER_11              ((tU32)0x00000400)
#define DEV_WUP_C_U32_EVENT_MASK_RESERVED_FOR_SERVER_12              ((tU32)0x00000800)
#define DEV_WUP_C_U32_EVENT_MASK_RESERVED_FOR_SERVER_13              ((tU32)0x00001000)
#define DEV_WUP_C_U32_EVENT_MASK_RESERVED_FOR_SERVER_14              ((tU32)0x00002000)
#define DEV_WUP_C_U32_EVENT_MASK_RESERVED_FOR_SERVER_15              ((tU32)0x00004000)
#define DEV_WUP_C_U32_EVENT_MASK_RESERVED_FOR_SERVER_16              ((tU32)0x00008000)
#define DEV_WUP_C_U32_EVENT_MASK_FREE_FOR_CLIENT_17                  ((tU32)0x00010000)
#define DEV_WUP_C_U32_EVENT_MASK_FREE_FOR_CLIENT_18                  ((tU32)0x00020000)
#define DEV_WUP_C_U32_EVENT_MASK_FREE_FOR_CLIENT_19                  ((tU32)0x00040000)
#define DEV_WUP_C_U32_EVENT_MASK_FREE_FOR_CLIENT_20                  ((tU32)0x00080000)
#define DEV_WUP_C_U32_EVENT_MASK_FREE_FOR_CLIENT_21                  ((tU32)0x00100000)
#define DEV_WUP_C_U32_EVENT_MASK_FREE_FOR_CLIENT_22                  ((tU32)0x00200000)
#define DEV_WUP_C_U32_EVENT_MASK_FREE_FOR_CLIENT_23                  ((tU32)0x00400000)
#define DEV_WUP_C_U32_EVENT_MASK_FREE_FOR_CLIENT_24                  ((tU32)0x00800000)
#define DEV_WUP_C_U32_EVENT_MASK_FREE_FOR_CLIENT_25                  ((tU32)0x01000000)
#define DEV_WUP_C_U32_EVENT_MASK_FREE_FOR_CLIENT_26                  ((tU32)0x02000000)
#define DEV_WUP_C_U32_EVENT_MASK_FREE_FOR_CLIENT_27                  ((tU32)0x04000000)
#define DEV_WUP_C_U32_EVENT_MASK_FREE_FOR_CLIENT_28                  ((tU32)0x08000000)
#define DEV_WUP_C_U32_EVENT_MASK_FREE_FOR_CLIENT_29                  ((tU32)0x10000000)
#define DEV_WUP_C_U32_EVENT_MASK_FREE_FOR_CLIENT_30                  ((tU32)0x20000000)
#define DEV_WUP_C_U32_EVENT_MASK_FREE_FOR_CLIENT_31                  ((tU32)0x40000000)
#define DEV_WUP_C_U32_EVENT_MASK_FREE_FOR_CLIENT_32                  ((tU32)0x80000000)

#define DEV_WUP_C_U8_INVALID_PROCESSOR                                     ((tU8)0x00)
#define DEV_WUP_C_U8_ENTIRE_SYSTEM                                         ((tU8)0xFF)
#define DEV_WUP_C_U8_APPLICATION_PROCESSOR                                 ((tU8)0xFE)
#define DEV_WUP_C_U8_SYSTEM_COMMUNICATION_CONTROLLER                       ((tU8)0xFD)
#define DEV_WUP_C_U8_ENTIRE_SYSTEM_WITH_POWER_DISCONNECTION                ((tU8)0xFC)
#define DEV_WUP_C_U8_BLUETOOTH_PROCESSOR                                   ((tU8)0x01)
#define DEV_WUP_C_U8_WIRELESS_LAN_PROCESSOR                                ((tU8)0x02)
#define DEV_WUP_C_U8_GNSS_PROCESSOR                                        ((tU8)0x03)
#define DEV_WUP_C_U8_XM_PROCESSOR                                          ((tU8)0x04)
#define DEV_WUP_C_U8_IPOD_PROCESSOR                                        ((tU8)0x05)
#define DEV_WUP_C_U8_ADR1_PROCESSOR                                        ((tU8)0x06)
#define DEV_WUP_C_U8_ADR2_PROCESSOR                                        ((tU8)0x07)
#define DEV_WUP_C_U8_VIDEO_PROCESSOR                                       ((tU8)0x08)

#define DEV_WUP_C_U8_RESET_MODE_UNLOGGED                                   ((tU8)0x01)
#define DEV_WUP_C_U8_RESET_MODE_LOGGED                                     ((tU8)0x02)

// Uncontrolled external AP reset reasons
#define DEV_WUP_C_U16_RESET_REASON_POWER_ON                  ((tU16)0x0000) // PRAM invalid
#define DEV_WUP_C_U16_RESET_REASON_UNKNOWN                   ((tU16)0xFFFF) // PRAM valid or invalid=> immediately set in PRAM at /dev/wup init after PRAM invalid 
                                                                    //                         detection or previous valid PRAM value was copied to RAM access variable
#define DEV_WUP_C_U16_RESET_REASON_POWER_OFF                 ((tU16)0x0002) // PRAM valid => written to PRAM at the end of a controlled shutdown
#define DEV_WUP_C_U16_RESET_REASON_POWER_LOSS                ((tU16)0x0003) // PRAM valid => written to PRAM at UDROP_30
#define DEV_WUP_C_U16_RESET_REASON_SCC                       ((tU16)0x0004) // PRAM valid => written to PRAM at SCC_RSTWARN_CPU
#define DEV_WUP_C_U16_RESET_REASON_SELF                      ((tU16)0x0005) // PRAM valid => written to PRAM at requested AP self reset
// Controlled and general requested reset reasons (valid for all processors) => MSB is NOT set
#define DEV_WUP_C_U16_RESET_REASON_UNSPECIFIED               ((tU16)0x0100)
#define DEV_WUP_C_U16_RESET_REASON_SW_DOWNLOAD               ((tU16)0x0101)
// Controlled and requested AP reset reasons (AP reset counter untouched) => MSB is NOT set
#define DEV_WUP_C_U16_RESET_REASON_SWITCH_BOOT_MODE_EMMC     ((tU16)0x0200)
#define DEV_WUP_C_U16_RESET_REASON_SWITCH_BOOT_MODE_USB      ((tU16)0x0201)
// Controlled and requested AP reset reasons (AP reset counter decreased) => MSB is set
#define DEV_WUP_C_U16_RESET_REASON_LATE_WAKEUP               ((tU16)0x8001)
#define DEV_WUP_C_U16_RESET_REASON_DIAGNOSIS                 ((tU16)0x8002)

// By the SCC reported reset reasons
#define DEV_WUP_C_U8_RESET_REASON_HW_WATCHDOG                ((tU8)0x00)
#define DEV_WUP_C_U8_RESET_REASON_POR                        ((tU8)0x01)
#define DEV_WUP_C_U8_RESET_REASON_COLDSTART                  ((tU8)0x02)
#define DEV_WUP_C_U8_RESET_REASON_APPMODE_CHANGE             ((tU8)0x03)
#define DEV_WUP_C_U8_RESET_REASON_DURING_LPW                 ((tU8)0x04)
#define DEV_WUP_C_U8_RESET_REASON_PLL_OSZ                    ((tU8)0x05)
#define DEV_WUP_C_U8_RESET_REASON_SW                         ((tU8)0x06)
#define DEV_WUP_C_U8_RESET_REASON_WARMSTART                  ((tU8)0x07)
#define DEV_WUP_C_U8_RESET_REASON_USER_RESET                 ((tU8)0x08)

#define DEV_WUP_C_U8_NOTIFY_NONE                                           ((tU8)0x00)
#define DEV_WUP_C_U8_NOTIFY_STATES_ONLY                                    ((tU8)0x01)
#define DEV_WUP_C_U8_NOTIFY_EVENTS_ONLY_WITH_PAST_ONES                     ((tU8)0x02)
#define DEV_WUP_C_U8_NOTIFY_EVENTS_ONLY_WITHOUT_PAST_ONES                  ((tU8)0x03)
#define DEV_WUP_C_U8_NOTIFY_STATES_AND_EVENTS_WITH_PAST_ONES               ((tU8)0x04)
#define DEV_WUP_C_U8_NOTIFY_STATES_AND_EVENTS_WITHOUT_PAST_ONES            ((tU8)0x05)

#define DEV_WUP_C_U8_BITMASK_SUPERVISION_METHOD_COM_WD              ((tU8)0x01)

#define DEV_WUP_C_U8_APPLICATION_MODE_UNKNOWN                               ((tU8)0xFF)
#define DEV_WUP_C_U8_APPLICATION_MODE_NORMAL                                ((tU8)0x00)
#define DEV_WUP_C_U8_APPLICATION_MODE_DOWNLOAD                              ((tU8)0x01)
#define DEV_WUP_C_U8_APPLICATION_MODE_TESTMANAGER                           ((tU8)0x02)

#define DEV_WUP_C_U8_CPU_SUPERVISION_ERROR_WARNING_NONE                           ((tU8)0xFF)
#define DEV_WUP_C_U8_CPU_SUPERVISION_ERROR_WARNING_SHUTDOWN_TIMEOUT               ((tU8)0x00)
#define DEV_WUP_C_U8_CPU_SUPERVISION_ERROR_WARNING_THERMAL_SHUTDOWN_TIMEOUT       ((tU8)0x01)
#define DEV_WUP_C_U8_CPU_SUPERVISION_ERROR_WARNING_COMMUNICATION_WATCHDOG_TIMEOUT ((tU8)0x02)
#define DEV_WUP_C_U8_CPU_SUPERVISION_ERROR_WARNING_STARTUP_FINISHED_TIMEOUT       ((tU8)0x03)
#define DEV_WUP_C_U8_CPU_SUPERVISION_ERROR_WARNING_USER_RESET                     ((tU8)0x04)

#define DEV_WUP_C_U8_OPERATIONAL_STATE_UNKNOWN                                ((tU8)0xFF)
#define DEV_WUP_C_U8_OPERATIONAL_STATE_DIAGNOSIS_0                            ((tU8)0x00)
#define DEV_WUP_C_U8_OPERATIONAL_STATE_DIAGNOSIS_1                            ((tU8)0x01)
#define DEV_WUP_C_U8_OPERATIONAL_STATE_NORMAL                                 ((tU8)0x02)
#define DEV_WUP_C_U8_OPERATIONAL_STATE_DMVERITY_CHECK                         ((tU8)0x03)

#define DEV_WUP_C_U8_DM_VERITY_STATE_UNKNOWN                                  ((tU8)0x00)
#define DEV_WUP_C_U8_DM_VERITY_STATE_FAILED                                   ((tU8)0x01)
#define DEV_WUP_C_U8_DM_VERITY_STATE_PASSED                                   ((tU8)0x02)

#define DEV_WUP_C_U8_DM_VERITY_CHECK_RESULT_UNKNOWN                           ((tU8)0x00)
#define DEV_WUP_C_U8_DM_VERITY_CHECK_RESULT_FAILED                            ((tU8)0x01)
#define DEV_WUP_C_U8_DM_VERITY_CHECK_RESULT_PASSED                            ((tU8)0x02)

#define DEV_WUP_C_U8_FAST_SHUTDOWN_INACTIVE                                    ((tU8)0x00)
#define DEV_WUP_C_U8_FAST_SHUTDOWN_ACTIVE                                      ((tU8)0x01)
#define DEV_WUP_C_U8_FAST_SHUTDOWN_UNKNOWN                                     ((tU8)0xFF)

typedef struct
{
  tU32  u32ClientId;
  tChar szNotificationEventName[DEV_WUP_C_U8_NOTIFICATION_EVENT_NAME_LENGTH];
} DEV_WUP_trClientRegistration;

typedef struct
{
  tU32  u32ClientId;
  tU8   u8NotificationMode;
  tBool bIsSystemMaster;
 } DEV_WUP_trOnOffReasonChangedRegistration;

typedef struct
{
  tU8  u8Event;
  tU16 u16MsgHandle;
  tU32 u32Timestamp;
} DEV_WUP_trOnOffEvent;

typedef struct
{
  tU32                 u32ClientId;
  tU8                  u8NumberOfOnOffEvents;
  DEV_WUP_trOnOffEvent arOnOffEvent[DEV_WUP_CONF_C_U8_MAX_NUM_OF_BUFFERED_ONOFF_EVENTS];
} DEV_WUP_trOnOffEventHistory;

typedef struct
{
  tU32 u32ClientId;
  tU16 u16OnOffEventMsgHandle;
} DEV_WUP_trOnOffEventAcknowledge;

typedef struct
{
  tU32 u32ClientId;
  tU16 u16OnOffStateMsgHandle;
} DEV_WUP_trOnOffStateAcknowledge;

typedef struct
{
  tU32 CAN            :  1;
  tU32 FLEXRAY        :  1;
  tU32 MOST           :  1;
  tU32 LIN            :  1;
  tU32 IGN_PIN        :  1;
  tU32 TELEPHONE_MUTE :  1;
  tU32 MOST_RBD       :  1;
  tU32 MOST_ECL       :  1;
  tU32 MOST_UNDEF     :  1;
  tU32 S_CONTACT      :  1;
  tU32 CAN2           :  1;
  tU32 CAN3           :  1;
  tU32 CAN4           :  1;
  tU32 ODOMETER       :  1;
  tU32 CELLNETWORK    :  1;
  tU32 EXTERNAL_PIN   :  1;
  tU32 USB            :  1;
  tU32 CD_CLAMP       :  1;
  tU32 ILLUMINATION   :  1;
  tU32 unused         : 13;
} DEV_WUP_trOnOffStatesBitfield;

union DEV_WUP_tuOnOffStates
{
  DEV_WUP_trOnOffStatesBitfield rBitfield;
  tU32                          u32;
};

typedef struct
{
  union DEV_WUP_tuOnOffStates uOnOffStates;
  tU16                        u16MsgHandle;
} DEV_WUP_trOnOffStates;

typedef struct
{
  tU8  u8Processor;
  tU8  u8ResetMode;
  tU16 u16ResetReason;
  tU16 u16ResetDurationMs;
} DEV_WUP_trResetProcessorInfo;

typedef struct
{
  tU16 u16ResetReasonAP;
  tU8 u8ResetReasonSCC;
} DEV_WUP_trLatestResetReason;

typedef struct
{
  tBool bSwitchOff;
  tU8   u8ExceptionBitmask;
} DEV_WUP_trResetMasterSupervision;

//END--------------------------------------------------------------------

//BEGIN---------------OSAL-device DRV_VOLT (for Gen2) -------------------
#define OSAL_C_S32_IOCTRL_VOLT_CREATE_NOTIFICATION_CLIENT          ((tS32)1)
#define OSAL_C_S32_IOCTRL_VOLT_REMOVE_NOTIFICATION_CLIENT          ((tS32)2)
#define OSAL_C_S32_IOCTRL_VOLT_SET_USER_THRESHOLD_NOTIFICATION     ((tS32)3)
#define OSAL_C_S32_IOCTRL_VOLT_DEREG_USER_THRESHOLD_NOTIFICATION   ((tS32)4)
#define OSAL_C_S32_IOCTRL_VOLT_SET_SYSTEM_THRESHOLD_NOTIFICATION   ((tS32)5)
#define OSAL_C_S32_IOCTRL_VOLT_DEREG_SYSTEM_THRESHOLD_NOTIFICATION ((tS32)6)

#define OSAL_C_S32_IOCTRL_VOLT_GET_SYSTEM_VOLTAGE_LEVEL_HISTORY    ((tS32)9)
#define OSAL_C_S32_IOCTRL_VOLT_GET_CVM_VOLTAGE_LEVEL_HISTORY       ((tS32)10)
#define OSAL_C_S32_IOCTRL_VOLT_GET_USER_VOLTAGE_LEVEL_HISTORY      ((tS32)11)

#define OSAL_C_S32_IOCTRL_VOLT_GET_SYSTEM_VOLTAGE_LEVEL            ((tS32)12)
#define OSAL_C_S32_IOCTRL_VOLT_GET_CVM_VOLTAGE_LEVEL               ((tS32)13)
#define OSAL_C_S32_IOCTRL_VOLT_GET_USER_VOLTAGE_RANGE              ((tS32)14)

#define OSAL_C_S32_IOCTRL_VOLT_GET_BOARD_VOLTAGE                   ((tS32)15)
#define OSAL_C_S32_IOCTRL_VOLT_SET_BOARD_VOLTAGE_SCALE             ((tS32)16)
#define OSAL_C_S32_IOCTRL_VOLT_GET_BOARD_CURRENT                   ((tS32)17)
#define OSAL_C_S32_IOCTRL_VOLT_SET_BOARD_CURRENT_SCALE             ((tS32)18)
#define OSAL_C_S32_IOCTRL_VOLT_GET_BOARD_VOLTAGE_RAW               ((tS32)19)
#define OSAL_C_S32_IOCTRL_VOLT_SET_BOARD_VOLTAGE_UREF              ((tS32)20)
#define OSAL_C_S32_IOCTRL_VOLT_GET_BOARD_VOLTAGE_SCALE             ((tS32)21)
#define OSAL_C_S32_IOCTRL_VOLT_GET_BOARD_VOLTAGE_MV				   ((tS32)22)

/* system threshold states */
#define OSAL_VOLT_CRITICAL_LOW_VOLTAGE              0  /* system threshold ids          */
#define OSAL_VOLT_LOW_VOLTAGE                       1
#define OSAL_VOLT_OPERATING_VOLTAGE                 2
#define OSAL_VOLT_OVER_VOLTAGE                      3
#define OSAL_VOLT_CRITICAL_OVER_VOLTAGE             4

#define OSAL_VOLT_CVM_CRITICAL_LOW_VOLTAGE          5  /* system threshold ids          */
#define OSAL_VOLT_CVM_LOW_VOLTAGE                   6  /* which are calculated by the   */
#define OSAL_VOLT_CVM_OPERATING_VOLTAGE             7  /* cvm automaton                 */
#define OSAL_VOLT_CVM_OVER_VOLTAGE                  8
#define OSAL_VOLT_CVM_CRITICAL_OVER_VOLTAGE         9


/* events for user thresholds */
#define OSAL_VOLT_IDX_OVERRUN                       1
#define OSAL_VOLT_IDX_UNDERRUN						2
#define OSAL_VOLT_IDX_INRANGE                       3

/* kind of system thresholds: pure or cvm */
#define OSAL_VOLT_KIND_SYSTEM_THRESHOLDS            0
#define OSAL_VOLT_KIND_SYSTEM_CVM_THRESHOLDS        1

#define OSAL_VOLT_IDX_MAX_SYSTEM_THRESHOLD          10
#define OSAL_VOLT_IDX_MAX_USER_THRESHOLD            3


/* number of events buffered in queue */
#define OSAL_VOLT_MAX_SYSTEM_HISTORY                20
#define OSAL_VOLT_MAX_USER_HISTORY                  10

/* system threshold states returned for accesses via 

   OSAL_C_S32_IOCTRL_VOLT_GET_CVM_VOLTAGE_LEVEL         (one value)
   OSAL_C_S32_IOCTRL_VOLT_GET_CVM_VOLTAGE_LEVEL_HISTORY (array of values)
*/
enum
{
  OSALCVM_CRITICAL_LOW_VOLTAGE_START,
  OSALCVM_CRITICAL_LOW_VOLTAGE_END,
  OSALCVM_LOW_VOLTAGE_START,
  OSALCVM_LOW_VOLTAGE_END,
  OSALCVM_HIGH_VOLTAGE_START,
  OSALCVM_HIGH_VOLTAGE_END,
  OSALCVM_CRITICAL_HIGH_VOLTAGE_START,
  OSALCVM_CRITICAL_HIGH_VOLTAGE_END,
  OSALCVM_CRITICAL_LOW_VOLTAGE_AT_STARTUP
};


typedef struct
{
    tS32 idClient;                        /* client id from create client              */
    tS32 kind;                            /* pure system or cvm thresholds             */
    OSAL_tEventHandle hdl;                /* handle id of event                        */
    tU32 mask;                            /* events for each system event              */
} OSAL_tVoltSystemThresholdNotification;

typedef struct
{
    tS32 idClient;                        /* client id from create client              */
    tS32 idThreshold;                     /* id of this threshold                      */
    tS32 idGroup;                         /* id of the user threshold group            */
    OSAL_tEventHandle hdl;                /* handle id of event                        */
    tU32 mask;                            /* event for each user event                 */
    tU32 thresholdVoltage;                /* the threshold voltage in mV               */
    tU32 thresholdHysteresis;             /* hysteresis in mV                          */
} OSAL_tVoltUserThresholdNotification;

typedef struct
{
    tS32 idClient;                        /* client id from create client              */
    tS32 idThreshold;                     /* id of this threshold                      */
} OSAL_tVoltRemoveThresholdNotification;

typedef struct
{
    tU32 highestVoltage;                  /* highest recognizable voltage on adc in mV */
    tU32 lowestVoltage;                   /* lowest recognizable voltage on adc in mV  */
} OSAL_tVoltUserThresholdRange;


typedef struct 
{
    tS32 idClient;                        /* client id from create client              */
    tS32 kind;                            /* pure system or cvm thresholds             */
    tU8 arEvents[OSAL_VOLT_MAX_SYSTEM_HISTORY]; /* events that occurred                */
    tU32 idx;                             /* number of valid entries                   */
} OSAL_tVoltSystemThresholdHistory;


typedef struct
{
    tS32 idClient;                        /* client id from create client              */
	tS32 idThreshold;                     /* id of this threshold                      */
	tS32 idGroup;                         /* find the group items of the threshold     */
    tU8 arEvents[OSAL_VOLT_MAX_USER_HISTORY]; /* events that occurred                  */
	tU8 arClients[OSAL_VOLT_MAX_USER_HISTORY]; /* corresponding client ids             */
    tU32 idx;                             /* number of valid entries                   */
} OSAL_tVoltUserThresholdHistory;
//END--------------------------------------------------------------------

//BEGIN---------------OSAL-device DEV_VOLT (for Gen3) -------------------

//#define OSAL_C_S32_IOCTRL_VOLT_GET_BOARD_VOLTAGE                            ((tS32)15)  // IO-control already defined by Gen2 defines
#define OSAL_C_S32_IOCTRL_VOLT_REGISTER_CLIENT                                ((tS32)50)
#define OSAL_C_S32_IOCTRL_VOLT_UNREGISTER_CLIENT                              ((tS32)51)
#define OSAL_C_S32_IOCTRL_VOLT_REGISTER_SYSTEM_VOLTAGE_NOTIFICATION           ((tS32)52)
#define OSAL_C_S32_IOCTRL_VOLT_UNREGISTER_SYSTEM_VOLTAGE_NOTIFICATION         ((tS32)53)
#define OSAL_C_S32_IOCTRL_VOLT_REGISTER_USER_VOLTAGE_NOTIFICATION             ((tS32)54)
#define OSAL_C_S32_IOCTRL_VOLT_UNREGISTER_USER_VOLTAGE_NOTIFICATION           ((tS32)55)
#define OSAL_C_S32_IOCTRL_VOLT_GET_SYSTEM_VOLTAGE_STATE                       ((tS32)56)
#define OSAL_C_S32_IOCTRL_VOLT_GET_SYSTEM_VOLTAGE_HISTORY                     ((tS32)57)
#define OSAL_C_S32_IOCTRL_VOLT_GET_USER_VOLTAGE_STATE                         ((tS32)58)
#define OSAL_C_S32_IOCTRL_VOLT_INJECT_TTFIS_COMMAND                           ((tS32)59)

// Values of the below voltages is significant. Only change them if you know what you do.

#define DEV_VOLT_C_U32_SYSTEM_VOLTAGE_STATE_CRITICAL_LOW                       ((tU32)0)
#define DEV_VOLT_C_U32_SYSTEM_VOLTAGE_STATE_LOW                                ((tU32)2)
#define DEV_VOLT_C_U32_SYSTEM_VOLTAGE_STATE_OPERATING                          ((tU32)4)
#define DEV_VOLT_C_U32_SYSTEM_VOLTAGE_STATE_HIGH                               ((tU32)5)
#define DEV_VOLT_C_U32_SYSTEM_VOLTAGE_STATE_CRITICAL_HIGH                      ((tU32)6)

#define DEV_VOLT_C_STRING_NOTIFICATION_EVENT_PREFIX              "DevVoltNotify"
#define DEV_VOLT_C_STRING_NOTIFICATION_EVENT_POSTFIX_FORMAT      "%s%02u"
#define DEV_VOLT_C_U8_NOTIFICATION_EVENT_NAME_LENGTH             ((tU8)(sizeof(DEV_VOLT_C_STRING_NOTIFICATION_EVENT_PREFIX)+2))

#define DEV_VOLT_C_U32_CLIENT_ID_INVALID                              ((tU32)0xFFFFFFFF)

#define DEV_VOLT_C_U32_EVENT_MASK_SYSTEM_VOLTAGE_CHANGED_NOTIFY       ((tU32)0x00000001)
#define DEV_VOLT_C_U32_EVENT_MASK_USER_VOLTAGE_CHANGED_NOTIFY         ((tU32)0x00000002)
#define DEV_VOLT_C_U32_EVENT_MASK_PERMANENT_HIGH_VOLTAGE              ((tU32)0x00000004)
#define DEV_VOLT_C_U32_EVENT_MASK_PERMANENT_CRITICAL_HIGH_VOLTAGE     ((tU32)0x00000008)
#define DEV_VOLT_C_U32_EVENT_MASK_RESERVED_FOR_SERVER_5               ((tU32)0x00000010)
#define DEV_VOLT_C_U32_EVENT_MASK_RESERVED_FOR_SERVER_6               ((tU32)0x00000020)
#define DEV_VOLT_C_U32_EVENT_MASK_RESERVED_FOR_SERVER_7               ((tU32)0x00000040)
#define DEV_VOLT_C_U32_EVENT_MASK_RESERVED_FOR_SERVER_8               ((tU32)0x00000080)
#define DEV_VOLT_C_U32_EVENT_MASK_RESERVED_FOR_SERVER_9               ((tU32)0x00000100)
#define DEV_VOLT_C_U32_EVENT_MASK_RESERVED_FOR_SERVER_10              ((tU32)0x00000200)
#define DEV_VOLT_C_U32_EVENT_MASK_RESERVED_FOR_SERVER_11              ((tU32)0x00000400)
#define DEV_VOLT_C_U32_EVENT_MASK_RESERVED_FOR_SERVER_12              ((tU32)0x00000800)
#define DEV_VOLT_C_U32_EVENT_MASK_RESERVED_FOR_SERVER_13              ((tU32)0x00001000)
#define DEV_VOLT_C_U32_EVENT_MASK_RESERVED_FOR_SERVER_14              ((tU32)0x00002000)
#define DEV_VOLT_C_U32_EVENT_MASK_RESERVED_FOR_SERVER_15              ((tU32)0x00004000)
#define DEV_VOLT_C_U32_EVENT_MASK_RESERVED_FOR_SERVER_16              ((tU32)0x00008000)
#define DEV_VOLT_C_U32_EVENT_MASK_FREE_FOR_CLIENT_17                  ((tU32)0x00010000)
#define DEV_VOLT_C_U32_EVENT_MASK_FREE_FOR_CLIENT_18                  ((tU32)0x00020000)
#define DEV_VOLT_C_U32_EVENT_MASK_FREE_FOR_CLIENT_19                  ((tU32)0x00040000)
#define DEV_VOLT_C_U32_EVENT_MASK_FREE_FOR_CLIENT_20                  ((tU32)0x00080000)
#define DEV_VOLT_C_U32_EVENT_MASK_FREE_FOR_CLIENT_21                  ((tU32)0x00100000)
#define DEV_VOLT_C_U32_EVENT_MASK_FREE_FOR_CLIENT_22                  ((tU32)0x00200000)
#define DEV_VOLT_C_U32_EVENT_MASK_FREE_FOR_CLIENT_23                  ((tU32)0x00400000)
#define DEV_VOLT_C_U32_EVENT_MASK_FREE_FOR_CLIENT_24                  ((tU32)0x00800000)
#define DEV_VOLT_C_U32_EVENT_MASK_FREE_FOR_CLIENT_25                  ((tU32)0x01000000)
#define DEV_VOLT_C_U32_EVENT_MASK_FREE_FOR_CLIENT_26                  ((tU32)0x02000000)
#define DEV_VOLT_C_U32_EVENT_MASK_FREE_FOR_CLIENT_27                  ((tU32)0x04000000)
#define DEV_VOLT_C_U32_EVENT_MASK_FREE_FOR_CLIENT_28                  ((tU32)0x08000000)
#define DEV_VOLT_C_U32_EVENT_MASK_FREE_FOR_CLIENT_29                  ((tU32)0x10000000)
#define DEV_VOLT_C_U32_EVENT_MASK_FREE_FOR_CLIENT_30                  ((tU32)0x20000000)
#define DEV_VOLT_C_U32_EVENT_MASK_FREE_FOR_CLIENT_31                  ((tU32)0x40000000)
#define DEV_VOLT_C_U32_EVENT_MASK_FREE_FOR_CLIENT_32                  ((tU32)0x80000000)

#define DEV_VOLT_C_U32_BIT_MASK_INDICATE_CRITICAL_HIGH_VOLTAGE        ((tU32)0x00000001)
#define DEV_VOLT_C_U32_BIT_MASK_INDICATE_HIGH_VOLTAGE                 ((tU32)0x00000002)
#define DEV_VOLT_C_U32_BIT_MASK_INDICATE_LOW_VOLTAGE                  ((tU32)0x00000004)
#define DEV_VOLT_C_U32_BIT_MASK_INDICATE_CRITICAL_LOW_VOLTAGE         ((tU32)0x00000008)

#define DEV_VOLT_C_U8_USER_VOLTAGE_LEVEL_INVALID                               ((tU8)0)
#define DEV_VOLT_C_U8_USER_VOLTAGE_LEVEL_EXCEEDED                              ((tU8)1)
#define DEV_VOLT_C_U8_USER_VOLTAGE_LEVEL_DECEEDED                              ((tU8)2)

#define DEV_VOLT_C_U8_USER_VOLTAGE_CROSS_DIRECTION_INVALID                     ((tU8)0)
#define DEV_VOLT_C_U8_USER_VOLTAGE_CROSS_DIRECTION_UPWARD                      ((tU8)1)
#define DEV_VOLT_C_U8_USER_VOLTAGE_CROSS_DIRECTION_DOWNWARD                    ((tU8)2)

typedef struct
{
  tU32  u32ClientId;
  tChar szNotificationEventName[DEV_VOLT_C_U8_NOTIFICATION_EVENT_NAME_LENGTH];
} DEV_VOLT_trClientRegistration;

typedef struct
{
  tU32 u32ClientId;
  tU32 u32VoltageIndicationMask;
  tU32 u32CurrentSystemVoltageState;
  tU8  u8PermHighVoltageCounter;
  tU8  u8PermCriticalHighVoltageCounter;
} DEV_VOLT_trSystemVoltageRegistration;

typedef struct
{
  tU32 u32CriticalLowVoltageCounter;
  tU32 u32LowVoltageCounter;
  tU32 u32HighVoltageCounter;
  tU32 u32CriticalHighVoltageCounter;
  tU32 u32CurrentSystemVoltageState;
} DEV_VOLT_trSystemVoltage;

typedef struct
{
  tU32                     u32ClientId;
  DEV_VOLT_trSystemVoltage rSystemVoltage;
} DEV_VOLT_trSystemVoltageHistory;

typedef struct
{
  tU32 u32ClientId;
  tU16 u16UserVoltageLevelMv;
  tU16 u16HysteresisMv;
  tU8  u8LevelCrossDirection;
  tU8  u8UserVoltageState;
} DEV_VOLT_trUserVoltageRegistration;

typedef struct
{
  tU32 u32ClientId;
  tU16 u16UserVoltageLevelMv;
} DEV_VOLT_trUserVoltageDeregistration;

typedef struct
{
  tU32 u32ClientId;
  tU16 u16LatestCrossedUserVoltageLevelMv;
  tU8  u8LatestUserVoltageState;
} DEV_VOLT_trUserVoltage;

//END--------------------------------------------------------------------

/* @@@@ 01.04.2003 Ka: Added the following command s for KDS */
/* Control-Commands of KDS-access */
#define OSAL_C_S32_IOCTRL_KDS_INIT             ((tS32)1)
#define OSAL_C_S32_IOCTRL_KDS_WRITE_ENABLE     ((tS32)2)
#define OSAL_C_S32_IOCTRL_KDS_GET_ENTRY        ((tS32)3)
#define OSAL_C_S32_IOCTRL_KDS_GET_NEXT_ID      ((tS32)4)
#define OSAL_C_S32_IOCTRL_KDS_GET_PREV_ID      ((tS32)5)
#define OSAL_C_S32_IOCTRL_KDS_CHECK            ((tS32)6)
#define OSAL_C_S32_IOCTRL_KDS_INVALIDATE_ENTRY ((tS32)7)
#define OSAL_C_S32_IOCTRL_KDS_CLEAR            ((tS32)8)
#define OSAL_C_S32_IOCTRL_KDS_REMAIN           ((tS32)9)
#define OSAL_C_S32_IOCTRL_KDS_CALLBACK_REG     ((tS32)10)
#define OSAL_C_S32_IOCTRL_KDS_CALLBACK_UNREG   ((tS32)11)
#define OSAL_C_S32_IOCTRL_KDS_WRITE_BACK       ((tS32)12)
#define OSAL_C_S32_IOCTRL_KDS_COMPRESS         ((tS32)13)

typedef void (*OSAL_trKdsCallback)( tU16 u16EntryId );


/* @@@@ 17.05.2003 Ka: Added the following commands for ERRMEM */
/* Control-Commands of ERRMEM-access */
#define OSAL_C_S32_IOCTRL_ERRMEM_CHECK         ((tS32)1)
#define OSAL_C_S32_IOCTRL_ERRMEM_CLEAR         ((tS32)2)
#define OSAL_C_S32_IOCTRL_ERRMEM_COMPRESS      ((tS32)3)
#define OSAL_C_S32_IOCTRL_ERRMEM_REGISTER      ((tS32)4)
#define OSAL_C_S32_IOCTRL_ERRMEM_UNREGISTER    ((tS32)5)
#define OSAL_C_S32_IOCTRL_ERRMEM_SET_BE        ((tS32)6)
#define OSAL_C_S32_IOCTRL_ERRMEM_STOP_BE       ((tS32)7)
#define OSAL_C_S32_IOCTRL_ERRMEM_FLUSH         ((tS32)8)
#define OSAL_C_S32_IOCTRL_ERRMEM_SET_LOGLEVEL  ((tS32)9)


/* Control-Commands of PERF-access */
#define OSAL_C_S32_IOCTRL_PERF_CHECK           ((tS32)1)

/* --Special USB defines and parameters. */

#define OSAL_C_S32_IOCTRL_USB_WRITE_BREAKTIME_SET   ((tS32)1)
#define OSAL_C_S32_IOCTRL_USB_READ_BREAKTIME_SET    ((tS32)2)
#define OSAL_C_S32_IOCTRL_USB_LINK_STATUS_CHECK     ((tS32)3)
#define OSAL_C_S32_IOCTRL_USB_LINK_STATUS_WAIT      ((tS32)4)
#define OSAL_C_S32_IOCTRL_USB_FILE_COMPLETE         ((tS32)5)
#define OSAL_C_S32_IOCTRL_USB_FILE_ABORT            ((tS32)6)
#define OSAL_C_S32_IOCTRL_USB_FLASH_COMPLETE        ((tS32)7)
#define OSAL_C_S32_IOCTRL_USB_FLASH_ERROR           ((tS32)8)
#define OSAL_C_S32_IOCTRL_USB_FLASH_PROGRESS        ((tS32)9)
#define OSAL_C_S32_IOCTRL_USB_ALL_COMPLETE          ((tS32)10)
#define OSAL_C_S32_IOCTRL_USB_BOARD_ID              ((tS32)11)
#define OSAL_C_S32_IOCTRL_USB_FOPEN                 ((tS32)12)
#define OSAL_C_S32_IOCTRL_USB_FREAD                 ((tS32)13)
#define OSAL_C_S32_IOCTRL_USB_FWRITE                ((tS32)14)
#define OSAL_C_S32_IOCTRL_USB_FSEEK                 ((tS32)15)
#define OSAL_C_S32_IOCTRL_USB_FCLOSE                ((tS32)16)
#define OSAL_C_S32_IOCTRL_USB_RAW                   ((tS32)17)

#define OSAL_C_S32_USB_EP12                     ((tS32)1)
#define OSAL_C_S32_USB_EP54                     ((tS32)2)
#define OSAL_C_S32_USB_EP76                     ((tS32)3)
#define OSAL_C_S32_USB_BUFFERSIZE               ((tS32)1024)

/* Flash  IOCTRL fx parameters */
#define OSAL_C_S32_IOCTRL_FLASH_WRITEDAT       ((tS32)1)
#define OSAL_C_S32_IOCTRL_FLASH_READDAT        ((tS32)2)
#define OSAL_C_S32_IOCTRL_FLASH_ERASE          ((tS32)3)
#define OSAL_C_S32_IOCTRL_FLASH_GETINFO        ((tS32)4)
#define OSAL_C_S32_IOCTRL_FLASH_OPEN           ((tS32)5)
#define OSAL_C_S32_IOCTRL_FLASH_CLOSE          ((tS32)6)

/* Acousticout */
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_EXTWRITE             ((tS32)1)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_REG_NOTIFICATION     ((tS32)2)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_WAITEVENT            ((tS32)3)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_SETWRITEINFO         ((tS32)4)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_GETSUPP_DECODER      ((tS32)5)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_NEXTNEEDEDDECODER    ((tS32)6)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_GETDECODER           ((tS32)7)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_SETDECODER           ((tS32)8)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_GETSUPP_SAMPLERATE   ((tS32)9)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_GETSAMPLERATE        ((tS32)10)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_SETSAMPLERATE        ((tS32)11)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_GETSUPP_SAMPLEFORMAT ((tS32)12)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_GETSAMPLEFORMAT      ((tS32)13)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_SETSAMPLEFORMAT      ((tS32)14)	
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_GETSUPP_CHANNELS     ((tS32)15)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_GETCHANNELS          ((tS32)16)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_SETCHANNELS          ((tS32)17)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_GETSUPP_BUFFERSIZE   ((tS32)18)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_GETBUFFERSIZE        ((tS32)19)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_SETBUFFERSIZE        ((tS32)20)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_SETERRTHR            ((tS32)21)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_GETTIME              ((tS32)22)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_SETTIME              ((tS32)23)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_START                ((tS32)24)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_STOP                 ((tS32)25)		
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_ABORT                ((tS32)26)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_PAUSE                ((tS32)27)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_GETBITRATE           ((tS32)28)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_REG_LOANBUFFER_CALLBACK ((tS32)29)
#define OSAL_C_S32_IOCTRL_ACOUSTICOUT_WRITE_LOANED_BUFFER ((tS32)30)

/* Acousticin*/
#define OSAL_C_S32_IOCTRL_ACOUSTICIN_EXTREAD               ((tS32)1)
#define OSAL_C_S32_IOCTRL_ACOUSTICIN_REG_NOTIFICATION      ((tS32)2)
#define OSAL_C_S32_IOCTRL_ACOUSTICIN_WAITEVENT             ((tS32)3)
#define OSAL_C_S32_IOCTRL_ACOUSTICIN_GETSUPP_SAMPLERATE    ((tS32)4)
#define OSAL_C_S32_IOCTRL_ACOUSTICIN_GETSAMPLERATE         ((tS32)5)
#define OSAL_C_S32_IOCTRL_ACOUSTICIN_SETSAMPLERATE	        ((tS32)6)
#define OSAL_C_S32_IOCTRL_ACOUSTICIN_GETSUPP_SAMPLEFORMAT  ((tS32)7)
#define OSAL_C_S32_IOCTRL_ACOUSTICIN_GETSAMPLEFORMAT       ((tS32)8)
#define OSAL_C_S32_IOCTRL_ACOUSTICIN_SETSAMPLEFORMAT       ((tS32)9)
#define OSAL_C_S32_IOCTRL_ACOUSTICIN_GETSUPP_CHANNELS	     ((tS32)10)
#define OSAL_C_S32_IOCTRL_ACOUSTICIN_GETCHANNELS           ((tS32)11)
#define OSAL_C_S32_IOCTRL_ACOUSTICIN_SETCHANNELS           ((tS32)12)
#define OSAL_C_S32_IOCTRL_ACOUSTICIN_GETSUPP_BUFFERSIZE	  ((tS32)13)
#define OSAL_C_S32_IOCTRL_ACOUSTICIN_GETBUFFERSIZE	        ((tS32)14)
#define OSAL_C_S32_IOCTRL_ACOUSTICIN_SETBUFFERSIZE		     ((tS32)15)
#define OSAL_C_S32_IOCTRL_ACOUSTICIN_SETERRTHR             ((tS32)16)
#define OSAL_C_S32_IOCTRL_ACOUSTICIN_START                 ((tS32)17)
#define OSAL_C_S32_IOCTRL_ACOUSTICIN_STOP                  ((tS32)18)
#define OSAL_C_S32_IOCTRL_ACOUSTICIN_ABORT                 ((tS32)19)	   
#define OSAL_C_S32_IOCTRL_ACOUSTICIN_PAUSE                 ((tS32)20)
#define OSAL_C_S32_IOCTRL_ACOUSTICIN_SET_FILTER_COEF       ((tS32)21)

/*AcousticSrc*/
#define OSAL_C_S32_IOCTRL_ACOUSTICSRC_CONVERT             ((tS32)1)
#define OSAL_C_S32_IOCTRL_ACOUSTICSRC_REG_NOTIFICATION     ((tS32)2)
#define OSAL_C_S32_IOCTRL_ACOUSTICSRC_WAITEVENT            ((tS32)3)
#define OSAL_C_S32_IOCTRL_ACOUSTICSRC_GETFILEPATH			((tS32)4)
#define OSAL_C_S32_IOCTRL_ACOUSTICSRC_GETSUPP_DECODER      ((tS32)5)
#define OSAL_C_S32_IOCTRL_ACOUSTICSRC_GETDECODER           ((tS32)6)
#define OSAL_C_S32_IOCTRL_ACOUSTICSRC_GETSUPP_SAMPLERATE   ((tS32)7)
#define OSAL_C_S32_IOCTRL_ACOUSTICSRC_GETSAMPLERATE        ((tS32)8)
#define OSAL_C_S32_IOCTRL_ACOUSTICSRC_SETSAMPLERATE        ((tS32)9)
#define OSAL_C_S32_IOCTRL_ACOUSTICSRC_GETSUPP_SAMPLEFORMAT ((tS32)10)
#define OSAL_C_S32_IOCTRL_ACOUSTICSRC_GETSAMPLEFORMAT      ((tS32)11)
#define OSAL_C_S32_IOCTRL_ACOUSTICSRC_SETSAMPLEFORMAT      ((tS32)12)	
#define OSAL_C_S32_IOCTRL_ACOUSTICSRC_GETSUPP_CHANNELS     ((tS32)13)
#define OSAL_C_S32_IOCTRL_ACOUSTICSRC_GETCHANNELS          ((tS32)14)
#define OSAL_C_S32_IOCTRL_ACOUSTICSRC_SETCHANNELS          ((tS32)15)
#define OSAL_C_S32_IOCTRL_ACOUSTICSRC_GETSUPP_BUFFERSIZE   ((tS32)16)
#define OSAL_C_S32_IOCTRL_ACOUSTICSRC_GETBUFFERSIZE        ((tS32)17)
#define OSAL_C_S32_IOCTRL_ACOUSTICSRC_SETBUFFERSIZE        ((tS32)18)
#define OSAL_C_S32_IOCTRL_ACOUSTICSRC_SETERRTHR            ((tS32)19)
#define OSAL_C_S32_IOCTRL_ACOUSTICSRC_START                ((tS32)20)
#define OSAL_C_S32_IOCTRL_ACOUSTICSRC_STOP                 ((tS32)21)		
#define OSAL_C_S32_IOCTRL_ACOUSTICSRC_ABORT                ((tS32)22)

/* Acousticecnr*/
#define OSAL_C_S32_IOCTRL_ACOUSTICECNR_EXTREAD               ((tS32)1)
#define OSAL_C_S32_IOCTRL_ACOUSTICECNR_REG_NOTIFICATION      ((tS32)2)
#define OSAL_C_S32_IOCTRL_ACOUSTICECNR_WAITEVENT             ((tS32)3)
#define OSAL_C_S32_IOCTRL_ACOUSTICECNR_GETSUPP_SAMPLERATE    ((tS32)4)
#define OSAL_C_S32_IOCTRL_ACOUSTICECNR_GETSAMPLERATE         ((tS32)5)
#define OSAL_C_S32_IOCTRL_ACOUSTICECNR_SETSAMPLERATE	        ((tS32)6)
#define OSAL_C_S32_IOCTRL_ACOUSTICECNR_GETSUPP_SAMPLEFORMAT  ((tS32)7)
#define OSAL_C_S32_IOCTRL_ACOUSTICECNR_GETSAMPLEFORMAT       ((tS32)8)
#define OSAL_C_S32_IOCTRL_ACOUSTICECNR_SETSAMPLEFORMAT       ((tS32)9)
#define OSAL_C_S32_IOCTRL_ACOUSTICECNR_GETSUPP_CHANNELS	     ((tS32)10)
#define OSAL_C_S32_IOCTRL_ACOUSTICECNR_GETCHANNELS           ((tS32)11)
#define OSAL_C_S32_IOCTRL_ACOUSTICECNR_SETCHANNELS           ((tS32)12)
#define OSAL_C_S32_IOCTRL_ACOUSTICECNR_GETSUPP_BUFFERSIZE	  ((tS32)13)
#define OSAL_C_S32_IOCTRL_ACOUSTICECNR_GETBUFFERSIZE	        ((tS32)14)
#define OSAL_C_S32_IOCTRL_ACOUSTICECNR_SETBUFFERSIZE		     ((tS32)15)
#define OSAL_C_S32_IOCTRL_ACOUSTICECNR_SETERRTHR             ((tS32)16)
#define OSAL_C_S32_IOCTRL_ACOUSTICECNR_START                 ((tS32)17)
#define OSAL_C_S32_IOCTRL_ACOUSTICECNR_STOP                  ((tS32)18)
#define OSAL_C_S32_IOCTRL_ACOUSTICECNR_ABORT                 ((tS32)19)	   
#define OSAL_C_S32_IOCTRL_ACOUSTICECNR_PAUSE                 ((tS32)20)
#define OSAL_C_S32_IOCTRL_ACOUSTICECNR_SET_FILTER_COEF       ((tS32)21)


/* CRADLE */
#define OSAL_C_S32_IOCTRL_CRDL_SET_CALLBACK_KEY_STATE      ((tS32)1)
#define OSAL_C_S32_IOCTRL_CRDL_SET_CALLBACK_DIAG_STATE     ((tS32)2)
#define OSAL_C_S32_IOCTRL_CRDL_SET_CALLBACK_CRADLE_STATE   ((tS32)3)
#define OSAL_C_S32_IOCTRL_CRDL_GET_KEY_STATE               ((tS32)4)
#define OSAL_C_S32_IOCTRL_CRDL_GET_DIAG_STATE              ((tS32)5)
#define OSAL_C_S32_IOCTRL_CRDL_GET_CRADLE_STATE            ((tS32)6)


/* GPIO  */
#define OSAL_C_32_IOCTRL_GPIO_SET_INPUT                    ((tS32)1)
#define OSAL_C_32_IOCTRL_GPIO_SET_OUTPUT                   ((tS32)2)
#define OSAL_C_32_IOCTRL_GPIO_SET_EDGE                     ((tS32)3)
#define OSAL_C_32_IOCTRL_GPIO_ENABLE_INT                   ((tS32)4)
#define OSAL_C_32_IOCTRL_GPIO_SET_CALLBACK                 ((tS32)5)
#define OSAL_C_32_IOCTRL_GPIO_SET_STATE                    ((tS32)6)
#define OSAL_C_32_IOCTRL_GPIO_GET_STATE                    ((tS32)7)
#define OSAL_C_32_IOCTRL_GPIO_ENABLE_TESTMODE              ((tS32)8)
#define OSAL_C_32_IOCTRL_GPIO_GET_TESTMODE                 ((tS32)9)
#define OSAL_C_32_IOCTRL_GPIO_ADD_TESTMODE_PIN             ((tS32)10)
#define OSAL_C_32_IOCTRL_GPIO_CLEAR_TESTMODE_PINS          ((tS32)11)
#define OSAL_C_32_IOCTRL_GPIO_SET_OUTPUT_LOW               ((tS32)12)
#define OSAL_C_32_IOCTRL_GPIO_SET_OUTPUT_HIGH              ((tS32)13)
#define OSAL_C_32_IOCTRL_GPIO_SET_TRIGGER                  ((tS32)14)
#define OSAL_C_32_IOCTRL_GPIO_IS_STATE_ACTIVE              ((tS32)15)
#define OSAL_C_32_IOCTRL_GPIO_SET_ACTIVE_STATE             ((tS32)16)
#define OSAL_C_32_IOCTRL_GPIO_SET_INACTIVE_STATE           ((tS32)17)
#define OSAL_C_32_IOCTRL_GPIO_SET_OUTPUT_ACTIVE            ((tS32)18)
#define OSAL_C_32_IOCTRL_GPIO_SET_OUTPUT_INACTIVE          ((tS32)19)


/* Timer (PWM) */
# define OSAL_C_S32_IOCTRL_TIMER_SET_PWM                             ((tS32) 1)
# define OSAL_C_S32_IOCTRL_TIMER_GET_PWM                             ((tS32) 2)
# define OSAL_C_S32_IOCTRL_TIMER_SET_FRQ                             ((tS32) 3)
# define OSAL_C_S32_IOCTRL_TIMER_GET_FRQ                             ((tS32) 4)
# define OSAL_C_S32_IOCTRL_TIMER_RADIOUNIT_DELAY_MICSEC              ((tS32) 5)
# define OSAL_C_S32_IOCTRL_TIMER_NOTIFY_FREQUENCY_CHANGE             ((tS32) 6)
# define OSAL_C_S32_IOCTRL_TIMER_FREQUENCY_CHANGE_NOTIFICATION_RANGE ((tS32) 7)
# define OSAL_C_S32_IOCTRL_TIMER_GET_DUTYCYCLE                       ((tS32) 8)
# define OSAL_C_S32_IOCTRL_TIMER_NOTIFY_DUTYCYCLE_CHANGE             ((tS32) 9)
# define OSAL_C_S32_IOCTRL_TIMER_DUTYCYCLE_CHANGE_NOTIFICATION_RANGE ((tS32) 10)

/* Frequency change notification callback function */
typedef void (*OSAL_tpfFreqChangeFun)( tU32 u32OldFrequency, tU32 u32NewFrequency );
typedef void (*OSAL_tpfDutyCycleChangeFun)( tU32 u32OldDutyCycle, 
                                           tU32 u32NewDutycycle, 
                                           tU32 u32CurrFrequency );


/* == dev_sysctrl ==  */
/* = battery flags =  */
/* battery level */
#define OSAL_C_SYSCTRL_BAT_LEVEL_4     0x0004
#define OSAL_C_SYSCTRL_BAT_LEVEL_3     0x0003
#define OSAL_C_SYSCTRL_BAT_LEVEL_2     0x0002
#define OSAL_C_SYSCTRL_BAT_LEVEL_1     0x0001
#define OSAL_C_SYSCTRL_BAT_HIGH        0x0003
#define OSAL_C_SYSCTRL_BAT_MIDDLE      0x0002
#define OSAL_C_SYSCTRL_BAT_LOW         0x0001
#define OSAL_C_SYSCTRL_BAT_CRITICAL    0x0000
/* battery status */
#define OSAL_C_SYSCTRL_BAT_FULLCHARGED 0x0200
#define OSAL_C_SYSCTRL_BAT_CHARGING    0x0100
#define OSAL_C_SYSCTRL_BAT_ONLY        0x0000
#define OSAL_C_SYSCTRL_BAT_CRITICAL    0x0000

/* unknown battery level and state */
#define OSAL_C_SYSCTRL_BAT_UNKNOWN     0xFFFF

/* card flags */
#define OSAL_C_SYSCTRL_CARD_EJECTED       0x00
#define OSAL_C_SYSCTRL_CARD_INSERTED      0x01
#define OSAL_C_SYSCTRL_CARD_READY         0x02
#define OSAL_C_SYSCTRL_CARD_NOT_READY     0x04

#if OSAL_OS==OSAL_WINNT
/* system state flags */
/*rar6kor - the following is required by Sysctrl Simulator which is a part 
of Osalbench. This is only applicable to Windows XP/2000/NT builds.
Here, the System State can be changed using Osalbench-Sysctrl device simulator*/
#define OSAL_C_SYSCTRL_SYSTEM_STATE_NORMAL       0x00
#define OSAL_C_SYSCTRL_SYSTEM_STATE_PAUSE      0x01
#define OSAL_C_SYSCTRL_SYSTEM_STATE_OFF         0x02
#endif

/* volume flags */
#define OSAL_C_SYSCTRL_VOLUME_DOWN        0
#define OSAL_C_SYSCTRL_VOLUME_UP          1

/* audio channel id's */
#define OSAL_C_SYSCTRL_AUDIOCHAN_BT_HF       0     // Bluetooth HF
#define OSAL_C_SYSCTRL_AUDIOCHAN_VOIP        1     // VOIP
#define OSAL_C_SYSCTRL_AUDIOCHAN_NAV         2     // Navigation Voice Guidance    
#define OSAL_C_SYSCTRL_AUDIOCHAN_AUDIOPLAYER 3     // Audio Player
#define OSAL_C_SYSCTRL_AUDIOCHAN_VIDEOPLAYER 4     // Video Player (Audio Signal)
#define OSAL_C_SYSCTRL_AUDIOCHAN_BT_A2DP     5     // Bluetooth A2DP sink
#define OSAL_C_SYSCTRL_AUDIOCHAN_DVBT        6     // DVB-T (Audio Signal)
#define OSAL_C_SYSCTRL_AUDIOCHAN_VOICEREC    7     // Voice Recorder
#define OSAL_C_SYSCTRL_AUDIOCHAN_UNDEFINE    8     // undefine audio source

/* notification flags */
#define OSAL_C_SYSCTRL_NOTIFY_BATTERY     0x0001
#define OSAL_C_SYSCTRL_NOTIFY_CARD        0x0002                
#define OSAL_C_SYSCTRL_NOTIFY_VOLUME      0x0004
#define OSAL_C_SYSCTRL_NOTIFY_LANGUAGE    0x0008
#define OSAL_C_SYSCTRL_NOTIFY_FACTORYMODE 0x0010
#define OSAL_C_SYSCTRL_NOTIFY_DAYLIGHT    0x0020
#define OSAL_C_SYSCTRL_NOTIFY_CLOCK       0x0040
#define OSAL_C_SYSCTRL_NOTIFY_MUTE        0x0080   // TRUE or FALSE
#define OSAL_C_SYSCTRL_NOTIFY_SHOW        0x0200   // TRUE or FALSE


#if OSAL_OS==OSAL_WINNT
/*rar6kor - the following is required by Sysctrl Simulator which is a part 
of Osalbench. This is only applicable to Windows XP/2000/NT builds.
Here, the System State can be changed using Osalbench-Sysctrl device simulator*/
#define OSAL_C_SYSCTRL_NOTIFY_SYSTEM_STATE        0x0100   
#define OSAL_C_SYSCTRL_NOTIFY_ALL         ( OSAL_C_SYSCTRL_NOTIFY_BATTERY | \
                                            OSAL_C_SYSCTRL_NOTIFY_CARD | \
                                            OSAL_C_SYSCTRL_NOTIFY_VOLUME | \
                                            OSAL_C_SYSCTRL_NOTIFY_LANGUAGE | \
                                            OSAL_C_SYSCTRL_NOTIFY_DAYLIGHT | \
                                            OSAL_C_SYSCTRL_NOTIFY_CLOCK | \
                                            OSAL_C_SYSCTRL_NOTIFY_FACTORYMODE | \
                                            OSAL_C_SYSCTRL_NOTIFY_MUTE |\
											OSAL_C_SYSCTRL_NOTIFY_SYSTEM_STATE)

#else
#define OSAL_C_SYSCTRL_NOTIFY_ALL         ( OSAL_C_SYSCTRL_NOTIFY_BATTERY | \
                                            OSAL_C_SYSCTRL_NOTIFY_CARD | \
                                            OSAL_C_SYSCTRL_NOTIFY_VOLUME | \
                                            OSAL_C_SYSCTRL_NOTIFY_LANGUAGE | \
                                            OSAL_C_SYSCTRL_NOTIFY_DAYLIGHT | \
                                            OSAL_C_SYSCTRL_NOTIFY_CLOCK | \
                                            OSAL_C_SYSCTRL_NOTIFY_FACTORYMODE | \
                                            OSAL_C_SYSCTRL_NOTIFY_MUTE |\
                                            OSAL_C_SYSCTRL_NOTIFY_SHOW)
#endif

/* notification callback function */
typedef void (*OSAL_tpSysCtrlFun)( tU32 u32Event, tS32 s32Value, tPVoid pvArg);

#define OSAL_C_U32_MAX_PATHLENGTH               ((tU32)256)

#define OSAL_C_U32_OS_PATHLENGTH_OFFSET         ((tU32)64)

typedef struct{
   char cErgFilePath[OSAL_C_U32_MAX_PATHLENGTH];
   char cKeyName[OSAL_C_U32_MAX_NAMELENGTH];
   tU32 u32ResultType;
   tS32 u32ResultValue;
   char cResultString[OSAL_C_U32_MAX_NAMELENGTH];
}OSAL_trErgReq;


/* mount information */
typedef struct _trMountPoint
{
   tChar szDevice[ OSAL_C_U32_MAX_NAMELENGTH];
   tChar szMountPoint[ OSAL_C_U32_MAX_PATHLENGTH];
} OSAL_trMountPoint;

typedef struct _trSysCtrlMsg
{
   tU32 u32Msg;
   tU32 u32WParam;
   tU32 u32LParam;
} OSAL_trSysCtrlMsg;

/* PND audio management interface */
typedef struct _trSysCtrlAudioIF
{
   tPVoid hChan;
   tU32 u32ChannelID;
   tBool bSetVolume;
   tU32 u32Timeout;
} OSAL_trSysCtrlAudioIF;

/* OS event notification */
typedef struct _trSysCtrlNotify
{
   tU32 u32Mask;
   tPVoid pvArg;
   OSAL_tpSysCtrlFun pFun;
} OSAL_trSysCtrlNotify;

/* OS local time information */
typedef struct _trSysCtrlClockInfo
{
   tS32 s32Bias;
   tS32 s32DaylightBias;
   tBool bClockFormat;
} OSAL_trSysCtrlClockInfo;

/* dynamic library info */
typedef struct
{
   tCString coszName;
   tPVoid   pvHandle;
   tInt   (*pSymbol)(tVoid);
} OSAL_trSysCtrlDynLibInfo;
/* end of dev_sysctrl */


/* == dev_tmc == */
/* notification flags */
#define OSAL_C_TMC_NOTIFY_TMCDATA     0x01
#define OSAL_C_TMC_NOTIFY_TMCLOCKED   0x02                
#define OSAL_C_TMC_NOTIFY_FREQCHANGE  0x04                
#define OSAL_C_TMC_NOTIFY_ALL         (OSAL_C_TMC_NOTIFY_TMCDATA | OSAL_C_TMC_NOTIFY_TMCLOCKED | OSAL_C_TMC_NOTIFY_FREQCHANGE)  /* UH  Remove Lint 773 */

/* device operational states */
#define OSAL_C_TMC_STATE_SUSPEND      0x01
#define OSAL_C_TMC_STATE_SEARCHING    0x02
#define OSAL_C_TMC_STATE_SCANNING     0x03
#define OSAL_C_TMC_STATE_LOCKED       0x04

/* notification callback function */
typedef void (*OSAL_tpTmcFun)( tU32, tPVoid );

/* tmc message */
typedef struct _trTMCData
{
   tU16 u16RDSB;
   tU16 u16RDSC;
   tU16 u16RDSD;
} OSAL_trTmcData;

/* register notification object */
typedef struct _trTmcNotify
{
   tU32 u32Mask;
   OSAL_tpTmcFun pFun;
} OSAL_trTmcNotify;
/* end of dev_tmc */

/* == dev_tsd == */

/* notification flags */
#define OSAL_C_TSD_NOTIFY_SPEEDLIMIT            0x01
#define OSAL_C_TSD_NOTIFY_NOOVERTAKING          0x02 /* not supported atm */
#define OSAL_C_TSD_NOTIFY_ALL                   (OSAL_C_TSD_NOTIFY_SPEEDLIMIT | OSAL_C_TSD_NOTIFY_NOOVERTAKING)  /* UH  Remove Lint 773 */

/* notification callback function */
typedef void (*OSAL_tpTsdFun)( tU32 u32Mask, tS32 s32SignValue, tS32 s32SignGoodness, tPVoid pvCustom);

/* register notification object */
typedef struct _trTsdNotify
{
    tU32            u32Mask;    /* notification mask */
    OSAL_tpTsdFun   pFun;       /* callback function */
    tPVoid          pvCustom;   /* custom pointer (e.g. class pointer) */
} OSAL_trTsdNotify;

/* end of dev_tsd */


/* == dev_vnv == */
/* notification callback function */
typedef OSAL_tpTmcFun OSAL_tpVnvFun;
/* register notification object */
typedef OSAL_trTmcNotify OSAL_trVnvNotify;
/* end of dev_vnv */


/* == Panasonic CDC == */

/* typedefs */

typedef struct
{
   tU8 u8CDCMessage[7]; /* Play and TOC data of the Pansonic CDC */
   tU8 u8CDCState;      /* State of the CDC and driver. */
} OSAL_trCDCMessage;    /* structure for the callbackfunction */

typedef void (*OSAL_trPanaCdcCallback)( OSAL_trCDCMessage *ptrMessage );

/* defines of the IOCTRLs */
#define OSAL_C_S32_IOCTRL_PANACDC_CMD_TX                   ((tS32)1)
#define OSAL_C_S32_IOCTRL_PANACDC_CMD_PWR_ON               ((tS32)2)
#define OSAL_C_S32_IOCTRL_PANACDC_CMD_PWR_OFF              ((tS32)3)
#define OSAL_C_S32_IOCTRL_PANACDC_CMD_REGISTER             ((tS32)4)
#define OSAL_C_S32_IOCTRL_PANACDC_CMD_UNREGISTER           ((tS32)5)


/* state bits of the structure member OSAL_trCDCMessage.u8CDCState */
#define OSAL_C_U8_CDC_NORMAL_OPERATION          ((tU8) 0x00)
#define OSAL_C_U8_CDC_WAITING_AFTER_POWER_ON    ((tU8) 0x01)
#define OSAL_C_U8_CDC_UNDERVOLTAGE              ((tU8) 0x02)
#define OSAL_C_U8_CDC_CHANGER_OVERCURRENT       ((tU8) 0x04)
#define OSAL_C_U8_CDC_WRONG_MESSAGE             ((tU8) 0x08)
#define OSAL_C_U8_CDC_BUFFER_OVERFLOW           ((tU8) 0x10)
#define OSAL_C_U8_CDC_NO_COMMUNICATION_FOR_10s  ((tU8) 0x20)
#define OSAL_C_U8_CDC_POWER_OFF                 ((tU8) 0x40)
#define OSAL_C_U8_CDC_COMMUNICATION_GAP         ((tU8) 0x80)

/* Commands send to the CDC */
#define OSAL_C_S32_PANACDC_REPEAT              ((tS32) 5)
#define OSAL_C_S32_PANACDC_SCAN_IN_A_DISC      ((tS32) 6)
#define OSAL_C_S32_PANACDC_DISC_SHUFFLE        ((tS32) 7)
#define OSAL_C_S32_PANACDC_MAGAZIN_SHUFFLE     ((tS32) 8)
#define OSAL_C_S32_PANACDC_STOP                ((tS32) 9)
#define OSAL_C_S32_PANACDC_DISC_REPEAT         ((tS32) 10)
#define OSAL_C_S32_PANACDC_SCAN_ALL            ((tS32) 12)
#define OSAL_C_S32_PANACDC_PAUSE               ((tS32) 13)
#define OSAL_C_S32_PANACDC_DISC_SCAN           ((tS32) 14)
#define OSAL_C_S32_PANACDC_RECALL              ((tS32) 15)
#define OSAL_C_S32_PANACDC_DISP                ((tS32) 16)
#define OSAL_C_S32_PANACDC_PLAY                ((tS32) 17)
#define OSAL_C_S32_PANACDC_RANDOM1             ((tS32) 18)
#define OSAL_C_S32_PANACDC_RANDOM_ALL          ((tS32) 19)
#define OSAL_C_S32_PANACDC_M_PLAY              ((tS32) 20)
#define OSAL_C_S32_PANACDC_PROGRAMM            ((tS32) 21)
#define OSAL_C_S32_PANACDC_TRACK_SEARCH_DOWN   ((tS32) 22)
#define OSAL_C_S32_PANACDC_TRACK_SEARCH_UP     ((tS32) 23)
#define OSAL_C_S32_PANACDC_MEMO                ((tS32) 24)
#define OSAL_C_S32_PANACDC_DISC_DOWN           ((tS32) 25)
#define OSAL_C_S32_PANACDC_REPEAT_RANDOM       ((tS32) 26)
#define OSAL_C_S32_PANACDC_SEARCH_DOWN         ((tS32) 27)
#define OSAL_C_S32_PANACDC_SEARCH_UP           ((tS32) 28)
#define OSAL_C_S32_PANACDC_DISC_UP             ((tS32) 29)
#define OSAL_C_S32_PANACDC_PLAY_PAUSE          ((tS32) 30)
#define OSAL_C_S32_PANACDC_TRACK_DOWN          ((tS32) 31)
#define OSAL_C_S32_PANACDC_TRACK_UP            ((tS32) 32)
#define OSAL_C_S32_PANACDC_DEMAND_TOC_DATA     ((tS32) 70)
#define OSAL_C_S32_PANACDC_DEMAND_TOC_READ     ((tS32) 71)
#define OSAL_C_S32_PANACDC_PLAY2               ((tS32) 72)
#define OSAL_C_S32_PANACDC_NOP_NULL            ((tS32) 73)
#define OSAL_C_S32_PANACDC_AUTO_PAUSE          ((tS32) 74)
#define OSAL_C_S32_PANACDC_10KEY_1             ((tS32) 81)
#define OSAL_C_S32_PANACDC_10KEY_2             ((tS32) 82)
#define OSAL_C_S32_PANACDC_10KEY_3             ((tS32) 83)
#define OSAL_C_S32_PANACDC_10KEY_4             ((tS32) 84)
#define OSAL_C_S32_PANACDC_10KEY_5             ((tS32) 85)
#define OSAL_C_S32_PANACDC_10KEY_6             ((tS32) 86)
#define OSAL_C_S32_PANACDC_10KEY_7             ((tS32) 87)
#define OSAL_C_S32_PANACDC_10KEY_8             ((tS32) 88)
#define OSAL_C_S32_PANACDC_10KEY_9             ((tS32) 89)
#define OSAL_C_S32_PANACDC_10KEY_10            ((tS32) 90)

/**************************************************************************/
/* typedefs                                                               */
/**************************************************************************/

/*----------------------------- SPI --------------------------------------*/
/* defines for u8Id */
#define OSAL_C_U8_SPI_ID_1      ((tU8) 0)
#define OSAL_C_U8_SPI_ID_2      ((tU8) 1)
#define OSAL_C_U8_SPI_ID_3      ((tU8) 2)
#define OSAL_C_U8_SPI_ID_4      ((tU8) 3)

/* defines for u8Phase */
#define OSAL_C_U8_SPI_PHASE_FIRST_EDGE   0x00
#define OSAL_C_U8_SPI_PHASE_SECOND_EDGE  0x01

/* defines for u8Pol */
#define OSAL_C_U8_SPI_POL_LOW       0x00
#define OSAL_C_U8_SPI_POL_HIGH      0x01

/* defines for u8Div */
#define OSAL_C_U8_SPI_DIV_MIN       0x00
#define OSAL_C_U8_SPI_DIV_MAX       0x0c

/* defines for u8Mode */
//#define OSAL_C_U8_SPI_MODE_SLAVE    0x00
#define OSAL_C_U8_SPI_MODE_MASTER   0x01

typedef struct _OSAL_trSPILock
{
  tU8 u8Id;
} OSAL_trSpiLock;

typedef struct _OSAL_trSPIUnlock
{
   tU8 u8Id;
} OSAL_trSpiUnlock;

typedef struct _OSAL_trSPISetup
{
   tU8 u8Id;
   tU8 u8Phase;
   tU8 u8Pol;
   tU8 u8Div;
   tU8 u8Mode;
} OSAL_trSpiSetup;

typedef struct _OSAL_trSPITransceive
{
   tU8 u8Id;
   tU8 *pu8TxData;
   tU8 *pu8RxData;
   tU32 u32Length;
} OSAL_trSpiTransceive;

typedef struct _OSAL_trSPITransceive_TunerICs //c.k. 180505
{
   tU8 *pu8TxData;
   tU8 *pu8RxData;
   tU32 u32Length;
   tBool bDriverUsesChipSelect;
} OSAL_trSpiTransceive_TunerICs;




/* size of transfer and receive buffer */
#define OSAL_BPM_C_U32_DATABUFFERSIZE     ((tU32) 256)


/* error codes */
#define OSAL_C_U8_SPI_E_DOESNOTRESPOND     ((tU8) 1)
#define OSAL_C_U8_SPI_E_CANTREAD           ((tU8) 2)
#define OSAL_C_U8_SPI_E_CANTWRITE          ((tU8) 3)
#define OSAL_C_U8_SPI_E_UNKNOWN_COMP_ID    ((tU8) 4)
#define OSAL_C_U8_SPI_E_TRANSMISSION_ERROR ((tU8) 5)

#define OSAL_C_U8_SPI_E_TXBUFFERFULL       ((tU8) 20)
#define OSAL_C_U8_SPI_E_RXBUFFERFULL       ((tU8) 21)
#define OSAL_C_U8_SPI_E_UNKNOWN            ((tU8) 22)
#define OSAL_C_U8_SPI_E_BUS_ERROR          ((tU8) 23)

#define OSAL_C_U8_PANELAVAILABLE           ((tU8) 30)
#define OSAL_C_U8_PANELNOTAVAILABLE        ((tU8) 31)
#define OSAL_C_U8_PANEL_CONNTIMEOUT        ((tU8) 32)

/* defines for control standby state */
#define OSAL_C_S32_SPI_STANDBY_GOIN      ((tS32) 1)
#define OSAL_C_S32_SPI_STANDBY_GOOUT     ((tS32) 2)

/* defines for cause used by callback function */
#define OSAL_C_S32_SPI_ERROROCCURES      ((tS32) 1)
#define OSAL_C_S32_SPI_PANELAVAILABLE    ((tS32) 2)
#define OSAL_C_S32_SPI_PANELNOTAVAILABLE ((tS32) 3)
#define OSAL_C_S32_SPI_DISPLAYHANDLE     ((tS32) 4)  // added Krappweis 3SOFT
#define OSAL_C_S32_SPI_TRANSFERSUCCEDED  ((tS32) 5)  // added Krappweis 3SOFT

#define OSAL_C_S32_SPI_FLUSH_ALL_TX      ((tS32) 6)  // added Fabig 3Soft

/* transfer buffer */
typedef struct _OSAL_trSPITxDataBuffer
{
   tU8 u8CompID;
   tU8 u8BufferLength;
   tU8 *pu8DataBuffer;
   tU8 u8FillByte;
   tU8 u8FillByte2;
   tU8 u8FillByte3;
} OSAL_trSpiTxDataBuffer;

/* receive buffer */
typedef struct _OSAL_trSPIRxDataBuffer
{
   tU16 u16ErrorCounter;
   tU8  u8CompID;
   tU8  u8BufferLength;
   tU8  pu8DataBuffer[OSAL_BPM_C_U32_DATABUFFERSIZE];
   tU8 u8FillByte;
} OSAL_trSpiRxDataBuffer;


/* SPI Error buffer */
typedef struct
{
   tS32 s32BufferSize;   /* number of error elements * sizeof(OSAL_trSPIErrorBuffer) */
   tS32 s32NumErrors;    /* number of logged errors */
   tPVoid pvErrorBuffer; /* pointer to OSAL_trSPIErrorBuffer items */
} OSAL_trGetSPIErrorBuffer; /* @@@@ kos2hi: replaced wrong name OSAL_trGetErrorBuffer */

/* an errorbuffer item*/
typedef struct
{
   tU8 u8CompID;
   tU8 u8Errortype;
   tU32 u32Timestamp;
} OSAL_trSPIErrorBuffer;

/* callback function */
typedef struct
{
   tVoid (*CapCallBack) (tS32 s32Arg);
} OSAL_trSPINotify;

/* proposal uk for Callback functions */
typedef struct
{
   tU32 u32CallBackCause;
   tU8  *pu8Handle;
   tU32 u8Length;
   tU8  u8CompID;
} OSAL_trIOCallback;

/* proposal for Display Data field */
typedef struct
{
   tU8   u8Ind;      /* Indication 0x00 free, 0x01 used */
   tU8   u8Pad1;
   tU8   u8Pad2;
   tU8   u8Pad3;
   tU32  u32Length;  /* length */
   tU8   *pu8Data;   /* pointer to data */
} OSAL_trIODisplayDataField;


/* for synchronous transfer */
typedef struct _OSAL_trIOCtrlSPITransferData
{
   OSAL_trSpiRxDataBuffer rRxData;
   OSAL_trSpiTxDataBuffer rTxData;
   tU8 u8CompID;
} OSAL_trIOCtrlSpiTransferData;

/* datastructures and defines for command and data mixed */
#define OSAL_C_U8_SPI_IS_DISP_COMMAND (1)
#define OSAL_C_U8_SPI_IS_DISP_DATA    (2)
typedef struct
{
   tU8   u8IsCommand;   /* Indication command or data */
   tU8   u8Ind;         /* Indication 0x00 free, 0x01 used */
   tU16  u16Length;     /* length */
   tU8*  pu8Data;       /* pointer to data */
} OSAL_trIODisplayData;

#define OSAL_C_U8_SPI_MAX_DISPLAY_MIX_DATA_ENTRIES  10
typedef struct
{
   tU8   u8NrOfMixDatas;
   tU8   u8Ind;         /* Indication */
   OSAL_trIODisplayData trDisplayData[OSAL_C_U8_SPI_MAX_DISPLAY_MIX_DATA_ENTRIES];
} OSAL_trIODisplayMixData;

/* --Special SIO (Serial I/O) defines and parameters. */

#define OSAL_C_S32_SIO_COM1                     ((tS32)1)
#define OSAL_C_S32_SIO_COM2                     ((tS32)2)
#define OSAL_C_S32_COM_BUFFERSIZE               ((tS32)1024) /* @@@@ 26.08.2002 Ka */

#define OSAL_C_S32_SIO_BAUD_4800                ((tS32)0)
#define OSAL_C_S32_SIO_BAUD_9600                ((tS32)1)
#define OSAL_C_S32_SIO_BAUD_19200               ((tS32)2)
#define OSAL_C_S32_SIO_BAUD_38400               ((tS32)3)
#define OSAL_C_S32_SIO_BAUD_57600               ((tS32)4)
#define OSAL_C_S32_SIO_BAUD_115200              ((tS32)5)
#define OSAL_C_S32_SIO_BAUD_XCLK                ((tS32)6)

#define OSAL_C_S32_SIO_PARITY_NONE              ((tS32)0)
#define OSAL_C_S32_SIO_PARITY_ODD               ((tS32)1)
#define OSAL_C_S32_SIO_PARITY_EVEN              ((tS32)2)

#define OSAL_C_S32_SIO_CHARLEN_5                ((tS32)0)
#define OSAL_C_S32_SIO_CHARLEN_6                ((tS32)1)
#define OSAL_C_S32_SIO_CHARLEN_7                ((tS32)2)
#define OSAL_C_S32_SIO_CHARLEN_8                ((tS32)3)

#define OSAL_C_S32_SIO_STOPBITS_1               ((tS32)0)
#define OSAL_C_S32_SIO_STOPBITS_2               ((tS32)1)

#define OSAL_C_S32_SIO_REMOTEFLOW_OFF           ((tS32)0)
#define OSAL_C_S32_SIO_REMOTEFLOW_ON            ((tS32)1)
#define OSAL_C_S32_SIO_LOCALFLOW_OFF            ((tS32)0)
#define OSAL_C_S32_SIO_LOCALFLOW_ON             ((tS32)1)
#define OSAL_C_S32_SIO_CTS_OFF                  ((tS32)0)
#define OSAL_C_S32_SIO_CTS_ON                   ((tS32)1)


/**************************************************************************/
/* RTC */
/**************************************************************************/
/* --Special RTC defines  */
#define OSAL_C_S32_SIO_RTC1                        ((tS32)0)
                                                   
#define OSAL_C_S32_IOCTRL_RTC_VERSION              ((tS32)0)
#define OSAL_C_S32_IOCTRL_RTC_SET_CALLBACK         ((tS32)1)
#define OSAL_C_S32_IOCTRL_RTC_GET_CALLBACK         ((tS32)2)
#define OSAL_C_S32_IOCTRL_RTC_SET_PERIODIC_TIMER   ((tS32)3)
#define OSAL_C_S32_IOCTRL_RTC_GET_PERIODIC_TIMER   ((tS32)4)
#define OSAL_C_S32_IOCTRL_RTC_SET_AND_CALIBRATE    ((tS32)5)
#define OSAL_C_S32_IOCTRL_RTC_GET_CALIBRATION      ((tS32)6)
#define OSAL_C_S32_IOCTRL_RTC_SET_RTC_TIME         ((tS32)7)
#define OSAL_C_S32_IOCTRL_RTC_GET_RTC_TIME         ((tS32)8)
#define OSAL_C_S32_IOCTRL_RTC_SET_ALARM_TIME       ((tS32)9)
#define OSAL_C_S32_IOCTRL_RTC_GET_ALARM_TIME       ((tS32)10)
#define OSAL_C_S32_IOCTRL_RTC_SET_ALARM_STATUS     ((tS32)11)
#define OSAL_C_S32_IOCTRL_RTC_GET_ALARM_STATUS     ((tS32)12)
#define OSAL_C_S32_IOCTRL_RTC_SET_RUNSTATE         ((tS32)13)
#define OSAL_C_S32_IOCTRL_RTC_GET_RUNSTATE         ((tS32)14)
#define OSAL_C_S32_IOCTRL_RTC_TIME_VALID           ((tS32)15)
#define OSAL_C_S32_IOCTRL_RTC_SET_CALLBACK_UPDATE  ((tS32)16)
#define OSAL_C_S32_IOCTRL_RTC_GET_CALLBACK_UPDATE  ((tS32)17)
#define OSAL_C_S32_IOCTRL_RTC_SET_GPS_TIME         ((tS32)18)
#define OSAL_C_S32_IOCTRL_RTC_SET_RDS_TIME         ((tS32)19)
#define OSAL_C_S32_IOCTRL_RTC_SET_BASE_TIME        ((tS32)20)
#define OSAL_C_S32_IOCTRL_RTC_GETCONFIG            ((tS32)21)


#define OSAL_C_S32_IOCTRL_RTC_INVALID_S32ARG      ((tS32)-1)
#define OSAL_C_S32_IOCTRL_RTC_CREATE_LLD          ((tS32)-2)
#define OSAL_C_S32_IOCTRL_RTC_OPEN_LLD            ((tS32)-3)
#define OSAL_C_S32_IOCTRL_RTC_CLOSE_LLD           ((tS32)-4)
#define OSAL_C_S32_IOCTRL_RTC_DESTROY_LLD         ((tS32)-5)



/* RTC Run State */
typedef enum
{
  OSAL_RTC_FROZEN   = 1,
  OSAL_RTC_RUNNING  = 2
} OSAL_tenRtcRunState;

/* Periodic Interrupt Event */
typedef enum {
   OSAL_RTC_PERIOD_INT_SEC    = 1,  /* Do periodic INT every Second */
   OSAL_RTC_PERIOD_INT_MIN    = 2,  /* Do periodic INT every Minute */
   OSAL_RTC_PERIOD_INT_HOUR   = 3,  /* Do periodic INT every Hour */
   OSAL_RTC_PERIOD_INT_DAY    = 4,  /* Do periodic INT every Day */
   OSAL_RTC_PERIOD_INT_ALARM  = 5,  /* Do ALARM INT every Day */   
   OSAL_RTC_PERIOD_INT_POWERUP= 6,  /* Do POWERUP INT every Day */   
   OSAL_RTC_PERIOD_INT_OFF    = 7   /* Turn off the Periodic Interrupts */   
}OSAL_trPeriodicInt;


/* RTC Register for notification */
#define  OSAL_RTC_NOTIFY_ON_GPS_TIME    1
#define  OSAL_RTC_NOTIFY_ON_RDS_TIME    2
#define  OSAL_RTC_NOTIFY_ON_BASE_TIME   4


/*Sign of offset.If RTC Time is less offset is positive*/
typedef enum
{
  OSAL_RTC_POSITIVE_OFFSET    = 1,
  OSAL_RTC_NEGATIVE_OFFSET    = 2
}OSAL_tenRtcOffsetType;

/*State of time.Synchoronisation state in the current power cycle*/
typedef enum
{
  OSAL_RTC_INVALID    = 1,
  OSAL_RTC_EVER_SYNC    = 2,
  OSAL_RTC_VALID    	 = 3
}OSAL_tenRtcTimeState;


/* Structure to register for notification */
typedef struct 
{
    tU8 registerForNotify;              /* Choose the time on which the 	notification is requested */
    tU32  updateRate;                     /* Update rate in s */
} OSAL_trRegisterForRtcTime;

/* Structure for get the various times and their validity */
typedef struct 
{
    OSAL_trTimeDate gpsUtcTime;        /* UTC time only modified by VD-sensor */
    OSAL_tenRtcTimeState gpsUtcTimeState;  /*Time state of gps time*/
    OSAL_trTimeDate BaseTime;           /* BASE time only modified by VD-clock */
    OSAL_tenRtcTimeState BaseTimeState;  /*Time state of base time*/
    OSAL_trTimeDate RdsTime;             /* RDS time only modified by FC_TUNER */
    OSAL_tenRtcTimeState RdsTimeState;  /*Time state of rds time*/
} OSAL_trRtcTimes;

/*Structure to be used for OSAL_IORead from the client*/
typedef struct 
{
OSAL_trRegisterForRtcTime RegisterForRtcTime;
OSAL_trRtcTimes RtcTimes;
} OSAL_trRtcRead;

/*Structure for Offset information.This would be written in FFS*/
typedef struct
{
OSAL_trTimeDate rOffsetTimeDate; /*36 bytes.Offset time in OSAL structure*/
OSAL_tenRtcOffsetType enRtcOffsetType; /*Sign of offset*/
tU8	u8RtcOffsetSource;/*Source of time based upon which offset is calculated*/
tU8 u8DayBorrowFlag;/*1 - Day is borrwed when calculating offset or else 0*/
tU8 u8MonthRef;	/*Month based on which No. of days was calculated for offset*/
tU8 u8MonthRefForPosOffset;/*Month of RDS/BASE time when offset is positive.Useful when days are 
                                recalculated of RDS/BASE time */
tU8 u8YearRef;/*Year based on which No. of month was calculated for offset*/
tU8 u8YearRefPosOffset;/*Year of RDS/BASE time when offset is positive.Useful for leap year check when RDS/BASE
                         time is recalculated*/
tU8 u8TimeValidityFlag;/*Used to indicate whether RDS has been set*/
}OSAL_trRtcOffsetData;


/* Structure for set and calibrate */
typedef struct {
    OSAL_trTimeDate *early_time;        /* pointer to Early derived Reference Time information */
    OSAL_trTimeDate *master_time;       /* pointer to Master Time information */
    tS16            s16Calibration_val; /* Calibration value */
} OSAL_trRtcCalibration;

/* Structure for get/set the alarm status */
typedef struct {
   tBool alarmEnabled;        /* for get/set Alarm Status */
   tBool alarmOccured;        /* TRUE if Alarm occurred */
}OSAL_RtcAlarmStatus;

typedef struct 
{
	tU8* pau8Buf;
	tU16 u16BufSize;   

}OSAL_rRTCDataReadWrite;


// UPDATE callback Type
typedef tVoid (*OSAL_trRTCCallback)(tS32 s32CallbackId, tS32 s32Arg);

// callback Type for Periodic/Alarm/Powerup
typedef tVoid (*OSAL_trRTCCallback_PAP)(OSAL_trPeriodicInt reason, tS32 s32Arg);



/**************************************************************************/
/* END RTC */
/**************************************************************************/


/**************************************************************************/
/* /dev/chenc                                                             */
/**************************************************************************/


/*
    Device interface

    /dev/chenc

    Supports
        OSAL_IOOpen()
        OSAL_s32IOClose()
        OSAL_s32IOControl()
            OSAL_C_S32_IOCTRL_CHENC_CONVERT
            OSAL_C_S32_IOCTRL_CHENC_CONVERT_RAW
*/
                
/*!
 * \brief The data structure used to exchange data between the client
 * and the driver in the OSAL_C_S32_IOCTRL_CHENC_CONVERT ioctl.
 *
 * The caller must provide the fields marked below as caller defined.
 * The device driver will call the encryption library with the
 * provided values and fill in the fields marked as device driver
 * defined.
 */
typedef struct
{
   /*!
    * \brief Initialization flag.
    *
    * Caller defined.
    */
   tS32 s32InitializationFlag;

   /*!
    * \brief WGS84 longitude in radians.
    *
    * Caller defined.
    */
   tDouble dLongitude;

   /*!
    * \brief WGS84 latitude in radians.
    *
    * Caller defined
    */
   tDouble dLatitude;

   /*!
    * \brief WGS84 altitude in meters.
    *
    * Caller defined.
    */
   tDouble dAltitude;

   /*!
    * \brief GPS week number.
    *
    * Caller defined.
    */
   tS32 s32GpsWeek;

   /*!
    * \brief GPS seconds within week.
    *
    * Caller defined.
    */
   tU32 u32GpsSecond;
   
   /*!
    * \brief The return code from the encryption library.
    *
    * After a successful conversion, this field should be equal to 0.
    * All other values indicate an error.  If an error code is set,
    * the caller should not use the values of the other device driver
    * defined fields.
    * 
    * Device driver defined.
    */
   tU32 u32ReturnCode;

   /*!
    * \brief Encoded longitude in radians.
    *
    * Invalid if u32ReturnCode != 0.
    *
    * Device driver defined.
    */
   tDouble dChinaLongitude;

   /*!
    * \brief Encoded latitude in radians.
    *
    * Invalid if u32ReturnCode != 0.
    *
    * Device driver defined.
    */
   tDouble dChinaLatitude;
} OSAL_trChencConversionData;


/*!
 * \brief The data structure used to exchange data between the client
 * and the driver in the OSAL_C_S32_IOCTRL_CHENC_CONVERT_RAW ioctl.
 *
 * The caller must provide the fields marked below as caller defined.
 * The device driver will call the encryption library with the
 * provided values and fill in the fields marked as device driver
 * defined.
 *
 * Note: angular values are given in CAU (Chinese Angular Unit).
 * These are defined by 1 CAU = 1/1024 ".
 */
typedef struct
{
   /*!
    * \brief Initialization flag.
    *
    * Caller defined.
    */
   tS32 s32InitializationFlag;

   /*!
    * \brief WGS84 longitude in CAU.
    *
    * Caller defined.
    */
   tU32 u32Longitude;

   /*!
    * \brief WGS84 latitude in CAU.
    *
    * Caller defined
    */
   tU32 u32Latitude;

   /*!
    * \brief WGS84 altitude in meters.
    *
    * Caller defined.
    */
   tS32 s32Altitude;

   /*!
    * \brief GPS week number.
    *
    * Caller defined.
    */
   tS32 s32GpsWeek;

   /*!
    * \brief GPS seconds within week.
    *
    * Caller defined.
    */
   tU32 u32GpsSecond;
   
   /*!
    * \brief The return code from the encryption library.
    *
    * After a successful conversion, this field should be equal to 0.
    * All other values indicate an error.  If an error code is set,
    * the caller should not use the values of the other device driver
    * defined fields.
    * 
    * Device driver defined.
    */
   tU32 u32ReturnCode;

   /*!
    * \brief Encoded longitude in CAU.
    *
    * Invalid if u32ReturnCode != 0.
    *
    * Device driver defined.
    */
   tU32 u32ChinaLongitude;

   /*!
    * \brief Encoded latitude in CAU.
    *
    * Invalid if u32ReturnCode != 0.
    *
    * Device driver defined.
    */
   tU32 u32ChinaLatitude;
} OSAL_trChencRawConversionData;

typedef tU32 (*ChineseEncoderInterfaceFunc)(tS32 wg_flag, tU32 wg_lng, tU32 wg_lat, tS32 wg_heit, tS32 wg_week, tU32 wg_time, tU32 *china_lng, tU32 *china_lat);

/*!
 * \brief Structure to hold the callback function information for /dev/chenc
 *
 * This structure is used in the add_cb ioctrl of dev/chenc
 * It contains the callback function and
 * the Task ID of the thread which register the call back function
 * This is normaly the base thread of the china encoder application
 * The thread id is necessary to switch to the application process space
 * before call the callback function (which is included in this process space
 */

typedef struct trChinaEncoderCB
{
  ChineseEncoderInterfaceFunc pCSIFunc;
  tS32                idTask;
} OSAL_trChinaEncoderCallback;

/*!
 * \brief Base number for /dev/chenc ioctls.
 *
 * This number may need to be adapted to avoid collisions with other
 * ioctl numbers in the system.
 */
#define OSAL_C_S32_IOCTRL_CHENC_BASE                (42)
/*!
 * \brief Ioctl to convert a GPS position from WGS84 to Chinese
 * coordinates.
 *
 * The argument is a pointer to an OSAL_trChencConversionData
 * structure.  The angular values are given in radians.  /dev/chenc
 * converts these values to the units expected by the encoding
 * software.
 */
#define OSAL_C_S32_IOCTRL_CHENC_CONVERT             (OSAL_C_S32_IOCTRL_CHENC_BASE + 0)

/*!
 * \brief Ioctl to convert a GPS position from WGS84 to Chinese
 * coordinates.
 *
 * The argument is a pointer to an OSAL_trChencRawConversionData
 * structure.  The angular values are given in the units expected by
 * the encoding software and no conversion takes place.
 */
#define OSAL_C_S32_IOCTRL_CHENC_CONVERT_RAW         (OSAL_C_S32_IOCTRL_CHENC_BASE + 1)

/*!
 * \brief Ioctl to convert a GPS position from WGS84 to Chinese
 * coordinates.
 *
 * The argument is a pointer to an OSAL_trChencRawConversionData
 * structure.  The angular values are given in the units expected by
 * the encoding software and no conversion takes place.
 */
#define OSAL_C_S32_IOCTRL_CHENC_SET_CB         (OSAL_C_S32_IOCTRL_CHENC_BASE + 2)
/*!
 * \brief Ioctl to set callback function
 * coordinates.
 *
 * The argument is a pointer to an OSAL_trEncoderCallback
 * structure.  The angular values are given in the units expected by
 * the encoding software and no conversion takes place.
 */

#define OSAL_C_S32_IOCTRL_CHENC_TEMP_DISABLE    (OSAL_C_S32_IOCTRL_CHENC_BASE + 3)
#define OSAL_C_S32_IOCTRL_CHENC_TEMP_DISABLED   TRUE
#define OSAL_C_S32_IOCTRL_CHENC_TEMP_ENABLED    FALSE
/*!
 * \brief Ioctl to disable the china encoder temporary
  *
 * The argument is a bool value which is true if the china encoder should disabled, or false if the china encoder is enabled
 * This function doesn't remember the setting after switch off the system
 * This function only change the china encoder behaviour if the china encoder is running
 */


/**************************************************************************/
/* END /dev/chenc                                                         */
/**************************************************************************/



/**************************************************************************/
/* typedefs                                                               */
/**************************************************************************/

/* Flash driver related structures */

typedef struct
   {
   tPS8 ps8Buffer;
   tU32 u32FlashAddress;
   tU32 u32NumBytes;
   } OSAL_trFlashData;

typedef struct
   {
   tU16 u16NumIdentblock;
   tU32 u32BlockSize;
   } OSAL_trRegionInfo;

typedef struct
   {
   tU8 u8NumRegions;
   tU8 u8DevSize;
   tU8 u8IntCode;
   } OSAL_trFlashInfo;

// ioctrl for tffs to query the wear level counter
typedef struct
   {
   tU8 u8NumLU;
   tU8 u8SizeofLU;
   tPU32 pu32BufferWLcnt;
   } OSAL_trTFFSWearLevelInfo;

/* --Special Gyro defines and structures. */
#define OSAL_C_S16_GYRO_RINGBUFFERSIZE          \
        ((tS16)512*sizeof(OSAL_trIOCtrlGyroData))

#define OSAL_C_S16_3D_GYRO_RINGBUFFERSIZE       \
        ((tS16)512*sizeof(OSAL_trIOCtrl3dGyroData))

#define OSAL_C_S16_GYRO_ADCCHANNEL              ((tS16)0)
#define OSAL_C_S16_GYRO_NPERIOD                 ((tS16)16)
typedef struct
{
   tS16 s16Period;
   tS16 s16ADC_Channel;
   tS16 s16RingBufferSize;
   tU8  u8FillByte1;    /* Alignment auf 32 Byte Zugriffe */
   tU8  u8FillByte2;    /* Alignment auf 32 Byte Zugriffe */
} OSAL_trIOCtrlGyroInit;
typedef struct
{
   tU32 u32TimeStamp;
   tS16 s16ADC_Value;
   tU16 u16ErrorCounter;
} OSAL_trIOCtrlGyroData;

typedef struct
{
   tU32 u32TimeStamp;
   tU16 u16Gyro_r;
   tU16 u16Gyro_s;
   tU16 u16Gyro_t;
   tU16 u16ErrorCounter;
} OSAL_trIOCtrl3dGyroData;

typedef struct
{
   tU32 u32GyroValue;
   tU32 u32Uref;
} OSAL_trIOCtrlDiagGyroRawData;

typedef struct
{
   tU32 u32Gyro_r;
   tU32 u32Gyro_s;
   tU32 u32Gyro_t;
   tU32 u32Uref;
} OSAL_trIOCtrlDiag3dGyroRawData;

typedef struct
{
   tU32 u32AdcRangeMin;
   tU32 u32AdcRangeMax;
   tU32 u32SampleMin;
   tU32 u32SampleMax;
   tF32 f32MinNoiseValue;
   tF32 f32EstimOffset;
   tF32 f32MinOffset;
   tF32 f32MaxOffset;
   tF32 f32DriftOffset;
   tF32 f32MaxUnsteadOffset;
   tF32 f32BestCalibOffset;
   tF32 f32EstimScaleFactor;
   tF32 f32MinScaleFactor;
   tF32 f32MaxScaleFactor;
   tF32 f32DriftScaleFactor;
   tF32 f32MaxUnsteadScaleFactor;
   tF32 f32BestCalibScaleFactor;
   tF32 f32DriftOffsetTime;
   tF32 f32DriftScaleFactorTime;
} OSAL_trSensorHwInfo;
typedef struct
{
   tU8 u8AngRX;
   tU8 u8AngRY;
   tU8 u8AngRZ;
   tU8 u8AngSX;
   tU8 u8AngSY;
   tU8 u8AngSZ;
   tU8 u8AngTX;
   tU8 u8AngTY;
   tU8 u8AngTZ;
} OSAL_tr3dMountAngles;
typedef struct
{
   OSAL_tr3dMountAngles rMountAngles;
   OSAL_trSensorHwInfo rRAxes;
   OSAL_trSensorHwInfo rSAxes;
   OSAL_trSensorHwInfo rTAxes;   
} OSAL_trIOCtrlHwInfo;
/* Gyro type definitions */
#define OSAL_C_S32_GYRO_TYPE_UNKNOWN ((tS32)0)
#define OSAL_C_S32_GYRO_TYPE_SMG_045 ((tS32)1)
#define OSAL_C_S32_GYRO_TYPE_EWTZGJ  ((tS32)2)
#define OSAL_C_s32_GYRO_TYPE_AY030AQ ((tS32)3)
#define OSAL_C_S32_GYRO_TYPE_NONE    ((tS32)1234)


/* Accelerometer entries */
typedef struct
{
   tU32 u32TimeStamp;
   tU16 u16Acc_x;
   tU16 u16Acc_y;
   tU16 u16Acc_z;
   tU16 u16ErrorCounter;
} OSAL_trIOCtrlAccData;

typedef struct
{
   tU32 u32Acc_x;
   tU32 u32Acc_y;
   tU32 u32Acc_z;
   tU32 u32Uref;
} OSAL_trIOCtrlDiagAccRawData;

#define OSAL_C_S16_ACC_RINGBUFFERSIZE       \
        ((tS16)512*sizeof(OSAL_trIOCtrlAccData))



/* --Special Odometer defines and structures. */

#define OSAL_C_S16_ODOMETER_RINGBUFFERSIZE      \
        ((tS16)512*sizeof(OSAL_trIOCtrlOdometerData))
#define OSAL_C_S16_ODOMETER_NPERIOD                     ((tS16)0)
#define OSAL_C_S16_ODOMETER_FDETECTION          ((tS16)0)
#define OSAL_C_ODOMETER_NDIRECTION      \
        ((OSAL_tenIOCtrlOdometerRFS)OSAL_EN_RFS_FORWARD)

typedef enum {
   OSAL_EN_RFS_UNKNOWN,
   OSAL_EN_RFS_FORWARD,
   OSAL_EN_RFS_REVERSE
} OSAL_tenIOCtrlOdometerRFS;

//#Ma. start new
typedef struct
{
   OSAL_tenIOCtrlOdometerRFS enDirection;
   tS16 s16Period;      /*period of data collection in Hz*/
   tS16 s16RingBufferSize; /* size of ringbuffer in byte */
   tU8  u8Detection;    /* driving direction */
   tU8  u8FillByte1;    /* Alignment auf 32 Byte Zugriffe */
   tU8  u8FillByte2;    /* Alignment auf 32 Byte Zugriffe */
   tU8  u8FillByte3;    /* Alignment auf 32 Byte Zugriffe */
}  OSAL_trIOCtrlOvCInit;

typedef enum
   {
      ODOMSTATE_CONNECTED_NORMAL = 0,
      ODOMSTATE_CONNECTED_NO_CALIBRATION = 248,
      ODOMSTATE_CONNECTED_DATA_INVALID = 249,
      ODOMSTATE_CONNECTED_INTERNALERROR = 250,
      ODOMSTATE_CONNECTED_NOINFO = 251,
      ODOMSTATE_CONNECTED_NOMOVEMENT = 252,
      ODOMSTATE_CONNECTED_ERROR = 253,
      ODOMSTATE_DISCONNECTED = 254,
      ODOMSTATE_UNKNOWN = 255
   } OSAL_tenOdometerStatus;

typedef struct
   {
      tU32 u32TimeStamp;
      tU32 u32WheelCounter;
      OSAL_tenIOCtrlOdometerRFS enDirection;
      tU16 u16ErrorCounter;
      OSAL_tenOdometerStatus  enOdometerStatus;
      tU8  u8FillByte1;    /* Alignment auf 32 Byte Zugriffe */
      tU8  u8FillByte2;    //#MaV01A.n
      tU8  u8FillByte3;    //#MaV01A.n
   } OSAL_trIOCtrlOvCData;
//#Ma.end new

//#MaV01A.sn
typedef struct
{
   tU16  u16OdomCounterInit;                 // start of odometer counter
   OSAL_tenIOCtrlOdometerRFS enDirection;    // actual driving direction (16Bit)
   tU8   u8SendPeriod;
   tU8   u8DrivingTime;                      // time from first movement/change of odometer-counter to this init message [unit: 50 ms]
   tU8   u8MsgCounterInit;                   // start of message counter
   tU8   u8FillByte1;
} OSAL_trOvcInitValue;

typedef struct
{
   tU16  u16OdomCounter;                     // absolute wrap around counter of odometer
   OSAL_tenIOCtrlOdometerRFS enDirection;    // actual driving direction (16Bit)
   tU8   u8MsgCounter;                       // wrap around counter of odometer messages
   tU8   u8OdomStatus;                       // status of odometer information
   tU8   u8FillByte1;
   tU8   u8FillByte2;
} OSAL_trOvcCounterValue;

//#MaV01A.en

typedef struct
   {
   OSAL_tenIOCtrlOdometerRFS enDirection;
   tS16 s16Period;
   tS16 s16RingBufferSize;
   tU8  u8Detection;
   tU8  u8FillByte1;    /* Alignment auf 32 Byte Zugriffe */
   tU8  u8FillByte2;    /* Alignment auf 32 Byte Zugriffe */
   tU8  u8FillByte3;    /* Alignment auf 32 Byte Zugriffe */
   tU16 u16OdoMsgCounter;                                      //#MaOdo01.n
   } OSAL_trIOCtrlOdometerInit;
typedef struct
{
   tU32 u32TimeStamp;
   tU32 u32WheelCounter;
   OSAL_tenIOCtrlOdometerRFS enDirection;
   tU16 u16ErrorCounter;
/* Only for Testing of odometer via CAN */
//   tU16 u16OICRecv;        //#MaTmp.n
//   tU16 u16OICSent;        //#MaTmp.n
//   tU32 u32TuaregTimestamp;//#MaTmp.n
   OSAL_tenOdometerStatus  enOdometerStatus;      //#MaF70.001.n
   tU8 u8FillByte1;    /* Alignment auf 32 Byte Zugriffe */
   tU8 u8FillByte2;    /* Alignment auf 32 Byte Zugriffe *///#MaV01A.n
   tU8 u8FillByte3;    /* Alignment auf 32 Byte Zugriffe *///#MaV01A.n
   tU16 u16OdoMsgCounter;                                                //#MaOdo01.n
   tU8 u8FillByte4;    /* Alignment auf 32 Byte Zugriffe *///#MaV01A.n   //#MaOdo01.n
   tU8 u8FillByte5;    /* Alignment auf 32 Byte Zugriffe *///#MaV01A.n   //#MaOdo01.n
} OSAL_trIOCtrlOdometerData;
/* --Special Filesystem defines and structures. */

#define OSAL_C_U32_MAX_PATHLENGTH               ((tU32)256)

#define OSAL_C_S32_SEEK_SET                                             ((tS32)0)
#define OSAL_C_S32_SEEK_CUR                                             ((tS32)1)
#define OSAL_C_S32_SEEK_END                                             ((tS32)2)
typedef struct
{
   tS8         s8Name [OSAL_C_U32_MAX_PATHLENGTH];
} OSAL_trIOCtrlDirent;

typedef struct
{
   OSAL_tIODescriptor          fd;             /* file descriptor for open directory */
   intptr_t                    s32Cookie;      /* filesys-specific marker within dir */
   OSAL_trIOCtrlDirent         dirent;         /* obtained directory entry */
} OSAL_trIOCtrlDir;

typedef enum 
{ 
   OSAL_EN_FILE = 0x0,                     /* type: file */ 
   OSAL_EN_DIRECTORY = 0x1                /* type: directory */ 
} OSAL_tenFileFlags; 



typedef struct   
{ 
   OSAL_tenFileFlags enFileFlags;              /* (o) file type */ 
   tU32 u32FileSize;                           /* (o) file size */ 
   tS8     s8Name [OSAL_C_U32_MAX_PATHLENGTH]; /* (o) file name */ 
} OSAL_trIOCtrlExtDirent; 



typedef struct   
{ 
   intptr_t s32Cookie;                /* (x): filesys specific marker within dir; set to 0 before first call, doesn't change afterwards */
   tU32   u32NbrOfEntries;          /* (i): Number of entries to read */ 
   tU32   u32NbrEntries;            /* (o): Number of read entries */ 
   OSAL_trIOCtrlExtDirent *pDirent; /* (-> o): Entries */ 
} OSAL_trIOCtrlExtDir; 

typedef struct
{
  tCString          coszDrive[OSAL_C_U32_MAX_NAMELENGTH];
  tU32              u32OpenFiles;
  tU32              u32OpenFilesRW;
  tU32              u32OpenFilesRO;
  tU32              u32OpenFilesWO;
  OSAL_tenAccess    enAccess;       // general access right to mountpoint
}OSAL_trOsalMountPointInfo;

typedef struct
{
   tChar szRealPath[ OSAL_C_U32_MAX_PATHLENGTH + OSAL_C_U32_OS_PATHLENGTH_OFFSET ];
}OSAL_trOsalRealPath;


/* ****** */

typedef struct
{
   tU8  u8Second;             /* second               [0...59]     */
   tU8  u8Minute;             /* minute               [0...59]     */
   tU8  u8Hour;               /* hour                 [0...23]     */
   tU8  u8Day;                /* day                  [1...31]     */
   tU8  u8Month;              /* month                [1...12]     */
   tS16 s16Year;              /* year         [-32768...32767]     */
} OSAL_trShortTimeDate;

typedef struct   
{ 
   OSAL_tenFileFlags enFileFlags;            /* (o) file type */ 
   tU8  u8FileAttributes;                    /* (o) for future use: OSAL_C_U8_FIO_ATTRIB_NORMAL, ... */
   tU32 u32FileSize;                         /* (o) file size */ 
   OSAL_trShortTimeDate trFileDateAndTime;   /* (o) */
   tS8  s8Name [OSAL_C_U32_MAX_PATHLENGTH];  /* (o) file name */ 
} OSAL_trIOCtrlExt2Dirent; 

typedef struct   
{ 
   intptr_t  s32Cookie;                 /* (x): filesys specific marker within dir; set to 0 before first call, doesn't change afterwards */
   tU32   u32NbrOfEntries;           /* (i): Number of entries to read */ 
   tU32   u32NbrEntries;             /* (o): Number of read entries */ 
   OSAL_trIOCtrlExt2Dirent *pDirent; /* (-> o): Entries */ 
} OSAL_trIOCtrlExt2Dir; 

/* ****** */


/* --Special HiResTimer structure. */
typedef struct
{
   tU32 u32High;
   tU32 u32Low;
} OSAL_trIOCtrlAuxClockTicks;

/*!
 * \brief Parameter structure for /dev/auxclock IOControl
 * OSAL_C_S32_IOCTRL_AUXILIARY_CLOCK_CONVERTTICKSTOPOSIX.
 *
 * This structure contains an auxclock time stamp which is converted
 * to POSIX time.
 */
typedef struct
{
   /*!
    * \brief High 32 bits of the auxclock time stamp. (I)
    *
    * Alternatively, the value can be
    * AUXCLOCK_C_U32_HEURISTIC_CONVERSION, in which case /dev/auxclock
    * makes an informed guess.
    */
   tU32 u32AuxClockTicksHigh;

   /*!
    * \brief Low 32 bits of the auxclock time stamp. (I)
    */
   tU32 u32AuxClockTicksLow;

   /*!
    * \brief Seconds since the POSIX Epoch. (O)
    */
   tU32 u32PosixTime;

   /*!
    * \brief Milliseconds since the last second boundary. (O)
    */
   tU16 u16ExactTime;
} OSAL_trIOCtrlAuxClockTicksToPosix;

/*!
 * \brief Specifies that /dev/auxclock should use a heuristic
 * algorithm to guess the value of the high 32 bits in
 * OSAL_C_S32_IOCTRL_AUXILIARY_CLOCK_CONVERTTICKSTOPOSIX.
 */
#define AUXCLOCK_C_U32_HEURISTIC_CONVERSION ((tU32)0xffffffff)

/* --Speech Status. */
#define OSAL_C_S32_SPEECH_READY                 (0)
#define OSAL_C_S32_SPEECH_BUSY                  (255)
#define OSAL_MAX_NUMBER_OF_PHRASEN                  (50)
#define OSAL_PHRASEN_OPTION_MONO                      (0x0001)

/* --Special Speech structure. */
typedef struct
{
   tU32     u32StartAddress;
   tU32     u32StopAddress;
   tU16     u16SamplingRate; /* typd: 16kHz */
   tU16     u16MemoryWidth;  /* unused */
} OSAL_trIOCtrlSpeechBufferList;

typedef struct   {
   tU32     u32StartAddress;    /* Contains the start address */
   tU32     u32Length;          /* and length of the DMA OKI ram */
} OSAL_trIOCtrlSpeechMemoryConfig;

typedef struct   {
   tU32     u32StartAddress;    /* Contains the start address of the phrase*/
   tU32     u32Length;          /* and length of the phrase */
} OSAL_trIOCtrlSpeechPhraseMemory;

typedef struct
{
   tU16 u16NumberOfPhrasen; /*  count of phrases (maximum is OSAL_MAX_NUMBER_OF_PHRASEN) */
   tU16 u16SampleFrequenzInHz;  /* actually not used*/
   tU16 u16Resolution;      /*  */
   tU16 u16Options;     /* OSAL_PHRASEN_OPTION_MONO */
   OSAL_trIOCtrlSpeechPhraseMemory rPhrasen[OSAL_MAX_NUMBER_OF_PHRASEN];
} OSAL_trIOCtrlSpeechPhraseBufferList;

/* --Special Trace defines and structure. */

#define TRACE_C_S32_BAUDRATE  (tS32)(57600)
#define OSAL_C_U32_TRACE_MAX_MESSAGESIZE        (256) /* Max. Size of single message */
#define OSAL_C_U32_TRACE_MAX_BUFFERSIZE         (OSAL_C_U32_TRACE_MAX_MESSAGESIZE*16)

#define OSAL_C_U32_TRACE_OUTPUT                 (OSAL_C_S32_SIO_COM1)


#define OSAL_C_U32_TRACE_LEVEL_FATAL_ERROR            0
#define OSAL_C_U32_TRACE_LEVEL_ERROR                  1
#define OSAL_C_U32_TRACE_LEVEL_WARNING                2
#define OSAL_C_U32_TRACE_LEVEL_MESSAGE                5
#define OSAL_C_U32_TRACE_LEVEL_DEFAULT                8

#define OSAL_C_U32_TRACE_CLASS_DEFAULT                TR_CLASS_NAVI
#define OSAL_C_U32_TRACE_CLASS_NAVI                   TR_CLASS_NAVI

typedef struct
{
   tU32     u32Length;
   tU32     u32Level;
   tU32     u32Class;
   tPCS8    pcos8Buffer;
} OSAL_trIOWriteTrace;

typedef struct
{
   tPCS8    pcos8Name;
   tU32     u32Size;
   tS32     s32Type;
   tPU8     ps8Value;
} OSAL_trIOCtrlRegistry;

#define OSAL_C_U32_MAX_VALUENAME 512

typedef struct
{
   tS8    s8Name[OSAL_C_U32_MAX_PATHLENGTH];
   tS32   s32Type;
   tS8    s8Value[OSAL_C_U32_MAX_VALUENAME];
} OSAL_trIOCtrlRegistryValue;


typedef struct
{
    tBool                   bIsActive;
    TR_tenTraceClass        enTraceClass;
    TR_tenTraceLevel        enTraceLevel;
} OSAL_trIOCtrlActivTrace;

typedef struct
{
    TR_tenTraceChan         enTraceChannel;
    OSAL_tpfCallback        pCallback;
} OSAL_trIOCtrlLaunchChannel;

typedef  struct
{
   tU32 u32CompId;
   tU32 u8SockId;
   tU32 u32BufferLen;
   tUChar* puchDataBuffer;
} OSAL_trIOCtrlBinaryData;

typedef  struct
{
   tString strFileName;
   tU8 u8Mode;
   tU32 u32Interval;
} OSAL_trIOCtrlInitTripData;

typedef struct
{
tU16	u16DspClassID;
tChar  strInstName[32];
}OSAL_trIOCtrlDspInstName;


typedef struct
{   
  tBool	bState;     
} OSAL_trIOCtrlTTFisSink;

typedef struct
{   
  tU8 u8LockStatus;     
} OSAL_trIOCtrlTargetLock;


#define OSAL_C_S32_VALUE_STRING  ((tS32)0)
#define OSAL_C_S32_VALUE_S32  ((tS32)1)

/* Special audioin structures */
#define OSAL_C_S32_LASTBUFFER_FLAG         ((tS32)1)

#define OSAL_C_S32_16BITPCM_MODE           ((tS32)1)

#define OSAL_C_S32_MIC_MODE                ((tS32)1)
#define OSAL_C_S32_FILE_MODE               ((tS32)2)

#define OSAL_C_S32_SAMPLERATE_8000KHZ     ((tS32)8000)
#define OSAL_C_S32_SAMPLERATE_11025KHZ     ((tS32)11025)
#define OSAL_C_S32_SAMPLERATE_16000KHZ     ((tS32)16000)
#define OSAL_C_S32_SAMPLERATE_22050KHZ     ((tS32)22050)

typedef struct {
   tVoid* pvDataBuffer;
   tU32   u32BufferSize;
} OSAL_trAudioInBufferInfo;

typedef struct {
   tS32		s32Mode;
   tChar	s8Filename[OSAL_C_U32_MAX_PATHLENGTH];
} OSAL_trAudioInSource;
//Änderung von ESH2-Sn
//Alt
//typedef void (*OSAL_AUDIOIN_CALLBACKFUNC) (tPS16 pu32Data, tS32 c32Cntelements, tU32 flags);
//Neu
typedef void (*OSAL_AUDIOIN_CALLBACKFUNC) (tPS16 pu32Data, tS32 c32Cntelements,
             tU32 flags, tU32 u32LostBuffer);
//
/* Special audioout structures */

#define OSAL_C_S32_MODE_0                    ((tS32)0)
#define OSAL_C_S32_MODE_1                    ((tS32)1)
#define OSAL_C_S32_MODE_2                    ((tS32)2)

#define OSAL_C_S32_VOLUMERANGE               ((tS32)64)

typedef struct {
    tS32    s32SampleRate;
    tS16    s16BufferSize;
    tS16    s16VolumeRange;
} OSAL_trAudioOutInit;

typedef struct {
    tS32    s32VolumeLevel;
} OSAL_trAudioVolumeLevel;

typedef struct {
    tS32    s32VolumeLeftLevel;
    tS32    s32VolumeRightLevel;
} OSAL_trAudioStereoVolumeLevel;

typedef struct {
   tVoid* pvDataBuffer;
   tU32   u32BufferSize;
} OSAL_trAudioOutBufferInfo;

/* -- Speechdata structures */
typedef struct
{
   tU8   u8MaxPackages;    // Maximum number of packages available
   tU8   u8StoredPackages; // Number of currently stored packages
   tBool bAllTransparent;  // TRUE if all packages may be read transparently
                           //   (i.e. are stored or buffered in SDRAM)
                           // FALSE if some or all packages require read
                           //   access via OSAL_s32IORead
} OSAL_trIOCtrlSpeechDataInfo;

typedef struct
{
  tU8 u8Package;       // (IO) Number of the package whose pointer is to
                       //      be queried
  const tU8* pu8Data;  // (O)  Pointer to the memory location of the indicated
                       //      package, or NULL if direct data access is not
                       //      possible
} OSAL_trIOCtrlSpeechDataPointer;

/*******************************************************************************
PRM structures
*******************************************************************************/
//#ifdef ADAPT_PRMPRC
/*AppID values should be sequentials and in priority order*/
#define OSAL_C_U16_DIAGNOSIS_APPID (tU16)0x0000
#define OSAL_C_U16_CDMANAGER_APPID (tU16)0x0001
#define OSAL_C_U16_DOWNLOAD_APPID  (tU16)0x0002
#define OSAL_C_U16_DAPI_APPID      (tU16)0x0003
#define OSAL_C_U16_AUDIOCD_APPID   (tU16)0x0004
#define OSAL_C_U16_MP3CD_APPID     (tU16)0x0005
#define OSAL_C_U16_VOICE_APPID     (tU16)0x0006
#define OSAL_C_U16_OTHERAPP_APPID  (tU16)0x0007
#define OSAL_C_U16_SDS_APPID       (tU16)0x0008
#define OSAL_C_U16_APPID_COUNT     (tU16)0x0009
#define OSAL_C_U16_NAVCOPY_APPID   (tU16)0x000A
#define OSAL_C_U16_POI_APPID       (tU16)0x000B
#define OSAL_C_U16_NAAGS_APPID     (tU16)0x000C
#define OSAL_C_U16_ADAPTOR_APPID   (tU16)0x000D
#define OSAL_C_U16_MAPUPDATE_APPID (tU16)0x000E
#define OSAL_C_U16_NAVI_APPID      (tU16)0x000F
#define OSAL_C_U16_CD_FLASH_APPID  (tU16)0x0008
#define OSAL_C_U16_DIM_APPID       (tU16)0x0001 //for ADIT Plattform no CDMANAGER is implemented
#define OSAL_C_U16_OTA_APPID       (tU16)0x0010
#define OSAL_C_U16_MEMNAVIDB_APPID (tU16)0x0011

#define OSAL_C_U16_INVALID_APPID             (tU16)0xFFFF


#if 0 //GS-110203
#define OSAL_C_STRING_RES_CDCTRL       "cdctrl"
#define OSAL_C_STRING_RES_CDAUDIO      "cdaudio"
#define OSAL_C_STRING_RES_CDROM        "cdrom"
#define OSAL_C_STRING_RES_CACHEDCDFS   "cachedcdfs"
#define OSAL_C_STRING_RES_CDDEV        "cddev"
#define OSAL_C_STRING_RES_CDFS         "cdfs"
#endif

#define OSAL_C_STRING_RES_CDCTRL       OSAL_C_STRING_DEVICE_CDCTRL
#define OSAL_C_STRING_RES_CDAUDIO      OSAL_C_STRING_DEVICE_CDAUDIO
#define OSAL_C_STRING_RES_CDROM        OSAL_C_STRING_DEVICE_CDROM
#define OSAL_C_STRING_RES_CACHEDCDFS   OSAL_C_STRING_DEVICE_CACHEDCDFS
#define OSAL_C_STRING_RES_CDDEV        "cddev"
#define OSAL_C_STRING_RES_CDFS         "cdfs"
#define OSAL_C_STRING_RES_USBH         OSAL_C_STRING_DEVICE_USB
#define OSAL_C_STRING_RES_SDA          OSAL_C_STRING_DEVICE_CARD
#define OSAL_C_STRING_RES_MMSDA       OSAL_C_STRING_DEVICE_MMCARD

#define OSAL_C_STRING_RES_CDCTRL0      OSAL_C_STRING_DEVICE_CDCTRL0
#define OSAL_C_STRING_RES_CDAUDIO0     OSAL_C_STRING_DEVICE_CDAUDIO0
#define OSAL_C_STRING_RES_CD0          OSAL_C_STRING_DEVICE_CD0
#define OSAL_C_STRING_RES_CACHEDCD0    OSAL_C_STRING_DEVICE_CACHEDCD0
#define OSAL_C_STRING_RES_CDDEV0       "cddev0"
#define OSAL_C_STRING_RES_CDFS0        "cdfs0"

#define OSAL_C_STRING_RES_CDCTRL1      OSAL_C_STRING_DEVICE_CDCTRL1
#define OSAL_C_STRING_RES_CDAUDIO1     OSAL_C_STRING_DEVICE_CDAUDIO1
#define OSAL_C_STRING_RES_CD1          OSAL_C_STRING_DEVICE_CD1
#define OSAL_C_STRING_RES_CACHEDCD1    OSAL_C_STRING_DEVICE_CACHEDCD1
#define OSAL_C_STRING_RES_CDDEV1       "cddev1"
#define OSAL_C_STRING_RES_CDFS1        "cdfs1"

#define OSAL_C_STRING_RES_CDCTRL2      OSAL_C_STRING_DEVICE_CDCTRL2
#define OSAL_C_STRING_RES_CDAUDIO2     OSAL_C_STRING_DEVICE_CDAUDIO2
#define OSAL_C_STRING_RES_CD2          OSAL_C_STRING_DEVICE_CD2
#define OSAL_C_STRING_RES_CACHEDCD2    OSAL_C_STRING_DEVICE_CACHEDCD2
#define OSAL_C_STRING_RES_CDDEV2       "cddev2"
#define OSAL_C_STRING_RES_CDFS2        "cdfs2"

#define OSAL_C_STRING_RES_CDCTRL3      OSAL_C_STRING_DEVICE_CDCTRL3
#define OSAL_C_STRING_RES_CDAUDIO3     OSAL_C_STRING_DEVICE_CDAUDIO3
#define OSAL_C_STRING_RES_CD3          OSAL_C_STRING_DEVICE_CD3
#define OSAL_C_STRING_RES_CACHEDCD3    OSAL_C_STRING_DEVICE_CACHEDCD3
#define OSAL_C_STRING_RES_CDDEV3       "cddev3"
#define OSAL_C_STRING_RES_CDFS3        "cdfs3"


#define OSAL_C_U16_NOTI_MEDIA_CHANGE         (tU16)0x0001
#define OSAL_C_U16_NOTI_TOTAL_FAILURE        (tU16)0x0002
#define OSAL_C_U16_NOTI_MODE_CHANGE          (tU16)0x0004
#define OSAL_C_U16_NOTI_MEDIA_STATE          (tU16)0x0008
#define OSAL_C_U16_NOTI_DVD_OVR_TEMP         (tU16)0x0010
#define OSAL_C_U16_NOTI_DEFECT               (tU16)0x0020
#define OSAL_C_U16_NOTI_EJECTKEY             (tU16)0x0040
#define OSAL_C_U16_NOTI_DEVICE_READY         (tU16)0x0080
#define OSAL_C_U16_NOTI_IDLE                 (tU16)0x0100
#define OSAL_C_U16_NOTI_LOW_POW              (tU16)0x0200


// parameters for notification
#define OSAL_C_U16_DEVICE_NOT_READY          (tU16)0x0000
#define OSAL_C_U16_DEVICE_READY              (tU16)0x0001
#define OSAL_C_U16_DEVICE_UV_NOT_READY       (tU16)0x0002
#define OSAL_C_U16_DEVICE_UV_READY           (tU16)0x0004

#define OSAL_C_U16_MEDIA_EJECTED             (tU16)0x0001
#define OSAL_C_U16_INCORRECT_MEDIA           (tU16)0x0002
#define OSAL_C_U16_DATA_MEDIA                (tU16)0x0004
#define OSAL_C_U16_AUDIO_MEDIA               (tU16)0x0008
#define OSAL_C_U16_UNKNOWN_MEDIA             (tU16)0x0010
#define OSAL_C_U16_DATA_MEDIA_NAVI           (tU16)0x0100
#define OSAL_C_U16_DATA_MEDIA_AUDIO          (tU16)0x0200
#define OSAL_C_U16_DATA_MEDIA_DNL            (tU16)0x0300
#define OSAL_C_U16_DATA_MEDIA_FLASH          (tU16)0x0400
#define OSAL_C_U16_DATA_MEDIA_MIX_MODE       (tU16)0x0500
#define OSAL_C_U16_DATA_MEDIA_UNKNOWN        (tU16)0x0800
#define OSAL_C_U16_OVER_TEMPERATURE          (tU16)1
#define OSAL_C_U16_NORMAL_TEMPERATURE        (tU16)0
#define OSAL_C_U16_DEVICE_OK                 (tU16)1
#define OSAL_C_U16_DEVICE_FAIL               (tU16)0
#define OSAL_C_U16_MEDIA_READY               (tU16)1
#define OSAL_C_U16_MEDIA_NOT_READY           (tU16)0
#define OSAL_C_U16_DEFECT_LOAD_EJECT         (tU16)0x0001
#define OSAL_C_U16_DEFECT_LOAD_INSERT        (tU16)0x0002
#define OSAL_C_U16_DEFECT_DISCTOC            (tU16)0x0004
#define OSAL_C_U16_DEFECT_DISC               (tU16)0x0008
#define OSAL_C_U16_DEFECT_COM                (tU16)0x0010
#define OSAL_C_U16_DEFECT_STA016_READ        (tU16)0x0020
#define OSAL_C_U16_DEFECT_STA016_TIMEOUT     (tU16)0x0040
#define OSAL_C_U16_DEFECT_CMD_TIMEOUT        (tU16)0x0080
#define OSAL_C_U16_DEFECT_CMD_TIMEOUT_OK     (tU16)0x0100
#define OSAL_C_U16_DEFECT_COM_OK             (tU16)0x0200
#define OSAL_C_U16_DEFECT_READ_ERR           (tU16)0x0400
#define OSAL_C_U16_DEFECT_READ_OK            (tU16)0x0800
#define OSAL_C_U16_DEFECT_TEMP_READ          (tU16)0x1000
#define OSAL_C_U16_DEFECT_ABNORMAL_WRITE_TERMINATION  (tU16)0x2000
#define OSAL_C_U16_DEFECT_POWER_STATUS_ERR   (tU16)0x4000
#define OSAL_C_U16_DEFECT_POWER_STATUS_OK    (tU16)0x8000
#define OSAL_C_U16_EJECTKEY_UP               (tU16)0x0080
#define OSAL_C_U16_EJECTKEY_DOWN             (tU16)0x00C0

// For evaluate media type from struct OSAL_trMediaInfo
#define OSAL_C_U8_INCORRECT_MEDIA            (tU8)0
#define OSAL_C_U8_UNKNOWN_MEDIA              (tU8)1
#define OSAL_C_U8_DATA_MEDIA                 (tU8)2
#define OSAL_C_U8_AUDIO_MEDIA                (tU8)3

// For evaluate disk type from struct OSAL_trMediaInfo
#define OSAL_C_U8_DISK_TYPE_UNKNOWN          (tU8) 0
#define OSAL_C_U8_DISK_TYPE_CD               (tU8) 1
#define OSAL_C_U8_DISK_TYPE_DVD              (tU8) 2

// For evaluate ROM status from struct OSAL_trMediaInfo
#define OSAL_C_U8_ROM_STATUS_UNKNOWN         (tU8) 0
#define OSAL_C_U8_ROM_STATUS_ROM             (tU8) 1
#define OSAL_C_U8_ROM_STATUS_NOT_ROM         (tU8) 2

// For evaluate file system type from struct OSAL_trMediaInfo
#define OSAL_C_U8_FS_TYPE_CDFS       (tU8)0  // cdfs
#define OSAL_C_U8_FS_TYPE_UDFS       (tU8)1  // udfs
#define OSAL_C_U8_FS_TYPE_UNKNOWN    (tU8)2  // unknown filesystem

// For evaluate loader info from struct OSAL_trLoaderInfo
#define OSAL_C_U8_MEDIA_IN_SLOT        (tU8)1   // Media is ejected but still in slot
#define OSAL_C_U8_NO_MEDIA             (tU8)2   // no media in drive
#define OSAL_C_U8_MEDIA_INSIDE         (tU8)3   // Media Completely inserted
#define OSAL_C_U8_EJECT_IN_PROGRESS    (tU8)4   // Ejecting in progress

// Notification Callback function type.
typedef void (*OSALCALLBACKFUNC) (tPU32 pu32Data);
typedef void (*OSALCALLBACKFUNCEXT2) (tPU32 pu32Data, tU8 au8String[] );

typedef struct
{
   tU16     u16AppID;      /* ID of the application              */
   tCString ResourceName;  /* Name of the resource               */
} OSAL_trAccessData;

typedef struct
{
   tU16     u16AppID;            /* ID of the application               */
   tCString ResourceName;        /* Name of the resource                */
   tU16     u16NotificationType; /* Type of Notifications               */
   OSALCALLBACKFUNC  pCallback;  /* Callback function                   */
   tPU32    pu32Data;            /* parameter of the callback function  */
   tU8      u8Status;            /* Status of the resource              */
} OSAL_trNotifyData;

typedef struct
{
   tU16     u16AppID;                  /* ID of the application               */
   tCString ResourceName;              /* Name of the resource                */
   tU16     u16NotificationType;       /* Type of Notifications               */
   OSALCALLBACKFUNCEXT2 pCallbackExt2; /* Callback function                   */
   tPU32    pu32Data;                  /* parameter of the callback function  */
   tU8      u8Status;                  /* Status of the resource              */
} OSAL_trNotifyDataExt2;

typedef struct
{
   tU16              u16AppID;            /* ID of the application               */
   OSALCALLBACKFUNC  pCallback;           /* Callback function                   */
   tPU32             pu32Data;            /* parameter of the callback function  */
} OSAL_trNotifyDataSystem;


typedef struct
{
   tU16     u16AppID;            /* ID of the application               */
   tCString ResourceName;        /* Name of the resource                */
   tU16     u16NotificationType; /* Type of Notifications               */
} OSAL_trRelNotifyData;

typedef struct
{
   tU16      u16AppID;            /* ID of the application               */
   tCString  szPath;              /* Path for remount    */
   tCString   szOption;            /* Type of remount               */
} OSAL_trRemountData;

typedef struct
{
   tCString FileName;            /* Name of the file                    */
   OSAL_tenAccess enAccess;      /* Access type                         */
   tU16     u16AppID;            /* ID of the application               */
   OSAL_tIODescriptor     Fd;    /* File descriptor                     */
} OSAL_trEX_Open_Arg;

//#endif

typedef struct
{
   tU8  u8Temperature;  /* drive temperatute              */
   tU8  u8FillByte1;    /* Alignment auf 32 Byte Zugriffe */
   tU8  u8FillByte2;    /* Alignment auf 32 Byte Zugriffe */
   tU8  u8FillByte3;    /* Alignment auf 32 Byte Zugriffe */
} OSAL_trDriveTemperature;

typedef struct
{
   tU8  u8LoaderInfoByte;  /* info of current loader state   */
   tU8  u8FillByte1;       /* Alignment auf 32 Byte Zugriffe */
   tU8  u8FillByte2;       /* Alignment auf 32 Byte Zugriffe */
   tU8  u8FillByte3;       /* Alignment auf 32 Byte Zugriffe */
} OSAL_trLoaderInfo;

typedef struct
{
   tS16 s16BufferSize;  /* size of error buffer              */
   tPS8 ps8ErrorBuffer; /* destination buffer for error data */
} OSAL_trGetErrorBuffer;

typedef struct
{
   tU32  u32TrackNumber;  /* Desired Track Number   */
   tU32  u32LBAAddress;   /* Track starting address */
   tU32  u32TrackControl; /* Track control flags    */
} OSAL_trCDROMTrackInfo;

typedef struct
{
   tPS8  ps8Buffer;       /* destination buffer       */
   tU32  u32LBAAddress;   /* address of start block   */
   tU32  u32NumBlocks;    /* Number of blocks to read */
} OSAL_trReadRawInfo;

typedef struct
{
   tPS8  ps8Buffer;       /* destination buffer       */
   tU8   u8Minute;        /* address in MSF of start block   */
   tU8   u8Second;
   tU8   u8Frame;
   tU32  u32NumBlocks;    /* Number of blocks to read */
} OSAL_trReadRawMSFInfo;

typedef struct
{
   tU32  u32MinTrack;    /* First track number of CD */
   tU32  u32MaxTrack;    /* Last track number of CD  */
} OSAL_trCDInfo;


typedef struct
{
   tU8 u8NumberOfLayers;
   tU8 u8TrackPath;
   tU32 u32StartSector;
   tU32 u32EndSector;
   tU32 u32EndSectorOfLayer0;
} OSAL_trDvdInfo;


typedef struct
{
   tU8      u8MediaType;         /* Type of the media
                                            (unknown/data/audio/incorrect) */
   tU8      u8FileSystemType;    /* Type of the file system
                                                      (CDFS/UDFS/UNKNOWN)  */
   tChar    szcMediaID[32];      /* ID of the media                        */
   tChar    szcCreationDate[32]; /* Creation date of the media
                                                     (YYYY:MM:DD:HH:MM:SS) */
   tInt     nTimeZone;           /* the time zone                          */
} OSAL_trMediaInfo;

typedef struct
{
   tU8  u8DiskType;     /* Type of the disk (needed for copy protection)      */
   tU8  u8DiskSubType;  /* Sub type of disk (read-only/type of                */
                        /* writing, needed for copy protection)               */
                        /* Bit 7:   set if specification of Blaupunkt         */
                        /*          concerning a valid ROM status is met      */
                        /*          (book type = 0x00, book version = 0x01);  */
                        /*          otherwise zero                            */
                        /* Bit 6-4: reserved                                  */
                        /* Bit 3-0: contain subtype of disk                   */
} OSAL_trDiskType;



/********************************************/
/*         disk type related enums          */
/********************************************/
// defines for disk type OSAL_trDiskType
enum
{
   ATAPI_C_U8_DISK_TYPE_UNKNOWN,
   ATAPI_C_U8_DISK_TYPE_CD,
   ATAPI_C_U8_DISK_TYPE_DVD
};

// defines for subtype of disk of OSAL_trDiskType
#define ATAPI_C_U8_DISK_SUB_TYPE_BLAUPUNKT_ROM  ( (tU8) ( 0x01 << 7 ) )
// following enum should only contain values from 0 to 15 
// according to u8DiskSubType
enum
{
   ATAPI_C_U8_DISK_SUB_TYPE_UNKNOWN,
   ATAPI_C_U8_DISK_SUB_TYPE_CD_ROM,
   ATAPI_C_U8_DISK_SUB_TYPE_CD_R,
   ATAPI_C_U8_DISK_SUB_TYPE_CD_RW,
   ATAPI_C_U8_DISK_SUB_TYPE_DVD_ROM,
   ATAPI_C_U8_DISK_SUB_TYPE_DVD_R,
   ATAPI_C_U8_DISK_SUB_TYPE_DVD_MINUS_R,
   ATAPI_C_U8_DISK_SUB_TYPE_DVD_MINUS_RW,
   ATAPI_C_U8_DISK_SUB_TYPE_DVD_RAM,
   ATAPI_C_U8_DISK_SUB_TYPE_DVD_PLUS_R,
   ATAPI_C_U8_DISK_SUB_TYPE_DVD_PLUS_RW
};


// enum for IO-Ctrl to lock and unlock eject!
enum
{
   ATAPI_C_U8_UNLOCK_EJECT = 1,
   ATAPI_C_U8_LOCK_EJECT   = 2
};


// defines media device types
typedef enum { 
   OSAL_EN_MEDIADEV_UNKNOWN = 0x01, 
   OSAL_EN_MEDIADEV_CD = 0x02, 
   OSAL_EN_MEDIADEV_DVD = 0x04, 
   OSAL_EN_MEDIADEV_HDD = 0x08
} OSAL_tenIOCtrlMediaDevice;


typedef struct
{
   tU32 u32High;
   tU32 u32Low;
} OSAL_trIOCtrlDeviceSize;

typedef struct
{
   tU32 u32SWVersion;  /* Software version of the drive */
   tU32 u32HWVersion;  /* Hardware version of the drive */
} OSAL_trCDDriveVersion;


/* Parameter of OSAL_C_S32_IOCTRL_CDCTRL_GET_DRIVE_VERSION */
/* If drive version is called for an Atapi device, struct members */
/* are filled with the content of drive version command. (see ATAPI spec.) */
/* In other cases (BP7) only known members are filled. */
/* Unknown values are set to zero or ' '. */
typedef struct
{
  tU8   DeviceModel[20];
  tU8   HWVersion[20];
  tU8   SWVersion[24];
} OSAL_trCdDeviceVersion;

typedef struct
{
   tU8 au8SerialNumber[20];
   tU8 au8FirmwareRevision[8];
   tU8 au8ModelNumber[40];
   tU16  u16MajorVersionNumber;
   tU16  u16MinorVersionNumber;
} OSAL_trDriveVersion;

typedef struct{
	tCString path;
	tCString sRet;
}Part_info;


typedef struct{
	tCString mnt_image;
	tCString mnt_path;
}Loop_Mount;




/**************************************************************************/

/*******************************************************************************/
/* --Special CD audio defines and structure. */
/*******************************************************************************/

#define OSAL_C_S32_AUDIO_STATUS_NOT_VALID                ((tS32)0x00)
#define OSAL_C_S32_PLAY_IN_PROGRESS                      ((tS32)0x11)
#define OSAL_C_S32_PLAY_PAUSED                           ((tS32)0x12)
#define OSAL_C_S32_PLAY_COMPLETED                        ((tS32)0x13)
#define OSAL_C_S32_PLAY_OPERATION_STOPPED_DUE_TO_ERROR   ((tS32)0x14)
#define OSAL_C_S32_NO_CURRENT_AUDIO_STATUS               ((tS32)0x15)
#define OSAL_C_S32_PLAY_OPERATION_STOPPED_DUE_TO_UNDERVOLTAGE       ((tS32)0x16)

#define OSAL_C_S32_CDAUDIO_CDTEXT_NOTAVAILABLE     ((tS32)0)
#define OSAL_C_S32_CDAUDIO_CDTEXT_AVAILABLE        ((tS32)1)

#define OSAL_C_S32_CDAUDIO_MAXNAMESIZE             ((tS32)249)

#define OSAL_C_U8_CDAUDIO_TRACK_NONE        ((tU8)0xFF)
#define OSAL_C_U16_CDAUDIO_OFFSET_TRACK_END ((tU16)0xFFFF)

/* defines for OSAL_trAdditionalCDInfo and OSAL_C_S32_IOCTRL_CDAUDIO_GETADDITIONALCDINFO*/
/* following is used as value*/
#define OSAL_C_U32_CDAUDIO_ADDITIONALCDINFO_ALLBITS_VALUE                0xFFFFFFFFUL
#define OSAL_C_U32_CDAUDIO_ADDITIONALCDINFO_NULL_VALUE                   0x00000000UL
#define OSAL_C_U32_CDAUDIO_ADDITIONALCDINFO_SIMPLE_AUDIO_CD_VALUE        0x00000000UL
/* following is used as bit mask*/
#define OSAL_C_U32_CDAUDIO_ADDITIONALCDINFO_FIRST_TRACK_DATA_BITMASK     0x00000001UL
#define OSAL_C_U32_CDAUDIO_ADDITIONALCDINFO_MAYBE_COPYPROTECTED_BITMASK  0x00000002UL
#define OSAL_C_U32_CDAUDIO_ADDITIONALCDINFO_IS_COPYPROTECTED_BITMASK     0x00000004UL
#define OSAL_C_U32_CDAUDIO_ADDITIONALCDINFO_MULTISESSION_BITMASK         0x00000008UL

/*4*U32 = 16 bytes for storing bit-coded-track-info of max 99 tracks, (16 bytes have room for 128 tracks)*/
#define OSAL_C_U32_CDAUDIO_ADDITIONALCDINFO_DATATRACK_ARRAY_SIZE         4 

/*max 99 tracks on cd, track #0 is used for volume info */
#define OSAL_C_U32_CDAUDIO_ADDITIONALCDINFO_DATATRACK_MAX                99 


typedef struct
{
   tU8   u8MSFMinute;
   tU8   u8MSFSecond;
   tU8   u8MSFFrame;
   tU8   u8MSFFiller;
} OSAL_trMSFAddress;


typedef struct
{
   OSAL_trMSFAddress   rStartAdr;   /* play start address */
   OSAL_trMSFAddress   rEndAdr;     /* play end address */
} OSAL_trAdrRange;

typedef struct
{
   tU8 u8Track;      /* Track number */
   tU8 u8Pad;        /* unused; padding to even address */
   tU16 u16Offset;   /* Offset in seconds from the start of the track */
} OSAL_trTrackPosition;

typedef struct
{
   OSAL_trTrackPosition rStartAdr;  /* play start address */
   OSAL_trTrackPosition rEndAdr;    /* play end address */
} OSAL_trPlayRange;

typedef struct
{
   OSAL_trMSFAddress rAbsTrackAdr;  /* absolute time at the just played track */
   OSAL_trMSFAddress rRelTrackAdr;  /* relative time at the just played track */
   tU32  u32TrackNumber;            /* number of currently played track */
   tU32  u32StatusPlay;             /* status of play operations */
} OSAL_trPlayInfo;

typedef struct
{
   tU32  u32CdText;                 /* signalized, if CD text is available */
   tU32  u32MinTrack;               /* first track number of CD */
   tU32  u32MaxTrack;               /* Last track number of CD */
   tU32  u32TrMinutes;              /* total minutes of all tracks on CD */
   tU32  u32TrSeconds;              /* total seconds of all tracks on CD */
} OSAL_trCDAudioInfo;

typedef struct
{
   tU32  u32TrackNumber;            /* desired track number */
   OSAL_trMSFAddress   rStartAdr;   /* track start address */
   OSAL_trMSFAddress   rEndAdr;     /* track end address */
   tU32  u32TrackControl;           /* Track Control Flags (CDTRACK_) */
} OSAL_trTrackInfo;


/* PlayInfo notification */
typedef tVoid (*OSAL_tPlayInfoCallback)(tPVoid pvCookie,
                                        const OSAL_trPlayInfo* prInfo);

/* A pointer to this structure has to be passed as argument to the
 * CDAUDIO IOControls REGPLAYNOTIFY and UNREGPLAYNOTIFY */
typedef struct
{
   /* This cookie value is not interpreted by the device, but will
    * be passed as first argument of the callback function */
   tPVoid pvCookie;

   /* Pointer to the callback function that is called for notification */
   OSAL_tPlayInfoCallback pCallback;
} OSAL_trPlayInfoReg;


/* -- CD text information */
typedef struct
{
   tU32   u32TrackNumber;                                /* desired track number */
   tChar rTrackTitle[OSAL_C_S32_CDAUDIO_MAXNAMESIZE];   /* title of the track name in ASCI */
   tChar rPerformer[OSAL_C_S32_CDAUDIO_MAXNAMESIZE];    /* name(s) of the performer in ASCI */
} OSAL_trTrackCdTextInfo;


/*used for OSAL_C_S32_IOCTRL_CDAUDIO_GETADDITIONALCDINFO*/
typedef struct
{
   tU32 u32InfoBits;  /* bit-coded informations about the inserted audio cd*/
   tU32 u32DataTracks[OSAL_C_U32_CDAUDIO_ADDITIONALCDINFO_DATATRACK_ARRAY_SIZE];  /*each bit set to 1 represents a data track - track 1 is u32DataTracks[0] Bit 1;
                                                                                    track 99 ist u32DataTracks[3] bit 2*/
} OSAL_trAdditionalCDInfo;


/*******************************************************************************/

/**************************************************************************/
/* typedefs                                                               */
/**************************************************************************/
/* @@@@ 01.04.2003 Ka: KDS related structures */

   /* Results of KDS-access */
   #define OSAL_C_S32_IOCTRL_KDS_OK               ((tS32)0)    /* Not Error Detected */
   #define OSAL_C_S32_IOCTRL_KDS_COMMON_ERROR     ((tS32)-1)   /* Unknown Error Detected */
   #define OSAL_C_S32_IOCTRL_KDS_PARAM_ERROR      ((tS32)-2)   /* There is an Error in the calling Parameters */
   #define OSAL_C_S32_IOCTRL_KDS_NOT_FOUND        ((tS32)-3)   /* KDS isn't initialised */
   #define OSAL_C_S32_IOCTRL_KDS_INITIALISED      ((tS32)-4)   /* KDS is initialised */
   #define OSAL_C_S32_IOCTRL_KDS_OTHER_VERSION    ((tS32)-5)   /* KDS with other Version found */
   #define OSAL_C_S32_IOCTRL_KDS_WRONG_DATA       ((tS32)-6)   /* KDS with other Data found */
   #define OSAL_C_S32_IOCTRL_KDS_CORRUPT_HEADER   ((tS32)-7)   /* KDS-Header with corrupt CS */
   #define OSAL_C_S32_IOCTRL_KDS_CS_ERROR         ((tS32)-8)   /* Entry or all Entries have wrong checksum */
   #define OSAL_C_S32_IOCTRL_KDS_CONFLICT         ((tS32)-9)   /* There are more then one correct Entry */
   #define OSAL_C_S32_IOCTRL_KDS_DATAFAULT        ((tS32)-10)  /* There are more then one Entry, but only
                                                                   one has a correct Checksum */
   #define OSAL_C_S32_IOCTRL_KDS_NOT_IN_LIST      ((tS32)-11)  /* Entry not found in KDS */
   #define OSAL_C_S32_IOCTRL_KDS_BUFFER_TO_SMALL  ((tS32)-12)  /* Entry can't be copied in Buffer */
   #define OSAL_C_S32_IOCTRL_KDS_WRITE_ERROR      ((tS32)-13)  /* The Writefunction returned an Error */
   #define OSAL_C_S32_IOCTRL_KDS_FULL             ((tS32)-14)  /* There is no space left in KDS */
   #define OSAL_C_S32_IOCTRL_KDS_CLEAR_ERROR      ((tS32)-15)  /* The Clearfunction returned an Error */
   #define OSAL_C_S32_IOCTRL_KDS_CHECK_ERROR      ((tS32)-16)  /* There is an Error in the KDS.
                                                                  Read the specified Entry to check what's
                                                                  wrong */
   #define OSAL_C_S32_IOCTRL_KDS_WRITE_PROTECTED  ((tS32)-17)  /* Entry is write protected and can't be
                                                                  overwritten */

   /* Definitions of common Entry-Flags */
   #define M_KDS_ENTRY_FLAG_NONE                ((tU16)0x0000)
   #define M_KDS_ENTRY_FLAG_WRITE_PROTECTED     ((tU16)0x0001)

   #define KDS_MAX_ENTRY_LENGTH       (240) /*Bytes*/

   typedef struct
   {
      tU16     u16Entry;
      tU16     u16EntryLength;
      tU16     u16EntryFlags;
      tU8      au8EntryData[KDS_MAX_ENTRY_LENGTH];
   } tsKDSEntry;

    /* Definitions for the state of read flash data */
   #define M_KDS_INFO_READ_FLASH_DATA_ACTUAL                  ((tU16)0x0000) /* read actual data */
   #define M_KDS_INFO_READ_FLASH_DATA_LAST_VALID              ((tU16)0x0001) /* read last valid data */ 
   #define M_KDS_INFO_READ_FLASH_DATA_BACKUP_FILE             ((tU16)0x0002) /* read datt from backup file*/

   typedef struct
   {
      tU32     u32NumberOfActiveEntries;/* Number of active Entries */
      tU32     u32NumberOfEntries;      /* Number of all Entries including invalid */
      tU32     u32KDS_Size;             /* Space (Bytes) used by KDS */
      tU32     u32KDS_UsedSize;         /* Realy written used by KDS-Entries */
      tS32     s32EntryError;           /* Error-Code for following ID */
      tU16     u16IdWithError;          /* ID of first damaged entry */
      tU16     u16StateReadFlashData;   /* the state of the read flash data*/
   } tsKDS_Info;
/**************************************************************************/
/**************************************************************************/
/* typedefs                                                               */
/**************************************************************************/
/* @@@@ 12.05.2003 Ka: Error Memory definitions and structures */

   /* Results of KDS-access */
   #define OSAL_C_S32_IOCTRL_ERRMEM_OK               ((tS32)0)    /* Not Error Detected */
   #define OSAL_C_S32_IOCTRL_ERRMEM_COMMON_ERROR     ((tS32)-1)   /* Unknown Error Detected */
   #define OSAL_C_S32_IOCTRL_ERRMEM_PARAM_ERROR      ((tS32)-2)   /* There is an Error in the calling Parameters */
   #define OSAL_C_S32_IOCTRL_ERRMEM_NOT_FOUND        ((tS32)-3)   /* ERRMEM isn't initialised */
   #define OSAL_C_S32_IOCTRL_ERRMEM_NOT_IN_LIST      ((tS32)-4)   /* Entry not found in ERRMEM */
   #define OSAL_C_S32_IOCTRL_ERRMEM_BUFFER_TO_SMALL  ((tS32)-5)   /* Entry can't be copied in Buffer */
   #define OSAL_C_S32_IOCTRL_ERRMEM_WRITE_ERROR      ((tS32)-6)   /* The Writefunction returned an Error */
   #define OSAL_C_S32_IOCTRL_ERRMEM_FULL             ((tS32)-7)   /* There is no space left in ERRMEM */
   #define OSAL_C_S32_IOCTRL_ERRMEM_CLEAR_ERROR      ((tS32)-8)   /* The Clearfunction returned an Error */
   #define OSAL_C_S32_IOCTRL_ERRMEM_CHECK_ERROR      ((tS32)-9)   /* There is an Error in the ERRMEM. */

#if OSAL_OS==OSAL_TENGINE
   #define ERRMEM_MAX_ENTRY_LENGTH       (256) /*Bytes*/
#elif (OSAL_OS==OSAL_LINUX) || (OSAL_OS==OSAL_DARWIN)
   #define ERRMEM_MAX_ENTRY_LENGTH       (256) /*Bytes*/
#else
   #define ERRMEM_MAX_ENTRY_LENGTH       (128) /*Bytes*/
#endif
   #define ERRMEM_CLEAR_MAGIC_VALUE      (0x634F6445) /* Paramter to enable clearing "cOdE" */

   typedef enum
   {
      eErrmemEntryUndefined = 0,
      eErrmemEntryNormal,
      /* Insert new type(s) here */
      eErrmemEntryInfo   = 0x8000,
      eErrmemValidRTCTime = 0xABBA,
      eErrmemEntryFatal  = 0xFFFF
   } tenErrmemEntryType;

   typedef struct
   {
      tU16               u16Entry;         /* Specific Entry Code (Type of Entry)*/
      tU16               u16EntryCount;    /* Number of same entries stored (sum after compress) */
      tenErrmemEntryType eEntryType;       /* Special infos additional to entry */
      OSAL_trTimeDate    rEntryTime;       /* Timing Info when the entry occured.
                                              After compression, only the time of the last stored
                                              entry is available here */
      tU16               u16EntryLength;   /* Length of Entry-Data. 0..ERRMEM_MAX_ENTRY_LENGTH */
      tU16               u16Align;
      tU8                au8EntryData[ERRMEM_MAX_ENTRY_LENGTH]; /* Additional data to entry */
   } trErrmemEntry;

   typedef struct
   {
      tU32     u32Size;                 /* Memory available for ERRMEM */
      tU32     u32UsedSize;             /* Memory used by errors */
      tU32     u32NumberOfEntries;      /* Number of all errors including Fatals */
      tU32     u32CountOfEntries;       /* Summerized number of all errors including fatals */
      tU32     u32NumberOfFatals;       /* Number of fatal errors stored */
      tU32     u32CountOfFatals;        /* Summerized number of fatal errors stored */
      tU32     u32NumberOfCompressions; /* Number of compressions done */
   } trErrmemInfo;

   /* Notification for new Errmem entries
    * Errmem notification callback function
    * Be sure to store the data given by parameter directly in local structures,
    * because the pointers are invalid after the function returns.
    * If you register for the callback, you get the last written errmem entry
    * directly AFTER it has been stored in flash memory.
    */
   typedef tVoid (*OSAL_tErrmemCallback)(tPVoid pvCookie,
                                         const trErrmemEntry* ptrErrmemEntry);

   /* A pointer to this structure has to be passed as argument to the
    * ERRMEM IOControls OSAL_C_S32_IOCTRL_ERRMEM_REGISTER and
    * OSAL_C_S32_IOCTRL_ERRMEM_UNREGISTER */
   typedef struct
   {
      /* This cookie value is not interpreted by the device, but will
       * be passed as first argument of the callback function */
      tPVoid pvCookie;

      /* Pointer to the callback function that is called for notification */
      OSAL_tErrmemCallback pCallback;
   } OSAL_trErrmemInfoReg;


/**************************************************************************/
/* @@@@ 11.08.2003 Sbv2hi: Perf definitions and structures */

/* IMPORTANT NOTICE: Some of the following 'perf'-definitions are just dummies and may be removed!
   (Derived from ERRMEM/FFS device) */

   #define OSAL_C_S32_IOCTRL_PERF_OK               ((tS32)0)    /* Not Error Detected */
   #define OSAL_C_S32_IOCTRL_PERF_COMMON_ERROR     ((tS32)-1)   /* Unknown Error Detected */
   #define OSAL_C_S32_IOCTRL_PERF_PARAM_ERROR      ((tS32)-2)   /* There is an Error in the calling Parameters */
   #define OSAL_C_S32_IOCTRL_PERF_NOT_FOUND        ((tS32)-3)   /* PERF isn't initialised */
   #define OSAL_C_S32_IOCTRL_PERF_NOT_IN_LIST      ((tS32)-4)   /* Entry not found in PERF */
   #define OSAL_C_S32_IOCTRL_PERF_BUFFER_TO_SMALL  ((tS32)-5)   /* Entry can't be copied in Buffer */
   #define OSAL_C_S32_IOCTRL_PERF_WRITE_ERROR      ((tS32)-6)   /* The Writefunction returned an Error */
   #define OSAL_C_S32_IOCTRL_PERF_FULL             ((tS32)-7)   /* There is no space left in PERF */
   #define OSAL_C_S32_IOCTRL_PERF_CLEAR_ERROR      ((tS32)-8)   /* The Clearfunction returned an Error */
   #define OSAL_C_S32_IOCTRL_PERF_CHECK_ERROR      ((tS32)-9)   /* There is an Error in the PERF. */

   #define PERF_MAX_ENTRY_LENGTH       (128) /*Bytes*/
   #define PERF_CLEAR_MAGIC_VALUE      (0x634F6445) /* Paramter to enable clearing "cOdE" */

   typedef enum
   {
      ePerfEntryUndefined = 0,
      ePerfEntryNormal,
      /* Insert new type(s) here */
      ePerfEntryFatal  = 0xFFFF
   } tenPerfEntryType;

   typedef struct
   {
      tU16               u16Entry;         /* Specific Entry Code (Type of Entry)*/
      tU16               u16EntryCount;    /* Number of same entries stored (sum after compress) */
      tenPerfEntryType eEntryType;       /* Special infos additional to entry */
      OSAL_trTimeDate    rEntryTime;       /* Timing Info when the entry occured.
                                              After compression, only the time of the last stored
                                              entry is available here */
      tU16               u16EntryLength;   /* Length of Entry-Data. 0..PERF_MAX_ENTRY_LENGTH */
      tU8                au8EntryData[PERF_MAX_ENTRY_LENGTH]; /* Additional data to entry */
   } trPerfEntry;

   typedef struct
   {
      tU32     u32Size;                 /* Memory available for PERF */
      tU32     u32UsedSize;             /* Memory used by errors */
      tU32     u32NumberOfEntries;      /* Number of all errors including Fatals */
      tU32     u32CountOfEntries;       /* Summerized number of all errors including fatals */
      tU32     u32NumberOfFatals;       /* Number of fatal errors stored */
      tU32     u32CountOfFatals;        /* Summerized number of fatal errors stored */
      tU32     u32NumberOfCompressions; /* Number of compressions done */
   } trPerfInfo;
/**************************************************************************/

   /* DAB IOCtrl */
#define OSAL_C_S32_IOCTRL_DAB_DEVICE_DCSR                         ((tS32) 305)
#define OSAL_C_S32_IOCTRL_DAB_IOREAD_CALLBACK                     ((tS32) 307)
#define OSAL_C_S32_IOCTRL_DAB_UNREG_NOTIFICATION                  ((tS32) 308)
#define OSAL_C_S32_IOCTRL_DAB_READ_ASYNC		    	                ((tS32) 309)

/* MP3 IOCtrl - normal play mode */
#define OSAL_C_S32_IOCTRL_MP3_PLAY                                ((tS32) 0)
#define OSAL_C_S32_IOCTRL_MP3_STOP                                ((tS32) 1)
#define OSAL_C_S32_IOCTRL_MP3_PAUSE                               ((tS32) 2)
#define OSAL_C_S32_IOCTRL_MP3_NEXTTRACK                           ((tS32) 3)
#define OSAL_C_S32_IOCTRL_MP3_PREVIOUSTRACK                       ((tS32) 4)
#define OSAL_C_S32_IOCTRL_MP3_FASTFORWARD                         ((tS32) 5)
#define OSAL_C_S32_IOCTRL_MP3_FASTBACKWARD                        ((tS32) 6)
#define OSAL_C_S32_IOCTRL_MP3_REGNOTIFICATION                     ((tS32) 7)
#define OSAL_C_S32_IOCTRL_MP3_PLAYPOSITION                        ((tS32) 8)
#define OSAL_C_S32_IOCTRL_MP3_NEXTDIR                             ((tS32) 9)
#define OSAL_C_S32_IOCTRL_MP3_PREVIOUSDIR                         ((tS32) 10)


/* MP3 IOCtrl - Configuration of STA016 */
#define OSAL_C_S32_IOCTRL_MP3_CONFIG_SETFASTFORWARDSPEED          ((tS32) 20)
#define OSAL_C_S32_IOCTRL_MP3_CONFIG_SCANNINGTIME                 ((tS32) 21)
#define OSAL_C_S32_IOCTRL_MP3_CONFIG_PLAYMODE                     ((tS32) 22)

#define OSAL_C_S32_IOCTRL_MP3_CONFIG_ENTERLOWPOWERMODE            ((tS32) 23)
#define OSAL_C_S32_IOCTRL_MP3_CONFIG_LEAVELOWPOWERMODE            ((tS32) 24)
#define OSAL_C_S32_IOCTRL_MP3_CONFIG_WAITLEAVELOWPOWER            ((tS32) 25)

#define OSAL_C_S32_IOCTRL_MP3_SETNORMALMODE                       ((tS32) 30)
#define OSAL_C_S32_IOCTRL_MP3_SETREPEATFILE                       ((tS32) 31)
#define OSAL_C_S32_IOCTRL_MP3_SETREPEATALB                        ((tS32) 32)
#define OSAL_C_S32_IOCTRL_MP3_SETMIXALB                           ((tS32) 33)
#define OSAL_C_S32_IOCTRL_MP3_SETMIXALL                           ((tS32) 34)
#define OSAL_C_S32_IOCTRL_MP3_SETSCANALB                          ((tS32) 35)
#define OSAL_C_S32_IOCTRL_MP3_SETSCANALL                          ((tS32) 36)
#define OSAL_C_S32_IOCTRL_MP3_SETPAUSEAFTERTRACK                  ((tS32) 37)

//update packet browsing feature  

#define OSAL_C_S32_IOCTRL_MP3_START_BROWSINGMODE                  ((tS32) 40) // scanning complete CD-ROM via /dev/cdrom
#define OSAL_C_S32_IOCTRL_MP3_START_MP3MODE                       ((tS32) 41) // switch to MP3 mode 
#define OSAL_C_S32_IOCTRL_MP3_ENABLEFILELISTING                   ((tS32) 42) // use STA016 file listing feature 


#define OSAL_C_S32_IOCTRL_MP3_BROWSE_GETVALIDLIST                 ((tS32) 50) // s32Arg: pointer to trMP3BrowseInfo
                                                                              // get elements of current virtual directory 
#define OSAL_C_S32_IOCTRL_MP3_BROWSE_GODIRUP                      ((tS32) 51) // go to parent dir, 
                                                                              // change virtual directory for browsing
#define OSAL_C_S32_IOCTRL_MP3_BROWSE_GODIR                        ((tS32) 52) // s32Arg directory number
                                                                              // change virtual directory for browsing
#define OSAL_C_S32_IOCTRL_MP3_GET_DIRNUMBER                       ((tS32) 53) // get number of directorie on CD-ROM
#define OSAL_C_S32_IOCTRL_MP3_GET_TOTALTRACKS                     ((tS32) 54) // get total number of tracks on CD-ROM
#define OSAL_C_S32_IOCTRL_MP3_BROWSE_DIR_INFO                     ((tS32) 55) // get information about current browse dir
// end browsing

/* MP3 IOCtrl - Diagnose functions */
#define OSAL_C_S32_IOCTRL_MP3_DIAGNOSE_TESTTONE_START             ((tS32) 200)
#define OSAL_C_S32_IOCTRL_MP3_DIAGNOSE_TESTTONE_STOP              ((tS32) 201)
#define OSAL_C_S32_IOCTRL_MP3_DIAGNOSE_TRACKUP                    ((tS32) 202)
#define OSAL_C_S32_IOCTRL_MP3_DIAGNOSE_TRACKDOWN                  ((tS32) 203)
#define OSAL_C_S32_IOCTRL_MP3_DIAGNOSE_PLAYPOSITION               ((tS32) 204)
#define OSAL_C_S32_IOCTRL_MP3_DIAGNOSE_GET_HWVERSION              ((tS32) 205)
#define OSAL_C_S32_IOCTRL_MP3_DIAGNOSE_GET_SWVERSION              ((tS32) 206)


/* MP3 IOCtrl - Getting information */
#define OSAL_C_S32_IOCTRL_MP3_GETPLAYINFO                         ((tS32) 100)
#define OSAL_C_S32_IOCTRL_MP3_GETTRACKINFO                        ((tS32) 101)
#define OSAL_C_S32_IOCTRL_MP3_GETDIRINFO                          ((tS32) 102)
#define OSAL_C_S32_IOCTRL_MP3_GETMEDIAINFO                        ((tS32) 103)


/* media type */
#define OSAL_C_U32_MEDIATYPE_MP3                                  ((tU32) 1)
#define OSAL_C_U32_MEDIATYPE_UNKNOWN                              ((tU32) 2)
#define OSAL_C_U32_MEDIATYPE_NOTVALID                             ((tU32) 3)

typedef struct
{
  tU32 u32VolIdentifier;
  tU32 u32MediaType;
  tChar szCDName[33];
  tU8 u8NumberofDirs;
} trMP3_MediaInfo;


/* callback information */

/* callback reasons */
#define OSAL_C_U32_CALLBACK_MP3_NEWTRACKINFO                      ((tU32) 0)
#define OSAL_C_U32_CALLBACK_MP3_NEWDIRINFO                        ((tU32) 1)
#define OSAL_C_U32_CALLBACK_MP3_NEWPLAYTIME                       ((tU32) 2)
/* NO_MP3MEDIA is obsolete, replaced by newmediainfo */
/*#define OSAL_C_U32_CALLBACK_MP3_NO_MP3MEDIA                     ((tU32) 3)*/
#define OSAL_C_U32_CALLBACK_MP3_NEWMEDIAINFO                      ((tU32) 3)
#define OSAL_C_U32_CALLBACK_MP3_ERROR                             ((tU32) 4)
#define OSAL_C_U32_CALLBACK_MP3_TRACK_END_REACHED                 ((tU32) 5)

// update packet browsing feature
#define OSAL_C_U32_CALLBACK_MP3_DIRLISTAVAILABLE                  ((tU32) 6)

// Callbacks for undervoltage handling
#define OSAL_C_U32_CALLBACK_MP3_UNDERVOLTAGE_RECOVERY             ((tU32) 7)
#define OSAL_C_U32_CALLBACK_MP3_RECOVERED                         ((tU32) 8)

typedef struct
{
  tU32  u32CallBackReason;    // callback reason
  tPVoid pvData;
} trMP3_CallBackInfo;

// error structur
typedef struct
{
   tS16 wError;     // error value
   tS8  bStatus;    // TRUE = set error, false = reset error
} MP3_trErrorInfo;

/* playtime information - OSAL_C_U32_CALLBACK_MP3_NEWPLAYTIME */
typedef struct
{
  tU8 u8Minutes;  // minute of played MP3 track
  tU8 u8Seconds;  // second of played MP3 track
  tU8 u8TrackNr;
  tU8 u8DirNr;
  tU8 u8MediaPositionMinute;  // pick up position
  tU8 u8MediaPositionSecond;  // pick position
  tU8 u8MediaPositionFrame;   // pick up postion
} trMP3_PlayInfo;

/* track information - OSAL_C_U32_CALLBACK_MP3_NEWTRACKINFO */
typedef struct
{
  tChar szID3Name [33];
  tChar szID3Artist [33];
  tChar szID3Album [33];
  tChar szFileName [33];
  tChar szDirName [33];
} trMP3_TrackInfo;

/* directory information - OSAL_C_U32_CALLBACK_MP3_NEWDIRINFO */
typedef struct
{
   tU8 u8CurTrack;
   tU8 u8CurDir;
   tU8 u8NumberofSubDir;
   tU8 u8NumberofTracks;
   tU8 u8ParentDirIndex;
} trMP3_DirInfo;


/* update packet browsing feature */
#define MP3_BROWSE_NAME_LEN 33

/* browsing element */
// directory: u8DirNr != 0 && u8TrackNr == 0
// filename : u8DirNr != 0 && u8TrackNr != 0
typedef struct 
{
   tU8  u8DirNr;     /* directory number */
   tU8  u8TrackNr;   /* file number */
   tU8  u8ParentDirNr; /* parent directory number */
   tChar szName[MP3_BROWSE_NAME_LEN+1]; /* name UTF 8 */ 
} trMP3BrowseElement;


/* browse info list */
typedef struct
{
   tU16 u16IndexStartNr;                 // -> in start index
   tU16 u16NumberofRequestedElements;    // -> in number of elements to read 
   tU16 u16AvailableElements;            // <- out how mamy elements are in this virt. dir available
   trMP3BrowseElement *prData;          // <- out pointer to trMP3BrowseElements
} trMP3BrowseInfo;

//--------------------------------------------------------------------------------
/* end MP3 */


/* dev_diaglog begin */
#ifdef VARIANT_S_FTR_ENABLE_DIAGLOG_DEVICE

/* OSAL_s32IOControl function IDs */
#define OSAL_C_IOCTRL_DIAGLOG_READ_ERROR                ((tS32)11)
#define OSAL_C_IOCTRL_DIAGLOG_READ_ERROR_LIST           ((tS32)12)
#define OSAL_C_IOCTRL_DIAGLOG_READ_SUPPORTED_LIST       ((tS32)13)
#define OSAL_C_IOCTRL_DIAGLOG_CLEAR_ERROR               ((tS32)14)
#define OSAL_C_IOCTRL_DIAGLOG_CLEAR_ERROR_LIST          ((tS32)15)
#define OSAL_C_IOCTRL_DIAGLOG_REG_ERROR_STATE_CALLBACK  ((tS32)16)
#define OSAL_C_IOCTRL_DIAGLOG_REG_PLAUSIBILITY_CALLBACK ((tS32)17)
#define OSAL_C_IOCTRL_DIAGLOG_REG_CLEAR_CALLBACK        ((tS32)18)
#define OSAL_C_IOCTRL_DIAGLOG_STORE                     ((tS32)19)
#define OSAL_C_IOCTRL_DIAGLOG_GET_MAX_NUM_ENTRIES       ((tS32)20)
#define OSAL_C_IOCTRL_DIAGLOG_PREVENT_STORING           ((tS32)21)


/* data structure for OSAL_s32IOWrite */     
typedef struct
{
   tU16 u16ErrorCode;
   tU8  u8Event;
}  tDiaglogWrite;


/* error states for u8ErrStatus */
#define ERR_DISAPPEARS      0x00
#define ERR_APPEARS         0x01
#define ERR_NOT_STORED      0x11
#define ERR_UNCHECKED       0xFF


/* data structure for OSAL_s32IOControl */
typedef struct 
{
    tU16 u16ReqErrCode;
    tU8  u8ErrNum;
    struct
    {
        tU16 u16ErrCode;
        tU8  u8ErrStatus;
        tU8  u8ErrCount;
    } Error[1];
} tDiaglogCtrl;


/* error notification callback function type */
typedef tVoid (*tDiaglogErrorStateCallback) (tU16 u16ErrorCode, tU8 u8Condition);    

/* error plausibility test callback function type */
typedef tBool (*tDiaglogPlausibilityCallback) (tU16 u16ErrorCode, tU8 u8Condition);    

/* clear notification callback function for error reinsert */
typedef tVoid (*tDiaglogClearCallback) (tU16 u16Group);

#endif
/* end dev_diaglog */


/******************************************************************************************/
/*  Device AudioRouter EWL 12.05.2005                                                     */
/******************************************************************************************/
/* dev_audrout begin */

/* OSAL_s32IOControl function IDs */
#define OSAL_C_S32_IOCTRL_AUDIOROUTER_SETUP_STREAM                 ((tS32)1)
#define OSAL_C_S32_IOCTRL_AUDIOROUTER_KILL_STREAM                  ((tS32)2)
#define OSAL_C_S32_IOCTRL_AUDIOROUTER_PING_EDAR                    ((tS32)3)
#define OSAL_C_S32_IOCTRL_AUDIOROUTER_GETSHAREDMEMINFO             ((tS32)4)
#define OSAL_C_S32_IOCTRL_AUDIOROUTER_GETMSGCHANINFO               ((tS32)5)
#define OSAL_C_S32_IOCTRL_AUDIOROUTER_SENDMSG                      ((tS32)6)
#define OSAL_C_S32_IOCTRL_AUDIOROUTER_RCVMSG                       ((tS32)7)
#define OSAL_C_S32_IOCTRL_AUDIOROUTER_REG_NOTIFICATION             ((tS32)8)


/** \brief Maximum string length of speechreco application result string */
#define OSAL_C_U32_AUDIOROUTER_MAX_APPRES_STRLEN       ((tU32)128) /*Bytes*/

/** \brief A pointer to this structure has to be passed as argument to the
  * Audiorouter IOControls OSAL_C_S32_IOCTRL_AUDIOROUTER_STARTFRONTEND,
  * OSAL_C_S32_IOCTRL_AUDIOROUTERH_STOPFRONTEND,
  * OSAL_C_S32_IOCTRL_AUDIOROUTER_PINGFRONTEND
  */
typedef struct
{
   /** \brief This value is the result of the application control command. Its
     * meaning is defined between frontend and backend. */
   tU32 u32AppCmdResultVal;
   
   /** \brief This is an additional string provided as result of the application
     * control command. Its meaning is defined between frontend and backend.
     */
   tChar szAppCmdResultStr[OSAL_C_U32_AUDIOROUTER_MAX_APPRES_STRLEN];
} OSAL_trAudioRouterAppCtrlInfo;

/** \brief A pointer to this structure has to be passed as argument to the
  * Audiorouter IOControls OSAL_C_S32_IOCTRL_AUDIOROUTER_SENDMSG,
  * OSAL_C_S32_IOCTRL_AUDIOROUTER_RCVMSG
  */
typedef struct
{
   /** \brief This is a user provided message buffer */
   tPVoid pvMsgBuffer;
   
   /** \brief This is the size of the provided buffer */
   tSize siBufferSize;

   /** \brief Timeout when receiving message (ignored when sending message)
     *
     * 0: nonblocking
     * 0<x< LIMIT_C_MAX_U32: timeout value in milliseconds
     * 0xFFFFFFFF: blocking
     */
   tU32  u32Timeout;
} OSAL_trAudioRouterMsgInfo;

/** \brief A pointer to this structure has to be passed as argument to the
  * Audiorouter IOControls OSAL_C_S32_IOCTRL_AUDIOROUTER_GETMSGINFO
  */
typedef struct
{
   tBool   bMessagesAvailable;              /*!< Unread messages available? */
} OSAL_trAudioRouterMsgChanInfo;

/*******end dev_audrout******************************************************/


/* dev_adcc begin */
/*****************************************************************************
*			 Constants and defines 
******************************************************************************/

/* Base number for /dev/adc ioctls. 
This number may need to be adapted to avoid collisions with other ioctl  
numbers in the system. */

#define OSAL_C_S32_IOCTRL_ADC_BASE 			(42)

/* Ioctl to configure an ADC. 
The argument is a pointer to a OSAL_trAdcConfigureAdc structure. */

#define OSAL_C_S32_IOCTRL_ADC_CONFIGURE_ADC	(OSAL_C_S32_IOCTRL_ADC_BASE + 0)

/* Ioctl to configure a scan group. 
The argument is a pointer to a OSAL_trAdcConfigureScanGroup structure. */

#define OSAL_C_S32_IOCTRL_ADC_CONFIGURE_SCAN_GROUP (OSAL_C_S32_IOCTRL_ADC_BASE + 1)

/* Ioctl to retrieve configuration information for a scan group.  
The argument is a pointer to a  OSAL_trAdcConfigureScanGroup structure. */

#define OSAL_C_S32_IOCTRL_ADC_GET_SCAN_GROUP_INFO (OSAL_C_S32_IOCTRL_ADC_BASE + 2)

/* Ioctl to configure a logical channel. 
The argument is a pointer to a OSAL_trAdcConfigureLogicalChannel structure.*/

#define OSAL_C_S32_IOCTRL_ADC_CONFIGURE_LOGICAL_CHANNEL (OSAL_C_S32_IOCTRL_ADC_BASE + 3)

/* Ioctl to set a threshold level for a logical channel. 
The argument is a pointer to a OSAL_trAdcSetThreshold structure. */

#define OSAL_C_S32_IOCTRL_ADC_SET_THRESHOLD (OSAL_C_S32_IOCTRL_ADC_BASE + 4)

/* Ioctl to set a callback for a hardware event.  
The argument is a pointer to a OSAL_trAdcSetCallback structure. */

#define OSAL_C_S32_IOCTRL_ADC_SET_CALLBACK (OSAL_C_S32_IOCTRL_ADC_BASE + 5)

/* Ioctl to perform a "single read".  
The argument is a pointer to a OSAL_trAdcSingleRead structure. */

#define OSAL_C_S32_IOCTRL_ADC_SINGLE_READ (OSAL_C_S32_IOCTRL_ADC_BASE + 6)

/* Added additional IoCtrls for 'dev_sadc' for ADIT Platform */
/*  Ioctl to get Attribute data of Sensor ADC.  The argument is a pointer to a OSAL_trAdcAttributeDataInfo structure.  */

#define OSAL_C_S32_IOCTRL_ADC_GET_ATTRIBUTE_DATA_INFO	(OSAL_C_S32_IOCTRL_ADC_BASE + 7)

/*Ioctl to set Limit violation interrupt register with the value specified in the structure.  The argument is a register value.*/

#define OSAL_C_S32_IOCTRL_ADC_SET_LIMVIO_INT_REG (OSAL_C_S32_IOCTRL_ADC_BASE + 8)

/*Ioctl to Set the Sensor ADC Interrupt States Mask Register.The argument is a register value. */

#define OSAL_C_S32_IOCTRL_ADC_SET_STATES_INT_MSK (OSAL_C_S32_IOCTRL_ADC_BASE + 9)

/*Ioctl to Set the Sensor ADC Interrupt Limit Violation Mask Register. The argument is a register value. */

#define OSAL_C_S32_IOCTRL_ADC_SET_LIMVIO_INT_MSK (OSAL_C_S32_IOCTRL_ADC_BASE + 10)

/*Voice channel*/

#define OSAL_C_S32_IOCTRL_ADC_VC_GET_BLOCKSIZE (OSAL_C_S32_IOCTRL_ADC_BASE + 11)

/* Added additional IoCtrls for 'dev_sadc' for ADIT Platform */
/*  Ioctl to get block size data of Sensor ADC.   */

#define OSAL_C_S32_IOCTRL_SADC_GET_BLOCK_SIZE  ( OSAL_C_S32_IOCTRL_ADC_BASE + 12)

/*Added new ioctl for Resolution support in Gen3*/

#define OSAL_C_S32_IOCTRL_ADC_GET_CONFIG ( OSAL_C_S32_IOCTRL_ADC_BASE + 13)

/* Dev_steering*/




/*IO Control to register application call back function and which can be
  called once key is pressed or released with keycode */ 
#define OSAL_C_S32_IOCTRL_SWC_REGISTER_CALLBACK	        ((tS32)1)
   // to be removed
#define OSAL_C_S32_IOCTRL_STEERING_WHEEL_SET_CALLBACK_KEY_STATE	((tS32)1)

/*IO Control to get the last key code value */
#define OSAL_C_S32_IOCTRL_SWC_GET_KEY_CODE              ((tS32)2)

// to be removed
#define OSAL_C_S32_IOCTRL_STEERING_WHEEL_GET_KEY_STATE          ((tS32)2)

/*IO Control to get the device state i.e. whether keypad is connected or not*/
#define OSAL_C_S32_IOCTRL_SWC_GET_DEVICE_STATE          ((tS32)3)

/*IO Control to get the keytable information*/
#define OSAL_C_S32_IOCTRL_SWC_CHK_SAMPLE_VALIDITY ((tS32)4)

/*IO Control to load the key table */
#define OSAL_C_S32_IOCTRL_SWC_LOAD_THRESHOLDS ((tS32)5)

/*IO Control to load the key table */
#define OSAL_C_S32_IOCTRL_SWC_GET_VARIANT_TYPE ((tS32)6)

#define OSAL_C_S32_IOCTRL_DEV_SWC_DEVICE_VERSION    ((tS32)7)

/***** Status information on Steering Wheel Control*********/
#define OSAL_C_U8_SWC_CONNECTED          0x800  /* SWC is conntected */
#define OSAL_C_U8_SWC_NOT_CONNECTED      0x1000  /* SWC is not connected */
#define OSAL_C_U8_SWC_SHORT_CIRCUIT      0x2000  /* SWC is short circuited */ 
#define OSAL_C_U8_SWC_INVALID_LEVEL      0x4000  /* SWC is invalid */ 

#define OSAL_C_U8_SWC_VARIANT_TYPE_X351      ((tU16)0xFFE0)  /* SWC variant type X350 */
#define OSAL_C_U8_SWC_VARIANT_TYPE_X250      ((tU16)0xFFE1)  /* SWC variant type X250 */

#define OSAL_C_U8_SWC_JLR_LOAD_X351_THRESHOLDS ((tS32)351)
#define OSAL_C_U8_SWC_JLR_LOAD_X250_THRESHOLDS ((tS32)250)
#define OSAL_C_U16_SWC_LCN2KAY_LOAD_THRESHOLDS      0x101   // set SWC threshold for LCN2Kay variant

#define OSAL_SWC_IO_CTRL_VERSION                    0x0100  // version string read v01.00

/***************  Structures and type definitions **************************/
/*************************************************************************
*	Type definition for ADCs.  
*	Values of this type are used to specify one of the two ADCs that can be
*   attached to the ADCC.
*************************************************************************/

typedef enum
{
    enAdc0,			/* Internal ADC in Arion */
    
    enAdc1			/* Optional external ADC via SPI interface */

}OSAL_tenAdc;


/*************************************************************************
*	 Type definition for scan groups. 
*************************************************************************/

typedef enum
{
    /* Used for channels which are not members of a scan group. */
    enAdcScanGroupNone,		

    enAdcScanGroup0,			/* Scan group 0. */
    
    enAdcScanGroup1			/* Scan group 1. */
  
    
}OSAL_tenAdcScanGroup;
/*************************************************************************
*	 Type definition for threshold comparisons. 
*************************************************************************/

/* Type definition for threshold comparisons.  This type is used to
   specify which kind of comparison a threshold comparsion register
   should be used for. */
typedef enum
{
    /* Less than comparison */
    enAdcThresholdLt,

    /* Greater or equal comparison */
    enAdcThresholdGt

}OSAL_tenAdcComparison;


/*************************************************************************
* 	Parameter structure for OSAL_C_S32_IOCTRL_ADC_CONFIGURE_ADC ioctl.  
*************************************************************************/

typedef struct
{
    /* The ADC to configure. */
   	OSAL_tenAdc enAdc;		    	
	
	/* The value of the prescaler divider (common to both ADCs).
    Allowable values are 0-15.  M_CLK will be divided by
	prescaler_divider + 1  */
	tU8 u8PrescalerDivider;	  		
    
    /* Frequency divider for ADCx_SCLK relative to M_CLK/Prescale.
	The divider is 2^log_2_frequency_divider. Allowable values are
	0 (divider 1) - 12 (divider 4096) */
	tU8 u8Log2FrequencyDivider;		
    
}OSAL_trAdcConfigureAdc;
 
/*************************************************************************
*	Parameter structure for OSAL_C_S32_IOCTRL_ADC_CONFIGURE_SCAN_GROUP
*	and OSAL_C_S32_IOCTRL_ADC_GET_SCAN_GROUP_INFO ioctl.
*************************************************************************/

typedef struct
{
    /* The scan group to configure */							
    OSAL_tenAdcScanGroup enScanGroup;	
	/* The period will be relative to the ADCx_SCLK for this ADC */
    OSAL_tenAdc enAdc;			
	/* Period in ticks of the chosen ADC base clock - 1 */
    tU16 u16Period;			
	/* Enable/disable flag for the scan group */
    tBool bEnable;			    

}OSAL_trAdcConfigureScanGroup;

/*************************************************************************
*	Parameter structure for
*	OSAL_C_S32_IOCTRL_ADC_CONFIGURE_LOGICAL_CHANNEL ioctl.
*************************************************************************/

 
typedef struct
{

    /* The scan group this logical channel belongs to, if any */ 				
    OSAL_tenAdcScanGroup enScanGroup;	
    
    /* Should the clipping detect callback for this logical channel 
	be enabled? */
    tBool bClippingDetectionEnable; 	
    
    /* Should the FIFO be enabled?  This parameter is only used for
	logical channels 0 and 1.  It is ignored for all other
	channels, since they have no FIFOs. */
	tBool bFifoEnable;					

}OSAL_trAdcConfigureLogicalChannel;
 
/*************************************************************************
*	Parameter structure for
*	OSAL_C_S32_IOCTRL_ADC_CONFIGURE_SET_THRESHOLD ioctl.
*************************************************************************/
    
typedef struct
{
   	/* The threshold value */
   	tU16 u16Threshold;					
	/* Greater than or equal / less than */
    OSAL_tenAdcComparison enComparison;		
	/* The number of the comparator register we want to use. */
    tU8 u8RegisterNumber;		    
	/* Should an interrupt be generated for this comparator? */
    tBool bEnable;			

}OSAL_trAdcSetThreshold;

/*************************************************************************
*	Parameter structure for
*	OSAL_C_S32_IOCTRL_ADC_GET_CONFIG ioctl.Added for Gen3 Platform
*************************************************************************/

typedef struct
{
	tU8 u8AdcResolution;        /* Get ADC resolution */

}OSAL_trAdcConfiguration;



/*************************************************************************
*	Type definition for callback events.  
*	Used to specify when a callback function should be called.
*************************************************************************/

typedef enum
{
 	/* Callbacks with this identifier will be called when a scan group 0 
	completion interrupt is received. */
    enAdcCallbackScanGroup0Complete,

    /* Callbacks with this identifier will be called when a scan group 1 
	completion interrupt is received. */
    enAdcCallbackScanGroup1Complete,

    /* Callbacks with this identifier will be called when a clipping interrupt 
	is received.  The callback function has to be installed for a specific 
	logical channel.*/
    enAdcCallbackClippingDetected,

	/* Callbacks with this identifier will be called when a threshold interrupt 
	is received. The callback function has to be installed for a specific 
	logical channel. */
    enAdcCallbackThreshold,

	/* Callbacks with this identifier will be called when a single threshold 
	interrupt is received. The callback function has to be installed for 
	a specific logical channel. */
    enAdcCallbackSingleInterruptThreshold,

	/* Callbacks with this identifier will be called when a End of conversion 
	interrupt is received. The callback function has to be installed for 
	a specific channel.
        Note: This Interrupt is supported only by Dragon Hardware*/
     enAdcCallbackEndOfConversion

}OSAL_tenAdcCallbackType;

/*************************************************************************
*	Type definition for callback functions.
*************************************************************************/

typedef tVoid (*OSAL_tpfnAdcCallback)(tVoid);


 /*************************************************************************
*	Parameter structure for OSAL_C_S32_IOCTRL_ADC_SET_CALLBACK ioctl. 
*************************************************************************/

typedef struct
{
    /* In which situation should the callback function be called? */
    OSAL_tenAdcCallbackType enCallbackType;

    /* The function to call */
    OSAL_tpfnAdcCallback pfnCallbackFunction;

}OSAL_trAdcSetCallback;


/*************************************************************************
*	Parameter structure for OSAL_C_S32_IOCTRL_ADC_SINGLE_READ ioctl.
*************************************************************************/

typedef struct
{
   	/* A pointer to a buffer where the data should be written. */
    tU16* pu16Buffer;
  
   	/* The number of samples to read.  The buffer must be large enough 
	to contain this number of samples. */
    tU32 u32NumSamples;
   
	 /* Specifies the wait strategy.  True if busy wait is to be used,
        false if completion interrupt is to be used. */
    tBool bBusyWait;

}OSAL_trAdcSingleRead;

/*************************************************************************
*	Parameter structure for OSAL_C_S32_IOCTRL_ADC_GET_ATTRIBUTE_DATA_INFO ioctl.
*************************************************************************/
/* added for 'dev_sadc' in ADIT platform */ 
typedef struct 
{
   tS32 hs_dat_size;      /*    - Size of one sampling data of high-speed unit */
   tS32 hs_blk_size;      /*    - Number of sampling data of 1 blocks of high-speed unit */
   tS32 hs_smpl_tim;      /*    - Sampling interval of high-speed unit*/
   tS32 ls_dat_size;      /*    - Size of one sampling data of low-speed unit */
   
} OSAL_trAdcAttributeDataInfo;


/* dev_adcc end */

/* Dev_rms begin*/
#define OSAL_C_S32_IOCTRL_RMS_SET_COUNT            ((tS32)1)
#define OSAL_C_S32_IOCTRL_RMS_GET_COUNT            ((tS32)2)


/* Dev_rms end*/

/* dev_dspexch begin */
/* OSAL_s32IOControl function IDs */
#define OSAL_C_S32_IOCTRL_DSPEXCH_STARTFRONTEND                ((tS32)1)
#define OSAL_C_S32_IOCTRL_DSPEXCH_STOPFRONTEND                 ((tS32)2)
#define OSAL_C_S32_IOCTRL_DSPEXCH_PINGFRONTEND                 ((tS32)3)
#define OSAL_C_S32_IOCTRL_DSPEXCH_GETSHAREDMEMINFO             ((tS32)4)
#define OSAL_C_S32_IOCTRL_DSPEXCH_GETMSGCHANINFO               ((tS32)5)
#define OSAL_C_S32_IOCTRL_DSPEXCH_SENDMSG                      ((tS32)6)
#define OSAL_C_S32_IOCTRL_DSPEXCH_RCVMSG                       ((tS32)7)
#define OSAL_C_S32_IOCTRL_DSPEXCH_REG_NOTIFICATION             ((tS32)8)
#define OSAL_C_S32_IOCTRL_DSPEXCH_ACTIVATE_MIC                 ((tS32)9)
#define OSAL_C_S32_IOCTRL_DSPEXCH_DEACTIVATE_MIC               ((tS32)10)

/** \brief Maximum string length of speechreco application result string */
#define OSAL_C_U32_DSPEXCH_MAX_APPRES_STRLEN       ((tU32)128) /*Bytes*/


/** \brief A pointer to this structure has to be passed as argument to the
  * DSPExchange IOControls OSAL_C_S32_IOCTRL_DSPEXCH_GETSHAREDMEMINFO
  */
typedef struct
{
   /* The following fields indicate information about the shared memory area reserved
    * for the frontend/backend application. As frontend and backend run on different CPUs,
    * the address space of both can be different, i.e. the virtual address of the
    * shared memory area will differ too between frontend and backend. Therefore, both
    * addresses are defined as fields below. The backend is expected to send the frontend
    * address to the frontend (e.g. via message).
    * Note: For now, shared memory (shm) is established solely in the
    * external memory (extmem). Other sections could also be established later (e.g. internal
    * SRAM or DSP internal memory) for more timing critical data.
    */
   tPVoid   pvBackendExtShmStart;  /*!< Virtual start address of ext. shared mem area (backend) */
   tPVoid   pvFrontendExtShmStart; /*!< Virtual start address of ext. shared mem area (frontend) */
   tSize    siExtShmSize;          /*!< Size of external shared mem area in bytes */
} OSAL_trDSPExchSharedMemInfo;

/** \brief A pointer to this structure has to be passed as argument to the
  * DSPExchange IOControls OSAL_C_S32_IOCTRL_DSPEXCH_GETMSGINFO
  */
typedef struct
{
   tBool   bMessagesAvailable;              /*!< Unread messages available? */
} OSAL_trDSPExchMsgChanInfo;

/** \brief This callback reason will be provided as additional info
  * in OSAL_trDSPExchCallbackInfo when performing a callback
  */
typedef enum
{
   eDSPExchEvNewMessage                     /*!< Event: new message received from backend
                                             * (callback data type: OSAL_trDSPExchMsgInfo)
                                             */
} OSAL_tenDSPExchCallbackReason;

/** \brief A pointer to this structure will be passed as argument to the
  * DSPExchange callback
  */
typedef struct
{
   /** \brief This cookie value is not interpreted by the device itself, but
     * will be passed as argument to the callback function (e.g. to distinguish
     * the callback reason in the application if one callback function shall be
     * used on several devices
     */
   tPVoid                           pvCookie;

   /* Actual reason for callback */
   OSAL_tenDSPExchCallbackReason    enCallbackReason;

   /* Callback data (depending on callback reason) */
   tPVoid                           pvCallbackData;
} OSAL_trDSPExchCallbackInfo;


/** \brief DSPExchange event notification callback function
  * Be sure to store the data given by parameter directly in local structures,
  * because the pointers are invalid after the function returns.
  */
typedef tVoid (*OSAL_tpfDSPExchCallback)(const OSAL_trDSPExchCallbackInfo* prCallbackInfo);


/** \brief A pointer to this structure has to be passed as argument to the
  * DSPExchange IOControl OSAL_C_S32_IOCTRL_DSPEXCH_REGNOTIFICATION
  */
typedef struct
{
   /** \brief This cookie value is not interpreted by the device itself, but
    * will be passed as argument to the callback function (e.g. to distinguish
    * the callback reason in the application if one callback function shall be
    * used on several devices */
   tPVoid pvCookie;
   
   /** \brief Pointer to the callback function that is called for
     * notification
     */
   OSAL_tpfDSPExchCallback pfCallback;
} OSAL_trDSPExchCallbackReg;

/** \brief A pointer to this structure has to be passed as argument to the
  * DSPExchange IOControls OSAL_C_S32_IOCTRL_DSPEXCH_STARTFRONTEND,
  * OSAL_C_S32_IOCTRL_DSPEXCH_STOPFRONTEND,
  * OSAL_C_S32_IOCTRL_DSPEXCH_PINGFRONTEND
  */
typedef struct
{
   /** \brief This value is the result of the application control command. Its
     * meaning is defined between frontend and backend. */
   tU32 u32AppCmdResultVal;
   
   /** \brief This is an additional string provided as result of the application
     * control command. Its meaning is defined between frontend and backend.
     */
   tChar szAppCmdResultStr[OSAL_C_U32_DSPEXCH_MAX_APPRES_STRLEN];
} OSAL_trDSPExchAppCtrlInfo;

/** \brief A pointer to this structure has to be passed as argument to the
  * DSPExchange IOControls OSAL_C_S32_IOCTRL_DSPEXCH_SENDMSG,
  * OSAL_C_S32_IOCTRL_DSPEXCH_RCVMSG
  */
typedef struct
{
   /** \brief This is a user provided message buffer */
   tPVoid pvMsgBuffer;
   
   /** \brief This is the size of the provided buffer */
   tSize siBufferSize;

   /** \brief Timeout when receiving message (ignored when sending message)
     *
     * 0: nonblocking
     * 0<x< LIMIT_C_MAX_U32: timeout value in milliseconds
     * 0xFFFFFFFF: blocking
     */
   tU32  u32Timeout;
} OSAL_trDSPExchMsgInfo;

//******************/* dev_dspexch end */*****************************************//

/******************************************************************************************/
/*  Device I2C ABR 24.06.2005                                                             */
/******************************************************************************************/
/*I2C IOCTRL */
#define OSAL_C_S32_IOCTRL_I2C_SET_CLOCKSPEED            ((tS32)1)
#define OSAL_C_S32_IOCTRL_I2C_SET_CALLBACK              ((tS32)2)
#define OSAL_C_S32_IOCTRL_I2C_GET_CALLBACK              ((tS32)3)
#define OSAL_C_S32_IOCTRL_I2C_SET_WRITE_BREAKTIME       ((tS32)4)
#define OSAL_C_S32_IOCTRL_I2C_SET_READ_BREAKTIME        ((tS32)5)
#define OSAL_C_S32_IOCTRL_I2C_GET_STATE_OF_CHANNEL      ((tS32)6)
#define OSAL_C_S32_IOCTRL_I2C_SET_OPMODE				((tS32)7)
#define	OSAL_C_S32_IOCTRL_I2C_COMBINED_TRANSFER		((tS32)8)


/* Clockspeed    I2C standard speed settings. These are specified …. */
typedef enum
{
  OSAL_I2C_CLK_SPEED_50K  = 1,              /* I2C Clockspeed  = 50k         */
  OSAL_I2C_CLK_SPEED_100K = 2,             /* I2C Clockspeed  = 100k        */
  OSAL_I2C_CLK_SPEED_200K = 3,             /* I2C Clockspeed  = 200k        */
  OSAL_I2C_CLK_SPEED_400K = 4              /* I2C Clockspeed  = 400k        */  
}Osal_tenI2CClockSpeed;

typedef enum 
{
  OSAL_I2C_OPMODE_POLLED    = 1,				/** POLLING Mode */
  OSAL_I2C_OPMODE_INTERRUPT	= 2,	     	    /* INTERRUPT Mode */
  OSAL_I2C_OPMODE_INVALID	= 3
} Osal_tenI2CDriverMode;

/*read modes*/
typedef enum
{
  OSAL_I2C_READ_FROM_SLAVE_N_ACK,
  OSAL_I2C_READ_FROM_SLAVE_SUB_ADDR	
}Osal_tenI2CReadMode;

/* write modes*/
typedef enum
{
  OSAL_I2C_WRITE_TO_SLAVE,
  OSAL_I2C_WRITE_TO_SLAVE_SUB_ADDR	
} Osal_tenI2CWriteMode;

/* enum for the state of one channel */
typedef enum
{
  OSAL_I2C_STATUS_CHANNEL_CLOSE,			//the channel is close
  OSAL_I2C_STATUS_CHANNEL_OPEN,				//the channel is open
  OSAL_I2C_STATUS_CHANNEL_BUSY				//the channel is busy
}OSAL_tenI2CStateChan;

/*  I2C channel read mode */
typedef struct OSAL_trI2CReadData
{
   Osal_tenI2CReadMode   i2cReadCommand;   /* read command*/
   tU8 		*i2cRxBuffer;    
   tU8                   *i2cSubaddr;
   tU8		i2cNumberofSubaddr;
}OSAL_trI2CReadData;

/*  I2C channel write mode */
typedef struct OSAL_trI2CWriteData
{
   Osal_tenI2CWriteMode   i2cWriteCommand;  /*write command*/
   tU8 		  *i2cTxBuffer;     
   tU8                    *i2cSubaddr;
   tU8		   i2cNumberofSubaddr;	   
}OSAL_trI2CWriteData;
  
/* typedef  callback  function */
typedef  tVoid (*OSAL_trI2CCallback)(tU16  u16CallbackId, tU8* u8Buff, tS32 s32Count);

/*Set and get Callback */
typedef struct
{
   tU16  				        i2cCallbackId;   	  /* This id value is not interpreted by the device, but will
   						                               * be passed as first argument of the callback function */
   OSAL_trI2CCallback		pCallback;        	/* Pointer to the callback function that is called for notification */
} OSAL_trI2CReqCallback;

/*  I2C channel Combined Transaction */
typedef struct OSAL_trI2CCombinedTransfer
{
   tU8 	     *i2cTxBuffer;   /* buffer filled with address from which data to be read */  
   tU8 	      *i2cRxBuffer;   /* Read buffer */ 
   tU32		 BytesToWrite;/* No of bytes to write */
   tU32            BytesToRead; /* No of bytes to be read */	   
}OSAL_trI2CCombinedTransfer;


/* acoustic */

/* @brief Sample rate (in Hz) 
* 
* This typedef is used when configuring the sample rate for an audio stream, 
* e.g. within IOControls OSAL_C_S32_IOCTRL_ACOUSTICOUT_GET/SET_SAMPLERATE 
*/ 
typedef tU32 OSAL_tAcousticSampleRate; 


/* @brief Size of acoustic buffer (in bytes) 
* 
* This typedef is used when configuring the buffer size for an audio stream,
* e.g. within IOControls OSAL_C_S32_IOCTRL_ACOUSTICOUT_GET/SET_BUFFERSIZE 
*/ 
typedef tSize OSAL_tAcousticBuffersize;


/* @brief PCM sample formats 
* 
* Each entry must provide an OSAL type (representing bitwidth, endianness, 
* sign). All signed values are 2s complement based. 
* The representation of “CPU endianess” is project specific. 
* Note that not each implementation supports all enum values. 
* 
* This typedef is used when configuring the sample format for an audio stream, 
* e.g. within IOControls OSAL_C_S32_IOCTRL_ACOUSTICOUT_GET/SET_SAMPLEFORMAT
*/ 
typedef enum { 
	OSAL_EN_ACOUSTIC_SF_S8,    /*!< signed 8 bit */ 
	OSAL_EN_ACOUSTIC_SF_S16,   /*!< signed 16 bit, CPU endian */ 
	OSAL_EN_ACOUSTIC_SF_S32,   /*!< signed 32 bit, CPU endian */ 
	OSAL_EN_ACOUSTIC_SF_F32,   /*!< float (IEEE 754) 32 bit, CPU endian */ 
	OSAL_EN_ACOUSTIC_SF_S16LE, /*!< signed 16 bit, little endian */ 
	OSAL_EN_ACOUSTIC_SF_S32LE, /*!< signed 32 bit, little endian */ 
	OSAL_EN_ACOUSTIC_SF_F32LE, /*!< float (IEEE 754) 32 bit, little endian */ 
	OSAL_EN_ACOUSTIC_SF_S16BE,  /*!< signed 16 bit, big endian */ 
	OSAL_EN_ACOUSTIC_SF_S32BE, /*!< signed 32 bit, big endian */ 
	OSAL_EN_ACOUSTIC_SF_F32BE  /*!< float (IEEE 754) 32 bit, big endian */ 
	/* add new sample formats here (e.g. unsigned, or little/big endian) */ 
} OSAL_tenAcousticSampleFormat;


/* @brief Acousticout events 
* 
* This typedef is used by the driver when signaling to the client that a new 
* event occurred (via callback, event loop or other notification mechanism). 
*/ 
typedef enum { 
	OSAL_EN_ACOUSTICOUT_EVAUDIOSTOPPED, /*!< audio stopped after last sample */ 
	OSAL_EN_ACOUSTICOUT_EVERRTHRESHREACHED, /*!< error threshold reached */ 
	OSAL_EN_ACOUSTICOUT_EVTIMER, /*!< timer notification */ 
	OSAL_EN_ACOUSTICOUT_EVSTARTMARKREACHED, /*!< marker at phrase start reached */ 
	OSAL_EN_ACOUSTICOUT_EVEPISODEFINISHED, /*!< Episode end Event */
    OSAL_EN_ACOUSTICOUT_LOAN_CB_REGISTERED /*!< Call Back has been registered */
	/* add new events here */ 
} OSAL_tenAcousticOutEvent; 


/* @brief Error types that can occur during audio streaming
* 
* The client can set thresholds for these errors via IOControl 
* OSAL_C_S32_IOCTRL_ACOUSTICOUT_SETERRTHR. Afterwards, the driver will 
* signal to the client when the error threshold counter is reached. 
*/ 
typedef enum { 
	OSAL_EN_ACOUSTIC_ERRTYPE_XRUN,        /*!< buffer xrun (overrun/underrun) */ 
	OSAL_EN_ACOUSTIC_ERRTYPE_BITSTREAM,    /*!< bitstream error */
	OSAL_EN_ACOUSTIC_ERRTYPE_NOVALIDDATA,  /*!< no valid data in stream */
	OSAL_EN_ACOUSTIC_ERRTYPE_WRONGFORMAT,  /*!< wrong format in stream */
	OSAL_EN_ACOUSTIC_ERRTYPE_INTERNALERR,  /*!< internal codec error */
	OSAL_EN_ACOUSTIC_ERRTYPE_FATALERR,     /*!< fatal codec error */
	OSAL_EN_ACOUSTIC_ERRTYPE_BURSTERROR,  /*!< lots of errors in a row*/
	OSAL_EN_ACOUSTIC_ERRTYPE_JUMPBACKERROR,     /*!< decoder wants data from discarded buffer*/
	/* add new error types here */ 
	OSAL_EN_ACOUSTIC_ERRTYPE_LAST          /*!< no actual enum element */
} OSAL_tenAcousticErrType; 


/* @brief acoustic codecs supported by the acoustic device driver 
* 
* This list defines available audio codecs, differentiated as encoders 
* (for acousticin) and decoders (for acousticout). Note that not each
* implementation supports all enum values. 
*/ 
typedef enum { 
	OSAL_EN_ACOUSTIC_DEC_PCM,    /*!< PCM audio decoder/output */ 
	OSAL_EN_ACOUSTIC_ENC_PCM,    /*!< PCM audio encoder/input */ 
	OSAL_EN_ACOUSTIC_DEC_AMR,    /*!< AMR audio decoder */ 
	OSAL_EN_ACOUSTIC_ENC_AMR,    /*!< AMR audio encoder */ 
	OSAL_EN_ACOUSTIC_DEC_AMRWB,  /*!< AMR wideband audio decoder */ 
	OSAL_EN_ACOUSTIC_ENC_AMRWB,  /*!< AMR wideband audio encoder */ 
	OSAL_EN_ACOUSTIC_DEC_MP3,    /*!< MP3 audio decoder */ 
	OSAL_EN_ACOUSTIC_ENC_MP3,    /*!< MP3 audio encoder */
	OSAL_EN_ACOUSTIC_DEC_MP3PRO, /*!< MP3pro audio decoder */ 
	OSAL_EN_ACOUSTIC_ENC_MP3PRO, /*!< MP3pro audio encoder */ 
	OSAL_EN_ACOUSTIC_DEC_AAC,    /*!< AAC audio decoder */ 
	OSAL_EN_ACOUSTIC_ENC_AAC,    /*!< AAC audio encoder */ 
	OSAL_EN_ACOUSTIC_DEC_WMA,    /*!< WMA audio decoder */ 
	OSAL_EN_ACOUSTIC_ENC_WMA,    /*!< WMA audio encoder */ 
	OSAL_EN_ACOUSTIC_DEC_AC3,    /*!< AC3 audio decoder */ 
	OSAL_EN_ACOUSTIC_ENC_AC3,    /*!< AC3 audio encoder */ 
	OSAL_EN_ACOUSTIC_DEC_OGG,    /*!< OGG audio decoder */ 
	OSAL_EN_ACOUSTIC_ENC_OGG,    /*!< OGG audio encoder */ 
	/* add new acoustic codecs here */ 

	OSAL_EN_ACOUSTIC_CODECLAST,  /*!< pseudo entry for last elem in arrays */
	OSAL_EN_ACOUSTIC_CODECFIRST = OSAL_EN_ACOUSTIC_DEC_PCM /*!< pseudo entry */
} OSAL_tenAcousticCodec; 


/* @brief Possible status of media blocks 
* 
* This information is provided to the acoustic driver when playing audio data 
* in order to signal that some data in the stream is corrupt or missing 
*/ 
typedef enum { 
	OSAL_EN_ACOUSTIC_DATA_VALID,     /*!< audio data is valid */ 
	OSAL_EN_ACOUSTIC_DATA_CORRUPTED, /*!< audio data is corrupted */ 
	OSAL_EN_ACOUSTIC_DATA_MISSING,   /*!< audio data is missing */ 
	OSAL_EN_ACOUSTIC_DATA_RAW        /*!< audio data is raw (containing error syndromes) */ 
	/* add new status types here */ 
} OSAL_tenAcousticDataStatus; 

/* @brief Acousticin filter coefficient sets
 *
 * This information is provided to the acousticin driver to set the used 
 * set of filter coefficients for micadc
*/
typedef enum {
   OSAL_EN_ACOUSTICIN_FILTER_COEF_100HZ_5800HZ, /* filter coefficients from dragon spec */
   OSAL_EN_ACOUSTICIN_FILTER_COEF_0HZ_7600HZ,   /* calculated filter coefficients  for 7600 Hz */
   OSAL_EN_ACOUSTICIN_FILTER_COEF_250HZ_7300HZ, /* calculated filter coefficients for 7300 Hz */
   /* add new set of filter coefficients */
   OSAL_EN_ACOUSTICIN_FILTER_COEF_MAX_SETS    /* do not change, must be always the last entry (used for loops) */
} OSAL_tenAcousticInFilterCoefSet;

/* @brief A pointer to this structure has to be passed as argument to the 
* IOControls OSAL_C_S32_IOCTRL_ACOUSTICOUT_GET/SET_SAMPLERATE 
* 
* This struct provides the sample rate for a particular acoustic codec. 
*/ 
typedef struct { 
	OSAL_tenAcousticCodec enCodec;        /*!< codec for sample rate */ 
	OSAL_tAcousticSampleRate nSamplerate; /*!< current sample rate (in Hz)*/ 
} OSAL_trAcousticSampleRateCfg; 


/* @brief A pointer to this structure has to be passed as argument to the
* IOControls OSAL_C_S32_IOCTRL_ACOUSTICOUT_GETSUPP_PCMSAMPLERATE 
* 
* This returns the supported sample rate range in Hz as a set of intervals 
* (e.g. for “quasi continuous” ranges x..y Hz: from[0]=x, to[0]=y; 
* for discrete value x Hz: from[0]=to[0]=x). 
*/ 
typedef struct { 
	OSAL_tenAcousticCodec enCodec;              /*!< codec for sample rate*/ 
	OSAL_tAcousticSampleRate *pnSamplerateFrom; /*!< supported sample rates, From val */ 
	OSAL_tAcousticSampleRate *pnSamplerateTo;   /*!< supported sample rates, To val */ 
	tU32 u32ElemCnt; /*!< size of arrays (# elements) */ 
} OSAL_trAcousticSampleRateCapability; 


/* @brief A pointer to this structure has to be passed as argument to the 
* IOControls OSAL_C_S32_IOCTRL_ACOUSTICOUT_GET/SET_SAMPLEFORMAT 
* 
* This struct provides the sample format for a particular acoustic codec. 
*/ 
typedef struct { 
	OSAL_tenAcousticCodec enCodec; /*!< codec for sample format */ 
	OSAL_tenAcousticSampleFormat enSampleformat; /*!< current sample format */ 
} OSAL_trAcousticSampleFormatCfg; 


/* @brief A pointer to this structure has to be passed as argument to the 
* IOControls OSAL_C_S32_IOCTRL_ACOUSTICOUT_GETSUPP_SAMPLEFORMAT 
*/ 
typedef struct { 
	OSAL_tenAcousticCodec enCodec;                  /*!< codec for sample format */ 
	OSAL_tenAcousticSampleFormat *penSampleformats; /*!< supported sample formats */ 
	tU32 u32ElemCnt;                                /*!< size of array (# elements) */ 
} OSAL_trAcousticSampleFormatCapability; 


/* @brief A pointer to this structure has to be passed as argument to the 
* IOControls OSAL_C_S32_IOCTRL_ACOUSTICOUT_GETSUPP_CHANNELS 
*/ 
typedef struct { 
	tPU32 pu32NumChannels; /*!< number of channels */ 
	tU32 u32ElemCnt;       /*!< size of array (# elements) */ 
} OSAL_trAcousticChannelCapability; 


/* @brief A pointer to this structure has to be passed as argument to the 
* IOControls OSAL_C_S32_IOCTRL_ACOUSTICOUT_GETSUPP_BUFFERSIZE 
*/ 
typedef struct { 
	OSAL_tenAcousticCodec enCodec; /*!< codec for buffer */ 
	OSAL_tAcousticBuffersize *pnBuffersizes; /*!< possible buffer sizes (in bytes) */ 
	tU32 u32ElemCnt; /*!< size of array (# elements) */
} OSAL_trAcousticBufferSizeCapability; 


/* @brief A pointer to this structure has to be passed as argument to the
* IOControls OSAL_C_S32_IOCTRL_ACOUSTICOUT_SETBUFFERSIZE, 
* OSAL_C_S32_IOCTRL_ACOUSTICOUT_GETBUFFERSIZE
*/ 
typedef struct { 
	OSAL_tenAcousticCodec enCodec; /*!< codec for buffer */ 
	OSAL_tAcousticBuffersize nBuffersize; /*!< buffer size (in bytes) */ 
} OSAL_trAcousticBufferSizeCfg; 


/* @brief A pointer to this structure has to be passed as argument to the 
* IOControls OSAL_C_S32_IOCTRL_ACOUSTICOUT_GETSUPP_DECODER 
*/ 
typedef struct { 
	OSAL_tenAcousticCodec *penCodecs; /*!< array of supported decoders */ 
	tU32 u32ElemCnt; /*!< size of array (# elements) */ 
	tU32 u32MaxCodecCnt; /*!< max. number of codec instances */ 
} OSAL_trAcousticCodecCapability; 


/* @brief A pointer to this structure has to be passed as argument to the 
* IOControls OSAL_C_S32_IOCTRL_ACOUSTICOUT_SETERRTHR 
*/ 
typedef struct { 
	OSAL_tenAcousticErrType enErrType; /*!< error type */ 
	tS32 s32Threshold;                 /*!< new threshold value (0=disabled) */ 
} OSAL_trAcousticErrThrCfg; 


/* @brief Information about time stamp */ 
typedef struct { 
	tU32 u32TimestampSec; /*!< time stamp in seconds */ 
	tU32 u32TimestampNsec; /*!< time stamp remainder in nanoseconds */ 
	tU32 u32SampleCount;   /*!< number of played samples at time stamp */
	tS32 s32BitRate;   /*!< bit rate (mp3) of input stream in Kbit/s [0..320], -1 for no valid value*/
	tU32 u32Reserved;   /*reserved*/	
} OSAL_trAcousticTimestamp; 


/* @brief Information about bitrate and time stamp */ 
typedef struct { 
	tU32 u32TimeStampSec; /*!< time stamp in seconds */ 
	tU32 u32TimestampNsec; /*!< time stamp remainder in nanoseconds */ 
	tU32 u32SampleCount;   /*!< number of played samples at time stamp */
	tS32 s32BitRate;   /*!< bit rate (mp3) of input stream in Kbit/s [0..320], -1 for no valid value*/
	tS32 s32Reserved;   /*reserved*/
} OSAL_trAcousticBitRate; 


/* @brief Audio control data for write operation (set) 
* 
* A pointer to this structure has to be passed as argument to the 
* IOControl OSAL_C_S32_IOCTRL_ACOUSTICOUT_SETWRITEINFO 
*/ 
typedef struct { 
	/** @brief timeout for write in ms (OSAL_C_TIMEOUT_NOBLOCKING=nonblocking, 
	* OSAL_C_TIMEOUT_FOREVER=infinite) */ 
	OSAL_tMSecond nTimeout; 

	/** @brief event id to signal when phrase playback starts, 
	* (set to 0 if no marker event shall be signaled for this phrase) */ 
	tU32 u32PhraseStartEvtId; 
	
	/** @brief This indicates the status of the provided audio data *
	* The status indicates if the buffer data is valid, if it is corrupted due 
	* to media read errors, or if a complete block in the stream is missing 
	* due to read errors. The driver can handle corrupted streams better 
	* if this additional flag is provided. */ 
	OSAL_tenAcousticDataStatus enBufStatus; 

	/** @brief Flag indicating that last word of current phrase was written 
	* This is necessary for at least two reasons: 
	* - correct concatenation of next phrase without glitches 
	* - between some encoded phrases (e.g. two AMR phrases) the decoder
	* is required to be reset. */ 
	tBool bPhraseComplete; 
} OSAL_trAcousticOutSetWriteInfo; 



/* @brief Audio data for extended write operation
 *
 * A pointer to this structure has to be passed as argument to the
 * IOControl OSAL_C_S32_IOCTRL_ACOUSTICOUT_EXTWRITE
 *
 */
typedef struct   {
   tPVoid               pvBuffer;       /*!< buffer filled by client
                                             with audio data */
   tU32                 u32BufferSize;  /*!< size of buffer (in bytes) */

   /** @brief timeout for write in ms (OSAL_C_TIMEOUT_NOBLOCKING=nonblocking,
     * OSAL_C_TIMEOUT_FOREVER=infinite) */
   OSAL_tMSecond        nTimeout;

   /** @brief event id to signal when phrase playback starts,
     * (set to 0 if no marker event shall be signaled for this phrase) */
   tU32                 u32PhraseStartEvtId;

   /** @brief This indicates the status of the provided audio data
     *
     * The status indicates if the buffer data is valid, if it is corrupted due
     * to media read errors, or if a complete block in the stream is missing
     * due to read errors. The driver can handle corrupted streams better
     * if this additional flag is provided. */
   OSAL_tenAcousticDataStatus    enBufStatus;

   /** @brief Flag indicating that last word of current phrase was written
  * This is necessary for at least two reasons:
  * - correct concatenation of next phrase without glitches
  * - between some encoded phrases (e.g. two AMR phrases) the decoder
  *   is required to be reset.
  */
   tBool                bEpisodeComplete; 
} OSAL_trAcousticOutWrite;


/* @brief Information about marker event */ 
typedef struct { 
	tU32 u32PhraseStartEvtId; 

	/*!< event id to signal due to phrase playback start */ 
	tU32 u32TimestampSec; 

	/*!< time stamp of event in seconds */ 
	tU32 u32TimestampNsec; 

	/*!< time stamp remainder in nanoseconds */ 
} OSAL_trAcousticOutMarkerEventInfo; 


/* @brief Acousticsrc events 
* 
* This typedef is used by the driver when signaling to the client that a new 
* event occurred (via callback, event loop or other notification mechanism). 
*/ 
typedef enum { 
	OSAL_EN_ACOUSTICSRC_EVAUDIOSTOPPED, /*!< audio stopped after last sample */ 
	OSAL_EN_ACOUSTICSRC_EVERRTHRESHREACHED, /*!< error threshold reached */ 
	OSAL_EN_ACOUSTICSRC_EVTIMER, /*!< timer notification */ 
	OSAL_EN_ACOUSTICSRC_EVSTARTMARKREACHED, /*!< marker at phrase start reached */ 
	OSAL_EN_ACOUSTICSRC_EVEPISODEFINISHED, /*!< Episode end Event */
    OSAL_EN_ACOUSTICSRC_LOAN_CB_REGISTERED /*!< Call Back has been registered */
	/* add new events here */ 
} OSAL_tenAcousticSrcEvent; 


/* @brief Callback for event notification 
* enCbReason: Reason for callback (event) 
* pvAddData: Additional data, depending on callback reason (NULL if unused) 
* pvCookie: Additional data for client which is not interpreted by the device 
*/ 
typedef tVoid (*OSAL_tpfAcousticSrcEvCallback)(OSAL_tenAcousticSrcEvent enCbReason,
              tPVoid pvAddData, 
              tPVoid pvCookie); 


/* @brief A pointer to this structure has to be passed as argument to the 
* ACOUSTICSRC IOControl OSAL_C_S32_IOCTRL_ACOUSTICSRC_REG_NOTIFICATION 
*/ 
typedef struct { 
	/** @brief Pointer to the callback func called for event notification */ 
	OSAL_tpfAcousticSrcEvCallback pfEvCallback; 

	/** @brief Cookie: This value is not interpreted by the device, but will be 
	* passed as argument to the callback func for client specific purposes */ 
	tPVoid pvCookie; 
} OSAL_trAcousticSrcCallbackReg;

/* @brief Information about marker event */ 
typedef struct { 
	tU32 u32PhraseStartEvtId; 

	/*!< event id to signal due to phrase playback start */ 
	tU32 u32TimestampSec; 

	/*!< time stamp of event in seconds */ 
	tU32 u32TimestampNsec; 

	/*!< time stamp remainder in nanoseconds */ 
} OSAL_trAcousticSrcMarkerEventInfo; 


/* @brief A pointer to this structure has to be passed as argument to the 
* IOControls OSAL_C_S32_IOCTRL_ACOUSTICSRC_WAITEVENT 
*/ 
typedef struct { 
	/** @brief timeout for wait in ms (OSAL_C_TIMEOUT_NOBLOCKING=nonblocking, 
	* OSAL_C_TIMEOUT_FOREVER=infinite) */ 
	OSAL_tMSecond nTimeout; 

	OSAL_tenAcousticSrcEvent enEvent; /*!< signaled event */ 

	/** @brief EN_ACOUSTICSRC_EVSTARTMARKREACHED: Additional marker info */ 
	OSAL_trAcousticSrcMarkerEventInfo rMarkerInfo; 

	/** @brief EN_ACOUSTICSRC_EVTIMER: Additional timestamp info */ 
	OSAL_trAcousticTimestamp rTimestampInfo; 

	/** @brief EN_ACOUSTICOUT_EVERRTHRESHREACHED: Additional error info */ 
	OSAL_trAcousticErrThrCfg rErrThresholdInfo; 
} OSAL_trAcousticSrcWaitEvent;


/* @brief Audio data for Sample rate conversion
 *
 * A pointer to this structure has to be passed as argument to the
 * IOControl OSAL_C_S32_IOCTRL_ACOUSTICSRC_CONVERT
 *
 */
typedef struct   {
   tPVoid               pvBuffer;       /*!< buffer filled by client
                                             with audio data */
   tU32                 u32BufferSize;  /*!< size of buffer (in bytes) */

   /** @brief timeout for write in ms (OSAL_C_TIMEOUT_NOBLOCKING=nonblocking,
     * OSAL_C_TIMEOUT_FOREVER=infinite) */
   OSAL_tMSecond        nTimeout;

   /** @brief event id to signal when phrase playback starts,
     * (set to 0 if no marker event shall be signaled for this phrase) */
   tU32                 u32PhraseStartEvtId;

   /** @brief This indicates the status of the provided audio data
     *
     * The status indicates if the buffer data is valid, if it is corrupted due
     * to media read errors, or if a complete block in the stream is missing
     * due to read errors. The driver can handle corrupted streams better
     * if this additional flag is provided. */
   OSAL_tenAcousticDataStatus    enBufStatus;

   /** @brief Flag indicating that last word of current phrase was written
  * This is necessary for at least two reasons:
  * - correct concatenation of next phrase without glitches
  * - between some encoded phrases (e.g. two AMR phrases) the decoder
  *   is required to be reset.
  */
   tBool                bEpisodeComplete; 
} OSAL_trAcousticSrcConvert;


/* @brief Callback for event notification 
* enCbReason: Reason for callback (event) 
* pvAddData: Additional data, depending on callback reason (NULL if unused) 
* pvCookie: Additional data for client which is not interpreted by the device 
*/ 
typedef tVoid (*OSAL_tpfAcousticOutEvCallback) 
              (OSAL_tenAcousticOutEvent enCbReason,
              tPVoid pvAddData, 
              tPVoid pvCookie); 

/* @brief A pointer to this structure has to be passed as argument to the 
* ACOUSTICOUT IOControl OSAL_C_S32_IOCTRL_ACOUSTICOUT_REG_NOTIFICATION 
*/ 
typedef struct { 
	/** @brief Pointer to the callback func called for event notification */ 
	OSAL_tpfAcousticOutEvCallback pfEvCallback; 

	/** @brief Cookie: This value is not interpreted by the device, but will be 
	* passed as argument to the callback func for client specific purposes */ 
	tPVoid pvCookie; 
} OSAL_trAcousticOutCallbackReg;


/* @brief A pointer to this structure has to be passed as argument to the 
* IOControls OSAL_C_S32_IOCTRL_ACOUSTICOUT_WAITEVENT 
*/ 
typedef struct { 
	/** @brief timeout for wait in ms (OSAL_C_TIMEOUT_NOBLOCKING=nonblocking, 
	* OSAL_C_TIMEOUT_FOREVER=infinite) */ 
	OSAL_tMSecond nTimeout; 

	OSAL_tenAcousticOutEvent enEvent; /*!< signaled event */ 

	/** @brief EN_ACOUSTICOUT_EVSTARTMARKREACHED: Additional marker info */ 
	OSAL_trAcousticOutMarkerEventInfo rMarkerInfo; 

	/** @brief EN_ACOUSTICOUT_EVTIMER: Additional timestamp info */ 
	OSAL_trAcousticTimestamp rTimestampInfo; 

	/** @brief EN_ACOUSTICOUT_EVERRTHRESHREACHED: Additional error info */ 
	OSAL_trAcousticErrThrCfg rErrThresholdInfo; 
} OSAL_trAcousticOutWaitEvent;


/* @when call back is been executed it is possible to pass message to the receiving device
*/ 
typedef enum  
{   
   ACOUT_CB_JUST_BUFFER=0, //just delivering buffers
   ACOUT_CB_STOP, //do not fill any more buffers
   ACOUT_CB_ABORT //stop immediately and return all buffers as well 
} OSAL_enAcOutCBMsgLoanBuffer;

#define ACOUSTICOUT_LOANFIELD_SIZE (10)   //number of pointer in the buffer field
/* @brief is filled with dsp_com_buffer, which belong to AcousticOut and are shared with the DSP 
    pointing to pre allocated shared point-to-point (DSP-ARM) buffers
OSAL_EN_ACOUSTICOUT_SHARED_BUFFER_AVAILABLE
*/ 
typedef struct { 
	/** @brief a general information exchange variable.  */ 
	OSAL_enAcOutCBMsgLoanBuffer eInfoVar;
    
	/** @brief how many buuffer are delivered , max ACOUSTICOUT_LOADFIELD_SIZE*/ 
	tU32 uBufferIncluded;
    
	/** @brief size of buffer allocated for each pointer in the pointer field */ 
	tU32 uBufSizeShared;
    
	/** @brief a field of buffers which are loaned from the dsp-com system and  shall be returned or not used in case of error.
            Shall be a non-NULL value for valid buffer or NULL otherwise*/ 
	tPVoid apvLoanBuf[ACOUSTICOUT_LOANFIELD_SIZE]; 
}OSAL_trAcousticOutLoanBufferField;


/* @brief Callback for buffer passing
* uCbBufInfo: general info field, not defined yet  
* prAcOutSharedField: pointer to a shared buffer field
* cookie provided from external device at registration
*/ 
typedef tVoid (*OSAL_tpfAcousticOutCbLoanBuf) (tU32 uCbBufInfo 
                    ,OSAL_trAcousticOutLoanBufferField* prAcOutLoanField
                    ,tPVoid pvCookie);        

/* @brief A pointer to this structure has to be passed as argument to the 
* ACOUSTICOUT IOControl OSAL_C_S32_IOCTRL_ACOUSTICOUT_REG_LOANBUFFER_CALLBACK 
*/ 
typedef struct { 
	/** @brief Pointer to the callback func called for loan buffer handling */ 
	OSAL_tpfAcousticOutCbLoanBuf pfAcOutCbSharedBuf; 

	/** @brief Cookie: This value is not interpreted by the device, but will be 
	* passed as argument to the callback func for client specific purposes */ 
	tPVoid pvExtUseCookie; 
} OSAL_trAcousticOutCbBufLoan_Reg;

/* @special write to AcousticOut with loaned buffer mehtod, which is specially used for PCM-music
 *
 * A pointer to this structure has to be passed as argument to the
 * IOControl   OSAL_C_S32_IOCTRL_ACOUSTICOUT_WRITE_LOANED_BUFFER
 *
 */
typedef struct   {
   tPVoid   pvPcmBuffer_loaned;       /*!< buffer filled by client   with audio data (tr_PcmChannelData)*/
   tU32     u32BufferSize;  /*!< size of buffer (in bytes) */
   tU32     u32WriteTimeout; /* sets the time out for the write , tbd*/ 
   tU32     u32Info;     /* info, tbd*/
} OSAL_trAcOutLoanBuf;


/* @brief Acousticin events
 *
 * This typedef is used by the driver when signaling to the client that a new
 * event occurred (via callback, event loop or other notification mechanism).
*/
typedef enum   {
   OSAL_EN_ACOUSTICIN_EVAUDIOSTOPPED,    /*!< audio stopped after last sample */
   OSAL_EN_ACOUSTICIN_EVERRTHRESHREACHED   /*!< error threshold reached */
   /* add new events here */
} OSAL_tenAcousticInEvent;


/* @brief Audio data for read operation
 *
 * A pointer to this structure has to be passed as argument to the
 * IOControl OSAL_C_S32_IOCTRL_ACOUSTICIN_EXTREAD
 *
 */
typedef struct   {
   tPVoid               pvBuffer;       /*!< buffer filled by client
                                             with audio data */
   tU32                 u32BufferSize;  /*!< size of buffer (in bytes) */

   /** @brief timeout for write in ms (OSAL_C_TIMEOUT_NOBLOCKING=nonblocking,
     * OSAL_C_TIMEOUT_FOREVER=infinite) */
   OSAL_tMSecond        nTimeout;

   /** @brief External timestamp counter denoting start time of audio buf
     * (time base depends on external entity) */
   tU32                 u32Timestamp;

} OSAL_trAcousticInRead;


/* @brief Callback for event notification
 * enCbReason: Reason for callback (event)
 * pvAddData: Additional data, depending on callback reason (NULL if unused)
 * pvCookie: Additional data for client which is not interpreted by the device
 */
typedef tVoid (*OSAL_tpfAcousticInEvCallback)
              (OSAL_tenAcousticInEvent enCbReason,
               tPVoid pvAddData,
               tPVoid pvCookie);

/* @brief A pointer to this structure has to be passed as argument to the
 * ACOUSTICIN IOControl OSAL_C_S32_IOCTRL_ACOUSTICIN_REG_NOTIFICATION */
typedef struct
{
   /** @brief Pointer to the callback func called for event notification */
   OSAL_tpfAcousticInEvCallback pfEvCallback;

   /** @brief Cookie: This value is not interpreted by the device, but will be
     * passed as argument to the callback func for client specific purposes
     */
   tPVoid pvCookie;
} OSAL_trAcousticInCallbackReg;

/* @brief A pointer to this structure has to be passed as argument to the
 * IOControls OSAL_C_S32_IOCTRL_ACOUSTICIN_WAITEVENT
 */
typedef struct   {
   /** @brief timeout for wait in ms (OSAL_C_TIMEOUT_NOBLOCKING=nonblocking,
     * OSAL_C_TIMEOUT_FOREVER=infinite) */
   OSAL_tMSecond            nTimeout;

   OSAL_tenAcousticInEvent  enEvent;    /*!< signaled event */

   /** @brief EN_ACOUSTICOUT_EVERRTHRESHREACHED: Additional error info */
   OSAL_trAcousticErrThrCfg  rErrThresholdInfo;

} OSAL_trAcousticInWaitEvent;

/* @brief Acousticecnr events
 *
 * This typedef is used by the driver when signaling to the client that a new
 * event occurred (via callback, event loop or other notification mechanism).
*/
typedef enum   {
   AC_ECNR_EVAUDIOSTOPPED,      /*!< audio stopped after last sample */
   AC_ECNR_EVERRTHRESHREACHED   /*!< error threshold reached */
   /* add new events here */
} OSAL_tenAcousticECNREvent;

/* @brief Audio data for read operation
 *
 * A pointer to this structure has to be passed as argument to the
 * IOControl OSAL_C_S32_IOCTRL_ACOUSTICECNR_EXTREAD
 *
 */
typedef struct   {
   tPVoid               pvBuffer;       /*!< buffer filled by client
                                             with audio data */
   tU32                 u32BufferSize;  /*!< size of buffer (in bytes) */

   /** @brief timeout for write in ms (OSAL_C_TIMEOUT_NOBLOCKING=nonblocking,
     * OSAL_C_TIMEOUT_FOREVER=infinite) */
   OSAL_tMSecond        nTimeout;

   /** @brief External timestamp counter denoting start time of audio buf
     * (time base depends on external entity) */
   tU32                 u32Timestamp;

} OSAL_trAcousticECNRRead;

/* @brief Callback for event notification
 * enCbReason: Reason for callback (event)
 * pvAddData: Additional data, depending on callback reason (NULL if unused)
 * pvCookie: Additional data for client which is not interpreted by the device
 */
typedef tVoid (*OSAL_tpfAcousticECNREvCallback)
              (OSAL_tenAcousticECNREvent enCbReason,
               tPVoid pvAddData,
               tPVoid pvCookie);

/* @brief A pointer to this structure has to be passed as argument to the
 * ACOUSTICECNR IOControl OSAL_C_S32_IOCTRL_ACOUSTICECNR_REG_NOTIFICATION */
typedef struct
{
   /** @brief Pointer to the callback func called for event notification */
   OSAL_tpfAcousticECNREvCallback pfEvCallback;

   /** @brief Cookie: This value is not interpreted by the device, but will be
     * passed as argument to the callback func for client specific purposes
     */
   tPVoid pvCookie;
} OSAL_trAcousticECNRCallbackReg;

/* @brief A pointer to this structure has to be passed as argument to the
 * IOControls OSAL_C_S32_IOCTRL_ACOUSTICECNR_WAITEVENT
 */
typedef struct   {
   /** @brief timeout for wait in ms (OSAL_C_TIMEOUT_NOBLOCKING=nonblocking,
     * OSAL_C_TIMEOUT_FOREVER=infinite) */
   OSAL_tMSecond            nTimeout;

   OSAL_tenAcousticECNREvent  enEvent;    /*!< signaled event */

   /** @brief EN_ACOUSTICOUT_EVERRTHRESHREACHED: Additional error info */
   OSAL_trAcousticErrThrCfg  rErrThresholdInfo;

} OSAL_trAcousticECNRWaitEvent;



/* end acoustic */

/* Device DRV_Diag_Prod_Proxy, tst 14.09.05 */

typedef void (*OSAL_tpfDiagProdProxyOnReceiveCon)(tU32 u32res);
typedef void (*OSAL_tpfDiagProdProxyOnReceiveInd)(tPCS8 ps8Buffer, tU32 u32nbytes);

typedef struct
{
  OSAL_tpfDiagProdProxyOnReceiveCon m_pOnReceiveCon;
  OSAL_tpfDiagProdProxyOnReceiveInd m_pOnReceiveInd;

} OSAL_trDiagProdProxyCallback;

/* Device DRV_Diag_Custom_Proxy, tst 22.11.05 */

typedef void (*OSAL_tpfDiagCustomProxyOnReceiveStatus)(tU32 u32status);
typedef void (*OSAL_tpfDiagCustomProxyOnReceiveCon)(tU32 u32res);
typedef void (*OSAL_tpfDiagCustomProxyOnReceiveInd)(tPCS8 ps8Buffer, tU32 u32nbytes);
typedef void (*OSAL_tpfDiagCustomProxyOnReceiveResyncStatus)(tU32 u32Resyncstatus);

typedef struct
{
  OSAL_tpfDiagCustomProxyOnReceiveStatus m_pOnReceiveStatus;
  OSAL_tpfDiagCustomProxyOnReceiveCon m_pOnReceiveCon;
  OSAL_tpfDiagCustomProxyOnReceiveInd m_pOnReceiveInd;
  OSAL_tpfDiagCustomProxyOnReceiveResyncStatus m_pOnReceiveResyncStatus;

} OSAL_trDiagCustomProxyCallback;


/* Device DRV_Diag_Custom, tst 30.10.06 */

#define OSAL_C_S32_IOCTRL_DIAGCUSTOM_REG_CSM_ERROR    100
#define OSAL_C_S32_IOCTRL_DIAGCUSTOM_UUDT_FRAME       101

typedef void (*OSAL_tpfDiagCustomOnReceiveCsmError)(tS32 s32code, tS32 s32status);

typedef struct
{
  OSAL_tpfDiagCustomOnReceiveCsmError m_pOnReceiveError;

} OSAL_trDiagCustomCsmErrorCallback;

/* Device dev_DiagEOL, tst 29.06.07 */

#define OSAL_C_S32_IOCTRL_DIAGEOL_GET_MODULE_IDENTIFIER    100

typedef struct
{
  tU8      u8Table;
  tU16     u16Offset;
  tU16     u16EntryLength;
  tPU8     pu8EntryData;
} OSAL_trDiagEOLEntry;

typedef struct
{
  tU8      u8Table;                 /* in */
  tU32     u32PartNumber;           /* out */
  tU8      u8DesignLevelSuffix[2];  /* out */
} OSAL_trDiagEOLModuleIdentifier;


/* GPIO defines & typedefs */
#define OSAL_GPIO_EDGE_NONE 0
#define OSAL_GPIO_EDGE_LOW  1
#define OSAL_GPIO_EDGE_HIGH 2
#define OSAL_GPIO_EDGE_BOTH 3


typedef tVoid (*OSAL_tpfGPIOCallback)(tVoid *);

typedef tU32 OSAL_tGPIODevID;


typedef struct  
{
  OSAL_tGPIODevID         tId;
  union
  {
    tBool                 bState;         /* in/out */
    tU16                  u16Edge;        /* out */  
    OSAL_tpfGPIOCallback  pfCallback;     /* out */
  }
  unData ;
}
OSAL_trGPIOData;

typedef struct  
{
  OSAL_trGPIOData   rData;
  tVoid             *pvArg;
} 
OSAL_trGPIOCallbackData;

/* GPIO defines for OSAL to DTT abstraction */

typedef enum 
{
     OSAL_EN_EMBEDDEDRADIO_SPI_ADR_SPI1_CS       = 1,
     OSAL_EN_EMBEDDEDRADIO_GPIO_ADR_REQ          = 2,
     OSAL_EN_EMBEDDEDRADIO_GPIO_ADR_RESET        = 3,
     OSAL_EN_EMBEDDEDRADIO_GPIO_HW_MUTE          = 4,
     OSAL_EN_EMBEDDEDRADIO_GPIO_AMP_MUTE_ENABLE  = 5,
     OSAL_EN_EMBEDDEDRADIO_GPIO_TUN_PWR_ANT1     = 6,
     OSAL_EN_EMBEDDEDRADIO_GPIO_AMPOP_ON         = 7,
     OSAL_EN_EMBEDDEDRADIO_GPIO_TUN_PWR_ANT1_PCB = 8,
     OSAL_EN_EMBEDDEDRADIO_SPI_HIT_SPI_CS        = 9,
     OSAL_EN_EMBEDDEDRADIO_GPIO_HIT_REQ          = 10,
     OSAL_EN_EMBEDDEDRADIO_GPIO_HIT_RESET        = 11,
     OSAL_EN_CDDRIVE_RESET_GPIO                  = 12,
     OSAL_EN_DISPLAY_SETTINGS                    = 13,
     OSAL_EN_SPM_GPIO                            = 14,
     OSAL_EN_BACKLIGHT_SETTINGS                  = 15,
     OSAL_EN_EMBEDDEDRADIO_GPIO_HIT_PWRSUPPLY        = 16,
     OSAL_EN_EMBEDDEDRADIO_GPIO_AUX_IN_DIAG_ON_LEFT  = 17,
     OSAL_EN_EMBEDDEDRADIO_GPIO_AUX_IN_DIAG_ON_RIGHT = 18,
     OSAL_EN_CAP_GPIO_REQ                            = 19,
     OSAL_EN_CAP_GPIO_RESET                          = 20,
     OSAL_EN_EMBEDDEDRADIO_GPIO_AMP_OFFSET_DETECT    = 21,
     OSAL_EN_EMBEDDEDRADIO_GPIO_AMP_FRONT_STANDBY    = 22,
     OSAL_EN_EMBEDDEDRADIO_GPIO_AMP_REAR_STANDBY     = 23,
     OSAL_EN_PHONE_MUTE_GPIO                         = 24,
     OSAL_EN_EMBEDDEDRADIO_GPIO_AUD_AMP_MUTE         = 25,
     OSAL_EN_EMBEDDEDRADIO_GPIO_AUD_AMP_ON           = 26,
     OSAL_EN_PWR_PHANTOM_MIC_ON                      = 27,
     OSAL_EN_EMBEDDEDRADIO_GPIO_TUN_PWR_ANT2         = 28,
     OSAL_EN_PWR_PHANTOM_XM_TUNER_ON                 = 29,
     OSAL_EN_SELECT_RC2                              = 30,
     OSAL_EN_GNSS_FE_POWER_ON                        = 31,
     OSAL_EN_HC_GPIO_FAN_ON                          = 32,
     OSAL_EN_MIC_HW_POWER_CTRL                       = 33,
     OSAL_EN_MIC_SELECT_CTRL                         = 34,
     OSAL_EN_GNSS_ANTENNA_ERROR_DETECT               = 35,
     OSAL_EN_GNSS_ANTENNA_OPEN_DETECT                = 36,
     OSAL_EN_GNSS_ANTENNA_SHORT_DETECT               = 37,
     OSAL_EN_GNSS_ANTENNA_SHDN                       = 38,
     OSAL_EN_MIC_DIAG1_ENABLE                        = 39,
     OSAL_EN_MIC_DIAG2_ENABLE                        = 40,
     OSAL_EN_TEST_GPIO_INPUT_LOCAL_1                 = 41,
     OSAL_EN_TEST_GPIO_INPUT_LOCAL_2                 = 42,
     OSAL_EN_TEST_GPIO_INPUT_REMOTE_1                = 43,
     OSAL_EN_TEST_GPIO_INPUT_REMOTE_2                = 44,
     OSAL_EN_TEST_GPIO_OUTPUT_LOCAL_1                = 45,
     OSAL_EN_TEST_GPIO_OUTPUT_LOCAL_2                = 46,
     OSAL_EN_TEST_GPIO_OUTPUT_LOCAL_3                = 47,
     OSAL_EN_TEST_GPIO_OUTPUT_REMOTE_1               = 48,
     OSAL_EN_TEST_GPIO_OUTPUT_REMOTE_2               = 49,
     OSAL_EN_TEST_GPIO_OUTPUT_REMOTE_3               = 50,
     OSAL_EN_SPM_GPIO_WAKEUP_CAN                     = 51,
     OSAL_EN_CPU_RUN                                 = 52,
     OSAL_EN_PWR_UDROP_30                            = 53,
     OSAL_EN_SCC_RSTWARN_CPU                         = 54,
     OSAL_EN_CPU_PWR_OFF                             = 55,
     OSAL_EN_DAB_ANTENNA_ERROR_DETECT                = 56,
     OSAL_EN_FMAM_ANTENNA_ERROR_DETECT               = 57,
     OSAL_EN_MUTE_IN_ECALL                           = 58,
     OSAL_EN_MUTE_IN_VDA                             = 59,
     OSAL_EN_DAB_ANTENNA_SHDN                        = 60,
     OSAL_EN_SPM_GPIO_ON_TIPPER                      = 61,
     OSAL_EN_SPM_GPIO_WAKEUP_CD                      = 62,
     OSAL_EN_SPM_GPIO_CD_HW_EJECT                    = 63,
     OSAL_EN_PWR_UDROP_60                            = 64,
     OSAL_EN_PWR_UDROP_90                            = 65,
     OSAL_EN_MAX16946_SHDN                           = 66,
     OSAL_EN_MAX16946_SC                             = 67,
     OSAL_EN_MAX16946_OL                             = 68,
     OSAL_EN_TLF4277_EN                              = 69,
     OSAL_EN_TLF4277_ERROR                           = 70,
     OSAL_EN_ELMOS52240_EN_1                         = 71,
     OSAL_EN_ELMOS52240_NFLT_1                       = 72,
     OSAL_EN_ELMOS52240_EN_2                         = 73,
     OSAL_EN_ELMOS52240_NFLT_2                       = 74,
     OSAL_EN_REVERSE_DETECT                          = 75,
     OSAL_EN_JACK_DETECT                             = 76,
     OSAL_EN_PKB_DETECT                              = 77,
     OSAL_EN_MIC_DETECT                              = 78,
     OSAL_EN_CAMERA_DETECT                           = 79,
     OSAL_EN_PWR_RVC_SHDN                            = 80,
     OSAL_EN_CPU_RST_SCC                             = 81,
     OSAL_EN_CPU_RSTWARN_SCC                         = 82,
     OSAL_EN_TLF4277_EN_2                            = 83,
     OSAL_EN_TLF4277_ERROR_2                         = 84,
     OSAL_EN_DEBUG_WD_OFF                            = 85,
     OSAL_EN_MOST_DIAG_ECL_STATUS                    = 86,
     OSAL_EN_PWR_CDC                                 = 87,
     OSAL_EN_PWR_DISPLAY                             = 88,
     OSAL_EN_U140_SW_ENABLE                          = 89,
     OSAL_EN_U140_SW_DIAG                            = 90,
     OSAL_EN_ACC_DETECT		                          = 91,
     OSAL_EN_HF_VR_MODE		                          = 92,
     OSAL_EN_MIC_CAM			                          = 93,
     OSAL_EN_TEL_MODE_AMP	                          = 94,
     OSAL_EN_CPU_RST_BT	                             = 95,
     OSAL_EN_CPU_RST_WL	                             = 96,	
     OSAL_EN_ILLUMINATION_DETECT                     = 97,
     OSAL_EN_IGNITION_DETECT	                     = 98,
     OSAL_EN_FAREWELL_DETECT                     	 = 99,
     OSAL_EN_GALA_DETECT                     	     = 100,
     OSAL_EN_MR_OUT_DETECT                     	     = 101,
     OSAL_EN_DETECT_PLUG_1                     	     = 102,
     OSAL_EN_DETECT_PLUG_DIAG_1                      = 103,
     OSAL_EN_OUTPUT_SPARE_3                          = 104,
     OSAL_EN_ELMOS52240_NFLT_3                       = 105,	 
     OSAL_EN_FASCIA_CTRL_BZR_4K5                     = 106,
     OSAL_EN_FASCIA_CTRL_BZR_4K                      = 107,	  
     OSAL_EN_I_SPARE2			                     = 108,
     OSAL_EN_SPI_0_SCS			                     = 109,	 
     OSAL_EN_SPI_0_REQ			                     = 110,
     OSAL_EN_SPI_0_ACK			                     = 111,
     OSAL_EN_SPI_23_SCS			                     = 112,
     OSAL_EN_RST_XM				                     = 113,
     OSAL_EN_CPU_SHDN_XM			                 = 114,
     OSAL_EN_TPS7B7702_EN_1                          = 115,
     OSAL_EN_TPS7B7702_NFLT_1                        = 116,
     OSAL_EN_MAX20084_EN_1                           = 117,
     OSAL_EN_MAX20084_NFLT_1                         = 118,
     OSAL_EN_MAX20084_NFLT_2                         = 119,
     OSAL_EN_SCC_DEBUG_REQ_CPU                       = 120,
     OSAL_EN_SCC_REQ_APP_RST                         = 121,
     OSAL_EN_SCC_RST_CPU                             = 122,
     OSAL_EN_MIC_PRIVATE_SW                          = 123,
     OSAL_EN_WAKE_IN_L                               = 124,
     OSAL_EN_WAKE_OUT                                = 125,
     OSAL_EN_TPS7B7702_EN_2                          = 126,
     OSAL_EN_GPIOPINS_LASTENTRY                      = 127

}OSAL_enGpioPins;

/* OSAL defines for GPIO pin hardware identifiers (bank + pin number) */
#if (OSAL_OS==OSAL_LINUX) || (OSAL_OS==OSAL_DARWIN)
#define OSAL_GPIO_OFFSET   0x00010000

#define OSAL_GPIO_B0_OFFSET  0
#define OSAL_GPIO_B1_OFFSET  32
#define OSAL_GPIO_B2_OFFSET  64
#define OSAL_GPIO_B3_OFFSET  96
#define OSAL_GPIO_B4_OFFSET  128
#define OSAL_GPIO_B5_OFFSET  160
#define OSAL_GPIO_B6_OFFSET  192
#define OSAL_GPIO_B7_OFFSET  224
#define OSAL_GPIO_B8_OFFSET  256
#define OSAL_GPIO_B9_OFFSET  288
#define OSAL_GPIO_B10_OFFSET 320
#define OSAL_GPIO_B11_OFFSET 352
#define OSAL_GPIO_B12_OFFSET 384
#define OSAL_GPIO_B13_OFFSET 416
#define OSAL_GPIO_B14_OFFSET 448
#define OSAL_GPIO_B15_OFFSET 480
#define OSAL_GPIO_B16_OFFSET 512
#define OSAL_GPIO_B17_OFFSET 544
#define OSAL_GPIO_B18_OFFSET 576
#define OSAL_GPIO_B19_OFFSET 608
#define OSAL_GPIO_B20_OFFSET 640

#define OSAL_GPIO_B0_P0   (0  + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P1   (1  + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P2   (2  + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P3   (3  + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P4   (4  + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P5   (5  + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P6   (6  + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P7   (7  + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P8   (8  + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P9   (9  + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P10  (10 + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P11  (11 + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P12  (12 + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P13  (13 + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P14  (14 + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P15  (15 + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P16  (16 + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P17  (17 + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P18  (18 + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P19  (19 + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P20  (20 + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P21  (21 + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P22  (22 + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P23  (23 + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P24  (24 + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P25  (25 + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P26  (26 + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P27  (27 + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P28  (28 + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P29  (29 + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P30  (30 + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B0_P31  (31 + OSAL_GPIO_B0_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P0   (0  + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P1   (1  + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P2   (2  + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P3   (3  + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P4   (4  + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P5   (5  + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P6   (6  + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P7   (7  + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P8   (8  + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P9   (9  + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P10  (10 + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P11  (11 + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P12  (12 + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P13  (13 + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P14  (14 + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P15  (15 + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P16  (16 + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P17  (17 + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P18  (18 + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P19  (19 + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P20  (20 + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P21  (21 + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P22  (22 + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P23  (23 + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P24  (24 + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P25  (25 + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P26  (26 + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P27  (27 + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P28  (28 + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P29  (29 + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P30  (30 + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B1_P31  (31 + OSAL_GPIO_B1_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P0   (0  + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P1   (1  + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P2   (2  + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P3   (3  + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P4   (4  + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P5   (5  + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P6   (6  + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P7   (7  + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P8   (8  + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P9   (9  + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P10  (10 + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P11  (11 + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P12  (12 + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P13  (13 + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P14  (14 + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P15  (15 + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P16  (16 + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P17  (17 + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P18  (18 + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P19  (19 + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P20  (20 + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P21  (21 + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P22  (22 + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P23  (23 + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P24  (24 + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P25  (25 + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P26  (26 + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P27  (27 + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P28  (28 + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P29  (29 + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P30  (30 + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B2_P31  (31 + OSAL_GPIO_B2_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P0   (0  + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P1   (1  + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P2   (2  + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P3   (3  + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P4   (4  + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P5   (5  + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P6   (6  + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P7   (7  + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P8   (8  + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P9   (9  + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P10  (10 + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P11  (11 + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P12  (12 + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P13  (13 + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P14  (14 + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P15  (15 + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P16  (16 + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P17  (17 + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P18  (18 + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P19  (19 + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P20  (20 + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P21  (21 + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P22  (22 + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P23  (23 + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P24  (24 + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P25  (25 + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P26  (26 + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P27  (27 + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P28  (28 + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P29  (29 + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P30  (30 + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B3_P31  (31 + OSAL_GPIO_B3_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P0   (0  + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P1   (1  + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P2   (2  + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P3   (3  + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P4   (4  + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P5   (5  + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P6   (6  + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P7   (7  + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P8   (8  + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P9   (9  + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P10  (10 + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P11  (11 + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P12  (12 + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P13  (13 + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P14  (14 + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P15  (15 + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P16  (16 + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P17  (17 + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P18  (18 + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P19  (19 + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P20  (20 + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P21  (21 + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P22  (22 + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P23  (23 + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P24  (24 + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P25  (25 + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P26  (26 + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P27  (27 + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P28  (28 + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P29  (29 + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P30  (30 + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B4_P31  (31 + OSAL_GPIO_B4_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P0   (0  + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P1   (1  + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P2   (2  + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P3   (3  + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P4   (4  + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P5   (5  + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P6   (6  + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P7   (7  + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P8   (8  + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P9   (9  + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P10  (10 + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P11  (11 + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P12  (12 + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P13  (13 + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P14  (14 + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P15  (15 + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P16  (16 + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P17  (17 + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P18  (18 + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P19  (19 + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P20  (20 + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P21  (21 + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P22  (22 + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P23  (23 + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P24  (24 + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P25  (25 + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P26  (26 + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P27  (27 + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P28  (28 + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P29  (29 + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P30  (30 + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B5_P31  (31 + OSAL_GPIO_B5_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P0   (0  + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P1   (1  + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P2   (2  + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P3   (3  + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P4   (4  + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P5   (5  + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P6   (6  + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P7   (7  + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P8   (8  + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P9   (9  + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P10  (10 + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P11  (11 + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P12  (12 + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P13  (13 + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P14  (14 + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P15  (15 + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P16  (16 + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P17  (17 + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P18  (18 + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P19  (19 + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P20  (20 + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P21  (21 + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P22  (22 + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P23  (23 + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P24  (24 + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P25  (25 + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P26  (26 + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P27  (27 + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P28  (28 + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P29  (29 + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P30  (30 + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B6_P31  (31 + OSAL_GPIO_B6_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P0   (0  + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P1   (1  + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P2   (2  + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P3   (3  + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P4   (4  + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P5   (5  + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P6   (6  + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P7   (7  + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P8   (8  + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P9   (9  + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P10  (10 + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P11  (11 + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P12  (12 + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P13  (13 + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P14  (14 + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P15  (15 + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P16  (16 + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P17  (17 + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P18  (18 + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P19  (19 + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P20  (20 + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P21  (21 + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P22  (22 + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P23  (23 + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P24  (24 + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P25  (25 + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P26  (26 + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P27  (27 + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P28  (28 + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P29  (29 + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P30  (30 + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B7_P31  (31 + OSAL_GPIO_B7_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P0   (0  + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P1   (1  + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P2   (2  + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P3   (3  + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P4   (4  + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P5   (5  + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P6   (6  + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P7   (7  + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P8   (8  + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P9   (9  + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P10  (10 + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P11  (11 + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P12  (12 + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P13  (13 + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P14  (14 + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P15  (15 + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P16  (16 + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P17  (17 + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P18  (18 + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P19  (19 + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P20  (20 + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P21  (21 + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P22  (22 + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P23  (23 + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P24  (24 + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P25  (25 + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P26  (26 + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P27  (27 + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P28  (28 + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P29  (29 + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P30  (30 + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B8_P31  (31 + OSAL_GPIO_B8_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P0   (0  + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P1   (1  + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P2   (2  + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P3   (3  + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P4   (4  + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P5   (5  + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P6   (6  + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P7   (7  + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P8   (8  + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P9   (9  + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P10  (10 + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P11  (11 + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P12  (12 + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P13  (13 + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P14  (14 + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P15  (15 + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P16  (16 + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P17  (17 + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P18  (18 + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P19  (19 + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P20  (20 + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P21  (21 + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P22  (22 + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P23  (23 + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P24  (24 + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P25  (25 + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P26  (26 + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P27  (27 + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P28  (28 + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P29  (29 + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P30  (30 + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B9_P31  (31 + OSAL_GPIO_B9_OFFSET  + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P0  (0  + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P1  (1  + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P2  (2  + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P3  (3  + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P4  (4  + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P5  (5  + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P6  (6  + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P7  (7  + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P8  (8  + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P9  (9  + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P10 (10 + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P11 (11 + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P12 (12 + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P13 (13 + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P14 (14 + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P15 (15 + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P16 (16 + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P17 (17 + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P18 (18 + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P19 (19 + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P20 (20 + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P21 (21 + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P22 (22 + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P23 (23 + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P24 (24 + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P25 (25 + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P26 (26 + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P27 (27 + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P28 (28 + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P29 (29 + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P30 (30 + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B10_P31 (31 + OSAL_GPIO_B10_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P0  (0  + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P1  (1  + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P2  (2  + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P3  (3  + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P4  (4  + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P5  (5  + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P6  (6  + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P7  (7  + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P8  (8  + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P9  (9  + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P10 (10 + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P11 (11 + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P12 (12 + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P13 (13 + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P14 (14 + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P15 (15 + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P16 (16 + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P17 (17 + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P18 (18 + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P19 (19 + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P20 (20 + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P21 (21 + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P22 (22 + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P23 (23 + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P24 (24 + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P25 (25 + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P26 (26 + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P27 (27 + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P28 (28 + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P29 (29 + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P30 (30 + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B11_P31 (31 + OSAL_GPIO_B11_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P0  (0  + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P1  (1  + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P2  (2  + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P3  (3  + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P4  (4  + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P5  (5  + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P6  (6  + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P7  (7  + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P8  (8  + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P9  (9  + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P10 (10 + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P11 (11 + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P12 (12 + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P13 (13 + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P14 (14 + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P15 (15 + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P16 (16 + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P17 (17 + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P18 (18 + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P19 (19 + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P20 (20 + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P21 (21 + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P22 (22 + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P23 (23 + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P24 (24 + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P25 (25 + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P26 (26 + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P27 (27 + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P28 (28 + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P29 (29 + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P30 (30 + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B12_P31 (31 + OSAL_GPIO_B12_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P0  (0  + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P1  (1  + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P2  (2  + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P3  (3  + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P4  (4  + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P5  (5  + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P6  (6  + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P7  (7  + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P8  (8  + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P9  (9  + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P10 (10 + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P11 (11 + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P12 (12 + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P13 (13 + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P14 (14 + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P15 (15 + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P16 (16 + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P17 (17 + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P18 (18 + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P19 (19 + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P20 (20 + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P21 (21 + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P22 (22 + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P23 (23 + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P24 (24 + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P25 (25 + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P26 (26 + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P27 (27 + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P28 (28 + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P29 (29 + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P30 (30 + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B13_P31 (31 + OSAL_GPIO_B13_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P0  (0  + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P1  (1  + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P2  (2  + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P3  (3  + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P4  (4  + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P5  (5  + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P6  (6  + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P7  (7  + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P8  (8  + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P9  (9  + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P10 (10 + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P11 (11 + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P12 (12 + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P13 (13 + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P14 (14 + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P15 (15 + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P16 (16 + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P17 (17 + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P18 (18 + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P19 (19 + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P20 (20 + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P21 (21 + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P22 (22 + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P23 (23 + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P24 (24 + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P25 (25 + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P26 (26 + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P27 (27 + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P28 (28 + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P29 (29 + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P30 (30 + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B14_P31 (31 + OSAL_GPIO_B14_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P0  (0  + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P1  (1  + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P2  (2  + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P3  (3  + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P4  (4  + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P5  (5  + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P6  (6  + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P7  (7  + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P8  (8  + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P9  (9  + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P10 (10 + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P11 (11 + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P12 (12 + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P13 (13 + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P14 (14 + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P15 (15 + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P16 (16 + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P17 (17 + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P18 (18 + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P19 (19 + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P20 (20 + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P21 (21 + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P22 (22 + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P23 (23 + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P24 (24 + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P25 (25 + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P26 (26 + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P27 (27 + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P28 (28 + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P29 (29 + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P30 (30 + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B15_P31 (31 + OSAL_GPIO_B15_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P0  (0  + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P1  (1  + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P2  (2  + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P3  (3  + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P4  (4  + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P5  (5  + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P6  (6  + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P7  (7  + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P8  (8  + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P9  (9  + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P10 (10 + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P11 (11 + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P12 (12 + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P13 (13 + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P14 (14 + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P15 (15 + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P16 (16 + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P17 (17 + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P18 (18 + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P19 (19 + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P20 (20 + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P21 (21 + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P22 (22 + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P23 (23 + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P24 (24 + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P25 (25 + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P26 (26 + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P27 (27 + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P28 (28 + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P29 (29 + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P30 (30 + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B16_P31 (31 + OSAL_GPIO_B16_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P0  (0  + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P1  (1  + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P2  (2  + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P3  (3  + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P4  (4  + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P5  (5  + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P6  (6  + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P7  (7  + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P8  (8  + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P9  (9  + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P10 (10 + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P11 (11 + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P12 (12 + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P13 (13 + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P14 (14 + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P15 (15 + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P16 (16 + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P17 (17 + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P18 (18 + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P19 (19 + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P20 (20 + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P21 (21 + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P22 (22 + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P23 (23 + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P24 (24 + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P25 (25 + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P26 (26 + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P27 (27 + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P28 (28 + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P29 (29 + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P30 (30 + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B17_P31 (31 + OSAL_GPIO_B17_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P0  (0  + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P1  (1  + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P2  (2  + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P3  (3  + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P4  (4  + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P5  (5  + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P6  (6  + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P7  (7  + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P8  (8  + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P9  (9  + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P10 (10 + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P11 (11 + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P12 (12 + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P13 (13 + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P14 (14 + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P15 (15 + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P16 (16 + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P17 (17 + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P18 (18 + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P19 (19 + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P20 (20 + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P21 (21 + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P22 (22 + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P23 (23 + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P24 (24 + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P25 (25 + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P26 (26 + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P27 (27 + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P28 (28 + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P29 (29 + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P30 (30 + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B18_P31 (31 + OSAL_GPIO_B18_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P0  (0  + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P1  (1  + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P2  (2  + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P3  (3  + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P4  (4  + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P5  (5  + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P6  (6  + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P7  (7  + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P8  (8  + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P9  (9  + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P10 (10 + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P11 (11 + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P12 (12 + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P13 (13 + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P14 (14 + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P15 (15 + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P16 (16 + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P17 (17 + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P18 (18 + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P19 (19 + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P20 (20 + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P21 (21 + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P22 (22 + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P23 (23 + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P24 (24 + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P25 (25 + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P26 (26 + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P27 (27 + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P28 (28 + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P29 (29 + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P30 (30 + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B19_P31 (31 + OSAL_GPIO_B19_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P0  (0  + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P1  (1  + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P2  (2  + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P3  (3  + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P4  (4  + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P5  (5  + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P6  (6  + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P7  (7  + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P8  (8  + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P9  (9  + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P10 (10 + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P11 (11 + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P12 (12 + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P13 (13 + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P14 (14 + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P15 (15 + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P16 (16 + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P17 (17 + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P18 (18 + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P19 (19 + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P20 (20 + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P21 (21 + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P22 (22 + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P23 (23 + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P24 (24 + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P25 (25 + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P26 (26 + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P27 (27 + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P28 (28 + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P29 (29 + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P30 (30 + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)
#define OSAL_GPIO_B20_P31 (31 + OSAL_GPIO_B20_OFFSET + OSAL_GPIO_OFFSET)

#define OSAL_GPIO_LAST OSAL_GPIO_B20_P31

#endif

/******************************************************************************************/
/*  driver  for CGI Faceplate                                                               */
/******************************************************************************************/
/* IOCTRL */
#define OSAL_C_S32_IOCTRL_CGI_DEV_SET_DIMMING    ((tS32)1)
#define OSAL_C_S32_IOCTRL_CGI_DEV_SET_INDICATOR  ((tS32)2)
#define OSAL_C_S32_IOCTRL_CGI_DEV_CLR_INDICATOR  ((tS32)3)
#define OSAL_C_S32_IOCTRL_CGI_DEV_ABORT_READ     ((tS32)4)
#define OSAL_C_S32_IOCTRL_CGI_DEV_GET_ACTUAL_KEY ((tS32)5)
#define OSAL_C_S32_IOCTRL_CGI_CLEAR_DIAGNOSTIC_INFO ((tS32)6)
#define OSAL_C_S32_IOCTRL_CGI_DEV_HW_TEST_ENABLE          ((tS32)7)
#define OSAL_C_S32_IOCTRL_CGI_DEV_HW_TEST_DISABLE         ((tS32)8)
#define OSAL_C_S32_IOCTRL_CGI_DEV_SET_CNTR_STACK_WAKE     ((tS32)9)
#define OSAL_C_S32_IOCTRL_CGI_DEV_GET_CNTR_STACK_WAKE     ((tS32)10)
#define OSAL_C_S32_IOCTRL_CGI_DEV_SET_CNTR_STACK_RESET    ((tS32)11)
#define OSAL_C_S32_IOCTRL_CGI_DEV_SET_DIMMING_FTD         ((tS32)12)
#define OSAL_C_S32_IOCTRL_CGI_DEV_GET_TEMPERATURE_FTD     ((tS32)13)
#define OSAL_C_S32_IOCTRL_CGI_DEV_SET_PIN_RMTENABLE       ((tS32)15)
#define OSAL_C_S32_IOCTRL_CGI_DEV_SET_PIN_RESET_FTD       ((tS32)16)


/*with the following define the indicator CD inserted can be set or clear*/
#define OSAL_CGI_DEV_INDICATOR_CD_INSERTED                               0x80   


/*count of read bytes, with switch and encoder information*/
#define OSAL_CGI_DEV_COUNT_BYTES_SWITCH_STATE    6
#define OSAL_CGI_DEV_COUNT_BYTES_ENCODER_STATE   6 

/*With the following defines the error codes of the fault data 
  from the faceplate and the communication loses after 3 
  successive retries to the Faceplate are described. */
#define OSAL_CGI_DEV_ERROR_COMMUNICATION_LOST                            0x01   
#define OSAL_CGI_DEV_ERROR_FAULT_DATA_MULTI_FUNCTION_CONTROLLER_COMM     0x02	
#define OSAL_CGI_DEV_ERROR_FAULT_DATA_FACEPLATE_COMM                     0x04	
#define OSAL_CGI_DEV_ERROR_FAULT_DATA_DISPLAY_HEATER                     0x08
#define OSAL_CGI_DEV_ERROR_FAULT_DATA_DISPLAY_CONTROLLER                 0x10
#define OSAL_CGI_DEV_ERROR_FAULT_DATA_RUNNING_RESET_DETECTED             0x20
#define OSAL_CGI_DEV_ERROR_FAULT_DATA_RAM_TEST                           0x40
#define OSAL_CGI_DEV_ERROR_FAULT_DATA_ROM_CHECKSUM                       0x80

/*with the following defines the state information described*/
#define OSAL_CGI_DEV_STATE_RDF_FAIL                                      0x01   
#define OSAL_CGI_DEV_STATE_DISABLE_NORMAL_COMMUNICATION                  0x02
#define OSAL_CGI_DEV_STATE_GET_NO_VALID_KEY_AND_ENCODER_DATA             0x04


/*with the following structure the keys and encoder data are described. 
  After calling the read function, this buffer contains 
  the state for the keys (released or unused, pressed) and 
  the encoder data (see GIS-34A-040 ControlStatus Message Definition [4] ). 
  The buffer must be allocated by the caller of this function. */
typedef struct OSAL_trCgiDevKeyInfo
{
   tU8	u8CgiDevSwitchStatusByte[OSAL_CGI_DEV_COUNT_BYTES_SWITCH_STATE];
   tU8	u8CgiDevEncoderData[OSAL_CGI_DEV_COUNT_BYTES_ENCODER_STATE];
} OSAL_trCgiDevKeyInfo;

/*The following structure is used to read the key and error 
  information with the function OSAL_s32IORead. */
typedef struct OSAL_trCgiDevRead
{
   tU8		                    u8CgiDevErrorCode;        /* in */
   tU8		                    u8CgiDevStateInfo;        /* in */
   OSAL_trCgiDevKeyInfo         trCgiDevRxBuffer;         /* in */
}OSAL_trCgiDevRead;

/*With the following structure the dimming values for the faceplate can be set with the function OSAL_s32IOControl. */
typedef struct OSAL_trCgiDevControlDimming
{
   tU16			            	     	u16CgiDevMainDisplayBrightness;    
   tU16			            	     	u16CgiDevControlBrightness;    
   tU16			            	     	u16CgiDevIndicatorColorOneBrightness;    
} OSAL_trCgiDevControlDimming;

/*The following defines indicates the states of the hardware pin "Centre Stack Wakeline" or Centr Stack Reset, 
which can be set to high/low or get to high/low in the hardware test.*/
#define OSAL_CGI_DEV_CNTR_STACK_LOW                               	0x00    
#define OSAL_CGI_DEV_CNTR_STACK_HIGH                               	0x01   



/*----------------          structure for FTD FrontTouchDisplay   ------------------------*/

/*define for the length of the error bytes, which gets from FTD*/
#define OSAL_CGI_DEV_COUNT_ERROR_FTD         4

/*The following structure is used to read the position of the touch- screen and error 
  information with the function OSAL_s32IORead and the channel OSAL_C_STRING_DEVICE_CGI_DEV_KEY_FTD. */
typedef struct OSAL_trCgiDevReadFTD
{
  tU8   u8CgiDevAction;        
  tU8   u8CgiDevPosX;
  tU8   u8CgiDevPosY;
  tU8   u8CgiDevErrorCodeFTD[OSAL_CGI_DEV_COUNT_ERROR_FTD];       
  tU8   u8CgiDevErrorCodeSBX;           
}OSAL_trCgiDevReadFTD;

/*With the following defines the error codes of the fault data from the FTD  
  and the error communication lost from SBX are described. */
#define OSAL_CGI_DEV_ERROR_COMMUNICATION_LOST_TO_FTD                     0x01   /*u8CgiDevErrorCodeSBX*/
#define OSAL_CGI_DEV_ERROR_FAULT_TOUCHPANEL_CONTROLLER                   0x06             /*u8CgiDevErrorCodeFTD*/
/*if the bit 7 set the error is current, else history*/
#define OSAL_CGI_DEV_ERROR_CURRENT                                       0x80
#define OSAL_CGI_DEV_ERROR_HISTORY                                       0x00


/*with the folowing structure the dimmin values for the FTD can be set with the fucntion OSAL_s32IOControl*/
typedef struct OSAL_trCgiDevControlDimmingFTD
{
   tU16                u16CgiFTDBrightness;      
} OSAL_trCgiDevControlDimmingFTD;

/*With the following structure the temperature 
  info can be get with the function OSAL_s32IOControl.
  If the value of u8CgiHighTempErrorDetect zero the temperature 
  is normal else the touch- screen de-tects a high temperature error. 
  The value of u8CgiTemp can be 0x30-0x7F (48°C -127°C).*/
typedef struct OSAL_trCgiDevControlTempFTD
{
   tU8    u8CgiTempHighErrorDetect;                 
   tU8    u8CgiTemp;        
}OSAL_trCgiDevControlTempFTD;

/*The following defines indicates the states of the hardware pin, 
  which can be set to high/low.*/
#define OSAL_CGI_DEV_PIN_LOW                                   0x00    
#define OSAL_CGI_DEV_PIN_HIGH                                   0x01  


/******************************************************************************************/
/*  driver  for PWM/Dimming                                                          */
/******************************************************************************************/
#define OSAL_C_S32_IOCTRL_PWM_SET_PWM ((tS32) 1)
#define OSAL_C_S32_IOCTRL_PWM_GET_PWM ((tS32) 2)

#define OSAL_C_S32_IOCTRL_ILLUMINATION_SET ((tS32) 3)
#define OSAL_C_S32_IOCTRL_ILLUMINATION_GET ((tS32) 4)
#define OSAL_C_S32_IOCTRL_ILLUMINATION_SET_BACKLIGHT ((tS32) 5)
#define OSAL_C_S32_IOCTRL_ILLUMINATION_SET_LCD 		((tS32) 6)
#define OSAL_C_S32_IOCTRL_ILLUMINATION_GET_LCD_READY_STATUS ((tS32) 7)
#define OSAL_C_S32_ILLUM_ON	   ((tS32) 1)
#define OSAL_C_S32_ILLUM_OFF   ((tS32) 0)
typedef struct
{
  tS32 hz;
  tS32 percent_high;
} OSAL_trPWM_SetPwm;

/******************************************************************************************/
/*  Driver for Rotary Encoder */
/******************************************************************************************/

/* IO Control to get the version details of the driver */
#define OSAL_C_S32_IOCTRL_ROT_ENCODER_GET_VERSION ((tS32)1)

/*IO Control to register application call back function with the driver framework */
#define OSAL_C_S32_IOCTRL_ROT_ENCODER_REG_CALLBACK ((tS32)2)

/* IO Control to test the supportive driver's functions */
#define OSAL_C_S32_IOCTRL_DRIVER_TEST ((tS32)0x2012)

typedef enum
{
   ROTENC_EN_ROT_CLKWISE,                  /* MOVEMENT OF ENCODER IN CLOCKWISE DIRECTION -> 0*/
   ROTENC_EN_ROT_CCLKWISE                  /* MOVEMENT OF ENCODER IN ANTICLOCKWISE DIRECTION-> 1*/
}OSAL_tenRotEncoderDir;

typedef enum
{
   ROTENC_EN_ROT_LEFT,                        /* LEFT ENCODER -> 0*/
   ROTENC_EN_ROT_RIGHT                        /* RIGHT ENCODER -> 1*/   
}OSAL_tenRotEncoderType;

typedef struct
{
   OSAL_tenRotEncoderType tenRot_Type;
   OSAL_tenRotEncoderDir tenRot_Dir;
   tU32 u32Count;                        /* Rotational count of the encoder */
}OSAL_trRotEncoderData;


typedef void (*OSAL_tpf_RotEncoder_Callback)(OSAL_trRotEncoderData * );  // Callback

/*****************************************************************************************/
/*  Typedefs & defines for /dev/card													 */
/*****************************************************************************************/
/* File Attribute definitions. */
#define OSAL_C_U8_FIO_ATTRIB_NORMAL         0x00 /* Normal file attributes. */
#define OSAL_C_U8_FIO_ATTRIB_ARDONLY        0x01 /* Read only file attributes. */
#define OSAL_C_U8_FIO_ATTRIB_AHIDDEN        0x02 /* Hidden file attributes. */
#define OSAL_C_U8_FIO_ATTRIB_ASYSTEM        0x04 /* System file attributes. */
#define OSAL_C_U8_FIO_ATTRIB_AVOLUME        0x08 /* Volume Label file attributes. */
#define OSAL_C_U8_FIO_ATTRIB_ADIRENT        0x10 /* Directory file attributes. */
#define OSAL_C_U8_FIO_ATTRIB_ARCHIVE        0x20 /* Archives file attributes. */

typedef struct   {
   tBool    bHW_WriteProtected;    /* indicates HW wite protection of the card is set*/
   tBool    bSW_WriteProtected;    /* indicates HW wite protection of the card is set*/
   tBool    bMounted;              /* indicates the current mount state*/
   tU16     u16UncleanUnmountCnt;  /* indicates the number of unclean unmounts*/
   tU16     u16UncleanWriteCnt;  /* indicates the number of unclean Writes*/
   tU16     u16UncleanReadCnt;  /* indicates the number of unclean Reads*/
   tU8      u8ManufactureId; /* Card ManufactureId */
   tU32     u32SerialNumber; /* Card SerialNumber */
   /* u8SDCardSpecVersion indicates the the value of CSD Register */
   /* ('0' indicates spec 1.0 to 1.10) */
   tU8      u8SDCardSpecVersion;  
   tU8      u8CIDRegister[16];  /*content of Card Id Rgister*/
   tU64     u64CardSize; /* card size */
   /*applications have to pass the uuid as szDevicName to access the OSAL_C_S32_IOCTRL_CARD_STATE IOCTRL*/
   tChar    szDevicName[64]; 
} OSAL_trIOCtrlCardState;

/* to get/update the File/Directory attributes from card */
typedef struct   {
   tU8 u8Attr;
   tU8 au8FileName[256];
} OSAL_trIOCtrlCardFileAttr;

typedef void (*OSAL_tpfCardCallback) (tU8 u8Progress); 
/* u8Progress indicates the progress in percent (0->0% - 100->100%) */


/* A pointer to this structure has to be passed as argument to the
 Card IOControl OSAL_C_S32_IOCTRL_CARD_CHKDSK_NOTIFY */
typedef struct
{
      /* Pointer to the callback func called for progress notification */
   OSAL_tpfCardCallback            pvCardCallbackData;
     /** Cookie: This value is not interpreted by the device, but will be
     * passed as argument to the callback func for client specific purposes*/
   tPVoid pvCookie;
     
} OSAL_trCardCallbackReg;

typedef enum {
   OSAL_EN_SIGN_TYPE_UNKNOWN = -1,
   OSAL_EN_SIGN_XML_VIN, 
   OSAL_EN_SIGN_XML_CID,
   OSAL_EN_SIGN_BINARY_CID,
   OSAL_EN_SIGN_XML_DID
} OSAL_tenSignFileType;
typedef enum {
   OSAL_EN_SIGN_STATUS_UNKNOWN = -1,
   OSAL_EN_SIGN_VERIFY_PASSED, 
   OSAL_EN_SIGN_VERIFY_INPROGRESS, 
   OSAL_EN_SIGN_VERIFY_FAILED 
} OSAL_tenSignVerifyStatus;

typedef struct {
   OSAL_tenSignFileType enSigType; /* Type of the Signature File*/
   tCString coszCertPath; /* Certificate File Path */
} OSAL_trGetSigTypeArg;

typedef struct {
   OSAL_tenSignVerifyStatus enStatus; /* Signature verification Status */
   tCString coszCertPath; /* Certificate File Path */
} OSAL_trTrigSigVerifyArg;

#define OSAL_C_U32_ERROR_OTHER                  ((tU32)0x0000) 
#define OSAL_C_U32_ERROR_CLEANUNMOUNTED         ((tU32)0x0001)
#define OSAL_C_U32_ERROR_UNCLEANUNMOUNTED       ((tU32)0x0002)

#define OSAL_C_U32_CRYPT_DEV_CARD_NUM   (0)
#define OSAL_C_U32_MUSIC_MM_CARD_NUM    (1)
/*****************************************************************************************/
/*  Typedefs & defines for /dev/abs                                                      */
/*****************************************************************************************/
/* -- IOControl functions ----------------------------------------------- */
#define OSAL_C_S32_IOCTRL_ABS_FLUSH  ((tS32)1) /* Flush the ring buffer of the device. */
#define OSAL_C_S32_IOCTRL_ABS_GETCNT ((tS32)2) /* Return the number of entries currently 
                                                  in the ring buffer. */
#define OSAL_C_S32_IOCTRL_ABS_GET_SAMPLING_INTERVAL ((tS32)3)
/* -- Status code definitions ------------------------------------------- */
#define OSAL_C_U8_ABS_STATUS_NORMAL         0    /* Data is trustworthy. */
#define OSAL_C_U8_ABS_STATUS_DATA_INVALID   0xf9 /* Consistency of data cannot be guaranteed. */
#define OSAL_C_U8_ABS_STATUS_INTERNAL_ERROR 0xfa /* Internal error in the device driver. */
#define OSAL_C_U8_ABS_STATUS_NO_INFO        0xfb /* Information not available */
#define OSAL_C_U8_ABS_STATUS_NO_MOVEMENT    0xfc /* Vehicle is not moving. */
#define OSAL_C_U8_ABS_STATUS_ERROR          0xfd /* The vehicle has reported an error. */
#define OSAL_C_U8_ABS_STATUS_DISCONNECTED   0xfe /* The vehicle's CAN bus is inactive. */
#define OSAL_C_U8_ABS_STATUS_UNKNOWN        0xff /* The status could not be determined. */
#define OSAL_C_U8_ABS_DIR_UNKNOWN 0 /* The wheel's direction of rotation cannot be determined. */
#define OSAL_C_U8_ABS_DIR_FORWARD 1 /*  */
#define OSAL_C_U8_ABS_DIR_REVERSE 2 /*  */
/* -- IORead data structure --------------------------------------------- */
typedef struct
{
   tU32 u32TimeStamp; /* Time stamp for this data set. Refers to /dev/auxclock. */
   tU32 u32CounterFrontLeft;  /* Wheel counter value for the left front wheel. */
   tU32 u32CounterFrontRight; /* Wheel counter value for the right front wheel. */
   tU32 u32CounterRearLeft;   /* Wheel counter value for the left rear wheel. */
   tU32 u32CounterRearRight;  /* Wheel counter value for the right rear wheel. */
   tU8 u8StatusFrontLeft;     /* Status of the front left wheel counter. */
   tU8 u8StatusFrontRight;    /* Status of the front right wheel counter. */
   tU8 u8StatusRearLeft;      /* Status of the rear left wheel counter. */
   tU8 u8StatusRearRight;     /* Status of the rear right wheel counter. */
   tU8 u8DirectionFrontLeft;  /* Direction of the front left wheel counter. */
   tU8 u8DirectionFrontRight; /* Direction of the front right wheel counter */
   tU8 u8DirectionRearLeft;   /* Direction of the rear left wheel counter. */
   tU8 u8DirectionRearRight;  /* Direction of the rear right wheel counter */
   tU16 u16ErrorCounter;
} OSAL_trAbsData;

/*****************************************************************************************/
/*  Typedefs & defines for /dev/steering                                                      */
/*****************************************************************************************/
/* -- IOControl functions ----------------------------------------------- */
#define OSAL_C_S32_IOCTRL_STEERING_FLUSH  ((tS32)1) /* Flush the ring buffer of the device. */
#define OSAL_C_S32_IOCTRL_STEERING_GETCNT ((tS32)2) /* Return the number of entries currently in 
                                                       the ring buffer. */
/* -- Status code definitions ------------------------------------------- */
#define OSAL_C_U8_STEERING_STATUS_NORMAL         0    /* Data is trustworthy. */
#define OSAL_C_U8_STEERING_STATUS_DATA_INVALID   0xf9 /* Consistency of data cannot be guaranteed. */
#define OSAL_C_U8_STEERING_STATUS_INTERNAL_ERROR 0xfa /* Internal error in the device driver. */
#define OSAL_C_U8_STEERING_STATUS_NO_INFO        0xfb /* Information not available */
#define OSAL_C_U8_STEERING_STATUS_NO_MOVEMENT    0xfc /* Vehicle is not moving. */
#define OSAL_C_U8_STEERING_STATUS_ERROR          0xfd /* The vehicle has reported an error. */
#define OSAL_C_U8_STEERING_STATUS_DISCONNECTED   0xfe /* The vehicle's CAN bus is inactive. */
#define OSAL_C_U8_STEERING_STATUS_UNKNOWN        0xff /* The status could not be determined. */
/* -- IORead data structure --------------------------------------------- */
typedef struct
{
   tU32 u32TimeStamp;   /* Time stamp for this data set. Refers to /dev/auxclock.*/
   tS32 s32WheelAngle;  /* Steering wheel angle. The unit is 1/1000 degrees. pos val = clockwise */
   tS32 s32WheelRate;   /* Steering wheel angular rate. The unit is 1/1000 degrees/second. pos val = clockwise */
   tU8 u8StatusWheelAngle; /* Status for the wheel angle information. Use OSAL_C_U8_STEERING_STATUS_* constants */
   tU8 u8StatusWheelRate;  /* Status for the wheel angular rate information. use OSAL_C_U8_STEERING_STATUS_* */
   tU8 u8FillByte1;
   tU8 u8FillByte2;
} OSAL_trSteeringData;

/*****************************************************************************************/
/*  Typedefs & defines for /dev/matrix_key                                               */
/*****************************************************************************************/
// FIXME: Can't use define because OEDT doesn't compile. Seems as if OsalConf.h is included after this header.
//#ifdef MATRIX_KEYPAD_ACTIVE
#define OSAL_MATRIX_KEYPAD_IO_CTRL_VERSION  ((tU32)0x00000001)  //Driver version

#define OSAL_C_S32_IOCTRL_DEV_MATRIX_KEY_REG_CALLBACK          ((tS32)1)
#define OSAL_C_S32_IOCTRL_DEV_MATRIX_KEY_GET_KEY_CODE           ((tS32)2)
#define OSAL_C_S32_IOCTRL_DEV_MATRIX_KEY_DEVICE_VERSION        ((tS32)3)

typedef enum
{
    OSAL_EN_MTX_KEY_PRESSED = 0,    /* key is pressed */
    OSAL_EN_MTX_KEY_RELEASED       /* key is released */
} OSAL_tenMatrixKeyState;

typedef struct
{
    OSAL_tenMatrixKeyState   enKeyState;
    tU32                        u32KeyCode;
} OSAL_trMatrixKeyCodeInfo;

typedef tVoid   (*OSAL_tpfMatrixKeypadCallbackFn) (OSAL_trMatrixKeyCodeInfo *);   // Callback function
//#endif //MATRIX_KEYPAD_ACTIVE


/*****************************************************************************************/
/*  Typedefs & defines for /dev/touchscreen                                                      */
/*****************************************************************************************/
/* -- IOControl functions -------------------------------------------------------------- */
// FIXME: Can't use define because OEDT doesn't compile. Seems as if OsalConf.h is included after this header.
//#ifdef TOUCHSCREEN_ACTIVE
#define OSAL_TOUCHSCREEN_IO_CTRL_VERSION    ((tU32)0x00000001)  //Driver version

#define OSAL_C_TOUCHSCREEN_CAL_COUNT_MAX 5
#define OSAL_C_TOUCHSCREEN_CALIBRATION_VERSION 0xAAAA

#define OSAL_C_S32_IOCTL_TOUCHSCREEN_CLEARFIFO         ((tS32)1)
#define OSAL_C_S32_IOCTL_TOUCHSCREEN_GETCALINFO        ((tS32)2)
#define OSAL_C_S32_IOCTL_TOUCHSCREEN_SETCALINFO        ((tS32)3)
#define OSAL_C_S32_IOCTL_TOUCHSCREEN_PUTCALPOINT       ((tS32)4)
#define OSAL_C_S32_IOCTL_TOUCHSCREEN_SETCALIBRATION    ((tS32)5)
#define OSAL_C_S32_IOCTL_TOUCHSCREEN_GETCALVALUES      ((tS32)6)
#define OSAL_C_S32_IOCTL_TOUCHSCREEN_PUTCALVALUES      ((tS32)7)
#define OSAL_C_S32_IOCTL_TOUCHSCREEN_GETDISPPPROP      ((tS32)8)
#define OSAL_C_S32_IOCTL_TOUCHSCREEN_SETREADTIMEOUT_MS ((tS32)9)
#define OSAL_C_S32_IOCTL_TOUCHSCREEN_GETREADTIMEOUT_MS ((tS32)10)
#define OSAL_C_S32_IOCTL_TOUCHSCREEN_READ_W_TMO        ((tS32)11)
#define OSAL_C_S32_IOCTL_TOUCHSCREEN_REG_CALLBACK      ((tS32)12)
#define OSAL_C_S32_IOCTL_TOUCHSCREEN_DEVICE_VERSION    ((tS32)13)
#define OSAL_C_S32_IOCTL_TOUCHSCREEN_REG_CALIBRATION_CALLBACK ((tS32)14)
#define OSAL_C_S32_IOCTL_TOUCHSCREEN_START_CALIBRATION ((tS32)15)
#define OSAL_C_S32_IOCTL_TOUCHSCREEN_SET_CALIBRATION_INFO  ((tS32)16) 
#define OSAL_C_S32_IOCTL_TOUCHSCREEN_ABORT_CALIBRATION ((tS32)17)
#define OSAL_C_S32_IOCTL_TOUCHSCREEN_SETRESPONSE_TIME ((tS32)18)
#define OSAL_C_S32_IOCTL_TOUCHSCREEN_SETDISPLAYSIZE ((tS32)19)
#define  OSAL_C_U32_TOUCHSCREEN_PEN_DOWN   ((tU32)0xCD) 
#define  OSAL_C_U32_TOUCHSCREEN_PEN_UP     ((tU32)0xCE)
#define  OSAL_C_U32_TOUCHSCREEN_PEN_NOMOVE ((tU32)0xCF)
#define  OSAL_C_U32_TOUCHSCREEN_PEN_MOVE   ((tU32)0xE0)

typedef struct 
{
  tU8   u8Len       ;
  tU16  u16TpcCmd   ;
  tS16  s16Pixel_X  ;
  tS16  s16Pixel_Y  ;
  tS32  s32AdcMax   ;
  tS32  s32Adc_X    ;
  tS32  s32Adc_Y    ;
 }OSAL_trTouchscreenPoint;

typedef struct
{
  tS16   as16CrossSize;              // best size of cross size for Display (= pixel per cross angle)
  tS16   as16RefPoints;              // Number of reference points
  tS16   as16Val_X;                  // Validation point
  tS16   as16Val_Y;
  tS16   as16Ref_X[OSAL_C_TOUCHSCREEN_CAL_COUNT_MAX];   // Pixel reference
  tS16   as16Ref_Y[OSAL_C_TOUCHSCREEN_CAL_COUNT_MAX];
}OSAL_trTouchscreenCalInfo;

typedef struct 
{
	tBool IscalPhase;
	tBool IsValiPhase;
	tU32 u32CalpageIndex;
	tU32 u32ValPageIndex;
	tU16 u16XValue;
	tU16 u16YValue;
}OSAL_trTouchscreenCalibrationInfo;

typedef enum
{
	TOUCH_CAL_PAINT_PAGE1 = 1, /* Page number starts form 1 */
	TOUCH_CAL_PAINT_PAGE2,
	TOUCH_CAL_PAINT_PAGE3,
	TOUCH_CAL_PAINT_VAL_PAGE1,
	TOUCH_CAL_PAINT_VAL_PAGE2,
	TOUCH_CAL_SUCCESSFUL_END,
	TOUCH_CAL_FAILURE
}OSAL_tenCalStatus;

typedef struct 
{
  tU32   Ver;    /* Type of Calculation */
  tS32   An;     /* A = An/Divider */
  tS32   Bn;     /* B = Bn/Divider */
  tS32   Cn;     /* C = Cn/Divider */
  tS32   Dn;     /* D = Dn/Divider */
  tS32   En;     /* E = En/Divider */
  tS32   Fn;     /* F = Fn/Divider */
  tS32   Divider;
} OSAL_trCalibrationMatrix;

/* If the ADc is 12 bit resolution */
typedef struct 
{
  tU32   Ver;    /* Type of Calculation */
  tS64   An;     /* A = An/Divider */
  tS64   Bn;     /* B = Bn/Divider */
  tS64   Cn;     /* C = Cn/Divider */
  tS64   Dn;     /* D = Dn/Divider */
  tS64   En;     /* E = En/Divider */
  tS64   Fn;     /* F = Fn/Divider */
  tS64   Divider;
} OSAL_trCalibrationMatrix_64bit;

typedef struct 
{
  tS16  s16x_size;               /* x-size (horizontal) of the display */
  tS16  s16y_size;               /* y-size (vertical) of the display*/
  tBool bDualview;             /* if TRUE display is a dualview display */
} OSAL_trTouchscreenDispProp;  

typedef struct OSAL_trTouchPointCo
{
    tU16    u16x_co;
    tU16    u16y_co;
} OSAL_trTouchPointCo;  /*Touch co-ordinate*/


typedef enum
{
    PEN_DOWN = 0,       /* Touch screen is pressed*/
    PEN_MOVE,
    PEN_UP             /* Touch screen is released */
} OSAL_tenTouchState;

typedef struct OSAL_trArgTouchPoint
{
    OSAL_trTouchPointCo rTouchPoint;
    OSAL_tenTouchState  enTouchState;
    tU32 u32Timestamp;
} OSAL_trArgTouchPoint;

typedef tVoid (*OSAL_tpfTouchCallbackFn) (OSAL_trArgTouchPoint *); // Callback function

typedef struct
{
	tU32 u32Width;
	tU32 u32Height;
} OSAL_trDisplayConf;
//#endif //TOUCHSCREEN_ACTIVE

/*****************************************************************************************/
/*  Typedefs & defines for /dev/steering                                                      */
/*****************************************************************************************/
// FIXME: Can't use define because OEDT doesn't compile. Seems as if OsalConf.h is included after this header.
//#ifdef SWC_ACTIVE

//structure to check the validity of read sample
typedef struct
{
  tBool bIsValidwindow;
  tU16 u16Samplevalue;	
}OSAL_trIOCtrlSWCCheckSample;

typedef enum
{
    OSAL_EN_SWC_KEY_PRESSED = 0,    /* key is pressed */
    OSAL_EN_SWC_KEY_RELEASED       /* key is released */
} OSAL_tenSWCState;

typedef struct
{
    OSAL_tenSWCState    enKeyState;
    tU32                u32KeyCode;
} OSAL_trSWCKeyCodeInfo;

/************************************************************************
Structure used to store voltage levels of keypad status
************************************************************************/
typedef struct
{
   tU16 u16BaseVoltLow;
   tU16 u16BaseVoltHigh;
} OSAL_trSWCKeypadNoOperationWindow;

/************************************************************************
Structure used to store voltage levels of a key
************************************************************************/
typedef struct
{
   tU16 u16Lowerlimit;
   tU16 u16Upperlimit;
   tU16 u16KeyCode;
} OSAL_trSWCKeyWindow;
/************************************************************************
Structure used to store number of keys in swc_a and swc_b keypad and
those key voltage and keycode information
************************************************************************/
typedef struct
{
   tU8 u8NoOfKeys_A;
   tU8 u8NoOfKeys_B;
   OSAL_trSWCKeyWindow * rSWCKeyWindow;
} OSAL_trSWCKeysInfo;


typedef struct
{
   tU16 u16SwcKeypadVersion;
   OSAL_trSWCKeysInfo rSWCKeysInfo;
   OSAL_trSWCKeypadNoOperationWindow swc_A_NoOperation_Volt_Window;
   OSAL_trSWCKeypadNoOperationWindow swc_B_NoOperation_Volt_Window;
} OSAL_trSWCCfgVar;

typedef tVoid   (*OSAL_tpfSWCCallbackFn) (OSAL_trSWCKeyCodeInfo *);   // Callback function
//#endif //SWC_ACTIVE

/*****************************************************************************************/
/*  Typedefs & defines for /dev/ipod                                                      */
/*****************************************************************************************/
#define OSAL_C_S32_IOCTRL_IPOD_WRITE_BREAKTIME_SET          ((tS32)1)
#define OSAL_C_S32_IOCTRL_IPOD_READ_BREAKTIME_SET           ((tS32)2)

#define OSAL_C_S32_IOCTRL_IPOD_REG_CALLBACK                 ((tS32)17)
#define OSAL_C_S32_IOCTRL_IPOD_UNREG_CALLBACK               ((tS32)18)
#define OSAL_C_S32_IOCTRL_IPOD_SET_SAMPLERATE               ((tS32)19)
#define OSAL_C_S32_IOCTRL_IPOD_ACTIVATE_AUDIO               ((tS32)20)
#define OSAL_C_S32_IOCTRL_IPOD_ACTIVATE_USB_VBUS            ((tS32)21)
#define OSAL_C_S32_IOCTRL_IPOD_DEACTIVATE_USB_VBUS          ((tS32)22)

// functions for USB Host
#define OSAL_C_S32_IOCTRL_USBH_GETDEVICEINFO                ((tS32)31)
#define OSAL_C_S32_IOCTRL_USBH_SELECT_CONFIGURATION         ((tS32)32)
#define OSAL_C_S32_IOCTRL_USBH_MOUNT                        ((tS32)33)
#define OSAL_C_S32_IOCTRL_USBH_GETHUBDEVICEINFO             ((tS32)34)

// functions for USB IPOD
#define OSAL_C_S32_IOCTRL_IPOD_GETDEVICEINFO                ((tS32)31)
#define OSAL_C_S32_IOCTRL_IPOD_SELECT_CONFIGURATION         ((tS32)32)
#define OSAL_C_S32_IOCTRL_IPOD_MOUNT                        ((tS32)33)
   
// functions for USB Mass Storage
#define OSAL_C_S32_IOCTRL_USBMS_GETDEVICEINFO               ((tS32)31)
#define OSAL_C_S32_IOCTRL_USBMS_SELECT_CONFIGURATION        ((tS32)32)
#define OSAL_C_S32_IOCTRL_USBMS_MOUNT                       ((tS32)33)

// parameter to USBx_SELECT_CONFIGURATION
#define OSAL_C_S32_USB_SELECTOR_MS                          ((tS32) 1)  
#define OSAL_C_S32_USB_SELECTOR_IPOD                        ((tS32) 2)

#define OSAL_C_S32_IOCTRL_USBH_GETDEVICEINFO_IPOD           ((tS32)40)
#define OSAL_C_S32_IOCTRL_USBH_GETDEVICEINFO_USBMS          ((tS32)41)
#define OSAL_C_S32_IOCTRL_IPOD_USBDEVICE_VENDOR_REQ   		((tS32)42)
typedef struct
{
    tS32 s32Arg;
    tS32 s32Value;
} OSAL_trIPodCallbackInfo;

// Type definition for callback functions. 
typedef tVoid (*OSAL_tpfIPodCallback)(OSAL_trIPodCallbackInfo* prInfo);

// A pointer to this structure has to be passed as argument to the
// iPod IOControl OSAL_C_S32_IOCTRL_IPOD_REG_CALLBACK 
typedef struct
{  
   // Pointer to the callback function that is called for notification 
   OSAL_tpfIPodCallback pfCallback;
} OSAL_trIPodCallbackReg;


#define OSAL_C_S32_DEV_IPOD_ERROR       ((tS32) 99)

/* @brief Error types that can occur in dev_ipod
* 
* The error are categorised in FATAL, ERROR and WARNING. These are not return values of OSAL calls
* They are generated during run-time , OSAL_trIPodCallbackInfo.s32Arg=OSAL_C_S32_DEV_IPOD_ERROR
*/ 
typedef enum { 
	OSAL_EN_IPOD_ERRTYPE_FATAL              =0x0300,        /*!< fatal general */ 
	OSAL_EN_IPOD_ERRTYPE_ERROR              =0x0200,        /*!< error general */     
    OSAL_EN_IPOD_ERRTYPE_WARNING            =0x0100,        /*!< warning general */     
	 /*!< fatal  */ 
    OSAL_EN_IPOD_ERRTYPE_ACOUT_OPEN_FAILED  =0x0301,       
	OSAL_EN_IPOD_ERRTYPE_ACOUT_CLOSE_FAILED =0x0302,        
	OSAL_EN_IPOD_ERRTYPE_USBH_OPEN_FAILED   =0x0303,        
	OSAL_EN_IPOD_ERRTYPE_USBH_CLOSE_FAILED  =0x0304,        
	OSAL_EN_IPOD_ERRTYPE_AROUT_OPEN_FAILED  =0x0305,        
	OSAL_EN_IPOD_ERRTYPE_AROUT_CLOSE_FAILED =0x0306,        
	OSAL_EN_IPOD_ERRTYPE_AROUT_SETUP_FAILED =0x0307,        /*!< setup failed*/
    OSAL_EN_IPOD_ERRTYPE_FATAL_DEVIPOD      =0x0308,        /*!< dev ipod */ 
	/*!< error  */ 
	OSAL_EN_IPOD_ERRTYPE_ACOUT_SEND_FAILED  =0x0201,        /*!< sending to AcOut failed  */
	OSAL_EN_IPOD_ERRTYPE_AROUT_KILL_FAILED  =0x0202,        /*!< kill of stream failed*/
	OSAL_EN_IPOD_ERRTYPE_ERROR_DEVIPOD      =0x0203,        /*!< dev ipod */
    /*!< warning */ 
	OSAL_EN_IPOD_ERRTYPE_ACOUT_BUF_X_RUN    =0x0101,        /*!< buffer under run  Acout*/  
	OSAL_EN_IPOD_ERRTYPE_USBH_TIME_OUT      =0x0102,        /*!< got a time out from usbh-audio-stack  */
	OSAL_EN_IPOD_ERRTYPE_WARNING_DEVIPOD    =0x0103        /*!< dev ipod */ 
}OSAL_tenDevIpodErrType; 


//struct used in read/write functions
typedef struct
{
  tU8* pu8Buffer;
  tU32 u32BufferLength;
} OSAL_trIPodData;    

#define LENGTH_USBINFO_STRING (256)
typedef struct
{
      tU16  u16Media;                 // DATA_MEDIA, INCORRECT_MEDIA, AUDIO_MEDIA, MEDIA_EJECTED
      tU16  u16VendorID;
      tU16  u16ProductID;
      tU16  u16DeviceVersionNo;
      char  achSerialnumberstring[LENGTH_USBINFO_STRING];
      char  achManufacturerstring[LENGTH_USBINFO_STRING];
      char  achProductstring[LENGTH_USBINFO_STRING]; 
      tBool bMounted;                // for u16Media == DATA_MEDIA
} OSAL_trUsbDeviceInfo;

typedef struct
{
  tU32                  u32NumberOfDev;
  tU32                  u32EnteredDev;
  tBool                 bHubConnected;
  OSAL_trUsbDeviceInfo* pDeviceInfo;
}OSAL_trUsbHubDeviceInfo;

/*struct used for USB Device Requests */
typedef struct
{
  tU8 bmRequestType; /* Request type : Standard or Vendor, Recipent, Direction*/
  tU8 bmRequest;	 /* Request */
  tS16 wValue;		 /* Request specific Information */
  tS16 wIndex;		 /* Offset or Request specific Information to the device */
  tU16 wLength;		 /* No of bytes in the Data stage(to transfer or receive) */
  tU8* pu8Buffer;	 /* pointer to location where the data to be sent or received is found. 
                       Assign null in case of no data to be sent or received*/ 
           
} OSAL_trUSBDevReq;    


/****************************************************************************************/
/*  defines for /dev/fpga/pcm_player, see also osdevice.h                               */
/****************************************************************************************/
/* -- IOControl functions -------------------------------------------------------------- */

#define OSAL_C_U32_MOST_ENABLE_CMD        ((tU32) 0x100)
#define OSAL_C_U32_MOST_DISABLE_CMD       ((tU32) 0x110)
#define OSAL_C_U32_MOST_SET_CH_LIST_CMD   ((tU32) 0x120)
#define OSAL_C_U32_MOST_PLAY_CMD          ((tU32) 0x130)
#define OSAL_C_U32_MOST_SYNC_ALLOC        ((tU32) 0x140)
#define OSAL_C_U32_MOST_SYNC_DEALLOC      ((tU32) 0x150)


/****************************************************************************************/
/*  defines for /dev/ffd                                                                */
/****************************************************************************************/
/* Control-Commands of FFD-access */
#define OSAL_C_S32_IOCTRL_DEV_FFD_SAVENOW                      ((tS32)1)
#define OSAL_C_S32_IOCTRL_DEV_FFD_SEEK                         ((tS32)2)
#define OSAL_C_S32_IOCTRL_DEV_FFD_GET_ROM_DATA_VERSION         ((tS32)3)
#define OSAL_C_S32_IOCTRL_DEV_FFD_GET_TOTAL_FLASH_SIZE         ((tS32)4)
#define OSAL_C_S32_IOCTRL_DEV_FFD_GET_DATA_SET_SIZE            ((tS32)5)
#define OSAL_C_S32_IOCTRL_DEV_FFD_GET_FLASHBLOCK_RAWSIZE       ((tS32)6)
#define OSAL_C_S32_IOCTRL_DEV_FFD_GET_FLASHBLOCK_RAW_DATA      ((tS32)7)  
#define OSAL_C_S32_IOCTRL_DEV_FFD_SET_FLASHBLOCK_RAW_DATA      ((tS32)8)
#define OSAL_C_S32_IOCTRL_DEV_FFD_RELOAD                       ((tS32)9)
#define OSAL_C_S32_IOCTRL_DEV_FFD_SAVE_BACKUP_FILE             ((tS32)10)
#define OSAL_C_S32_IOCTRL_DEV_FFD_LOAD_BACKUP_FILE             ((tS32)11)
#define OSAL_C_S32_IOCTRL_DEV_FFD_GET_INFO_READ_DATA           ((tS32)12)

/* defines for OSAL_C_S32_IOCTRL_DEV_FFD_GET_INFO_READ_DATA */
#define M_FFD_INFO_READ_FLASH_DATA_ACTUAL                  ((tU16)0x0000) /* read actual data */
#define M_FFD_INFO_READ_FLASH_DATA_LAST_VALID              ((tU16)0x0001) /* read last valid data */ 

/****************************************************************************************/
/*  defines for /dev/pram                                                                */
/****************************************************************************************/

#define OSAL_C_S32_IOCTRL_DEV_PRAM_SEEK                      ((tS32)1)
#define OSAL_C_S32_IOCTRL_DEV_PRAM_TELL                      ((tS32)2)
#define OSAL_C_S32_IOCTRL_DEV_PRAM_GET_SIZE                  ((tS32)3)
#define OSAL_C_S32_IOCTRL_DEV_PRAM_GET_WRITTEN_SIZE          ((tS32)4)
#define OSAL_C_S32_IOCTRL_DEV_PRAM_CLEAR                     ((tS32)5)


typedef struct
{
  tU8   u8DataSet; 
  void* pvArg;
}OSAL_trFFDDeviceInfo;
  

#endif

