/************************************************************************
 * .EXPORT_ME
 * FILE:         osevent.h
 * PROJECT:      VASCO
 * SW-COMPONENT: OSAL
 *----------------------------------------------------------------------
 * DESCRIPTION:  This is the headerfile for the OS - Abstraction Layer for 
 *               Event-Functions. This Header has to be included to use
 *               functions for handling events.
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      |   Modification                   | Author
 * 16.03.00  |   Initial revision               | de Vries,EFT22
 * 10.04.00  |   Restructuring                  | Uelschen, EFT42
 * 07.06.00  |   OSAL_EventTimeoutWait removed  | de Vries, EFT22
 * 23.06.00  |   vxWorks: #include "os_event.h" | de Vries, EFT22
 * 17.01.01  |   changes for WinCE addes        | de Vries, EFG32
 * 07.02.02  |   class OSAL_tclEvent added      | Walkling, EST
 * 18.02.02  |   Nucleus defines added          | Uelschen, ESN2
 * 13.06.02  |   add dynamic-download           | Perick, CM-CR/EES4
 *           |   extension                      |
 * 19.10.07  |   Add defines for Linux          | Soj, RBIN 
 *************************************************************************/

#if !defined (OSAL_EVENT_HEADER)
   #define OSAL_EVENT_HEADER


#ifdef __cplusplus
extern "C"
{
   #endif
   
   /**************************************************************************/
   /* typedefs                                                               */
   /**************************************************************************/
   
   /* --Verknpfungsoptionen. */
   
   typedef enum {
           OSAL_EN_EVENTMASK_AND,                  /* Und */
           OSAL_EN_EVENTMASK_OR,                   /* Oder */
           OSAL_EN_EVENTMASK_XOR,                  /* Exklusiv-Oder */
           OSAL_EN_EVENTMASK_REPLACE               /* Ersetzen */
   } OSAL_tenEventMaskFlag;
   
   
   /* -- Typdefinition fr eine Ereignisfeldmaske. */
   
   typedef tU32 OSAL_tEventMask;
   #ifdef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT
   typedef uintptr_t OSAL_tEventHandle; 
   #else
   typedef tU32 OSAL_tEventHandle;
   #endif

#ifndef OSAL_DYNAMIC_DOWNLOAD

#if OSAL_OS==OSAL_WINNT || OSAL_OS==OSAL_RX732 || OSAL_OS==OSAL_VXWORKS \
		|| OSAL_OS==OSAL_WINCE || OSAL_OS==OSAL_NUCLEUS || OSAL_OS==OSAL_TENGINE \
		|| OSAL_OS==OSAL_LINUX || OSAL_OS==OSAL_DARWIN
   
   /* --12.2.1 Create a new Event Field */
   OSAL_DECL tS32 OSAL_s32EventCreate(tCString coszName, OSAL_tEventHandle* phEvent);
   
   /* --12.2.2 Open an Event Field */
   OSAL_DECL tS32 OSAL_s32EventOpen(tCString coszName, OSAL_tEventHandle* phEvent);
   
   /* --12.2.3 Close an Event Field */
   OSAL_DECL tS32 OSAL_s32EventClose(OSAL_tEventHandle hEvent);
   
   /* --12.2.4 Remove an Event Field from System */
   OSAL_DECL tS32 OSAL_s32EventDelete(tCString coszName);
   
   /* --12.2.5 Wait for an Event */
   OSAL_DECL tS32 OSAL_s32EventWait(OSAL_tEventHandle hEvent,
    OSAL_tEventMask mask, OSAL_tenEventMaskFlag enFlags, OSAL_tMSecond msec,
    OSAL_tEventMask* pOldMask);
   
   /* --12.2.6 Send an Event */
   OSAL_DECL tS32 OSAL_s32EventPost(OSAL_tEventHandle hEvent,
    OSAL_tEventMask mask, OSAL_tenEventMaskFlag enFlags);
   
   /* --12.2.7 Get the Event Field Status */
   OSAL_DECL tS32 OSAL_s32EventStatus(OSAL_tEventHandle hEvent,
    OSAL_tEventMask mask, OSAL_tEventMask* pMask);
   
   #endif

#endif // OSAL_DYNAMIC_DOWNLOAD
   

/**************************************************************************/
/* dynamic-download                                                       */
/**************************************************************************/
#if ( defined OSAL_DYNAMIC_DOWNLOAD || defined OSAL_DYNAMIC_BASE)
typedef tS32 (*tOSAL_s32EventCreate)(tCString coszName, 
                                    OSAL_tEventHandle* phEvent);
typedef tS32 (*tOSAL_s32EventOpen)(tCString coszName, 
                                  OSAL_tEventHandle* phEvent);
typedef tS32 (*tOSAL_s32EventClose)(OSAL_tEventHandle hEvent);
typedef tS32 (*tOSAL_s32EventDelete)(tCString coszName);
typedef tS32 (*tOSAL_s32EventWait)(OSAL_tEventHandle hEvent, 
                                   OSAL_tEventMask mask, 
                                   OSAL_tenEventMaskFlag enFlags, 
                                   OSAL_tMSecond msec,
                                   OSAL_tEventMask* pOldMask);
typedef tS32 (*tOSAL_s32EventPost)(OSAL_tEventHandle hEvent,
                                   OSAL_tEventMask mask, 
                                   OSAL_tenEventMaskFlag enFlags);
typedef tS32 (*tOSAL_s32EventStatus)(OSAL_tEventHandle hEvent,
                                     OSAL_tEventMask mask, 
                                     OSAL_tEventMask* pMask);
#endif


#ifdef OSAL_DYNAMIC_DOWNLOAD
extern tOSAL_s32EventCreate  OSAL_s32EventCreate;
extern tOSAL_s32EventOpen    OSAL_s32EventOpen;
extern tOSAL_s32EventClose   OSAL_s32EventClose;
extern tOSAL_s32EventDelete  OSAL_s32EventDelete;
extern tOSAL_s32EventWait    OSAL_s32EventWait;
extern tOSAL_s32EventPost    OSAL_s32EventPost;
extern tOSAL_s32EventStatus  OSAL_s32EventStatus;
#endif // OSAL_DYNAMIC_DOWNLOAD

   
   #ifdef __cplusplus
}
#endif

#ifdef __cplusplus

class OSAL_DECL OSAL_tclEvent : public OSAL_tclBase
{
   public:
      /* The following methods are according to the OSAL specification. */
      /* Constructor of this class. */
      OSAL_tclEvent();
      /* Destructor of this class. */
      virtual ~OSAL_tclEvent();
      /*
         This methode creates a field of events. 
         If the creation of the field of events has finished without
         an error the s32Open methode is called afterwards.
         (For more detail see OSAL Refernzhandbuch Kapitel Ereignisse.)
      
         Additional Errors or meaning:
         OSAL_E_UNKNOWN: A handle already stored in this object.
         OSAL_E_NOSPACE: There is no space to save the name.
      */
      tS32 s32Create( tCString coszName /* (I) */ );
      /*
         This methode opens a field of events.
         (For more detail see OSAL Refernzhandbuch Kapitel Ereignisse.)
      
         Additional Errors or meaning:
         OSAL_E_ALREADYEXISTS: There exists already an opened field of events.
         OSAL_E_NOSPACE: There is no space to save the name.
      */
      tS32 s32Open( tCString coszName /* (I) */ );
      /*
         This methode opens a field of events with the name stored
         in this object.
         (This is an additional method!)
      
         Additional Errors or meaning:
         OSAL_E_ALREADYEXISTS: There exists already an opened field of events.
         OSAL_E_UNKNOWN: There is no name saved in the object. 
                         (Use s32Open( tCString coszName ) )
      */
      tS32 s32Open();
      /*
         This methode closes a field of events.
         (For more detail see OSAL Refernzhandbuch Kapitel Ereignisse.)
      */
      tS32 s32Close( );
      /*
         This methode deletes the field of events. 
         Before deleting the field of events the methode s32Close will be
         performed to close the field of events. After performing this 
         methode this field of events object provides no event 
         functionality but it is possible to create a new field of events 
         in the same object.
         (For more detail see OSAL Refernzhandbuch Kapitel Ereignisse.)
      */
      tS32 s32Delete( );
      /*
         This methode waits for events specified in the parameters.
         (For more detail see OSAL Refernzhandbuch Kapitel Ereignisse.)
      */
      tS32 s32Wait( OSAL_tEventMask Mask,           /* (I) */
                    OSAL_tenEventMaskFlag enFlags,  /* (I) */
                    OSAL_tMSecond MSec,             /* (I) */
                    OSAL_tEventMask* pResultMask);  /* (->O) */
      /*
         This methode sents an event.
         (For more detail see OSAL Refernzhandbuch Kapitel Ereignisse.)
      */
      tS32 s32Post( OSAL_tEventMask Mask,            /* (I) */
                    OSAL_tenEventMaskFlag enFlags ); /* (I) */
      /*
         This methode provides the possibility to get the content of the field
         of events.
         (For more detail see OSAL Refernzhandbuch Kapitel Ereignisse 
          function OSAL_s32EventStatus().)
      */
      tS32 s32GetStatus( OSAL_tEventMask Mask,          /* (I) */
                         OSAL_tEventMask* pMask );      /* (->O) */
      /* 
         The following methods are new and/or with modification to the
         OSAL specification. 
      */
      /*
         To get the name of the created field of events this methode can be used.
         After deletion the field of events there is no name available furthermore.
      */
      tCString pszGetName();
   private:
      //
      /*
         This member stores the name of the field of events.
      */
      tCString szName;
      /*
         This member stores the handle of the field of events.
      */
      OSAL_tEventHandle hEventHandle;
};
#endif

#endif
