/*!
*******************************************************************************
* \file               sps_server_main.h
*******************************************************************************
\verbatim
PROJECT:        Seamless pairing
SW-COMPONENT:   Seamless pairing server
DESCRIPTION:    Header for main application
COPYRIGHT:      &copy; RBEI
HISTORY:
Date       | Author                   | Modifications
27.12.2017 | svs7kor                  | Initial Version
\endverbatim
******************************************************************************/

#include "sps_server_main.h"
#include "AGW_DBusHandler/AGW_SPS_DBusHandler.h"
#include "dlt/dlt.h"

//DLT APPID & CONTEXT DECLARATION
#define APPID_SPS "SPS0"

DLT_DECLARE_CONTEXT(SPS_MAIN);
DLT_DECLARE_CONTEXT(SPS_CONN);
DLT_DECLARE_CONTEXT(SPS_JMSG);

static GMainLoop *mainLoop = NULL;
/******************************************************************************
** FUNCTION   : bInitialize
*******************************************************************************
* \fn     bInitialize
* \brief  Function to initialize the main component
* \param  None.
* \retval gboolean.
******************************************************************************/
gboolean bInitialize()
{
   DLT_LOG(SPS_MAIN,DLT_LOG_INFO,DLT_STRING("bInitialize"));
   mainLoop = g_main_loop_new (NULL, FALSE);
   return TRUE;
}

/******************************************************************************
** FUNCTION   : poGetMainLoop
*******************************************************************************
* \fn     getMainLoop
* \brief  Function to return the main loop.
* \param  None.
* \retval gboolean.
******************************************************************************/
GMainLoop* getMainLoop()
{
   DLT_LOG(SPS_MAIN,DLT_LOG_INFO,DLT_STRING("getMainLoop"));
    printf("IN %s::",__FUNCTION__);
   return mainLoop;
}

/******************************************************************************
** FUNCTION   : bStart
*******************************************************************************
* \fn     bStart
* \brief  Function to start the main application.
* \param  None.
* \retval gboolean.
******************************************************************************/
gboolean bStart()
{
   DLT_LOG(SPS_MAIN,DLT_LOG_INFO,DLT_STRING("bStart"));
   printf("IN %s::",__FUNCTION__);

   DLT_REGISTER_CONTEXT(SPS_CONN,"SPSC","SPS Connection log");
   DLT_REGISTER_CONTEXT(SPS_JMSG, "SPSJ", "SPS Json msg handling log");	

   gboolean bStartAGW = bStartAGWDBusHandler();
	
  // DLT_LOG(SPS_MAIN,DLT_LOG_INFO,DLT_STRING("IN START : bStartAGWDBusHandler :"),DLT_INT(bStartAGW));
	
   
   g_main_loop_run (mainLoop);
   return TRUE;
  // bStartAGWDBusHandler();
}

/******************************************************************************
** FUNCTION   : vStop
*******************************************************************************
* \fn     vStop
* \brief  Function to stop the main application.
* \param  None.
* \retval gboolean.
******************************************************************************/
void vStop()
{
  DLT_LOG(SPS_MAIN,DLT_LOG_INFO,DLT_STRING("vStop"));
   printf("IN %s::",__FUNCTION__);
   g_main_loop_unref(mainLoop);
}

/******************************************************************************
** FUNCTION   : main
*******************************************************************************
* \fn     main
* \brief  Entry function of main application.
* \param  int argc, char *argv[].
* \retval int.
******************************************************************************/
int main (int argc, char *argv[])
{
   DLT_REGISTER_APP(APPID_SPS,  "SPS application for logging");
   DLT_REGISTER_CONTEXT(SPS_MAIN, "MAIN","MAIN SPS");

   DLT_LOG(SPS_MAIN,DLT_LOG_INFO,DLT_STRING("SPS- starting main SPS application"));
   printf("IN %s::",__FUNCTION__);
   gboolean bInitRet = bInitialize();
   DLT_LOG(SPS_MAIN,DLT_LOG_INFO,DLT_STRING("SPS- Init status"),DLT_INT(bInitRet));
   printf("Gmain loop created?? %d",bInitRet);
   gboolean bStartRet = bStart();
   DLT_LOG(SPS_MAIN,DLT_LOG_INFO,DLT_STRING("SPS- Main loop started"),DLT_INT(bStartRet));
   printf("Main loop started :: %d",bStartRet);
   vStop();
   DLT_LOG(SPS_MAIN,DLT_LOG_INFO,DLT_STRING("SPS- exiting SPS"));

   return 0;
}