/******************************************************************************
* \file               AGW_SPS_DBusHandler.h
*******************************************************************************
\verbatim
PROJECT:        Seamless pairing
SW-COMPONENT:   Seamless pairing server
DESCRIPTION:    Header for AGW dBushandler
COPYRIGHT:      &copy; RBEI
HISTORY:
Date       | Author                   | Modifications
01.02.2018 | svs7kor                  | Initial Version
\endverbatim
******************************************************************************/

#ifndef _AGW_SPS_DBUSHANDLER_H_
#define _AGW_SPS_DBUSHANDLER_H_

/******* INCLUDES ***************/

#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <time.h>
#include "dlt/dlt.h"

typedef enum
{
    SPS_START_SUCCESS = 0,
    SPS_START_FAILED,
    SPS_CLIENT_CONNECTED,
    SPS_CLIENT_DISCONNECTED,
    SPS_STOP_SUCCESS,
    SPS_STOP_FAILED
}SPServerConnectionState;
 
gboolean bStartAGWDBusHandler();
void     vStopAGWDBusHandler();
void     vForwardMsgFromApp( gchar*    key, 
                             GVariant* value);

void vUpdateSPConnectionState(SPServerConnectionState connState);

#endif //_AGW_SPS_DBUSHANDLER_H_
