/*!
*******************************************************************************
* @file             : AutomDBusServer.c
*******************************************************************************
*  - PROJECT:       : Seamless pairing
*  - SW-COMPONENT   : Seamless pairing middleware
*  - DESCRIPTION    : Seamless pairing midw dbus service handler
*  - COPYRIGHT      : &copy; 2017 Robert Bosch Engineering & Business Solutions
*  - Documents      : Give link of relevant documents

*  - HISTORY
*
*  Date     | Name          |  Version | Modification
* ----------|---------------|--------------------------|-----------------------
* 22.12.2017 | IPD5KOR(RBEI/ECO2)   | 1.0.0 | methods for Seamless middleware
                                              dbus service
******************************************************************************/

/**************************************************************************
************************ Includes ****************************************
**************************************************************************/
#include "dlt/dlt.h"
#include "seamlessMidw_DBusHandler.h"
#include "SeamlessMidw_HMI_DBusHandler.h"
#include "SeamlessMidw_SPS_DBusHandler.h" 
#include "Seamless_WBL_DBusHandler.h"
#include "Seamless_Connman_DBusHandler.h"
#include "SP_SystemSettings1_DBusHandler.h"

/***********************************************************************
******************** Global Declarations *******************************
************************************************************************/
static GDBusConnection* poSPMWDBusConn = NULL;
static guint            gSPMWactherID = 0;  

DLT_DECLARE_CONTEXT(SPM_framework); 

#define SP_DBUS_NAME "com.bosch.SeamlessMiddleware"  

/*****************************************************************************
* Function:    on_spmw_bus_acquired
* Description: Callback on D-Bus acquired
* Parameters:  Connection , Bus name, user data
* Return:      void
*****************************************************************************/
static void
on_spmw_bus_acquired( GDBusConnection *pConnection, 
                      const gchar     *pName,
                      gpointer        pUserData )
{
    DLT_LOG(SPM_framework,DLT_LOG_ERROR,DLT_STRING(
         "+"),DLT_STRING( __FUNCTION__ ));
    gboolean bRet = FALSE;
    poSPMWDBusConn = g_object_ref(pConnection);

    if(!bExportSeamlessHMI())    
    {
        DLT_LOG(SPM_framework,DLT_LOG_ERROR,DLT_STRING(
               "Unable to export a seamless HMI Interface"));
    }

    if(!bExportSPFactoryReset())
    {
        DLT_LOG(SPM_framework,DLT_LOG_ERROR,DLT_STRING(
                "Unable to export a SP Factory Reset Iface"));
    }

    if(!bExportSeamlessMidw_ServerIface())
    {
        DLT_LOG(SPM_framework,DLT_LOG_ERROR,DLT_STRING(
                 "Unable to export a seamless Server Interface"));
    }

    if(!(bWatchWBLService()))
    {
        DLT_LOG(SPM_framework,DLT_LOG_ERROR,DLT_STRING(
                 "Unable to Watch WBL Interface"));
    }
    
    if(!bStartSPMWConnmanService())
    {
        //Error
        DLT_LOG(SPM_framework,DLT_LOG_ERROR,DLT_STRING(
           "-on_spmw_bus_acquired"),DLT_STRING("Unable to start Connman System Service"));
    }
}

/******************************************************************************
* Function:    on_spmw_name_acquired
* Description: Callback on DBus name acquired
* Parameters:  Connection , Bus name, user data
* Return:      void
*****************************************************************************/
static void
on_spmw_name_acquired( GDBusConnection *pConnection, 
                       const gchar     *pName,
                       gpointer        pUserData )
{
    DLT_LOG(SPM_framework,DLT_LOG_INFO,DLT_STRING("+-"),
                              DLT_STRING(__FUNCTION__));
}

/****************************************************************************
* Function:    on_spmw_name_lost
* Description: Callback on D-Bus name lost
* Parameters:  Connection , Bus name, user data
* Return:      void
*****************************************************************************/
static void
on_spmw_name_lost( GDBusConnection *pConnection,
                   const gchar     *pName,
                   gpointer        pUserData )
{
    DLT_LOG(SPM_framework, DLT_LOG_INFO,DLT_STRING("+"),
                               DLT_STRING(__FUNCTION__));
    vStopSPMWDBusService();
    gSPMWactherID = 0;
    DLT_LOG(SPM_framework, DLT_LOG_INFO,DLT_STRING("-"),
                              DLT_STRING(__FUNCTION__));   
}

/****************************************************************************
* Function:    vStartSPMWDBusService
* Description: stats the seamless midw dbus service
* Parameters:  void
* Return:      void
*****************************************************************************/
void  vStartSPMWDBusService()
{
    DLT_LOG(SPM_framework, DLT_LOG_INFO,DLT_STRING("+"),
                             DLT_STRING(__FUNCTION__));      
      
    gSPMWactherID = g_bus_own_name( G_BUS_TYPE_SESSION,
                                    SP_DBUS_NAME,
                                    G_BUS_NAME_OWNER_FLAGS_NONE,
                                    on_spmw_bus_acquired,
                                    on_spmw_name_acquired,
                                    on_spmw_name_lost,
                                    NULL,
                                    NULL
                                  );

    if(gSPMWactherID)
         DLT_LOG(SPM_framework, DLT_LOG_INFO,DLT_STRING(__FUNCTION__),
           DLT_STRING("com.bosch.SeamlessMiddleware owned successfuly"));
    else
       DLT_LOG(SPM_framework, DLT_LOG_ERROR,DLT_STRING(__FUNCTION__),
     	    DLT_STRING("Failed to own com.bosch.SeamlessMiddleware"));
  
    DLT_LOG(SPM_framework, DLT_LOG_INFO,DLT_STRING("-"),
                              DLT_STRING(__FUNCTION__));   
}      

/****************************************************************************
* Function:    vStopSPMWDBusService
* Description: stops the seamless midw dbus service
* Parameters:  void
* Return:      void
****************************************************************************/
void  vStopSPMWDBusService()
{
    DLT_LOG(SPM_framework, DLT_LOG_INFO,DLT_STRING("+"),
                               DLT_STRING(__FUNCTION__));

    vUnExportSeamlessMidw_SPSIface();
    vUnExportSeamlessHMI();
    vUnExportSPFactoryReset();

    if(gSPMWactherID)
    {
        g_bus_unown_name(gSPMWactherID);
        gSPMWactherID = 0;
    }
    if(poSPMWDBusConn)
    {
       g_object_unref(poSPMWDBusConn);
        poSPMWDBusConn = NULL;
    }
    DLT_LOG(SPM_framework, DLT_LOG_INFO,DLT_STRING("-"),
                              DLT_STRING(__FUNCTION__));
}
    
/****************************************************************************
* Function:    poGetSPMDBusConn
* Description: Gives the dbus conn object of Seamless midw
* Parameters:  void
* Return:      GDBusConnection*
****************************************************************************/
GDBusConnection*  poGetSPMDBusConn()
{
   DLT_LOG(SPM_framework, DLT_LOG_INFO,DLT_STRING("+"),
                               DLT_STRING(__FUNCTION__));
   if(poSPMWDBusConn)
       return poSPMWDBusConn;
   else return NULL;
}


