/*!
*******************************************************************************
* @file             : gmain_source.h
*******************************************************************************
*  - PROJECT:       : Seamless Middleware
*  - SW-COMPONENT   : Seamless Middleware DBus Handler
*  - DESCRIPTION    : Header for seamless middleware dbus service
*  - COPYRIGHT      : &copy; 2017 Robert Bosch Engineering & Business Solutions
*  - Documents      : 
*  - HISTORY
*
*  Date     | Name          |  Version | Modification
* ----------|---------------|--------------------------|-------------------------
* 04.25.2018  | svs7kor (RBEI/ECO2) | 2.1.0 | Seamless Midw DBus Handler
******************************************************************************/
#include "gmain_source.h"
#include "dlt/dlt.h"

DLT_DECLARE_CONTEXT(SP_GMAIN);

/******************************************************************************
** FUNCTION   : bInitialize
*******************************************************************************
* \fn     bInitialize
* \brief  Function to initialize the main component
* \param  None.
* \retval gboolean.
******************************************************************************/
gboolean bInitialize()
{
   DLT_REGISTER_CONTEXT(SP_GMAIN, "GMAIN","MAIN Gmain loop creation");
   DLT_LOG(SP_GMAIN,DLT_LOG_INFO,DLT_STRING("bInitialize"));
   mainLoop = g_main_loop_new (NULL, FALSE);
   return TRUE;
}

/******************************************************************************
** FUNCTION   : poGetMainLoop
*******************************************************************************
* \fn     getMainLoop
* \brief  Function to return the main loop.
* \param  None.
* \retval gboolean.
******************************************************************************/
GMainLoop* poGetMainLoop()
{
   DLT_LOG(SP_GMAIN,DLT_LOG_INFO,DLT_STRING("getMainLoop"));
   return mainLoop;
}

/******************************************************************************
** FUNCTION   : bStart
*******************************************************************************
* \fn     bStart
* \brief  Function to start the main application.
* \param  None.
* \retval gboolean.
******************************************************************************/
gboolean bStart()
{
   DLT_LOG(SP_GMAIN,DLT_LOG_INFO,DLT_STRING("bStart"));
   g_main_loop_run (mainLoop);
   return TRUE;
}

/******************************************************************************
** FUNCTION   : vStop
*******************************************************************************
* \fn     vStop
* \brief  Function to stop the main application.
* \param  None.
* \retval gboolean.
******************************************************************************/
void vStop()
{
  DLT_LOG(SP_GMAIN,DLT_LOG_INFO,DLT_STRING("vStop"));
   g_main_loop_unref(mainLoop);
}
