/*!
*******************************************************************************
* \file               seamlessMidw_Service.cpp
*******************************************************************************
\verbatim
PROJECT:        G3G
SW-COMPONENT:   Seamless pairing middleware component.
DESCRIPTION:    CCA Application SEAMLESS_PAIRING_IPCM.
COPYRIGHT:      &copy; RBEI
HISTORY:
Date       | Author                 | Modifications
22.12.2017 | ipd5kor                | Initial Version
\endverbatim
*******************************************************************************/


#ifndef _SEAMLESS_MIDW_SERVICE_H_
#define _SEAMLESS_MIDW_SERVICE_H_
/******************************************************************************
| includes:
|----------------------------------------------------------------------------*/
//!Include Application Help Library.
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION

#include "ahl_if.h"
#include <glib.h>
#include <gio/gio.h>

#define UNUSED(x) (void)(x)

/******************************************************************************
| defines and macros and constants(scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/*!
* \Forward declarations
*/
class seamlessMidwMainApp;

class seamlessMidw_Service: public ahl_tclBaseOneThreadService
{
public:

    /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

    /***************************************************************************
   ** FUNCTION:  seamlessMidw_Service::seamlessMidw_Service()
   ***************************************************************************/
    /*!
   * \fn      seamlessMidw_Service(tVoid)
   * \brief   Constructor.
   *
   *          Create an object of the base class
   *          ahl_tclBaseOneThreadService with a pointer to this
   *          application, the offered service identifier and the
   *          service version as parameters.
   * \param   tVoid
   **************************************************************************/
    seamlessMidw_Service(tVoid);

    seamlessMidw_Service(seamlessMidwMainApp* poMainAppl);

    /**************************************************************************
   * FUNCTION : seamlessMidw_Service::~seamlessMidw_Service()
   ***************************************************************************/
    /*!
   * \fn      ~seamlessMidw_Service()
   * \brief: Destructor.
   * \param  : None.
   * \retval : None.
   ***************************************************************************/
    virtual ~seamlessMidw_Service();

    /***************************************************************************
   ** FUNCTION:  gboolean seamlessMidw_Service::bInitialize();
   **************************************************************************/
    /*!
   * \fn      bInitialize()
   * \brief   Method to initialize all the pointers used
   * \param   None
   **************************************************************************/
    virtual gboolean bInitialize();

    /***************************************************************************
   ** FUNCTION:  gboolean seamlessMidw_Service::bUnInitialize();
   **************************************************************************/
    /*!
   * \fn      bUnInitialize()
   * \brief   Method to de-initialize all the pointers used
   * \param   None
   **************************************************************************/
    virtual gboolean bUnInitialize();

    /***************************************************************************
   ** FUNCTION:  seamlessMidw_Service::vLoadSettings()
   ***************************************************************************/
    /*!
   * \fn      vLoadSettings()
   * \brief   vLoadSettings Method. Invoked during OFF->NORMAL state transition.
   * \sa      vSaveSettings()
   **************************************************************************/
    virtual void vLoadSettings();

    /***************************************************************************
   ** FUNCTION:  void seamlessMidw_Service::vSaveSettings()
   ***************************************************************************/
    /*!
   * \fn      vSaveSettings()
   * \brief   vSaveSettings Method.Invoked during NORMAL->OFF state transition.
   * \sa      vLoadSettings()
   **************************************************************************/
    virtual void vSaveSettings();

    /**************************************************************************
   * FUNCTION: tVoid seamlessMidw_Service::vProcessTimer
   ***************************************************************************/
    /*!
   * \fn     tVoid seamlessMidw_Service::vProcessTimer(tU16 u16TimerId)
   * \brief  This function is called from the vOnTimer() function of this
   *         CCA application on the expiration of a previously via function
   *         bStartTimer() started timer.
   * \param  [IN] u16TimerId = Identifier of the expired timer.
   * \retval  None.
   ***************************************************************************/
    tVoid vProcessTimer(tU16 u16TimerId);

    tBool bUpdateClients(tCU16 cu16FunID);

    /***************************************************************************
   ** FUNCTION:  tVoid seamlessMidw_Service::vOnLoopback(amt_tclSer...
   ***************************************************************************/
    /*!
   * \brief   Loopback service for Smartphone service.
   * \param   [u16ServiceID]:   (I) Service ID
   * \param   [poMessage]:      (->I) Pointer to incoming message.
   * \retval  NONE
   **************************************************************************/
    using ahl_tclBaseOneThreadService::vOnLoopback;
    virtual tVoid vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage);

protected:

    /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/

    /**************************************************************************
   ** FUNCTION   : tVoid seamlessMidw_Service::vOnServiceAvailable()
   ***************************************************************************
   * \fn      tVoid seamlessMidw_Service::vOnServiceAvailable()
   * \brief   This function is called by the CCA framework when the service
   which is offered by this server has become available.
   * \param   None.
   * \retval  None.
   * Overrides method ahl_tclBaseOneThreadService::vOnServiceAvailable().
   ***************************************************************************/
    virtual tVoid vOnServiceAvailable(tVoid);

    /**************************************************************************
   ** FUNCTION : tVoid seamlessMidw_Service:: vOnServiceUnavailable()
   ***************************************************************************
   * \fn     tVoid seamlessMidw_Service::   vOnServiceUnavailable()*/
    /*!
   * \brief  This function is called by the CCA framework when the service
   *         which is offered by this server has become unavailable.
   * \param  None.
   * \retval None.
   Overrides method ahl_tclBaseOneThreadService::vOnServiceUnavailable().
   **************************************************************************/
    virtual tVoid vOnServiceUnavailable(tVoid);

    /***************************************************************************
   ** FUNCTION   : tVoid seamlessMidw_Service::bStatusMessageFactory()
   ***************************************************************************
   * \fn       tBool seamlessMidw_Service::bStatusMessageFactory*/
    /*!
   * \brief    This function is called by the CCA framework to request ANY
   *           property which is offered by this service. For each property
   *           accessed via parameter 'u16FunctionId' the user has to prepare
   *           the corresponding FI data object and to copy it to the
   *           referenced service data object 'roOutMsg'.
   * \param   [IN] u16FunctionId = Function ID of the requested property.
   *          [OUT] roOutMsg = Reference to the service data object to which
   *           the content of the prepared FI data object
   *           should be copied to.
   *          [IN] poInMsg = Selector message which is used to select dedicated
   *           content to be copied to 'roOutMsg' instead of
   *          updating the entire FI data object.
   * \retval   TRUE = For the requested property the FI data object was
   *           successfully created and copied to the referenced service
   *           data object 'roOutMsg'. The CCA framework sends a 'STATUS'
   *           message of the updated property to each registered
   *          clients.
   *           FALSE = Failed to create the FI data object for the requested
   *           property and to update the referenced service data object
   *          roOutMsg' with the new property content. The CCA
   *           framework sends an error message to the requesting
   *          client.

   ****************************************************************************
   * Overrides method ahl_tclBaseOneThreadService::bStatusMessageFactory().
   ***************************************************************************/
    virtual tBool bStatusMessageFactory(tU16 u16FunctionId,
                                        amt_tclServiceData& roOutMsg,
                                        amt_tclServiceData* poInMsg);

private:

    /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

    /***************************************************************************
   * \Assignment Operator, will not be implemented.
   * \Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
   * \'seamlessMidw_Service' which has no assignment operator.
   * \NOTE:
   * \This is a technique to disable the assignment operator for this class.
   * \So if an attempt for the assignment is made linker complains.
   ***************************************************************************/
    seamlessMidw_Service&
    operator=(const seamlessMidw_Service &oClientHandler);

    /***************************************************************************
   * ! Data members
   ***************************************************************************/
    //! Gateway Main Application pointer
    seamlessMidwMainApp*      m_poMainAppl;

    /***************************************************************************
   ****************************END OF PRIVATE**********************************
   ***************************************************************************/


    /***************************************************************************
   * Message map definition macro
   ***************************************************************************/
    // DECLARE_MSG_MAP( seamlessMidw_Service)
};

#endif /* _seamlessMidw_Service_H_*/

