/*!
*******************************************************************************
* \file               seamless_midw_main.h
*******************************************************************************
\verbatim
PROJECT:        G3G
SW-COMPONENT:   Seamless pairing middleware
DESCRIPTION:    CCA Application SEAMLESS_PAIRING_IPCM.
COPYRIGHT:      &copy; RBEI
HISTORY:
Date       | Author                   | Modifications
22.12.2017 | ipd5kor                  | Initial Version

\endverbatim
******************************************************************************/

#ifndef _SEAMLESS_MIDW_MAIN_H_
#define _SEAMLESS_MIDW_MAIN_H_

/******************************************************************************
| includes:
|----------------------------------------------------------------------------*/
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"
#include "midw_fi_if.h"
#include "seamlessMidw_tclService.h"
#include "FC_SeamlessMidw_BT_ClientHandler.h"

#include <signal.h>
#include <glib.h>
#include <gio/gio.h>

#define UNUSED(x) (void)(x)

/*****************************************************************************/
/*                                                                           */
/* DEFINES                                                                   */
/*                                                                           */
/*****************************************************************************/
#define UNUSED(x) (void)(x)

//#define VARIANT_S_FTR_ENABLE_TRACE_CMD_DIRECT

//#ifdef SYSTEM_S_USE_BPSTL
//extern tBool __DELETEME__;
//#endif
/*!
* \class definition
*/
class ahl_tclBaseOneThreadApp;

class seamlessMidwMainApp : public ahl_tclBaseOneThreadApp
{
public:

/******************************************************************************
** FUNCTION   : seamlessMidwMainApp::seamlessMidwMainApp()
*******************************************************************************
* \fn     seamlessMidwMainApp::seamlessMidwMainApp()
* \brief  Constructor.
*         Component object is created as Singleton in method theServer().
* \param   None.
* \retval  None.
******************************************************************************/
    seamlessMidwMainApp(tVoid);

/******************************************************************************
** FUNCTION   : seamlessMidwMainApp::~seamlessMidwMainApp()
*******************************************************************************
* \fn      seamlessMidwMainApp::~seamlessMidwMainApp()
* \brief    Destructor.
         Invalidate static self reference.
* \param    None.
* \retval   None.
******************************************************************************/
    virtual ~seamlessMidwMainApp(tVoid);

/******************************************************************************
** FUNCTION   :tBool seamlessMidwMainApp::bOnInit() 
*******************************************************************************
* \fn       tBool seamlessMidwMainApp::bOnInit()
* \brief    This function is called by the CCA framework before starting any
*           CCA message related communication action. As default this
*           function always returns TRUE. The user has to implement all his
*           local application initialization (create client and service
*           handler, create worker threads, allocate application memory,...).
*           If returns TRUE, initialization was successfully performed
*           and framework will register application, else, a reset of the
*           system is forced immediately.
*           This function is the counterpart of vOnApplicationClose().
* \param    None.
* \retval   TRUE  = Application successfully initialized.
*           FALSE = Application NOT successfully initialized.
*******************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::bOnInit().
******************************************************************************/
    virtual tBool bOnInit(tVoid);

/******************************************************************************
** FUNCTION   :tVoid seamlessMidwMainApp::vOnApplicationClose()
*******************************************************************************
* \fn       tVoid seamlessMidwMainApp::vOnApplicationClose()*/
    /*!
* \brief    This function is called by the CCA framework to indicate the
*           imminent shutdown of the application. The user has to implement
*           the de-initialization of all his local application data (destroy
*           client and service handler, destroy worker threads, free
*           application memory, ... ). After this function call the
*           destructor of this application will be called.
*           This function is the counterpart of bOnInit().
* \param    None.
* \retval   None.
*******************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnApplicationClose().
******************************************************************************/
    virtual tVoid vOnApplicationClose(tVoid);

/******************************************************************************
** FUNCTION   :tVoid seamlessMidwMainApp::vOnLoadSettings()
*******************************************************************************
* \fn        tVoid seamlessMidwMainApp::vOnLoadSettings()
* \brief     This function is called by the CCA framework to trigger the
            loading of last mode settings. The user has to load the
            previously stored last mode settings from persistent memory.
* \param     None.
* \retval    None.
*******************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnLoadSettings().
******************************************************************************/
    virtual tVoid vOnLoadSettings(tVoid);

/******************************************************************************
** FUNCTION   : tVoid seamlessMidwMainApp::   vOnSaveSettings()
*******************************************************************************
* \fn        tVoid seamlessMidwMainApp::   vOnSaveSettings()
* \brief     This function is called by the CCA framework to trigger the
*            storage of last mode settings. The user has to store the last
*            mode settings to persistent memory.
* \param     None.
* \retval    None.
*******************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnSaveSettings().
******************************************************************************/
    virtual tVoid vOnSaveSettings(tVoid);

/******************************************************************************
** FUNCTION   : tVoid seamlessMidwMainApp::vOnTimer(tU16 u16TimerId)
*******************************************************************************
* \fn        tVoid seamlessMidwMainApp::vOnTimer(tU16 u16TimerId)
* \brief     This function is called by the CCA framework on the expiration
*            of a previously started timer via function bStartTimer(). The
*            expired timer is forwarded to the respective service or
*            client handlers via a call of vProcessTimer().
*            The function is called from this applications context and
*            therefore no interthread programming rules must be considered
*            and the application methods and/or member variables can be
*            accessed without using the static self reference
*            'm_poMainAppInstance'.
* \param     [IN] u16TimerId = Identifier of the expired timer.
* \retval     None.
*******************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnTimer().
******************************************************************************/
    virtual tVoid vOnTimer(tU16 nTimerId);


/******************************************************************************
** FUNCTION   : tVoid seamlessMidwMainApp::vCreateCCAClientHandlers
*******************************************************************************
* \fn        tVoid seamlessMidwMainApp::vCreateCCAClientHandlers
* \brief     This function is used to create the client handlers
             for CCA components used by seamless pairing.
* \param      None.
* \retval     None.
*******************************************************************************/
       tVoid vCreateCCAClientHandlers();

/******************************************************************************
** FUNCTION   : tVoid seamlessMidwMainApp::vDestroyCCAClientHandlers
*******************************************************************************
* \fn        tVoid seamlessMidwMainApp::vDestroyCCAClientHandlers
* \brief     This function is used to delete the client handlers
             of the CCA components used by seamless pairing.
* \param      None.
* \retval     None.
*******************************************************************************/
       tVoid vDestroyCCAClientHandlers();

/******************************************************************************
* FUNCTION: tVoid seamlessMidwMainApp::vOnLoopback(tU16 u16ServiceID,
                                                 amt_tclServiceData* poMessage)
*******************************************************************************
* \fn       tVoid seamlessMidwMainApp::vOnLoopback(tU16 u16ServiceID,
                                                 amt_tclServiceData* poMessage)
* \brief    This function is called by the CCA framework if a message was
*           sent from one if these applications services or from a
*           callback-handler of this application (so called self or loopback
*           messages). The message can be forwarded to the respective service
*           via a call of vOnLoopbackService(). If there is no service
*           registered for this message then the user has the option to
*           directly evaluate the message in the default block of this
*           methods switch-clause.
* \param    [IN] u16ServiceID = Identifier of the service from where the
*           message was sent.
*           [IN] poMessage = Message object.
* \retval   None.
*******************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnLoopback().
******************************************************************************/

    using ahl_tclBaseOneThreadApp::vOnLoopback;
    tVoid vOnLoopback(tU16 u16ServiceID, amt_tclBaseMessage* poMessage)
    {
        UNUSED(u16ServiceID);
        UNUSED(poMessage);
    }

/***************************************************************************
** FUNCTION   : void seamlessMidwMainApp::vSignalHandler()
***************************************************************************/
    /* !
* \fn       void vSignalHandler(gint32 s32SigNum, siginfo_t *pSiginfo,
                                  void *pContext)
* \brief    Method to Handle the signals sent to SPI Process/ threads created 
            by our process
* \param    s32SigNum : [IN] Signal ID/Number
* \param    pSiginfo  : [IN] Siginfo structure, which provides the details of 
                             the signal
* \param    pContext  : [IN] context ptr
* \retval   None.
**************************************************************************/
    static void vSignalHandler(gint32 s32SigNum, siginfo_t *pSiginfo,
                                 void *pContext);


    static seamlessMidwMainApp* poGetInstance(tVoid);



private:


/**************************************************************************
* Assignment Operator, will not be implemented.
* Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
* 'seamlessMidwMainApp' which has no assignment operator.
* NOTE:
* This is a technique to disable the assignment operator for this class.
* So if an attempt for the assignment is made linker complains.
**************************************************************************/
    seamlessMidwMainApp&
    operator=(const seamlessMidwMainApp
              &oseamlessMidwMainApp);

    /**************************************************************************
//!Copy Constructor, will not be implemented.
//!Avoids Lint Prio 3 warning:Info 1733: new in constructor for class
//!'seamlessMidwMainApp' which has no copy constructor.
//!NOTE:
//! This is a technique to disable the copy constructor for this class.
//!So if an attempt for the copy constructor is made linker complains.
**************************************************************************/
    seamlessMidwMainApp(const seamlessMidwMainApp
                                  &oseamlessMidwMainApp);

/**************************************************************************
* TTFIS callback register mechanism.
**************************************************************************/

    /*!
* Pointer to Trace Command handler.
*/
    //TraceStreamable* m_poTraceStreamer;

    /*!
* spi_tclService member variable
*/
    seamlessMidw_Service* m_poService;

public:
    static seamlessMidwMainApp* m_poMainAppInstance;
    static fc_seamless_midw_tcl_bt_clienthandler* m_poBTInstance;
}; 

#endif /* _seamlessMidwMainApp_H_*/




