/****************************************************************************
* FILE          : seamless_config_handler.cpp
* PROJECT       : Seamless Pairing For IPCM
* DESCRIPTION   : Logic to fetch HUID
* AUTHOR        : RVH5KOR
* COPYRIGHT     : (c) 2018 Robert Bosch GmbH, Hildesheim
****************************************************************************/

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"
#include "dlt/dlt.h"
#include "seamless_controller.h"
#include "seamless_config_handler.h"

DLT_IMPORT_CONTEXT(SPM_SPL);

/*************************************************************************
    *
    * FUNCTION: CarConfig::CarConfig
    *
    * DESCRIPTION: CarConfig constructor
    *
    * PARAMETER: void
    *
    * RETURNVALUE: NA
    *
*************************************************************************/
CarConfig::CarConfig()
{
    //Constructor
    DLT_LOG(SPM_SPL,DLT_LOG_INFO,DLT_STRING( __FUNCTION__));
}

/*************************************************************************
    *
    * FUNCTION: CarConfig::~CarConfig
    *
    * DESCRIPTION: CarConfig destructor
    *
    * PARAMETER: void
    *
    * RETURNVALUE: NA
    *
*************************************************************************/
CarConfig::~CarConfig()
{
    //Destructor
}

/*************************************************************************
    *
    * FUNCTION: CarConfig::bGetNavUnitID
    *
    * DESCRIPTION: Gets Navi unit ID
    *
    * PARAMETER: void
    *
    * RETURNVALUE: gboolean
    *
*************************************************************************/
gboolean CarConfig::bGetNavUnitID(gchar* l_pHuid)
{
       DLT_LOG(SPM_SPL,DLT_LOG_INFO,DLT_STRING( __FUNCTION__));

       dp_tclKdsNavUnitID l_navUnitID;
       std::string l_sHuid = sGetEcuSerialNumIdentifierfromKds(l_navUnitID);
       const char *l_sHuidConverted;

       //Check if empty string is returned for HUID
       if(!l_sHuid.empty())
       {
           l_sHuidConverted = l_sHuid.c_str();

           strncpy(l_pHuid, l_sHuid.c_str(), l_sHuid.length());
           l_pHuid[l_sHuid.length()] = '\0';

           DLT_LOG(SPM_SPL,DLT_LOG_INFO,DLT_STRING("Nav Uint ID String: "),
                   DLT_STRING(l_sHuidConverted));
           return TRUE;
       }
       else
       {
           DLT_LOG(SPM_SPL,DLT_LOG_INFO,DLT_STRING(__FUNCTION__), 
                       DLT_STRING("(): Failed to fetch HUID"));
           return FALSE;
       }
}

/*************************************************************************
    *
    * FUNCTION: CarConfig::sGetEcuSerialNumIdentifierfromKds
    *
    * DESCRIPTION: Gets HUID
    *
    * PARAMETER: dp_tclKdsNavUnitID
    *
    * RETURNVALUE: string
    *
*************************************************************************/
std::string CarConfig::sGetEcuSerialNumIdentifierfromKds(dp_tclKdsNavUnitID &l_navUnitID)
{
   DLT_LOG(SPM_SPL,DLT_LOG_INFO,DLT_STRING( __FUNCTION__));

   unsigned char l_u8data[14] = {0};
   tU8 l_u8Result = DP_U8_ELEM_STATUS_VALID;
   std::string l_sData = "";

   //Fetch 8 bytes NavUnitID
   l_u8Result = l_navUnitID.u8GetNavUnitID (l_u8data, 8);
   if (DP_U8_ELEM_STATUS_VALID == l_u8Result)
   {
      l_sData.append(reinterpret_cast<const char*>(l_u8data));
   }
   else
   {
      DLT_LOG(SPM_SPL,DLT_LOG_INFO,DLT_STRING( __FUNCTION__),
        DLT_STRING("(): u8GetNavUnitID returned invalid status"));
   }
   return l_sData;
}

#ifdef __cplusplus
extern "C"
{
#endif
gboolean bGetHUID(gchar* l_pHuid)
{
    DLT_LOG(SPM_SPL,DLT_LOG_INFO,DLT_STRING( __FUNCTION__));
	
    CarConfig* l_poCarConfigHandler = NULL;
    l_poCarConfigHandler = new CarConfig();

    //Call to fetch HUID
    gboolean l_bResult = l_poCarConfigHandler->bGetNavUnitID(l_pHuid);
    //Delete the object pointer here
    delete l_poCarConfigHandler;
    return l_bResult; 
}
#ifdef __cplusplus
}
#endif
