/*!
*******************************************************************************
* @file             : seamless_aes_sessionID.h
*******************************************************************************
*  - PROJECT:       : SEAMLESS PAIRING
*  - SW-COMPONENT   : FC_SEAMLESSPAIRING_IPCM
*  - DESCRIPTION    : Header for seamless_aes.sessionID.c
*  - COPYRIGHT      : &copy; 2018 Robert Bosch Engineering & Business Solutions
*  - Documents      :
*  - HISTORY
*
*  Date     | Name          |  Version | Modification
* ----------|---------------|--------------------------|-------------------------
* 24.01.2018  | IPD5KOR (RBEI/ECO2) | 2.1.0 | AES supported methods
******************************************************************************/

#ifndef __SEAMLESS_AES_SESSIONID_H_
#define __SEAMLESS_AES_SESSIONID_H_

#include <glib.h>


/****************************************************************
* Function:    bByteToHexStrConvert
* Description: This function converts a given string
               to hex format
* Parameters:  input, length, output
* Returns:     gboolean
*****************************************************************/
gboolean bByteToHexStrConvert( unsigned char* input,
                               size_t         len,
                               char*          output );

/****************************************************************
* Function:    bHexToByteStrConvert
* Description: This function converts a hex string to byte array
* Parameters:  input, output
* Returns:     gboolean
*****************************************************************/
gboolean bHexToByteStrConvert( char*          input,
                               unsigned char* output);

/****************************************************************
* Function:    bGenerateSessionID
* Description: This function generates AES256 coded sessionID
* Parameters:  hexSessionID
* Returns:     gboolean
*****************************************************************/
gboolean bGenerateSessionID(char* hexSessionID);

/****************************************************************
* Function:    bIsValidSessionID
* Description: This function validates the given sessionID
* Parameters:  sessionID
* Returns:     gboolean
****************************************************************/
gboolean bIsValidSessionID(char* sessionID);

#endif
