/****************************************************************************
* FILE          : TrustedDeviceList_Handler.h
* PROJECT       : Seamless Pairing For IPCM
* DESCRIPTION   : TrustedDeviceList logic
* AUTHOR        : RVH5KOR
* COPYRIGHT     : (c) 2018 Robert Bosch GmbH, Hildesheim
****************************************************************************/

#ifndef _TRUSTEDEVICELIST_HANDLER_H_
#define _TRUSTEDEVICELIST_HANDLER_H_

#include <stdio.h>
#include <glib.h>
#include <string.h>
#include <sys/socket.h>
#include <errno.h>
#include <linux/wireless.h>
#include <linux/if.h>
#include <linux/if_tun.h>
#include <sys/ioctl.h>
#include "SeamlessMidw_HMI_enums.h"

//Structure to consolidate a device's information
typedef struct deviceInfo
{
    char *sSsid;
    char *sPsk;
    char *sBssid;
    char *sName;
    char *sPairTime;
    char *sSerialNumber;
}TrustedDeviceInfo;

/*************************************************************************
 * FUNCTION     : bUpdateTrustedDeviceListInfo
 * DESCRIPTION  : This function updates Trusted devices' info
 * PARAMETER    : arg_TrustedDeviceInfo, arg_eAction
 * RETURNVALUE  : gboolean
*************************************************************************/
gboolean bUpdateTrustedDeviceListInfo(GVariant  *arg_TrustedDeviceInfo, 
                                      SeamlessPairingAction arg_eAction);

/*************************************************************************
 * FUNCTION     : vCreateNewHashTable
 * DESCRIPTION  : This function creates a new GKeyFile object
 * PARAMETER    : void
 * RETURNVALUE  : void
*************************************************************************/
void vCreateNewHashTable();

/*************************************************************************
 * FUNCTION     : vDestroyHashTable
 * DESCRIPTION  : This function destroys the existing GKeyFile object
 * PARAMETER    : void
 * RETURNVALUE  : void
*************************************************************************/
void vDestroyHashTable();

/*************************************************************************
 * FUNCTION     : bInsertDeviceInfo
 * DESCRIPTION  : This function inserts the new device info into the hash
 *                and the file in persistent storage
 * PARAMETER    : arg_DeviceInfo
 * RETURNVALUE  : gboolean
*************************************************************************/
gboolean bInsertDeviceInfo(TrustedDeviceInfo *arg_DeviceInfo);

/*************************************************************************
 * FUNCTION     : bRemoveDeviceInfo
 * DESCRIPTION  : This function removes the requested device info from
 *                the hash and the file in persistent storage
 * PARAMETER    : arg_DeviceInfo
 * RETURNVALUE  : gboolean
*************************************************************************/
gboolean bRemoveDeviceInfo(TrustedDeviceInfo *arg_DeviceInfo);

/*************************************************************************
 * FUNCTION     : bRemoveAllDeviceInfo
 * DESCRIPTION  : This function removes all the device info from
 *                the hash and the file in persistent storage
 * PARAMETER    : None
 * RETURNVALUE  : gboolean
*************************************************************************/
gboolean bRemoveAllDeviceInfo();

/*************************************************************************
 * FUNCTION     : bLoadTrustedDeviceInfo
 * DESCRIPTION  : This function loads all the existing device info from
 *                the file in persistent storage into the GKeyFile object
 * PARAMETER    : void
 * RETURNVALUE  : gboolean
*************************************************************************/
gboolean bLoadTrustedDeviceInfo();

/*************************************************************************
 * FUNCTION     : bBuildDeviceInfoPropertyUpdate
 * DESCRIPTION  : This function builds GBuilders with all devices' info
 *                to pass onto HMI
 * PARAMETER    : void
 * RETURNVALUE  : void
*************************************************************************/
void bBuildDeviceInfoPropertyUpdate();

void vFetchBssid();

void vCheckTDLForBSSID(char *arg_strBssid);

void vFetchSsid(char *arg_strSsid);

#endif
