#ifndef _SEAMLESS_WBL_INTERFACE_HANDLER_H_
#define _SEAMLESS_WBL_INTERFACE_HANDLER_H_

#include <glib.h>
#include <gio/gio.h>

typedef enum 
{
   WIFI_AP_ACTIVE = 0,
   WIFI_AP_INACTIVE,
   WIFI_MODE_TRANSITION
}WiFiAPState;

/****************************************************************************
* Function:    bWatchWBLService
* Description: This methods intiates the watch for WBL interface
* Parameters:  void
* Return:      gboolean
*****************************************************************************/
gboolean bWatchWBLService();

/****************************************************************************
* Function:    vUnwacthWBLService
* Description: This methods stops watcing for WBL interface
* Parameters:  void
* Return:      void
****************************************************************************/
void  vUnwatchWBLService();

/****************************************************************************
* Function:    vWBLServiceAppearedCB
* Description: Name appeared call back for WBL service
* Parameters:  connection , service_name , owner_name, userdata
* Return:      void
*****************************************************************************/
void
vWBLServiceAppearedCB( GDBusConnection *connection, const gchar *name,
                       const gchar *name_owner, gpointer user_data);

/***************************************************************************
* Function:    vWBLServiceVanishedCB
* Description: Name disappeared call back for wbl service
* Parameters:  connection, service_name, user_data
* Return:      void
****************************************************************************/
void
vWBLServiceVanishedCB( GDBusConnection *connection,
                      const gchar *service_name,
                      gpointer    user_data );

/***************************************************************************
* Function:     vWBLClientProxyCB
* Description:  This is call back function for WBL
                proxy object creation
* Parameters:   source_object, res, user_data
* Return:       void
***************************************************************************/
void vWBLClientProxyCB( GObject *source_object,
                        GAsyncResult *res,
                        gpointer user_data );

/*************************************************************************
* Function:    bWBLAvailable()
* Description: This function gives the WBL proxy availability status
* Parameters:  void
* Return:      void
*************************************************************************/
gboolean bWBLAvailable();

/***********************************************************************
* Function:    vHandleWifiSetupUpdate
* Descriptiom: Handles the WBL ActiveWifiSetups property update
* Parameters:  proxy, changed_properties, invalidated_properties
* Return:      void
************************************************************************/
void  vHandleWifiSetupUpdate( GDBusProxy          *proxy,
                              GVariant            *changed_properties,
                              const gchar* const  *invalidated_properties,
                              gpointer            user_data );

/************************************************************************
* Function:    vFetchWifiActiveSetup
* Descriptiom: Fetches the current active Wifi setups
* Parameters:  void
* Return:      void
************************************************************************/
void vFetchActiveWiFiSetup();

/***********************************************************************
* Function:    vDeActivateTempAP
* Descriptiom: Sends request to WBL to de-activate temp AP
* Parameters:  void
* Return:      void
************************************************************************/
void vDeActivateTempAP();

/***********************************************************************
* Function:    bCreateTempWiFiSetup
* Descriptiom: Method to create temporary wifi setup
* Parameters:  ssid, wpa_key
* Return:      gboolean
************************************************************************/
gboolean  bCreateTempWiFiSetup(gchar* ssid, gchar* wpa_key);

#endif
