#include "dlt/dlt.h"
#include "seamlessMidw_DBusHandler.h"
#include "Seamless_Connman_DBusHandler.h"
#include "TrustedDeviceList_Handler.h"
#include "mdns_manager.h"

DLT_DECLARE_CONTEXT(SPM_CONNMAN);

#define CONNMAN_MANAGER_OBJ_PATH    "/"
#define CONNMAN_MANAGER_IFACE       "net.connman.Manager"
#define CONNMAN_MANAGER_DBUS_NAME   "net.connman"
#define SP_DBUS_NAME                "com.bosch.SeamlessMiddleware"
#define SP_OBJECT_PATH              "/com/bosch/SeamlessMiddleware/Notification"

static guint g_iSPWatcherID = 0;
static GDBusConnection* g_system_conn = NULL;
NetConnmanManager *net_connman_mng_proxy = NULL;

/******************************************************************************
* Function:    on_spmw_name_acquired
* Description: Callback on DBus name acquired
* Parameters:  Connection , Bus name, user data
* Return:      void
*****************************************************************************/
void vOnSpmwSystemNameAcquired( GDBusConnection *pConnection,
                       const gchar     *pName,
                       gpointer        pUserData )
{
    DLT_LOG(SPM_CONNMAN,DLT_LOG_INFO,DLT_STRING("+"),
                              DLT_STRING(__FUNCTION__));
    DLT_LOG(SPM_CONNMAN,DLT_LOG_INFO,DLT_STRING("-"),
                              DLT_STRING(__FUNCTION__));
}

void vUnwatchConnmanService()
{
    DLT_LOG(SPM_CONNMAN, DLT_LOG_INFO, DLT_STRING("+"),DLT_STRING(__FUNCTION__));

    if(g_iSPWatcherID)
    {
       g_bus_unwatch_name(g_iSPWatcherID);
       g_iSPWatcherID = 0;
    }
    if(net_connman_mng_proxy)
    {
       g_clear_object(&net_connman_mng_proxy);
    }

    DLT_LOG(SPM_CONNMAN, DLT_LOG_INFO, DLT_STRING("-"),DLT_STRING(__FUNCTION__));
}

GDBusConnection* poGetSPMSystemBusConn()
{
    return g_system_conn;
}

void vHandleReleaseCB (NetConnmanNotification *object, GDBusMethodInvocation *invocation)
{
    DLT_LOG(SPM_CONNMAN,DLT_LOG_ERROR,DLT_STRING(
         "+"),DLT_STRING( __FUNCTION__ ));
}

void vHandleUpdateCB (NetConnmanNotification *object, GDBusMethodInvocation *invocation,
               GVariant *arg_fields)
{
    DLT_LOG(SPM_CONNMAN,DLT_LOG_INFO,DLT_STRING(
                "+"),DLT_STRING( __FUNCTION__ ));
    const gchar *name = NULL;
    GVariant *params = NULL;
    GVariantIter *iter;
    g_variant_get (arg_fields, "a{sv}", &iter);
    while (g_variant_iter_next (iter, "{&sv}", &name, &params))
    {
        gsize l_len = 0;
        char *l_strValue = NULL;
        l_strValue = g_variant_get_string(params, &l_len);
        DLT_LOG(SPM_CONNMAN,DLT_LOG_INFO,DLT_STRING(
                    "+vHandleUpdateCB: Key: "),DLT_STRING(name));
        DLT_LOG(SPM_CONNMAN,DLT_LOG_INFO,DLT_STRING(
                    "+vHandleUpdateCB: Value: "),DLT_STRING(l_strValue));
        if ((g_strcmp0 (name, "State") == 0))
        {
            char *l_strConnectionState = NULL;
            l_strConnectionState = g_variant_get_string(params, &l_len);
            DLT_LOG(SPM_CONNMAN,DLT_LOG_INFO,DLT_STRING(
                        "+vHandleUpdateCB: Connection state: "),DLT_STRING(l_strConnectionState));
            if(!strcmp(l_strConnectionState,"online") || !strcmp(l_strConnectionState,"connected"))
            {
                /*HU is connected to an external Network, so fetch the BSSID*/
                vFetchBssid();
            }
            else if(!strcmp(l_strConnectionState,"disconnected"))
            {
                //Call MDNS Deregister
                if(bIsMQTTServiceRegistered)
                {
                    MDNSDeRegister();
                    bIsMQTTServiceRegistered = FALSE;
                }
            }
        }
    }
}

void vOnNetConnmanNotiBusAcquired (GDBusConnection *connection,
                                   const gchar *name,
                                   gpointer user_data)
{
    DLT_LOG(SPM_CONNMAN,DLT_LOG_ERROR,DLT_STRING(
                "+"),DLT_STRING( __FUNCTION__ ));
    NetConnmanNotification *net_connman_noti_proxy = NULL;
    net_connman_noti_proxy = net_connman_notification_skeleton_new ();
    if (NULL != net_connman_noti_proxy)
    {
        g_signal_connect (net_connman_noti_proxy, "handle-release",
                          G_CALLBACK (vHandleReleaseCB), NULL);
        g_signal_connect (net_connman_noti_proxy, "handle-update",
                          G_CALLBACK (vHandleUpdateCB), NULL);

        if (!g_dbus_interface_skeleton_export (
                    G_DBUS_INTERFACE_SKELETON (net_connman_noti_proxy),
                    connection,
                    SP_OBJECT_PATH,
                    NULL))
        {
            DLT_LOG(SPM_CONNMAN,DLT_LOG_ERROR,DLT_STRING(
                        "Export failed"));
        }
    }
}

void vOnNetConnmanNotiNameAcquired (GDBusConnection *connection,
                                    const gchar *name,
                                    gpointer user_data)
{
    DLT_LOG(SPM_CONNMAN,DLT_LOG_ERROR,DLT_STRING(
         "+"),DLT_STRING( __FUNCTION__ ));
    DLT_LOG(SPM_CONNMAN,DLT_LOG_ERROR,DLT_STRING(
         "-"),DLT_STRING( __FUNCTION__ ));
}


void vOnNetConnmanNotiNameLost (GDBusConnection *connection,
                                const gchar *name,
                                gpointer user_data)
{
    DLT_LOG(SPM_CONNMAN,DLT_LOG_INFO,DLT_STRING(
         "+"),DLT_STRING( __FUNCTION__ ));
  /* free all dbus handlers ... */
   // vUnwatchConnmanService();
    DLT_LOG(SPM_CONNMAN,DLT_LOG_INFO,DLT_STRING(
         "-"),DLT_STRING( __FUNCTION__ ));
}

void vStartNetConnmanNotificationService ()
{
    DLT_LOG(SPM_CONNMAN,DLT_LOG_ERROR,DLT_STRING(
         "+"),DLT_STRING( __FUNCTION__ ));

    g_iSPWatcherID = g_bus_own_name (G_BUS_TYPE_SYSTEM,  // bus type
                                     //"net.connman.Notification",  // interface name/ bus or service name
                                     SP_DBUS_NAME,
                                     G_BUS_NAME_OWNER_FLAGS_NONE,  // bus own flag, can be used to take away the bus and give it to another service
                                     vOnNetConnmanNotiBusAcquired,  // callback invoked when the bus is acquired
                                     vOnNetConnmanNotiNameAcquired,  // callback invoked when interface name is acquired
                                     vOnNetConnmanNotiNameLost,  // callback invoked when name is lost to another service or other reason
                                     NULL,  // user data
                                     NULL);  // user data free func

}

void vCreateSessionCallback(GObject *source_object,
                            GAsyncResult *res,
                            gpointer user_data)
{
    DLT_LOG(SPM_CONNMAN,DLT_LOG_ERROR,DLT_STRING(
         "+"),DLT_STRING( __FUNCTION__ ));
    GError *error = NULL;
  gchar *out_session = NULL;
  net_connman_manager_call_create_session_finish( (NetConnmanManager *) source_object, &out_session, res, &error);
  if (error)
    {
      /*g_warning (" CreateSession failed %s",
                 error ? error->message : "no error given.");*/
      g_error_free (error);
      error = NULL;
    }
  else
    {
        /*g_print("session success \n");
        g_print(" Session path is %s\n", out_session);*/
      DLT_LOG(SPM_CONNMAN,DLT_LOG_ERROR,DLT_STRING(
           "No error in Create session"),DLT_STRING( __FUNCTION__ ));
    }
  DLT_LOG(SPM_CONNMAN,DLT_LOG_ERROR,DLT_STRING(
       "-"),DLT_STRING( __FUNCTION__ ));
}

void vCreateSession()
{
    DLT_LOG(SPM_CONNMAN,DLT_LOG_ERROR,DLT_STRING(
         "+"),DLT_STRING( __FUNCTION__ ));
    GVariant *parameters;
  GVariantBuilder *gvb;
  gvb = g_variant_builder_new (G_VARIANT_TYPE ("a{sv}"));
  const gchar *bearers[3] = { "wifi", NULL };
  g_variant_builder_add (gvb, "{sv}", "AllowedBearers", g_variant_new_strv (bearers, -1));
  g_variant_builder_add (gvb, "{sv}", "ConnectionType", g_variant_new_string ("any"));
  parameters =  g_variant_new ("a{sv}", gvb);
  net_connman_manager_call_create_session(net_connman_mng_proxy,
                                          parameters,
                                          SP_OBJECT_PATH,
                                          NULL,
                                          vCreateSessionCallback,
                                          NULL);

  DLT_LOG(SPM_CONNMAN,DLT_LOG_ERROR,DLT_STRING(
       "-"),DLT_STRING( __FUNCTION__ ));
}

void vNetConnmanManagerProxyCreatedCB (GObject *source_object,
                                       GAsyncResult *res,
                                       gpointer user_data)
{
    DLT_LOG(SPM_CONNMAN,DLT_LOG_ERROR,DLT_STRING(
         "+"),DLT_STRING( __FUNCTION__ ));
    GError *error = NULL;
  /* finishes the proxy creation and gets the proxy ptr */
  net_connman_mng_proxy = net_connman_manager_proxy_new_finish (res, &error);

  if ((net_connman_mng_proxy == NULL) || error)
    {
      //g_warning ("Error intializing the net.connman mng proxy %s",
                // error ? error->message : "no error given.");
    }
  else
    {
      vCreateSession();
    }
}

void vNetConnmanNameAppeared (GDBusConnection *connection,
                              const gchar *name,
                              const gchar *name_owner,
                              gpointer user_data)

{
    DLT_LOG(SPM_CONNMAN,DLT_LOG_ERROR,DLT_STRING(
         "+"),DLT_STRING( __FUNCTION__ ));
  net_connman_manager_proxy_new (connection, G_DBUS_PROXY_FLAGS_NONE,
                                 CONNMAN_MANAGER_DBUS_NAME,
                                 "/",
                                 NULL,
                                 vNetConnmanManagerProxyCreatedCB,
                                 user_data);
}

void vNetConnmanNameVanished (GDBusConnection *connection,
                              const gchar *name,
                              gpointer user_data)
{
    DLT_LOG(SPM_CONNMAN,DLT_LOG_ERROR,DLT_STRING(
         "+"),DLT_STRING( __FUNCTION__ ));

  if (NULL != net_connman_mng_proxy)
    {
      g_object_unref (net_connman_mng_proxy);
      net_connman_mng_proxy = NULL;
    }
}

gboolean bStartSPMWConnmanService()
{
    DLT_REGISTER_CONTEXT(SPM_CONNMAN,"SMCONN","Gateway Connman"
                         "context for DLT Logging");
    DLT_LOG(SPM_CONNMAN,DLT_LOG_ERROR,DLT_STRING(
         "+"),DLT_STRING( __FUNCTION__ ));

    vStartNetConnmanNotificationService();
    g_bus_watch_name (G_BUS_TYPE_SYSTEM,
                      CONNMAN_MANAGER_DBUS_NAME,
                      G_BUS_NAME_WATCHER_FLAGS_AUTO_START,
                      vNetConnmanNameAppeared,
                      vNetConnmanNameVanished,
                      NULL,
                      NULL);
    DLT_LOG(SPM_CONNMAN,DLT_LOG_ERROR,DLT_STRING(
         "-"),DLT_STRING( __FUNCTION__ ));

    return TRUE;
}
