/*!
*******************************************************************************
*    @file          : FC_SeamlessMidw_BT_ClientHandler.h
*******************************************************************************
*  - PROJECT:       : Seamless Pairing IPCM
*  - SW-COMPONENT   : SP_IPCM
*  - DESCRIPTION    : Header for Bluetooth client handler
*  - COPYRIGHT      : &copy; 2018 Robert Bosch Engineering & Business Solutions
*  - Documents      : Give link of relevant documents
*  - HISTORY
*
*  Date      | Name          |  Version | Modification
* -----------|---------------|-------------------------------------------------
* 30.05.2018 | IPD5KOR      | 1.0.0    | methods for Bluetooth Client Handler
******************************************************************************/

#ifndef _FC_SP_BT_CLIENTHANDLER_H_
#define _FC_SP_BT_CLIENTHANDLER_H_

/* Defines for including the needed interface header files */
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

//Include FI interface of Bluetooth Settings
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_ERRORCODES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_SERVICEINFO

#include "conn_most_fi_if.h"
#include "ahl_BaseOneThreadClienthandler.h"
#include <string>

#define BT_MAXDEVICENAME_LENGTH 255

class ahl_tclBaseOneThreadClientHandler;
class seamlessMidwMainApp;

class
   fc_seamless_midw_tcl_bt_clienthandler : 
                          public ahl_tclBaseOneThreadClientHandler
{

public:
        static fc_seamless_midw_tcl_bt_clienthandler* 
                                   m_poBluetoothClientHandler;

	fc_seamless_midw_tcl_bt_clienthandler( seamlessMidwMainApp*
	                  	                        poMainAppl );

	static fc_seamless_midw_tcl_bt_clienthandler* 
	          getInstance(seamlessMidwMainApp *poMainAppl);

        int iFetchSeamlessBTAddress( char*        sBluetoothAddress,
                                     unsigned int uBluetoothAddressSize);

        int iFetchSeamlessBTName( char*        sBluetoothName,
                                  unsigned int uBluetoothNameSize);
  
	/* Destructor */
	virtual ~fc_seamless_midw_tcl_bt_clienthandler();
	virtual tVoid vOnServiceAvailable();
	virtual tVoid vOnServiceUnavailable();

        //CCA client handler functions.
        tVoid vHandle_VehicleBTFriendlyName_Status(amt_tclServiceData* 
                                                            poMessage);	
        tVoid vHandle_VehicleBTAddress_Status(amt_tclServiceData* 
                                                            poMessage);
	
	/* Message map definition macro */
	DECLARE_MSG_MAP(fc_seamless_midw_tcl_bt_clienthandler);
private:
        std::string m_seamlessBTAddress;
        std::string m_seamlessBTFriendlyName;
};

#endif //_FC_GATEWAY_BLUETOOTHCLIENTHANDLER_H_
