/* File Projectif.h
*   Component: Profile Manager
*   Project Specific Configuration & Callback interface
*   Author: de\bn81lr
*/

#ifndef PROJECT_IF_H
#define PROJECT_IF_H

#include "core/configInterface.h"

namespace profileMngr{

class profileRenault_VCANClient;

class renaultCfg:public profileMngr::configIF
{
public:
	renaultCfg();
	virtual ~renaultCfg();
	virtual void startASFClients(::boost::shared_ptr< asf::dbus::DBusConnector > & DBus,::boost::shared_ptr< asf::core::ComponentContainer > & App);


	virtual bool Init(uint8_t & startProfile);
	virtual bool InitOnPowerMode(uint8_t & startUser){return true;};
	virtual bool doDefSet(profileData & Data);
	//Def Set for particular index
	virtual bool doDefSet(profileData & Data, unsigned char ID);


	//delete profile data
	virtual bool deleteProfileData(profileData & Data,unsigned char ID);


	virtual bool doChangeName(profileData & Data,unsigned char ID,std::string & Name);
	virtual bool doChangeImage(profileData & Data,unsigned char ID,unsigned char Idx);
	virtual bool doCreateProfile(profileData & Data,unsigned char ID,const std::string & Name,unsigned char Idx){ return false;}

	//copy profile
	virtual bool isCopyProfileAllowed(profileData & Data,unsigned char srcID,unsigned char destID);


	//isSetProfileNameAllowed
	virtual bool isSetProfileNameAllowed(profileData & Data,unsigned char userID,const std::string& profileName);

	//isSetProfileImageAllowed
	virtual bool isSetProfileImageAllowed(profileData & Data,unsigned char userID);

	//isDeleteProfileAllowed
	virtual bool isDeleteProfileAllowed(profileData & Data,unsigned char userID);

	//isCreateProfileAllowed
	virtual bool isCreateProfileAllowed(profileData & Data,const std::string& name, unsigned char &userID);

	//switch profile
	virtual bool isProfileChangeAllowed(unsigned char profileIDX,unsigned char activeProfile);

	//valetMode
	virtual bool isSetValetModeAllowed(unsigned char & newUserId);

	//
	virtual bool isValetModeProfileChangeAllowed(profileData & Data,unsigned char &  userId);

	//Return maximum number of profiles
	virtual unsigned char maxProfiles();

	virtual bool getDefaultProfile(unsigned char & defaultUserId);

	//Change to profile
	virtual void changeToProfileCompetionStatus(profileMngr::actionState status, unsigned char oldUserID, unsigned char newUserID);

	//copyProfile
	virtual void copyProfileCompletionStatus(profileMngr::actionState status,profileData & Data,unsigned char srcID, unsigned char destID,uint8_t & changeProfile);

	//Delete Profile
	virtual void deleteProfileCompletionStataus(profileMngr::actionState status, unsigned char userID,uint8_t & changeProfile){;}

	//create profile
	virtual void createProfileCompletionStatus(profileMngr::actionState status, unsigned char & newUserID){;}

	virtual bool load(){return true;}
	virtual bool store(){return true;}

	virtual void allClientsRegistered(){;}

private:
	bool bConvStrToInt(const std::string& str, int &iValue);
	void emitVCANSignalsOnChangeProfile(unsigned char ID);
	unsigned char m_maxProfiles;
	profileRenault_VCANClient *m_pVCANClient;
};

}
#endif
