

#include "renaultConfig.h"

#include "core/profileData.h"
#include "profileRenault_VCANClient.h"

#include <stdio.h>

using namespace std;

extern "C"
{
	void* getConfig()
	{
		return new profileMngr::renaultCfg();
	}
}

namespace profileMngr{

//Default name Array
static const profileConf aProfilerenaultCfg[] =
{
	#define PROFILE_KDSCONFIG_MAP(profileName, profileImageID,profileStatus, profileExternalID )  { profileName, unsigned (profileImageID), profileStatus, profileExternalID },
	#include "RenaultConfig.dat"
	#undef PROFILE_KDSCONFIG_MAP
};

#include "RenaultClientDB.dat"


// **************************** renaultCfg  ********************************

renaultCfg::renaultCfg():m_maxProfiles(6)
{
	m_pVCANClient = new profileRenault_VCANClient();
	//Initialize  Vector with default array
	const int mapSize = sizeof aClientDatabase / sizeof(std::string);
	for(int i = 0;i < mapSize; i++)
	{
		m_expectedClients.push_back(profileMngr::Client(0,aClientDatabase[i]));
	}
}

renaultCfg::~renaultCfg()
{
	delete m_pVCANClient;
}

// ************************** maxProfiles ********************************************************
unsigned char renaultCfg::maxProfiles()
{
	return m_maxProfiles;
}


// **************************** startASFClients  ********************************

void renaultCfg::startASFClients(::boost::shared_ptr< asf::dbus::DBusConnector > & DBus,::boost::shared_ptr< asf::core::ComponentContainer > & App)
{

}

// **************************** Init  ********************************
bool renaultCfg::Init(uint8_t & startProfile)
{
	FailureTimeout=5000;


	emitVCANSignalsOnChangeProfile(startProfile);

	return true;
}

// **************************** doDefSet  ********************************
bool renaultCfg::doDefSet(profileData & Data)
{

	//Initialize  Vector with default array
	const int mapSize = sizeof aProfilerenaultCfg / sizeof(profileConf);
    //std::vector<profileConf> defaultProfilesList(aProfilerenaultCfg, aProfilerenaultCfg + mapSize); //Initialize vector with array of default data;

	for (int i=0;i<mapSize;i++)
	{
		//filled the default values
		Data.setName(i,aProfilerenaultCfg[i]._profileName);
		Data.setImage(i,aProfilerenaultCfg[i]._profileImageID);
		Data.setStatus(i,aProfilerenaultCfg[i]._profileStatus);
	}

	return true;
}

// **************************** doDefSet (index) ********************************

bool renaultCfg::doDefSet(profileData & Data, unsigned char ID)
{
	Data.setName(ID,aProfilerenaultCfg[ID]._profileName);
	Data.setImage(ID,aProfilerenaultCfg[ID]._profileImageID);
	Data.setStatus(ID,aProfilerenaultCfg[ID]._profileStatus);
	return true;
}

// ************************** reset profile ********************************************************

bool renaultCfg::deleteProfileData(profileData & Data,unsigned char ID)
{
	Data.setName(ID,aProfilerenaultCfg[ID]._profileName);
	Data.setImage(ID,aProfilerenaultCfg[ID]._profileImageID);
	Data.setStatus(ID,aProfilerenaultCfg[ID]._profileStatus);
	return true;
}

// ************************** isSetProfileNameAllowed ********************************************************
bool renaultCfg::isSetProfileNameAllowed(profileData & Data,unsigned char userID,const std::string& profileName)
{
	bool bNameSet = false;

	if((userID < maxProfiles()) && (Data.getProfileStatus()[userID] != usGuest)  && !profileName.empty()  )
	{
		bNameSet = true;
		//Check if name is already used
		for(int i=0; i< maxProfiles();i++)
		{
			if(Data.getProfileNames().at(i)==profileName.c_str())
			{
				//ETG_TRACE_ERR(("Double Name Exist"));
				 bNameSet = false;
				 break;
			}
		}//end for
	}
	return bNameSet;
}

// ************************** isSetProfileImageAllowed ********************************************************
bool renaultCfg::isSetProfileImageAllowed(profileData & Data,unsigned char userID)
{
	if((userID < maxProfiles()) && (Data.getProfileStatus()[userID] != usGuest)) //validation
		return true;

	return false;

}

bool renaultCfg::isDeleteProfileAllowed(profileData & Data,unsigned char userID)
{
	if(userID < maxProfiles() )
		return true;

	return false;

}

bool renaultCfg::isProfileChangeAllowed(unsigned char  profileIDX,unsigned char activeProfile )
{
	return true;
}

bool renaultCfg:: isValetModeProfileChangeAllowed(profileData & Data,unsigned char &  userId)
{
	if (Data.getValetModeStatus())
	    if (Data.getProfileStatus()[userId]!=usProtectedPin)
	        return false;
	return true;

}
//********************************** doChangeName for copy profile **********************************
bool renaultCfg::doChangeName(profileData& Data, unsigned char ID,	std::string& Name)
{
	Name =Data.getProfileNames()[ID];
	int value=1;
	int count=Data.getProfileNames().size();
	uint8_t IDs[count],size[count];
	memset(IDs,255,sizeof(uint8_t)*6);
	memset(size,0,sizeof(uint8_t)*6);

	//calculate netto lenght of user name (without '(x)') and get the index value if available
	for (int k=0;k < count;++k)
	{
		size[k]=Data.getProfileNames()[k].length();
		size_t open = Data.getProfileNames()[k].find_last_of('(');
		if (open!= string::npos)
		{
			size_t close = Data.getProfileNames()[k].find_last_of(')');
			//printf("open:%i close:%i size:%i\n",open,close,size[k]);
			if (close >= open+2 && close ==size[k]-1)
			{
				IDs[k]= atoi(&Data.getProfileNames()[k][open+1]);
				size[k]=open;
			}
		}
	}

	if (IDs[ID]!=255)
		Name.erase(size[ID],Name.length()-size[ID]);

	if (Name.length() > 17)//NCG3D-79879
		Name.erase(17,17-Name.length());

// find the lowest free index
	for (int k=0;k < count;++k)
	{
		if( size[k]==size[ID] && IDs[k]==value && memcmp(Data.getProfileNames()[k].c_str(),Data.getProfileNames()[ID].c_str(),size[k])==0)
		{
			value++;k=-1;
		}
	}

	//append index to name
	char idx='0';idx+=value;
	Name.append("(");
	Name.append(&idx,1);
	Name.append(")");
	return true;
}

// ************************** doChangeImage ********************************************************

bool renaultCfg::doChangeImage(profileData& Data, unsigned char ID,	unsigned char Idx)
{
	return false;
}

// ************************** doCopyProfile ********************************************************

bool renaultCfg::isCopyProfileAllowed(profileData & Data,unsigned char srcID,unsigned char destID)
{
	bool re=false;
	if ((srcID < maxProfiles()) && (destID < maxProfiles()) && (srcID != destID) && (srcID == Data.currentProfile()) &&
		(profileMngr::usGuest!=Data.getProfileStatus()[srcID]) && (profileMngr::usGuest!= Data.getProfileStatus()[destID]))
		re=true;

	return re;
}

// ************************** getDefaultProfile ********************************************************
bool renaultCfg :: getDefaultProfile(unsigned char & defaultUserId)
{
	defaultUserId=0;
	return true;

}
 bool renaultCfg::isCreateProfileAllowed(profileData & Data,const std::string& name, unsigned char &userID)
 {
 	return false;
 }

 bool renaultCfg ::isSetValetModeAllowed(unsigned char & newUserId)
 {
	 newUserId=0;
	 return true;
 }

 //copyProfile
 void renaultCfg::copyProfileCompletionStatus(profileMngr::actionState status,profileData & data,unsigned char srcID, unsigned char destID,uint8_t & changeProfile)
 {
    // after a copy the Active Profile should be DestID
    changeProfile=destID;

    //get the new name from copy rules of variant
	std::string profileName;
    doChangeName(data,srcID,profileName);

	data.setName(destID,profileName);


	data.setImage(destID,aProfilerenaultCfg[destID]._profileImageID);

	data.setStatus(destID,usNormal);
 }

 //SwitchProfile
 void renaultCfg::changeToProfileCompetionStatus(profileMngr::actionState status, unsigned char oldUserID, unsigned char newUserID)
 {
	 emitVCANSignalsOnChangeProfile(newUserID);
 }


// private Function - convertion from string to integer
 // ************************** bConvStrToInt ********************************************************
bool renaultCfg::bConvStrToInt(const std::string& str, int &result)
{

		int strSize,iCntr = 0;
		int iResult = 0;
		strSize=str.size();
		bool bResult=true;

		while((iCntr < strSize) &&(str[iCntr] != '\0'))
		{
			if(str[iCntr] != 0x20) //Ignore space while conversion
			{
				if((str[iCntr] >= '0')&& (str[iCntr] <= '9'))
				{
					iResult = (iResult * 10) + (str[iCntr] - '0');
				}
				else if(str[iCntr] == '.')
				{

				   printf(" decimal value :");
				}
				else
				{
					bResult = false;
					break;
				}
			}

			printf("Current value :%d",iResult);
			iCntr++;
		}

		if(true == bResult)
		{
			result = iResult;
		}


	return bResult;
}

void renaultCfg::emitVCANSignalsOnChangeProfile(unsigned char userId)
{
	// Send current login user info to CSM
	if(m_pVCANClient)
	{
		//Map the System UserID to the MCAN UUDT ProfileID by adding 1
		(void)m_pVCANClient->writeCurrentUserSetting(userId+1);
	}
}

}


