#ifndef SERVICE_PIVI_H
#define SERVICE_PIVI_H

#include <iostream>

#include "asf/core/Logger.h"
#include "asf/core/Proxy.h"
#include "asf/core/Timer.h"

#include "bosch/cm/profilePIVIStub.h"

#include "asf/stream/MemoryStream.h"
#include "pivi/config/profileDataPIVI.h"

using namespace profileMngr;

namespace pivi { namespace core {

using namespace::asf::core;
using namespace::asf::stream;
using namespace bosch::cm::profilePIVI;
using namespace::asf::core;



class ServicePIVI : private ProfilePIVIStub
{
	private:
		DECLARE_CLASS_LOGGER();

	public:
		ServicePIVI();
		virtual ~ServicePIVI();
	public: //ProfilePIVIStub interface
		virtual void onMapKeyToCurrentProfileRequest (const ::boost::shared_ptr< MapKeyToCurrentProfileRequest >& request);
		virtual void onSetWelcomeGuidanceActiveRequest (const ::boost::shared_ptr< SetWelcomeGuidanceActiveRequest >& request);
		virtual void onSetLoginKeyLinkSettingRequest (const ::boost::shared_ptr< SetLoginKeyLinkSettingRequest >& request);
		virtual void onGetKeylistRequest (const ::boost::shared_ptr< GetKeylistRequest >& request);
		//Attribute Update
		virtual void getKeyIsMapped(bool &isKeyMapped)
		{
			isKeyMapped=ProfilePIVIStub::getKeyIsMapped();
		}
		virtual void getKeyMappingPossible(bool &isKeyMappingPossible)
		{
			isKeyMappingPossible=ProfilePIVIStub::getKeyMappingPossible();
		}
		virtual void getKeyID(uint32 &keyID)
		{
			keyID=ProfilePIVIStub::getKeyID();
		}
		virtual void getProfilekeyIIndex(uint8 &keyID)
		{
			keyID=ProfilePIVIStub::getProfilekeyIIndex();
		}

		void sendKeyIsMapped(bool keyIsMappedStatus);
		void sendKeyMappingPossible(bool keyMappingPossibleStatus);
		void updatePropertiesOnstartup();
		void sendkeyID(uint32 keyID);
		void sendLoginKeyLinkStatus(bool loginKeyLinkStatus);
		void sendProfilekeyIndex(uint8 keyIndex);//not implemented
		void sendWelcomeGuidanceActive(bool WgActive);
		void sendStartupUpdate(bool status);
		static ServicePIVI &getInstance() {return *m_servicePIVI;};
//		void setCurrentLoginUser(unsigned char userId);

	private:


		unsigned char getCurrentKey();

		//member variables
		static ServicePIVI* m_servicePIVI;
		act_t m_CurrentAct;

};

}}

#endif

