
#define ETRACE_S_IMPORT_INTERFACE_GENERIC

#include "pivi/core/ServicePIVI.h"
#include <pivi/config/piviConfig.h>
#include <pivi/config/profilePIVIDefines.h>
#include "pivi/core/profilePIVI_VCANClient.h"

#include <sstream>

#define DP_S_IMPORT_INTERFACE_BASE
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#include <pivi/core/profilePIVITrace.h>
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PROFILEMANAGER_APP_PIVI
#include "trcGenProj/Header/ServicePIVI.cpp.trc.h"
#endif



namespace pivi { namespace core {

using namespace::asf::core;
using namespace::asf::stream;
using namespace::bosch::cm::profilePIVI;

DEFINE_CLASS_LOGGER_AND_LEVEL("pivi/ServicePIVI", ServicePIVI, Info);

ServicePIVI * ServicePIVI::m_servicePIVI = NULL;

ServicePIVI::ServicePIVI():ProfilePIVIStub("profilePIVIPort"), m_CurrentAct(0)
{
	profilePIVI_VCANClient::ProfileStubAvailability = true;

	bool loginKeylinkStatus = Piviconfig::getInst().getLoginKeylinkStatus();
	sendLoginKeyLinkStatus(loginKeylinkStatus);

	m_CurrentAct=0;
	m_servicePIVI = this;
	LOG_INFO_STATIC("ServicePIVI-ctor");
	if(Piviconfig::getInst().getDigitalAssistant() == DIGITAL_ASSISTANT_ON)
	{
		ETG_TRACE_FATAL(("DigitalAssistant -> ON sending Initialized Flag"));
		if(!profilePIVI_VCANClient::getInstance().writeInitialFlag(en_Initialized))				// write initialized status to CSM once the service is up
		{
			ETG_TRACE_FATAL(("PIVI_VCANClient InitialFlag csm write failed"));
		}
	}
	if((Piviconfig::getInst().getDigitalAssistant() == DIGITAL_ASSISTANT_ON) && Piviconfig::getInst().getLoginKeylinkStatus())
	{
		updatePropertiesOnstartup();															// Update startup user properties to HMI

		// Read VCAN login_User_Change_Permit_Flag
		bool loginUserChangePermitFlag = false;
		if(!profilePIVI_VCANClient::getInstance().readLoginUserChangePermitFlag(loginUserChangePermitFlag))
		{
			ETG_TRACE_ERR(("Profile servicePIVI - Login User change Permit Flag read error"));
		}
	}
	else
	{
		ETG_TRACE_FATAL(("DigitalAssistant -> OFF, skipping startup user property update"));
	}

}

ServicePIVI::~ServicePIVI()
{
}

/*
void ServicePIVI::setCurrentLoginUser(unsigned char userId)
{
	const dp_tclSrvIf dpSrvIf;
	if(dpSrvIf.s32Lock(DP_U32_LOCK_MODE_END_USER)== DP_S32_NO_ERR)				// lock datapool before change
	{
		//update active profile id as guest
		if(dpSrvIf.s32SetEndUser(userId)!= DP_S32_NO_ERR)
			{ETG_TRACE_FATAL(("Datapool SetUser Failed"));}
		if(dpSrvIf.s32Unlock()!= DP_S32_NO_ERR)									// unlock datapool after change
			{ETG_TRACE_FATAL(("Datapool unlock Failed"));}
	}
	else
	{
		int tmp DP_DATAPOOL_ID;
		ETG_TRACE_FATAL(("Datapool Lock Failed:%x",tmp));
	}
}
*/

void ServicePIVI::onMapKeyToCurrentProfileRequest(	const ::boost::shared_ptr<MapKeyToCurrentProfileRequest>& request)
{
}


void ServicePIVI::onSetWelcomeGuidanceActiveRequest (const ::boost::shared_ptr< SetWelcomeGuidanceActiveRequest >& request)
{//
	ETG_TRACE_USR4(("ProfilePIVI setWelcomeGuidanceActive update request user:%d value: %d",request->getUserID(),request->getWgActive()));
	bool result = profileDataPIVI::getInst().setWelcomeguidance(request->getUserID(),request->getWgActive());
	serverResult srvrRslt = (result == true ? serverResult__SUCCESS : serverResult__FAILED);
	sendSetWelcomeGuidanceActiveResponse(srvrRslt);
	if(serverResult__SUCCESS == srvrRslt)
	{
		sendWelcomeGuidanceActive(request->getWgActive());//send property update on SUCCESS
	}
}

void ServicePIVI::onSetLoginKeyLinkSettingRequest (const ::boost::shared_ptr< SetLoginKeyLinkSettingRequest >& request)
{
	ETG_TRACE_USR4(("ProfilePIVI LoginKeyLinkSettingRequest toggle request"));
	//bool requestedSetting = request->getLoginKeyLinkSetting();
	if(!profilePIVI_VCANClient::getInstance().writeLoginKeyLinkSetting())
	{
		ETG_TRACE_ERR(("Profile servicePIVI - LoginKeyLinkSetting update failed"));
		sendSetLoginKeyLinkSettingResponse(serverResult__FAILED);
		return;
	}
	sendSetLoginKeyLinkSettingResponse(serverResult__SUCCESS);
	//sendLoginKeyLinkStatus(requestedSetting);//NB: once the setting request is sent to IDM and the property is set in IDM,
											//sync is implemented between keylink status and PIVI HMI
											//sync is not requierd between keylink Setting and PIVI HMI
}

void ServicePIVI::sendWelcomeGuidanceActive(bool WgActive)
{

	unsigned char keyID = KEY_NOT_USED;
	if(profilePIVI_VCANClient::getInstance().readUserIdSignal(keyID))
	{
		if(keyID > NO_KEYLESS_OPERATION && keyID <= MAX_KEYS)
		{
			setWelcomeGuidanceActive(WgActive);
			ETG_TRACE_USR4(("ProfilePIVI profileService setWelcomeGuidanceActive updates value %d",WgActive));
		}
		else
		{
			ETG_TRACE_USR4(("key value %d is not Valid",keyID));
		}
	}
	else
	{
		ETG_TRACE_USR4(("keyID read error"));
	}

}

void ServicePIVI::sendkeyID(uint32 keyID)
{
    setKeyID(keyID);
    ETG_TRACE_USR4(("ProfilePIVI profileService setKeyID property update: %d",keyID));
}

void ServicePIVI::sendLoginKeyLinkStatus(bool loginKeyLinkStatus)
{

	setLoginKeyLinkStatus(loginKeyLinkStatus);
	ETG_TRACE_USR4(("ProfilePIVI profileService setLoginKeyLinkStatus updated"));

}

void ServicePIVI::sendStartupUpdate(bool status)
{
	ETG_TRACE_USR4(("ProfilePIVI profileService sendStartupUpdate"));
	setIsStartupSequence(status);
}

void ServicePIVI::sendProfilekeyIndex(uint8 keyIndex)
{
	setProfilekeyIIndex(keyIndex);
}

void ServicePIVI::sendKeyIsMapped(bool keyIsMappedStatus)
{
	ETG_TRACE_USR4(("ProfilePIVI PIVIservice setKeyIsMapped property update: %d",keyIsMappedStatus));
	setKeyIsMapped(keyIsMappedStatus);
}

void ServicePIVI::sendKeyMappingPossible(bool keyMappingPossibleStatus)
{
	ETG_TRACE_USR4(("ProfilePIVI PIVIservice setKeyMappingPossible property update: %d",keyMappingPossibleStatus));
	setKeyMappingPossible(keyMappingPossibleStatus);
}


void ServicePIVI::updatePropertiesOnstartup()
{
	unsigned char keyID = 0;
	bool loginKeyLinkStatus = false;
	bool welcomeGuidance = true;

	// Read VCAN login_key_link_status
	if(!profilePIVI_VCANClient::getInstance().readLoginKeyLinkStatus(loginKeyLinkStatus))
	{
		ETG_TRACE_ERR(("Profile servicePIVI - Login key link status read error"));
		return;
	}
	else
	{
		sendLoginKeyLinkStatus(loginKeyLinkStatus);			// update LoginKeyLinkStatus to updated clients
		if(loginKeyLinkStatus)
		{
			// Read VCAN key_id signal
			if(profilePIVI_VCANClient::getInstance().readUserIdSignal(keyID))
			{
				sendkeyID(keyID);								// send key_ID property update to HMI
				// Check if valid key received
				if((keyID >= KEY1) && (keyID <= KEY4))
				{
					bool isKeyMapped = profileDataPIVI::getInst().iskeymapped(keyID);
					unsigned char userID = profileDataPIVI::getInst().getUserIDMapped(keyID);
					welcomeGuidance = profileDataPIVI::getInst().getWelcomeGuidance(userID);
					//send property updates to HMI via service
					sendKeyIsMapped(isKeyMapped);

					if(!isKeyMapped)			//Check if key mapped to any user and Key link status
					{
						bool KeyMappingPossible = profileDataPIVI::getInst().isKeyMappingPossible(keyID);
						sendKeyMappingPossible(KeyMappingPossible);
					}
				}
				else
				{
					ETG_TRACE_USR4(("Invalid key value received, load GUEST profile"));
				}
			}
			else
			{
				ETG_TRACE_ERR(("Profile servicePIVI - keyid read error"));
			}
		}
		else
		{
			ETG_TRACE_USR4(("loginKeyLinkStatus->OFF"));
		}
	}

	sendWelcomeGuidanceActive(welcomeGuidance);

}


void ServicePIVI::onGetKeylistRequest (const ::boost::shared_ptr< GetKeylistRequest >& request)
{
	uint8 userID = request->getUserID();
	if(userID < MAX_PROFILE_PIVI)
	{
		std::vector<uint8> keys = profileDataPIVI::getInst().getProfileKeys(userID);
		sendGetKeylistResponse(keys,request->getAct());
	}

}

} }

