/* profilePIVIDefines.h
*   Component: Profile - PIVI
*   Project Specific defines
*   Author: akm7cob
*/

#ifndef PROFILEPIVI_DEFINES_H
#define PROFILEPIVI_DEFINES_H

#define NO_KEYLESS_OPERATION			0
#define INDEX_ZEROTH_PROFILE			0		// Index for (dummy) profile
#define INDEX_GUEST_PROFILE				1		// Index for guest profile
#define PIVI_DEFAULT_PROFILE			INDEX_GUEST_PROFILE
#define DIGITAL_ASSISTANT_ON			0x01	// Digital assistant ON
#define DIGITAL_ASSISTANT_OFF			0x00	// Digital assistant OFF

#define KEY_NOT_USED					5		// 5 will be default for keys. considered as no key registered.
#define KEY1							1		// Key1 value
#define KEY4							4		// Key4 value

#define INVALID_USER					255
#define NOT_COPY_USER					5

#define MAX_PROFILE_PIVI				5		// Maximum user profile allowed in PIVI
#define MAX_NORMAL_PROFILE_PIVI			3 //3 normal profiles apart from Zeroth & Guest
#define MAX_KEYS						4

#define MSEC(SEC)						(SEC*1000)
#define COPY_PF_DRIVE_WAIT_TIME_SECS	2				// 2 seconds copy drive setting wait time
#define COPY_PF_ITS_WAIT_TIME_SECS		3				// 3 seconds copy ITS setting wait time

#define VCAN_GUEST_USERID				4
#define PROFILE_PIVI_DP_LENGTH			45


#endif
