/*
 * tunerSync.cpp
 *
 *  Created on: 28.02.2017
 *      Author: bn81lr
 */

#include <online/tunerSync.h>
#include <string.h>
#include <stdlib.h>

namespace profileMngr {
using namespace std;

tunerSync::tunerSync():syncObject("Radio","AMPresetNumber"),m_LoadingIndex(0)
{

}

tunerSync::~tunerSync()
{

}

bool tunerSync::bMatch(const unsigned char* token, size_t length)
{
	if (length < m_AppNameLen+m_NameLen+1)
		return false;
	if (memcmp(token,m_AppName,m_AppNameLen) !=0 )
		return false;
	if (memcmp(token+m_AppNameLen+1,m_Name,m_NameLen) != 0)
		return false;
	int index=atoi((const char*)token+m_AppNameLen+1);
	if (index ==0)
		return false;
	else
		{
			m_LoadingIndex=index;
			if (m_amPresets.size() < m_LoadingIndex)
				m_amPresets.resize(m_LoadingIndex);
		}
	return true;
}

bool tunerSync::onDouble(const unsigned char* Name, size_t nameSize,double value)
{
return true;
}

bool tunerSync::onInt(const unsigned char* Name, size_t nameSize,	long long int value)
{
	if (nameSize == 3 && memcmp(Name,"val",3)== 0)
	{
		m_amPresets[m_LoadingIndex].Frequency=value;
	}
	return true;
}

bool tunerSync::onString(const unsigned char* Name, size_t nameSize,	const unsigned char* value, size_t size)
{
	if (nameSize == 2 && memcmp(Name,"ts",2)== 0)
	{
		m_amPresets[m_LoadingIndex].TimeStamp=string((const char*)value,size);
	}

	return true;
}

bool tunerSync::onBoolean(const unsigned char* Name, size_t nameSize,int value)
{return true;
}

size_t tunerSync::onStore(char* pData, size_t max)
{return true;
}

bool tunerSync::sendName(int index, const char * Name,size_t nameLen,yajl_gen doc)
{
	char buff[50];
	size_t pos=0;
	memcpy(buff,g_RootName,g_RootNameLen);	pos=g_RootNameLen;
	buff[pos++]='/';
	memcpy(buff+pos,m_AppName,m_AppNameLen);pos+=m_AppNameLen;
	buff[pos++]='/';
	memcpy(buff+pos,Name,nameLen);pos+=nameLen;
	if (index > 10)
		buff[pos++]=(char)((index/10)+'0');

	buff[pos++]=(char)((index%10)+'0');
	return yajl_gen_string(doc,(unsigned char*)buff,pos) == yajl_gen_status_ok;
}

bool tunerSync::sendAm(int index,yajl_gen doc)
{

	yajl_gen_map_open(doc);
	sendName(index,m_Name,m_NameLen,doc);
	yajl_gen_map_open(doc);
	yajl_gen_string(doc,(unsigned char*)"val",3);
	yajl_gen_integer(doc,m_amPresets[index].Frequency);
	yajl_gen_string(doc,(unsigned char*)"ts",2);
	yajl_gen_string(doc,(unsigned char*)m_amPresets[index].TimeStamp.c_str(),m_amPresets[index].TimeStamp.length());
	yajl_gen_map_close(doc);

	return true;
}

bool tunerSync::onSend(yajl_gen doc)
{
	int amPos=1;
	for (vector<amPreset>::iterator it=m_amPresets.begin();it != m_amPresets.end();++it,amPos++)
		sendAm(amPos,doc);
	return true;
}

} /* namespace profileMngr */
