
#ifndef SYNC_OBJECT_H
#define SYNC_OBJECT_H

#include "string"
#include "yajl/yajl_gen.h"

namespace profileMngr{

class syncObject
{
public:
	syncObject(const char * App,const char * Name);
	virtual ~syncObject();
	virtual bool bMatch(const unsigned char * token, size_t length);


	virtual bool onDouble(const unsigned char * Name, size_t nameSize, double value){return false;};
	virtual bool onInt(const unsigned char * Name, size_t nameSize, long long int  value){return false;};
	virtual bool onString(const unsigned char * Name, size_t nameSize, const unsigned char* value,size_t size){return false;};
	virtual bool onBoolean(const unsigned char * Name, size_t nameSize, int value){return false;};

	// callback used, to store the last timestamp (s) onto the profile manager datapool maybe, the values itselv are also stored
	virtual size_t onStore(char * pData,size_t max){return 0;};
	virtual bool onSend(yajl_gen doc){return false;};
protected:
	const char * m_AppName;
	const char * m_Name;
	const char * m_ShortName;
	size_t m_AppNameLen;
	size_t m_NameLen;
};

extern const unsigned char *g_RootName;
extern size_t g_RootNameLen;
}

#endif
