/*****************************************************************************
* FILE:         UsbTcuSvcAdapter.cpp
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#ifndef _USBTCUSVCADAPTER_H_
#define _USBTCUSVCADAPTER_H_

#include <boost/shared_ptr.hpp>
#include <string>
#include <vector>

#include "asf/core/Logger.h"

#include "ServiceAdapter.h"
#include "tcu_usb_main_fiProxy.h"

namespace tcu_usb_main_fi { class ValidateUserCredentialsCallbackIF; }
namespace profileMngr
{

class ServiceProvider;

class UsbTcuSvcAdapter : public ServiceAdapter< ::tcu_usb_main_fi::Tcu_usb_main_fiProxy>
{
public:
   UsbTcuSvcAdapter();
   void sendValidateUserCredentialsStart(::tcu_usb_main_fi::ValidateUserCredentialsCallbackIF& cb,const ::std::string& acntName, const ::std::string& pwd);
   void sendDecodeIdTokenStart(::tcu_usb_main_fi::DecodeIdTokenCallbackIF& cb, const ::std::string& token);
private:
   // disable functions:
   UsbTcuSvcAdapter(const UsbTcuSvcAdapter&);
   UsbTcuSvcAdapter& operator=(const UsbTcuSvcAdapter&);



   DECLARE_CLASS_LOGGER();
};

} // namespace profileMngr


#endif  // _USBTCUSVCADAPTER_H_
