/*****************************************************************************
* FILE:         IServiceAvailable.h
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:  core logic for Online Profile Manager
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#ifndef _SERVICEPROVIDERTYPES_H_
#define _SERVICEPROVIDERTYPES_H_

#include <stdexcept>
#include <string>

namespace profileMngr
{

//definition of the adapter types - to be extended for each new adapter
enum AdapterType
{
   CONFIGURATIONMGMT_SVC,
   PROFILE_SVC,
   DUMM_SVC,
   USBTCU_SVC,
   UNKNOWN
};


class ServiceUnavailableException : public std::runtime_error
{
public:
   explicit ServiceUnavailableException(const ::std::string& message)
      : std::runtime_error(message)
   {}
};


}

#endif  // _SERVICEPROVIDERTYPES_H_
