/*****************************************************************************
* FILE:         ProfileSvcAdapter.cpp
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#include <string>
#include <vector>

#include "ProfileSvcAdapter.h"
#include "bosch/cm/profileProxy.h"

namespace profileMngr {
ProfileSvcAdapter::ProfileSvcAdapter()
                  : m_maxPINAttempts(0)
                  , m_maxPINAttemptsBeforeDelay(0)
                  , m_activeProfile(0)
                  , m_pinAuthenticationDelayTime(0)
                  , m_pinVerificationValidityTime(0)
                  , m_privacyMode(0)
{
}

void ProfileSvcAdapter::registerForProperties()
{
	//Register for Attributes:
	getProxy()->sendMaxPINAttemptsRegister(*this);
	getProxy()->sendMaxPINAttemptsGet(*this);
	getProxy()->sendMaxPINAttemptsBeforeDelayRegister(*this);
	getProxy()->sendMaxPINAttemptsBeforeDelayGet(*this);
	getProxy()->sendPinAuthenticationDelayTimeRegister(*this);
	getProxy()->sendPinAuthenticationDelayTimeGet(*this);
	getProxy()->sendPinVerificationValidityTimeRegister(*this);
	getProxy()->sendPinVerificationValidityTimeGet(*this);
	getProxy()->sendActiveProfileRegister(*this);
	getProxy()->sendActiveProfileGet(*this);
	getProxy()->sendPrivacyModeRegister(*this);
	getProxy()->sendPrivacyModeGet(*this);
}

void ProfileSvcAdapter::deRegisterForProperties()
{
	getProxy()->sendMaxPINAttemptsDeregisterAll();
	getProxy()->sendMaxPINAttemptsBeforeDelayDeregisterAll();
	getProxy()->sendPinAuthenticationDelayTimeDeregisterAll();
	getProxy()->sendPinVerificationValidityTimeDeregisterAll();
	getProxy()->sendActiveProfileDeregisterAll();
	getProxy()->sendPrivacyModeDeregisterAll();
}

void ProfileSvcAdapter::onMaxPINAttemptsBeforeDelayError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< MaxPINAttemptsBeforeDelayError >& error)
{
}

void ProfileSvcAdapter::onMaxPINAttemptsBeforeDelayUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< MaxPINAttemptsBeforeDelayUpdate >& update)
{
	if (getProxy() == proxy)
	   m_maxPINAttemptsBeforeDelay = update->getMaxPINAttemptsBeforeDelay();
}

void ProfileSvcAdapter::onMaxPINAttemptsError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< MaxPINAttemptsError >& error)
{

}
void ProfileSvcAdapter::onMaxPINAttemptsUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< MaxPINAttemptsUpdate >& update)
{
	if (getProxy() == proxy)
	   m_maxPINAttempts = update->getMaxPINAttempts();
}

void ProfileSvcAdapter::onPinAuthenticationDelayTimeError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< PinAuthenticationDelayTimeError >& error)
{

}
void ProfileSvcAdapter::onPinAuthenticationDelayTimeUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< PinAuthenticationDelayTimeUpdate >& update)
{
	if (getProxy() == proxy)
	   m_pinAuthenticationDelayTime = update->getPinAuthenticationDelayTime();
}

void ProfileSvcAdapter::onPinVerificationValidityTimeError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< PinVerificationValidityTimeError >& error)
{

}
void ProfileSvcAdapter::onPinVerificationValidityTimeUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< PinVerificationValidityTimeUpdate >& update)
{
	if (getProxy() == proxy)
	   m_pinVerificationValidityTime = update->getPinVerificationValidityTime();
}

void ProfileSvcAdapter::onActiveProfileError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< ActiveProfileError >& error)
{

}
void ProfileSvcAdapter::onActiveProfileUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< ActiveProfileUpdate >& update)
{
	if (getProxy() == proxy)
		m_activeProfile = update->getActiveProfile();
}

void ProfileSvcAdapter::onPrivacyModeError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< PrivacyModeError >& error)
{

}

void ProfileSvcAdapter::onPrivacyModeUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< PrivacyModeUpdate >& update)
{
	if (getProxy() == proxy)
		m_privacyMode = update->getPrivacyMode();
}

void ProfileSvcAdapter::onLinkProfileError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< LinkProfileError >& error)
{
}
void ProfileSvcAdapter::onLinkProfileResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< LinkProfileResponse >& response)
{
}


void ProfileSvcAdapter::setPINAuthenticationDelay(uint32_t delay)
{
	getProxy()->sendPinAuthenticationDelayTimeSet(delay);
}
void ProfileSvcAdapter::setAuthenticationValidTime(uint32_t validTime)
{
	getProxy()->sendPinVerificationValidityTimeSet(validTime);
}
void ProfileSvcAdapter::setMaxPINAttemptsTotal(uint8_t value)
{
	getProxy()->sendMaxPINAttemptsSet(value);
}
void ProfileSvcAdapter::setMaxPINAttemptsBeforeDelay(uint8_t value)
{
	getProxy()->sendMaxPINAttemptsBeforeDelaySet(value);
}

void ProfileSvcAdapter::setLinkProfileStatus(bool isLinked)
{
	getProxy()->sendLinkProfileRequest(*this,isLinked);
}

void ProfileSvcAdapter::sendGetProfileTypeRequest(bosch::cm::profile::GetProfileTypesCallbackIF& cb)
{
    getProxy()->sendGetProfileTypesRequest(cb);
}

}
