/*****************************************************************************
* FILE:         IServiceAvailable.h
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:  core logic for Online Profile Manager
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#ifndef _ISERVICEPROVIDER_H_
#define _ISERVICEPROVIDER_H_

#include <boost/shared_ptr.hpp>
#include <string>


namespace profileMngr
{

class ConfigMgmtSvcAdapter;
class ProfileSvcAdapter;
class DummSvcAdapter;
class UsbTcuSvcAdapter;

class IServiceProvider
{
public:
   virtual ~IServiceProvider() {}

   /**
    * @brief Releases all proxies in use, marks all adapters as invalid.
    */
   virtual void clear() = 0;

   /**
    * @brief Checks if all required services are up. If so the onAvailable() method is called of the IServiceAvailable interface
    * if it isn't already called.
    * This method is internally used and should be used by user on construction time to force an available check.
    */
   virtual void allServicesAvailable() = 0;

   /** @return true in case onAvailable is already called otherwise false is returned.
    */
   virtual bool areAllServicesAvailable() const  = 0;

   /**
    * @brief Return a shared pointer storing a dynamically allocated adapter object or a NULL object if the adapter was not available.
    */
   virtual ::boost::shared_ptr<ConfigMgmtSvcAdapter> getConfigMgmtSvcAdapter() = 0;
   virtual ::boost::shared_ptr<ProfileSvcAdapter> getProfileSvcAdapter() = 0;
   virtual ::boost::shared_ptr<DummSvcAdapter> getDummSvcAdapter() = 0;
   virtual ::boost::shared_ptr<UsbTcuSvcAdapter> getUsbTcuSvcAdapter() = 0;

protected:
   IServiceProvider() {}
};

} /* namespace profileMngr */

#endif  // _ISERVICEPROVIDER_H_
