/*****************************************************************************
* FILE:         DummSvcAdapter.cpp
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#include <string>
#include <vector>

#include "DummSvcAdapter.h"
#include "com/bosch/cm/dumm/DummServiceProxy.h"

namespace profileMngr {
DummSvcAdapter::DummSvcAdapter()
{
}

void DummSvcAdapter::sendUploadDataRequest(UploadDataCallbackIF& cb, const ::std::string& jsonUploadHeader, const ::std::string& jsonUploadData)
{
	getProxy()->sendUploadDataRequest(cb, jsonUploadHeader, jsonUploadData);
}

void DummSvcAdapter::sendGenCorrelationIdRequest(GenCorrelationIdCallbackIF& cb)
{
	getProxy()->sendGenCorrelationIdRequest(cb);
}

act_t DummSvcAdapter::sendProfileLocalLinkAckRegister(ProfileLocalLinkAckCallbackIF& cb)
{
	return (getProxy()->sendProfileLocalLinkAckRegister(cb));
}

bool DummSvcAdapter::sendProfileLocalLinkAckDeregister(act_t act)
{
	return (getProxy()->sendProfileLocalLinkAckDeregister(act));
}

act_t DummSvcAdapter::sendProfileLocalUnLinkAckRegister(ProfileLocalUnLinkAckCallbackIF& cb)
{
	return (getProxy()->sendProfileLocalUnLinkAckRegister(cb));
}

bool DummSvcAdapter::sendProfileLocalUnLinkAckDeregister(act_t act)
{
	return (getProxy()->sendProfileLocalUnLinkAckDeregister(act));
}

}
