/*****************************************************************************
* FILE:         ConfigMgmtSvcAdapter.cpp
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#include <string>
#include <vector>

#include "ConfigMgmtSvcAdapter.h"
#include "de/bosch/cm/ConfigManager/ConfigManagementProxy.h"
#include "online/jsonUtils.h"

#define DBUSNAME "app.core.ProfileMngrOnline"

namespace profileMngr {

static const char* PrivateConfigItems[] =
{ jsonUtils::UAM_PINAUTHENTICATIONDELAY,
  jsonUtils::UAM_AUTHENTICATIONVALIDTIME,
  jsonUtils::UAM_MAXPINATTEMPTSTOTAL,
  jsonUtils::UAM_MAXPINATTEMPTSBEFOREDELAY,
  jsonUtils::UPM_MAXSECUREDPROFILES,
  jsonUtils::UPM_LOCALLINKORDERTIMEOUT,
  jsonUtils::RVS_REMOTE_VEHICLE_SETTINGS_ACTIVATION
};

static const char* PublicConfigItems[] =
{ jsonUtils::CSA_CONNECTIVITY_AND_ACTIVATION_STATUS
};

ConfigMgmtSvcAdapter::ConfigMgmtSvcAdapter()
{
}

void ConfigMgmtSvcAdapter::sendRegisterReqForUAM()
{
	//Register for the Private CfgItems Under UAM
	std::string ItemName;
	std::string DbusName(DBUSNAME);
	int mapSize = sizeof PrivateConfigItems / sizeof(char*);
	for(int i = 0;i < mapSize; i++)
	{
		ItemName = PrivateConfigItems[i];
		sendRegisterPrivateItemReq(ItemName, DbusName, EnItemFormats__Default);
	}

	//Register for the Public CfgItems
	mapSize = sizeof PublicConfigItems / sizeof(char*);
	for(int i = 0;i < mapSize; i++)
	{
		ItemName = PublicConfigItems[i];
		sendRegisterPublicItemReq(ItemName, DbusName, EnItemFormats__Default);
	}
}

void ConfigMgmtSvcAdapter::sendRegisterPrivateItemReq(std::string& privateItemName, std::string& clientDBusName, EnItemFormats dataFormat)
{
	getProxy()->sendRegisterPrivateItemRequest(* this, privateItemName, clientDBusName, dataFormat);
}

void ConfigMgmtSvcAdapter::sendUnregisterPrivateItemReq(std::string& privateItemName, std::string& clientDBusName)
{
	getProxy()->sendUnregisterPrivateItemRequest(* this, privateItemName, clientDBusName);
}

void ConfigMgmtSvcAdapter::sendRegisterPublicItemReq(std::string& publicItemName, std::string& clientDBusName, EnItemFormats dataFormat)
{
	getProxy()->sendRegisterPublicItemRequest(* this, publicItemName, clientDBusName, dataFormat);
}

void ConfigMgmtSvcAdapter::sendUnregisterPublicItemReq(std::string& publicItemName, std::string& clientDBusName)
{
	getProxy()->sendUnregisterPublicItemRequest(* this, publicItemName, clientDBusName);
}

void ConfigMgmtSvcAdapter::onRegisterPrivateItemError(const::boost::shared_ptr <ConfigManagementProxy>  & proxy, const boost::shared_ptr <RegisterPrivateItemError>& error)
{
   (void)proxy;
   (void)error;
}
void ConfigMgmtSvcAdapter::onRegisterPrivateItemResponse(const::boost::shared_ptr <ConfigManagementProxy> & proxy, const boost::shared_ptr <RegisterPrivateItemResponse>& response)
{
   (void)proxy;
   (void)response;
}

void ConfigMgmtSvcAdapter::onRegisterPublicItemError(const::boost::shared_ptr <ConfigManagementProxy>  & proxy, const boost::shared_ptr <RegisterPublicItemError>& error)
{
   (void)proxy;
   (void)error;
}
void ConfigMgmtSvcAdapter::onRegisterPublicItemResponse(const::boost::shared_ptr <ConfigManagementProxy> & proxy, const boost::shared_ptr <RegisterPublicItemResponse>& response)
{
   (void)proxy;
   (void)response;
}

void ConfigMgmtSvcAdapter::onUnregisterPrivateItemError(const::boost::shared_ptr <ConfigManagementProxy>  & proxy, const boost::shared_ptr <UnregisterPrivateItemError>& error)
{
   (void)proxy;
   (void)error;
}
void ConfigMgmtSvcAdapter::onUnregisterPrivateItemResponse(const::boost::shared_ptr <ConfigManagementProxy> & proxy, const boost::shared_ptr <UnregisterPrivateItemResponse>& response)
{
   (void)proxy;
   (void)response;
}

void ConfigMgmtSvcAdapter::onUnregisterPublicItemError(const::boost::shared_ptr <ConfigManagementProxy>  & proxy, const boost::shared_ptr <UnregisterPublicItemError>& error)
{
   (void)proxy;
   (void)error;
}
void ConfigMgmtSvcAdapter::onUnregisterPublicItemResponse(const::boost::shared_ptr <ConfigManagementProxy> & proxy, const boost::shared_ptr <UnregisterPublicItemResponse>& response)
{
   (void)proxy;
   (void)response;
}

}
