/*****************************************************************************
* FILE:         AdapterBase.cpp
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/


#ifndef _ADAPTERBASE_H_
#define _ADAPTERBASE_H_

#include "ServiceProviderTypes.h"

namespace profileMngr
{
class ServiceProvider;

class AdapterBase
{
public:
   AdapterBase();
   virtual ~AdapterBase();

   bool isValid() const;
   virtual void clearProxy() = 0;
   bool isPaused() const;

protected:
   virtual bool isProxyValid() const = 0;
   virtual bool isProxyPaused() const = 0;

private:
};

} /* namespace profileMngr */

#endif  // _ADAPTERBASE_H_
