/******************************************************************************
 *	FILE:        : ProfileLocalLinkAckProperty.cpp
 *	PROJECT:     : A-IVI project
 *  SW-COMPONENT : ProfileManager
 *----------------------------------------------------------------------------
 *
 * DESCRIPTION:
 *
 *----------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
 *****************************************************************************/

#include <stdlib.h>
#include "ProfileLocalLinkAckProperty.h"

using namespace com::bosch::cm::dumm::DummService;
namespace profileMngr
{

ProfileLocalLinkAckProperty::ProfileLocalLinkAckProperty(
		boost::shared_ptr< DummSvcAdapter > dummSvcAdapter,
		uint32_t timerVal,
		IProfileLocalLinkAckData& notifyCb)
        : m_dummSvcAdapter(dummSvcAdapter)
        , m_timerValue(timerVal)
        , m_notifyCb(notifyCb)
        , m_serverAct(0)
{

}

ProfileLocalLinkAckProperty::~ProfileLocalLinkAckProperty()
{
	/*lint -save -e1506*/
	// it's ok to calls doDeregister here though it's virtual
	doDeregister();
	/*lint -restore */
}

void ProfileLocalLinkAckProperty::doRegister()
{
	if ( m_dummSvcAdapter->isValid() )
	{
		m_serverAct = m_dummSvcAdapter->sendProfileLocalLinkAckRegister(*this);
		m_isActive = true;
		//TODO: Check the possibility of starting a Timer here for LOCAL_LINK_ORDER_TIMEOUT
	}
	else
	{
		m_notifyCb.onProfileLocalLinkAckDataRegError(1);//TODO: Check for Error codes
	}
}

void ProfileLocalLinkAckProperty::startTimer()
{
	m_ackTimeoutTimer.start(*this,m_timerValue,Timer::Once);
}

void ProfileLocalLinkAckProperty::doDeregister()
{
   if ( m_dummSvcAdapter->isValid() )
   {
      if(m_isActive)
      {
         //LOG_INFO("UserTrafficImpactDataProperty::doDeregister()");
         m_dummSvcAdapter->sendProfileLocalLinkAckDeregister(m_serverAct);
      }
   }
   else
   {
      //LOG_WARN("m_dummSvcAdapter is not valid anymore");
   }
   if(m_ackTimeoutTimer.isActive())
   	    m_ackTimeoutTimer.stop();
   m_isActive = false;
   m_hasCurrentValue = false;
   m_serverAct = 0;
   m_dummSvcAdapter.reset();
}

void ProfileLocalLinkAckProperty::onProfileLocalLinkAckError(
		const ::boost::shared_ptr< DummServiceProxy >& proxy,
		const ::boost::shared_ptr< ProfileLocalLinkAckError >& error)
{
	if(m_ackTimeoutTimer.isActive())
	    m_ackTimeoutTimer.stop();
	m_notifyCb.onProfileLocalLinkAckDataRegError(1);
}

void ProfileLocalLinkAckProperty::onProfileLocalLinkAckSignal(
		const ::boost::shared_ptr< DummServiceProxy >& proxy,
		const ::boost::shared_ptr< ProfileLocalLinkAckSignal >& signal)
{
	if(m_ackTimeoutTimer.isActive())
	    m_ackTimeoutTimer.stop();
	m_notifyCb.onProfileLocalLinkAckDataUpdate(signal->getJsonDownloadHeader(),signal->getJsonDownloadData());
}

void ProfileLocalLinkAckProperty::onExpired(Timer& timer, ::boost::shared_ptr< TimerPayload > data)
{
	if(TimerPayload_Reason__Completed == data->getReason())
		m_notifyCb.onProfileLocalLinkAckDataTimeout();
}

} // profileMngr

