/*
 * onlineData.cpp
 *
 *  Created on: 21.01.2018
 *      Author: csb1kor
 */

#include "onlineData.h"

#include <fcntl.h>
#include <unistd.h>
#include <sys/stat.h>
#include <dlt/dlt.h>

DLT_IMPORT_CONTEXT(PROFILEDATA_COMPONENT);

#include <string.h> //memcpy
#include "SDCHandler.h"

#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_user_remote_sync_ctrl_if.h"
#endif

namespace profileMngr {

const unsigned char magicSeqNumber[] = {0x4C, 0x49, 0x46};

//*************************** onlineData()  *********************************

onlineData::onlineData():
		m_maxSecuredProfiles(5),
		m_localLinkOrderTimout(0),
		m_maxNumOfProfiles(0),
		m_isInit(false),
		m_remoteVehicleSettingsActivation(false),
        m_connectionStatus(false)
{
	m_Info.variantID = 0;
	m_Info.versionID = 0;

}

//*************************** init()  *********************************
bool onlineData::Init(uint8_t maxNumOfProfiles,VariantInfo& info)
{
	if(m_isInit)
	{
		DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_ERROR,DLT_STRING("onlineData::Init() is called twice"));
		return false;
	}
	m_isInit = true;
	m_maxNumOfProfiles = maxNumOfProfiles;
	m_accountNames.resize(m_maxNumOfProfiles);
	m_kIDs.resize(m_maxNumOfProfiles);
	//m_Info = info;
	m_Info.variantID = info.variantID;
	m_Info.versionID = info.versionID;

	//Read the MaxSecuredProfiles from Datapool
	uint8_t maxProfiles = 0;
	dp_tclprofileDatamaxSecuredProfiles dpmaxSuredProfiles;
	int32_t ret = dpmaxSuredProfiles.s32GetData(maxProfiles);
	DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_INFO,DLT_STRING("onlineData::Init()"),DLT_INT(ret),DLT_STRING("No Of Profiles"),DLT_INT(maxNumOfProfiles));
	if(ret == 0)
		m_maxSecuredProfiles = maxProfiles;
	else
		doDefSet();

	load();
	return true;
}


//*************************** ~onlineData()  ***********************************

onlineData::~onlineData()
{
}

//*************************** load()  ********************************************
bool onlineData::load()
{
    bool bFailed=false;

    uint32_t iTimeout = 0;
	dp_tclprofileDatalocalLinkOrderTimeout dplocalLinkOrderTimeout;
	int32_t load = dplocalLinkOrderTimeout.s32GetData(iTimeout);
	DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_INFO,DLT_STRING("LocalLinkOrderTimeout:"),DLT_INT(iTimeout),DLT_STRING("DP Read Status:"),DLT_INT(load));
	m_localLinkOrderTimout = iTimeout;

	dp_tclprofileDataremoteVehicleSettingsActivation dpremoteVehSetActivation;
	load = dpremoteVehSetActivation.s32GetData(m_remoteVehicleSettingsActivation);
	DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_INFO,DLT_STRING("RemoteVehicleSettingActivation:"),DLT_INT(m_remoteVehicleSettingsActivation),DLT_STRING("DP Read Status:"),DLT_INT(load));

	bFailed = loadProfileData();

	return !bFailed;
}
//*************************** store  **************************************************************

bool onlineData::store()
{
	dp_tclprofileDatamaxSecuredProfiles dpmaxSuredProfiles;
	int32_t ret = dpmaxSuredProfiles.s32SetData(m_maxSecuredProfiles);

	dp_tclprofileDatalocalLinkOrderTimeout dplocalLinkOrderTimeout;
	ret = dplocalLinkOrderTimeout.s32SetData(m_localLinkOrderTimout);

	dp_tclprofileDataremoteVehicleSettingsActivation dpremoteVehSetActivation;
	ret = dpremoteVehSetActivation.s32SetData(m_remoteVehicleSettingsActivation);

	storeAccountNameInfo();
	return true;
}


bool onlineData::loadProfileData()
{
	StorageInfo info;
	dp_tclprofileDataaccountNames profileValues;
	profileValues.s32GetData(reinterpret_cast<unsigned char*>(&info),sizeof(StorageInfo));
	if (info.ID!=diInfo)
		return false;

	if(  (info.Key1 != magicSeqNumber[0] || info.Key2 != magicSeqNumber[1] || info.Key3 == magicSeqNumber[2] ) ||
			(info.MayorBersion != m_Info.variantID || info.MinorVersdon != m_Info.versionID) )
		return false;

	unsigned char * pBuff=new unsigned char[info.Size];
	profileValues.s32GetData(pBuff,info.Size);

	DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_INFO,DLT_STRING("loadAccountName: Length of Data:"),DLT_INT(info.Size));

	encryptData *pEnc=reinterpret_cast<encryptData*>( pBuff+sizeof(StorageInfo));
	pEnc->pData=pBuff+sizeof(StorageInfo)+5;

	bool bRet=loadNameAndKid(*pEnc);
	delete [] pBuff;
	return bRet;
}

bool onlineData::loadNameAndKid(encryptData & header)
{

		unsigned char * decrypted_data=0;
		size_t decrypted_data_len=0;

		if(header.Size != 0)
		{
			//Decrypt the Data
			SDCHandler cdsobj;
			cdsobj.bGenerateStorageKey(12006,32);
			cdsobj.bDecryptData(12006,&decrypted_data,&decrypted_data_len,header.pData,header.Size);
		}
		else
		{
			decrypted_data=header.pData;
		}
		bool bFailed=false;
		uint8_t idx=0;

		for (unsigned char* pIn=decrypted_data;pIn  < decrypted_data+decrypted_data_len && bFailed==false;)
		{
			switch (*pIn)
			{
			case diactName:
				idx=pIn[1];pIn+=2;
				if (idx < m_accountNames.size())
				{
					loadstring(pIn,m_accountNames[idx]);
					DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_INFO,DLT_STRING("User ID:"),DLT_INT(idx),DLT_STRING("Account Name:"),DLT_STRING(m_accountNames[idx].c_str()));
				}
				else
					bFailed=true;
				break;
			case dikID:
				idx=pIn[1];pIn+=2;
				if (idx < m_kIDs.size())
				{
					loadstring(pIn,m_kIDs[idx]);
					DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_INFO,DLT_STRING("User ID:"),DLT_INT(idx),DLT_STRING("kID:"),DLT_STRING(m_kIDs[idx].c_str()));
				}
				else
					bFailed=true;
				break;
			default:
				bFailed=true;
			}
		}
		return bFailed;

}

void onlineData::storeAccountNameInfo()
{
	encryptData enc=storeNameAndkID();
	unsigned char * pData=new unsigned char[enc.Size+5+sizeof(StorageInfo)],*pPos=pData+sizeof(StorageInfo);
	StorageInfo *pInfo=reinterpret_cast<StorageInfo*>(pData);
	pInfo->ID=diInfo;
	pInfo->Key1=magicSeqNumber[0];
	pInfo->Key2=magicSeqNumber[1];
	pInfo->Key3=magicSeqNumber[2];
	pInfo->MayorBersion=m_Info.variantID;
	pInfo->MinorVersdon=m_Info.versionID;


	memcpy(pPos,&enc,5);//copy header
	memcpy(pPos+5,enc.pData,enc.Size);//add data
	delete [] enc.pData;//free encrypted buffer

	dp_tclprofileDataaccountNames profileValues;
	profileValues.s32SetData(pData,enc.Size+5+sizeof(StorageInfo));
	delete [] pData; //free Buffer

}
 encryptData onlineData::storeNameAndkID()
{
	unsigned char *pBuff=new unsigned char[96*m_maxSecuredProfiles], *pOut=pBuff;

	encryptData Enc;
	Enc.ID=diNamekID;
	Enc.pData=0;


	for (uint8_t s=0;s < m_maxNumOfProfiles;++s)
	{
		*pOut=diactName;++pOut;//ID
		*pOut=s;++pOut;// Index
		uint8_t sz=m_accountNames[s].size();
		*pOut=sz;++pOut; //string size
		if (sz > 0) //string data
		{memcpy(pOut,m_accountNames[s].c_str(),sz);pOut+=sz;}


		*pOut=dikID;++pOut;//ID
		*pOut=s;++pOut;// Index
		sz=m_kIDs[s].size();
		*pOut=sz;++pOut; //string size
		if (sz > 0) //string data
		{memcpy(pOut,m_kIDs[s].c_str(),sz);pOut+=sz;}
	}

		SDCHandler cdsobj;
		cdsobj.bGenerateStorageKey(12006,32);
		cdsobj.bEncryptData(12006,reinterpret_cast<const char*>(pBuff),pOut-pBuff,Enc.pData,Enc.Size);
		delete [] pBuff;
		return Enc;
}


void onlineData::doDefSet()
{
   //ToDO
}

void onlineData::loadstring(unsigned char * &pBuff,std::string & str)
{
	unsigned char len=*pBuff;pBuff++;
	str.assign((char *)pBuff,len);
	pBuff+=len;
}

//*************************** getName  ********************************************

std::string onlineData::getName(uint8_t iD) const
{
	if(iD < m_accountNames.size())
		return m_accountNames[iD];
	else
		return "";
}
//*************************** getImage  ********************************************

std::string onlineData::getkID(uint8_t iD) const
{
	if(iD < m_kIDs.size())
			return m_kIDs[iD];
		else
			return "";
}

//*************************** getaccountNames  **********************************************

const std::vector<std::string>& onlineData::getaccountNames()
{
	return m_accountNames;
}

//*************************** getkIDs  **********************************************

const std::vector<std::string>& onlineData::getkIDs()
{
	return m_kIDs;
}

//*************************** setName  **************************************************************

bool onlineData::setaccountName(unsigned char idx, const std::string& acntName)
{
	if(idx < m_maxNumOfProfiles)
		m_accountNames.at(idx)=acntName.c_str();
	return true;
}

bool onlineData::setkID(unsigned char idx, const std::string& kID)
{
	if(idx < m_maxNumOfProfiles)
	   m_kIDs.at(idx)=kID.c_str();
	return true;
}

bool onlineData::setMaxSecuredProfiles(uint32_t iMaxSecProfiles)
{
	dp_tclprofileDatamaxSecuredProfiles dpmaxSuredProfiles;
	int32_t ret = dpmaxSuredProfiles.s32SetData(iMaxSecProfiles);
	m_maxSecuredProfiles = iMaxSecProfiles;
	return true;
}
uint32_t onlineData::getMaxSecuredProfiles()
{
	return m_maxSecuredProfiles;
}

//********************** setLocalLinkOrderTimeout ***********************************
bool onlineData::setLocalLinkOrderTimeout(uint32_t iTimeout)
{
	dp_tclprofileDatalocalLinkOrderTimeout dplocalLinkOrderTimeout;
	int32_t ret = dplocalLinkOrderTimeout.s32SetData(iTimeout);
	m_localLinkOrderTimout = iTimeout;
	return true;
}

//********************** getLocalLinkOrderTimeout ***********************************
uint32_t onlineData::getLocalLinkOrderTimeout()
{
	return m_localLinkOrderTimout;
}

void onlineData::setConnectionStatus(bool value)
{
	m_connectionStatus = value;
	DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_INFO, DLT_STRING("setConnectionStatus:"),DLT_INT(m_connectionStatus));
}

bool onlineData::setRemoteVehicleSettitngActivation(bool bValue)
{
	dp_tclprofileDataremoteVehicleSettingsActivation dpremoteVehSetActivation;
	int32_t ret = dpremoteVehSetActivation.s32SetData(bValue);
	m_remoteVehicleSettingsActivation = bValue;
	DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_INFO, DLT_STRING("setRemoteVehicleSettitngActivation:"),DLT_INT(m_remoteVehicleSettingsActivation));
	return true;
}
bool onlineData::getRemoteVehicleSettitngActivation()
{
   return m_remoteVehicleSettingsActivation;
}

bool onlineData::addCorrelationID(uint8_t userID, const std::string& corrID)
{
    bool ret = true;
	if(m_pendingCorrelationIds.find(corrID) == m_pendingCorrelationIds.end())
    {
		const std::string kID = m_kIDs[userID];
		UserKIDPair pair(userID,kID);
    	m_pendingCorrelationIds.insert(std::pair<std::string, UserKIDPair>(corrID,pair) );
    }
    else
    { ret = false;DLT_LOG(PROFILEDATA_COMPONENT, DLT_LOG_ERROR,DLT_STRING("addCorrelationID: Key Already exist"));}
    return ret;
}
bool onlineData::isCorrIDPresent(const std::string& corrID)
{
   if(m_pendingCorrelationIds.find(corrID) != m_pendingCorrelationIds.end())
   	   return true;
   return false;
}
bool onlineData::removecorrelationID(const std::string& corrID)
{
	if(m_pendingCorrelationIds.find(corrID) != m_pendingCorrelationIds.end())
	{
		m_pendingCorrelationIds.erase(corrID);
		return true;
	}
	return false;
}



}

