/*****************************************************************************
* FILE:         onlineComponentImpl.h
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:  core logic for Online Profile Manager
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#ifndef ONLINE_COMPONENT_IMPL_H
#define ONLINE_COMPONENT_IMPL_H

#include <string>
#include <semaphore.h>
#include <stdint.h>
#include <vector>
#include "onlineFacade.h"
#include "serviceprovider/ServiceProvider.h"
using namespace std;

namespace app { namespace core { class ProfileMngrOnlineDBUSServiceImpl; class ProfileMngrConfigDataServiceImpl; }}

namespace profileMngr {

using namespace ::app::core;
class syncObject;
class jsonParser;

class onlineComponentImpl:
		public IServiceAvailable,
		private ILinkProfileReply,
		private IUnlinkProfileReply,
		private IAccountNameUpdate,
		private IKIDUpdate,
		private IRemoteVehicleSettingsActivationUpdate
{
public:
	onlineComponentImpl();
	~onlineComponentImpl();

	// IServiceAvailable implementation
	/**
	 * Called whenever the state of all used CMA or CMS services changed to state Available.
	 * The component will start to offer its service now.
	 */
	virtual void onAvailable();

	/**
	 * Called whenever the state of one of the used CMA or CMS services changed to state Disconnected.
	 * The components service will not longer be available for the clients.
	 */
	virtual void onUnavailable();

	/**
	 * Called whenever the state of one of the used CMA or CMS services changed to state Suspended.
	 * The components service will not longer be available for the clients.
	 */
	virtual void onPaused() {}

	std::vector<syncObject> m_SyncList;

private:
	void createProfileServiceStub();
	void destroyProfileServiceStub();
	void createConfigDataServiceStub();
	void destroyConfigDataServiceStub();

	// ILinkProfileReply
	virtual void onLinkProfileSuccess(uintptr_t act, resultState result);
	virtual void onLinkProfileError(uintptr_t act, resultState result);

	// IUnlinkProfileReply
	virtual void onUnlinkProfileSuccess(uintptr_t act, resultState result);
	virtual void onUnlinkProfileError(uintptr_t act, resultState result);

	// IAccountNameUpdate
	virtual void onAccountNameUpdate(const ::std::string& accountName);

	// IKIDUpdate
	virtual void onKIDUpdate(const ::std::string& kID);

	// IRemoteVehicleSettingsActivationUpdate
	virtual void onRemVehcleSettngsActivationUpdate(bool status);

	static void vTraceCallbackFunction(const uint8_t* puchData);

private:
	static onlineComponentImpl *m_pInstance;
	ProfileMngrOnlineDBUSServiceImpl* m_profileServiceImpl;
	ProfileMngrConfigDataServiceImpl* m_configDataServiceImpl;
	ServiceProvider m_serviceProvider;
	bool m_initialized;
	onlineFacade m_onlineFacade;

	//jsonParser & m_Parser;
};





} // ::ONLINE_COMPONENT_IMPL_H

#endif
