
#ifndef JSON_PARSER_H

#define JSON_PARSER_H
#include <stddef.h>
#include <string>
#include <vector>
#include <list>
#include <map>
#include <string.h> //memcpy
#include <stdint.h>

namespace profileMngr{


enum keyTypeID {
	ktInt,
	ktString,
	ktBool
};
struct KeyValue
{
	keyTypeID keyTID;
	int intVal;
	std::string strVal;
	bool boolVal;
	KeyValue()
		{
			keyTID=ktInt;
			intVal=0;
			strVal="";
			boolVal=false;
		};
	//copy constructor
	KeyValue(const KeyValue &iKeyValuePair)
	{
		keyTID = iKeyValuePair.keyTID;
		if (keyTID == ktString)
			strVal=iKeyValuePair.strVal;
		else if(keyTID == ktInt)
			intVal =iKeyValuePair.intVal;
		else if (keyTID == ktBool)
			boolVal = iKeyValuePair.boolVal;
	}
	//assignment operator
	KeyValue& operator=(KeyValue iKeyValuePair)
	{
		keyTID = iKeyValuePair.keyTID;
		if (keyTID == ktString)
			strVal=iKeyValuePair.strVal;
		else if(keyTID == ktInt)
			intVal =iKeyValuePair.intVal;
		else if (keyTID == ktBool)
			boolVal = iKeyValuePair.boolVal;
		return *this;
	}
};
class syncObject;
class jsonParser
{
public:
	jsonParser();
	//bool Parse(const char * file,size_t size,std::map<std::string);
	bool Parse(const char * file,size_t size);
	//void getKeyValuePair(std::map<std::string, KeyValue> & keyValuepair){keyValuepair=m_KeyValue;}
	bool tracekeyValuePair(std::map<std::string, KeyValue> & keyValuepair);
	bool getValue(std::string iKey,KeyValue &iVal);
	bool getUpLocalLinkStatus(const std::string& jsonData, uint8_t& result, uint8_t& errorcode);
	bool getUpLocalUnLinkStatus(const std::string& jsonData, uint8_t& result, uint8_t& errorcode);
	bool getCorrelationID(const std::string& jsonData,std::string& corrID);

private:
	static int cb_null(void * ctx);
	static int cb_boolean(void * ctx, int boolean);
	static int cb_number(void * ctx, const char * s, size_t l);
	static int cb_int(void* ctx, long long int number);
	static int cb_float(void* ctx, double number);
	static int cb_string(void * ctx, const unsigned char * stringVal,	size_t stringLen);
	static int cb_map_key(void * ctx, const unsigned char * stringVal,size_t stringLen);
	static int cb_start_map(void * ctx);
	static int cb_end_map(void * ctx);
	static int cb_start_array(void * ctx);
	static int cb_end_array(void * ctx);
	bool onKey(const unsigned char * key,size_t length);
	bool onStringValue(const std::string value);
	bool onBoolValue(int boolean);
	bool insert(KeyValue iValue);
	bool onIntValue(int number);

	inline void reset()
	{
		m_CurrKey.clear();
		m_KeyValue.clear();
	}

private:
	struct myStr
	{
		const unsigned char * pString;
		size_t length;
	};

	int m_SubLevel;
	myStr m_CurrentKey;
	std::string m_CurrKey;
	std::map<std::string, KeyValue> m_KeyValue;
};


}


#endif
