/*****************************************************************************
* FILE:         ICommand.h
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:  core logic for Online Profile Manager
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/
#ifndef _ICOMMAND_H_
#define _ICOMMAND_H_

namespace profileMngr
{

class ICommand
{
public:
   ICommand():m_busy(false){}
   virtual ~ICommand() {}
   virtual void execute() = 0;
   virtual void abort() {}

   virtual bool isBusy() const
   {
      return m_busy;
   }

protected:
   virtual void setBusy(bool commandIsBusy)
   {
      m_busy = commandIsBusy;
   }

private:
   bool m_busy;
};


}  //profileMngr
#endif  // _ICOMMAND_H_

