/******************************************************************************
 *	FILE:        : GetProfileTypesCommand.cpp
 *	PROJECT:     : A-IVI project
 *  SW-COMPONENT : ProfileManager
 *----------------------------------------------------------------------------
 *
 * DESCRIPTION:
 *
 *----------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
 *****************************************************************************/

#include <stdlib.h>
#include <dlt/dlt.h>
#include "GetProfileTypesCommand.h"
#include "online/onlineData.h"

DLT_IMPORT_CONTEXT(PROFILEDATA_COMPONENT);

using namespace bosch::cm::profile;
namespace profileMngr
{

GetProfileTypesCommand *GetProfileTypesCommand::m_pInstance=NULL;

GetProfileTypesCommand::GetProfileTypesCommand():
   m_completionCallback(0)
{
	m_pInstance = this;
}

GetProfileTypesCommand::~GetProfileTypesCommand()
{
   //lint -e1506 reset should be virtual to be able to Mock so disable lint warning
   reset();
}

void GetProfileTypesCommand::init(
		boost::shared_ptr< ProfileSvcAdapter > profileSvcAdapter,
		IGetProfileTypesCompletion& completionCallback)
{
	m_profileTypes.clear();
	m_completionCallback = &completionCallback;
	m_profileSvcAdapter = profileSvcAdapter;
}

void GetProfileTypesCommand::returnSuccess()
{
	if(m_completionCallback)
	{
		m_completionCallback->getProfileTypesCompleted(true);
	}
	reset();
}

void GetProfileTypesCommand::returnError()
{
   if(m_completionCallback)
   {
      m_completionCallback->getProfileTypesCompleted(false);
   }

   reset();
}

void GetProfileTypesCommand::reset()
{
   setBusy(false);
   m_completionCallback = 0;
   m_profileSvcAdapter.reset();
}

void GetProfileTypesCommand::execute()
{
   if(!m_profileSvcAdapter)
   {
      returnError();
      return;
   }

   setBusy(true);

   if(m_profileSvcAdapter->isValid())
   {
	   m_profileSvcAdapter->sendGetProfileTypeRequest(*this);
   }
   else
   {
	   returnError();
   }
}

void GetProfileTypesCommand::onGetProfileTypesError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< GetProfileTypesError >& error)
{
	returnError();
}
void GetProfileTypesCommand::onGetProfileTypesResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< GetProfileTypesResponse >& response)
{
	m_profileTypes = response->getTypes();
	returnSuccess();
}



} // profileMngr

