/*****************************************************************************
* FILE:         SDCHandler.h
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:  core logic for Online Profile Manager
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#ifndef _SDC_HANDLER_H
#define _SDC_HANDLER_H

#include <sdc.h>
#include <sdc_session.h>
#include <sdc_keystore_keys.h>
#include <sdc_op_conv.h>
#include <sdc_op_common.h>
#include <sdc_perm.h>
#include <stdint.h>
#include <string>

namespace profileMngr{

class SDCHandler
{
public:
	SDCHandler();
	virtual ~SDCHandler();

	bool bGenerateStorageKey(uint32_t kid, size_t key_length);
	bool bEncryptData(uint32_t kid, const char *in_data_to_wrap, size_t in_data_to_wrap_len, unsigned char*& outData, uint32_t& length);
	bool bDecryptData(uint32_t kid, uint8_t **out_unwrapped_data, size_t *out_unwrapped_data_len, uint8_t * inData, uint32_t len);

	uint8_t u8GetSdc_key_stor_opt();
	//virtual tVoid vSetSdc_kid_opt(std::string kid_opt);
	//virtual tVoid vSetSdc_key_stor_opt(std::string key_storage_opt);

private:

	sdc_error_t sdc_error;
	sdc_key_id_t sdc_kid;
	size_t sdc_key_len;
	sdc_key_id_options_t sdc_kid_opt;
	sdc_key_storage_options_t sdc_key_stor_opt;
	sdc_permissions_t *permissions;
	sdc_session_t *session;
	sdc_wrap_unwrap_type_t *type;
	uint8_t *encrypted_data;
	size_t encrypted_data_len;
	char *data_to_decrypt;
	size_t data_to_decrypt_len;

	std::string m_data;


};
}

#endif
