/*****************************************************************************
* FILE:         ReplyServiceInterfaces.h
* PROJECT:      A-IVI project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:  core logic for Online Profile Manager
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#ifndef _RELPYSERVICEINTERFACES_H
#define _RELPYSERVICEINTERFACES_H

namespace profileMngr {

// The caller of onlineFacade should implement this interface to receive notifications
struct ILinkProfileReply
{
   virtual ~ILinkProfileReply() {}
   virtual void onLinkProfileSuccess(uintptr_t act, resultState result) = 0;
   virtual void onLinkProfileError(uintptr_t act, resultState result) = 0;
};

struct IUnlinkProfileReply
{
	virtual ~IUnlinkProfileReply() {}
	virtual void onUnlinkProfileSuccess(uintptr_t act, resultState result) = 0;
	virtual void onUnlinkProfileError(uintptr_t act, resultState result) = 0;
};

struct IAccountNameUpdate
{
   virtual ~IAccountNameUpdate() {}
   virtual void onAccountNameUpdate(const ::std::string& accountName) = 0;
};

struct IKIDUpdate
{
	virtual ~IKIDUpdate() {}
	virtual void onKIDUpdate(const ::std::string& kID) = 0;
};

struct IRemoteVehicleSettingsActivationUpdate
{
	virtual ~IRemoteVehicleSettingsActivationUpdate() {}
	virtual void onRemVehcleSettngsActivationUpdate(bool status) = 0;
};

} // ::profileMngr

#endif
