/*****************************************************************************
* FILE:         pm_Client__CLIENT_NAME__.cpp
* PROJECT:      A-IVI project
* SW-COMPONENT: profile manager
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#include <stdint.h>

#ifndef _PROFILEMANAGERTRACE_H_
#define _PROFILEMANAGERTRACE_H_

#define TR_COMP_APPINFRA_USERMGMT    ((256 * 122) + 160)

enum tenTrcTraceClass__APP_NAME__ {
     TR_CLASS_PROFILEMANAGER_APP  = TR_COMP_APPINFRA_USERMGMT + 0,
	 TR_CLASS_PROFILEMANAGER_CCA  = TR_COMP_APPINFRA_USERMGMT + 1,
	 TR_CLASS_PROFILEMANAGER_DBUS  = TR_COMP_APPINFRA_USERMGMT + 2,
	 TR_CLASS_PROFILESERVER_ASF  = TR_COMP_APPINFRA_USERMGMT + 3,
	 TR_CLASS_PROFILECLIENT_ASF  = TR_COMP_APPINFRA_USERMGMT + 4,
     TR_CLASS_PROFILEMANAGER_MAX
};

enum enTraceCode
{
	tcCCAMsgFactoryCall=0,
	tcCCAMsgFactoryError=1,
	trCCAReceivedInvalidMsg=2,
	trCCASendMsgFailed=3,
	trCCAbOnInit=4,
	trCCALoadRegitryFailed=5,
	tcInitTraceFailed=6,
	trcSetPrivacyMode=7,
	trWriteDPResult=8,
	trInvalidClientName=9,
	trSystemUP=10,
	trRemovedClient=11,
	trMissingClient=12,
	trServerState=13,
	trLogoutTimeStamp=14,
	trLoginTimestamp=15
};

void traceN(enTraceCode code,uint8_t level,uint32_t data);
void traceL(enTraceCode code,uint8_t level,uint64_t data);
void traceS(enTraceCode code,uint8_t level,const char* data);

enum enExitCode
{
	excNoConfig=30,
	excNoInstane=31
};

#define TR_PROFILEMANAGER_CMD_START                                           0x0000
#define TR_PROFILEMANAGER_CMD_DO_SWITCH_TO_PROFILE                            0x0001
#define TR_PROFILEMANAGER_CMD_DO_DELETE_PROFILE                            0x0002
#define TR_PROFILEMANAGER_CMD_DO_COPY_PROFILE                            0x0003
#define TR_PROFILEMANAGER_CMD_ON_DATA_CHANGED                            0x0004
#define TR_PROFILEMANAGER_CMD_ON_PROFILE_CREATED                            0x0005
#define TR_PROFILEMANAGER_CMD_ON_PROFILE_COPIED                            0x0006
#define TR_PROFILEMANAGER_CMD_DO_DEFSET                                   0x0007
#define TR_PROFILEMANAGER_CMD_DO_CREATE_PROFILE                           0x0008
#define TR_PROFILEMANAGER_CMD_GET_CLIENT_LIST                           0x0009
#define TR_PROFILEMANAGER_TST_ADD_CLIENT							0x000A
#define TR_PROFILEMANAGER_TST_REMOVE_CLIENT						0x000B

#define TR_PROFILEMANAGER_CMD_END                                            0x0050

#endif // _PROFILEMANAGERTRACE_H_

